(*  Title: 	LK/set/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Adds Set Theory to a database containing LK. 
Should be executed in the directory LK/set.
*)

writeln"LK/set/ROOT: Root file for Set Theory";

open PolyML;  (*essential when using make_database!*)

print_depth 1;  
use "syntax.ML";
use ".rules.ML";
use "resolve.ML";

print_depth 0;  
structure Set_Syntax = Set_SyntaxFun
	(structure LK_Syntax=LK_Syntax and Pretty=Pretty);
structure Set_Rule = Set_RuleFun
	(structure Set_Syntax=Set_Syntax and LK_Rule=LK_Rule);
structure Set_Resolve = Set_ResolveFun
	(structure Set_Syntax=Set_Syntax and Set_Rule=Set_Rule
	 and LK_Rule=LK_Rule and LK_Resolve=LK_Resolve and Conv=Conv);

open Thm Tactic Goals Conv;
open LK_Syntax LK_Rule LK_Resolve;
open Set_Syntax Set_Rule Set_Resolve;

Unify.printer := Syntax.prin syn;

print_depth 8;  
use "subset.ML";


