(*  Title: 	LK/ex/prop
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Classical FOL: examples with propositional connectives
Can be read to test the LK system.

by (step_tac [triv_pack, LK_pack] 1);
*)

writeln"LK/ex/prop: propositional examples";

writeln"absorptive laws of & and | ";

goal LK_Rule.thy "[| |- P & P <-> P |]";
by (pc_tac 1);
result();

goal LK_Rule.thy "[| |- P | P <-> P |]";
by (pc_tac 1);
result();

writeln"commutative laws of & and | ";

goal LK_Rule.thy "[| |- P & Q  <->  Q & P |]";
by (pc_tac 1);
result();

goal LK_Rule.thy "[| |- P | Q  <->  Q | P |]";
by (pc_tac 1);
result();


writeln"associative laws of & and | ";

goal LK_Rule.thy "[| |- (P & Q) & R  <->  P & (Q & R) |]";
by (pc_tac 1);
result();

goal LK_Rule.thy "[| |- (P | Q) | R  <->  P | (Q | R) |]";
by (pc_tac 1);
result();
(*3 secs*)


writeln"distributive laws of & and | ";
goal LK_Rule.thy "[| |- (P & Q) | R  <-> (P | R) & (Q | R) |]";
by (pc_tac 1);
result();
(*4 secs*)

goal LK_Rule.thy "[| |- (P | Q) & R  <-> (P & R) | (Q & R) |]";
by (pc_tac 1);
result();
(*4 secs*)

writeln"Laws involving implication";

goal LK_Rule.thy "[| |- (P|Q --> R) <-> (P-->R) & (Q-->R) |]";
by (pc_tac 1);
result(); 
(*3 secs*)

goal LK_Rule.thy "[| |- (P & Q --> R) <-> (P--> (Q-->R)) |]";
by (pc_tac 1);
result(); 


goal LK_Rule.thy "[| |- (P --> Q & R) <-> (P-->Q)  &  (P-->R) |]";
by (pc_tac 1);
result();
(*3 secs*)


writeln"Classical theorems";

goal LK_Rule.thy "[| |- P|Q --> P| ~P&Q |]";
by (pc_tac 1);
result();


goal LK_Rule.thy "[| |- (P-->Q)&(~P-->R)  -->  (P&Q | R) |]";
by (pc_tac 1);
result();


goal LK_Rule.thy "[| |- P&Q | ~P&R  <->  (P-->Q)&(~P-->R) |]";
by (pc_tac 1);
result();


goal LK_Rule.thy "[| |- (P-->Q) | (P-->R)  <->  (P --> Q | R) |]";
by (pc_tac 1);
result();
(*3 secs*)


goal LK_Rule.thy "[| |- (P<->Q) <-> (Q<->P) |]";
by (pc_tac 1);
result();



(*Sample problems from 
  F. J. Pelletier, 
  Seventy-Five Problems for Testing Automatic Theorem Provers,
  J. Automated Reasoning 2 (1986), 191-216.
  Errata, JAR 4 (1988), 236-236.
*)

(*1*)
goal LK_Rule.thy "[| |- (P-->Q)  <->  (~Q --> ~P) |]";
by (pc_tac 1);
result();

(*2*)
goal LK_Rule.thy "[| |- ~ ~ P  <->  P |]";
by (pc_tac 1);
result();

(*3*)
goal LK_Rule.thy "[| |- ~(P-->Q) --> (Q-->P) |]";
by (pc_tac 1);
result();

(*4*)
goal LK_Rule.thy "[| |- (~P-->Q)  <->  (~Q --> P) |]";
by (pc_tac 1);
result();

(*5*)
goal LK_Rule.thy "[| |- ((P|Q)-->(P|R)) --> (P|(Q-->R)) |]";
by (pc_tac 1);
result();

(*6*)
goal LK_Rule.thy "[| |- P | ~ P |]";
by (pc_tac 1);
result();

(*7*)
goal LK_Rule.thy "[| |- P | ~ ~ ~ P |]";
by (pc_tac 1);
result();

(*8.  Peirce's law*)
goal LK_Rule.thy "[| |- ((P-->Q) --> P)  -->  P |]";
by (pc_tac 1);
result();

(*9*)
goal LK_Rule.thy "[| |- ((P|Q) & (~P|Q) & (P| ~Q)) --> ~ (~P | ~Q) |]";
by (pc_tac 1);
result();

(*10*)
goal LK_Rule.thy "[| Q-->R, R-->P&Q, P-->(Q|R) |- P<->Q |]";
by (pc_tac 1);
result();

(*11.  Proved in each direction (incorrectly, says Pelletier!!)  *)
goal LK_Rule.thy "[| |- P<->P |]";
by (pc_tac 1);
result();

(*12.  "Dijkstra's law"*)
goal LK_Rule.thy "[| |- ((P <-> Q) <-> R)  -->  (P <-> (Q <-> R)) |]";
by (pc_tac 1);
result();
(*5 secs*)

(*13.  Distributive law*)
goal LK_Rule.thy "[| |- P | (Q & R)  <-> (P | Q) & (P | R) |]";
by (pc_tac 1);
result();
(*3 secs*)

(*14*)
goal LK_Rule.thy "[| |- (P <-> Q) <-> ((Q | ~P) & (~Q|P)) |]";
by (pc_tac 1);
result();
(*4 secs*)

(*15*)
goal LK_Rule.thy "[| |- (P --> Q) <-> (~P | Q) |]";
by (pc_tac 1);
result();

(*16*)
goal LK_Rule.thy "[| |- (P-->Q) | (Q-->P) |]";
by (pc_tac 1);
result();

(*17*)
goal LK_Rule.thy "[| |- ((P & (Q-->R))-->S) <->  \
\    ((~P | Q | S) & (~P | ~R | S)) |]";
by (pc_tac 1);
result();
(*9 secs*)


writeln"Reached end of file.";

(*21 August 88: loaded in 52.7 secs*)
