(*  Title: 	LK/ex/hard-quant
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Hard examples with quantifiers.  Can be read to test the LK system.
From  F. J. Pelletier, 
  Seventy-Five Problems for Testing Automatic Theorem Provers,
  J. Automated Reasoning 2 (1986), 191-216.
  Errata, JAR 4 (1988), 236-236.

by (step_tac [triv_pack, LK_pack] 1);
*)

writeln"LK/ex/hard-quant: Hard examples with quantifiers";

timing true;

writeln"Problem 18.  REQUIRES EXPLICIT STEP BECAUSE OF THINNING";
goal LK_Rule.thy "[| |- EXISTS y. ALL x. P(y)-->P(x) |]";
by (resolve_tac [exists_right] 1);
by (pc_tac 1);
result(); 



writeln"Problem 19.  REQUIRES EXPLICIT STEP BECAUSE OF THINNING";
goal LK_Rule.thy
   "[| |- EXISTS x. ALL y. ALL z. (P(y)-->Q(z)) --> (P(x)-->Q(x)) |]";
by (resolve_tac [exists_right] 1);
by (pc_tac 1);  (*7 secs*)
result();


writeln"Problem 20";
goal LK_Rule.thy
   "[| |- (ALL x. ALL y. EXISTS z. ALL w. (P(x)&Q(y)-->R(z)&S(w))) \    
\     -->  (EXISTS x. EXISTS y. P(x) & Q(y)) --> EXISTS z. R(z) |]";
by (pc_tac 1);  (*3 secs*)
result();



writeln"Problem 21.  REQUIRES EXPLICIT STEPS BECAUSE OF THINNING ";
goal LK_Rule.thy
   "[| EXISTS x. P-->Q(x), EXISTS x. Q(x)-->P |- EXISTS x. P<->Q(x) |]";
by (resolve_tac [exists_left] 1);
by (resolve_tac [exists_left] 1);
by (resolve_tac [exists_right] 1);
by (pc_tac 1);  (*4 secs*)
result();


writeln"Problem 22";
goal LK_Rule.thy
   "[| |- (ALL x. P <-> Q(x))  -->  (P <-> ALL x. Q(x)) |]";
by (pc_tac 1);  (*1 secs*)
result();


writeln"Problem 23";
goal LK_Rule.thy "[| |- (ALL x. P | Q(x))  <->  (P | ALL x. Q(x)) |]";
by (pc_tac 1);  (*1 sec*)
result();


writeln"Problem 24";
goal LK_Rule.thy
   "[|  ~ EXISTS x. S(x)&Q(x),  \
\       ALL x. P(x) --> Q(x)|R(x),  \
\       (~ EXISTS x.P(x)) --> EXISTS x.Q(x), \
\       ALL x. Q(x)|R(x) --> S(x) \
\       |- EXISTS x. P(x)&R(x) |]";
by (pc_tac 1);  (*19 secs*)
result();


writeln"Problem 25";
goal LK_Rule.thy
   "[|  EXISTS x. P(x),  \
\       ALL x. L(x) --> ~ (M(x) & R(x)), \
\       ALL x. P(x) --> (M(x) & L(x)), \
\       (ALL x. P(x)-->Q(x)) | (EXISTS x. P(x)&R(x)) \
\   |- EXISTS x. Q(x)&P(x) |]";
by (pc_tac 1);  (*12 secs*)
result();


writeln"Problem 27";
goal LK_Rule.thy
   "[|  EXISTS x. P(x) & ~Q(x),  \
\       ALL x. P(x) --> R(x), \
\       ALL x. M(x) & L(x) --> P(x), \
\       (EXISTS x. R(x) & ~ Q(x)) --> (ALL x. L(x) --> ~ R(x)) \
\   |- ALL x. M(x) --> ~L(x) |]";
by (pc_tac 1);  (*11 secs*)
result();


writeln"Problem 28.  AMENDED";
goal LK_Rule.thy
   "[|  ALL x. P(x) --> ALL x. Q(x),  \
\       (ALL x. Q(x)|R(x)) --> EXISTS x. Q(x)&S(x), \
\       (EXISTS x.S(x)) --> (ALL x. L(x) --> M(x)) \
\       |- ALL x. P(x) & L(x) --> M(x) |]";
by (pc_tac 1);  (*9 sec*)
result();


writeln"Problem 29.  Essentially the same as Principia Mathematica *11.71";
goal LK_Rule.thy
   "[| (EXISTS x. P(x)) & (EXISTS x. Q(x))  \
\   |- (ALL x. P(x)-->R(x)) & (ALL x. Q(x)-->S(x))  \
\         <->  ALL x. ALL y. P(x) & Q(y) --> R(x) & S(y) |]";
by (pc_tac 1);  (*11 secs*)
result();


writeln"Problem 30";
goal LK_Rule.thy
   "[|  ALL x. P(x) | Q(x) --> ~ R(x),  \
\       ALL x. (Q(x) --> ~ S(x)) --> P(x) & R(x) \
\   |- ALL x. S(x) |]";
by (pc_tac 1);   (*3 secs*)
result();


writeln"Problem 31";
goal LK_Rule.thy
   "[|  ~ EXISTS x.P(x) & (Q(x) | R(x)), \
\       EXISTS x. L(x) & P(x),  \
\       ALL x. ~ R(x) --> M(x) \
\   |- EXISTS x. L(x) & M(x) |]";
by (pc_tac 1); (*4 secs*)
result();



writeln"Problem 32";
goal LK_Rule.thy
   "[|  ALL x. P(x) & (Q(x)|R(x))-->S(x),  \
\       ALL x. S(x) & R(x) --> L(x),  \
\       ALL x. M(x) --> R(x) \
\   |- ALL x. P(x) & M(x) --> L(x) |]";
by (pc_tac 1); (*7 secs*)
result();


(*Times for loading file to this point:
  est.	1200 secs in April 88	
	367 secs on 3/May/88	with suppression of flexflex
	104 secs on 3/May/88	with filseq_resolve_tac
*)


writeln"Problem 33";
goal LK_Rule.thy
   "[| |- (ALL x. P(a) & (P(x)-->P(b))-->P(c))  <->   \
\         (ALL x. (~P(a) | P(x) | P(c)) & (~P(a) | ~P(b) | P(c))) |]";
by (pc_tac 1); (*6 secs*)
result();


writeln"Problem 35.  REQUIRES EXPLICIT STEP BECAUSE OF THINNING";
goal LK_Rule.thy
   "[| |- EXISTS x. EXISTS y. P (x,y) -->  (ALL x.ALL y.P(x,y)) |]";
by (resolve_tac [exists_right] 1);
by (pc_tac 1); (*1 secs*)
result();


writeln"Problem 36.  NOT PROVED";
goal LK_Rule.thy
 "[| ALL x. EXISTS y. F(x,y), \
\    ALL x. EXISTS y. G(x,y), \
\    ALL x. ALL y. F(x,y) | G(x,y) --> (ALL z. F(y,z) | G(y,z) --> H(x,z))  \
\ |- ALL x. EXISTS y. H(x,y) |]";


writeln"Problem 37";
goal LK_Rule.thy
 "[| ALL z. EXISTS w. ALL x. EXISTS y. (P(x,z)-->P(y,w)) &  \
\                 P(y,z) & (P(y,w)--> (EXISTS u.Q(u,w))),  \
\    ALL x. ALL z. ~P(x,z) --> (EXISTS y. Q(y,z)),  \
\    (EXISTS x. EXISTS y. Q(x,y)) --> (ALL x. R(x,x))  \
\ |- ALL x. EXISTS y. R(x,y) |]";
by (pc_tac 1); (*58 secs*)
result();


writeln"Problem 39";
goal LK_Rule.thy "[| |- ~ (EXISTS x. ALL y. F(x,y) <-> ~F(y,y)) |]";
by (pc_tac 1); (*1 secs*)
result();


writeln"Problem 40.  AMENDED";
goal LK_Rule.thy
 "[| |- (EXISTS y. ALL x. F(y,x) <-> ~F(x,x))  -->    \
\       ~ (ALL x. EXISTS y. ALL z. F(z,y) <-> ~ F(z,x)) |]";
by (pc_tac 1); (*1 secs*)
result();



writeln"Reached end of file.";

(*21 August 88: loaded in 182 secs*)
