


infix ASN;

(*Assumption solving: exactly one resolvent must be produced*) 
fun (th ASN i) = 
  case Sequence.chop (2, assumption (th,i)) of
      ([th],_) => th
    |      _   => raise THM("ASN", i, [th]);



fun gen_elem_var (Const("Elem",_) $ v $ _, th) = 
	forall_intr (Sign.cterm_of HOL_Rule.sign v) th
  | gen_elem_var (_, th) = th;

val subst_rls = [subst1,subst2,subst3,subst4,subst5];

fun gen_type_thm F_type =
    lift_rule (subst1, 2)
      (itlist_right gen_elem_var (prems_of F_type, F_type));

fun make_congr_rule F_type =
    let val prems = prems_of F_type;
	val gen_rl = lift_rule (subst1, 2)
	      (itlist_right gen_elem_var (prems, F_type));
	val subst_rl = nth_elem (length prems - 1, subst_rls)
		handle LIST _ => raise THM
		    ("make_congr_rule: premises", 0, [F_type]);
	val thsq = bicompose (subst_rl, 1) (false, gen_rl, 0)
    in  case Sequence.chop (2, thsq) of
	   ([th],_) => standard th
	 |      _   => raise THM("make_congr_rule failed!", 0, [F_type])
    end;

	


val gth = lift_rule (subst1, 2)
    (forall_intr (Sign.read_cterm HOL_Rule.sign ("?p",Aexp)) fst_type); 

val [th] = Sequence.list_of_s (bicompose (subst1, 1) (false, gth, 0));


val gth =
forall_intr (Sign.read_cterm HOL_Rule.sign ("?a",Aexp))
  (forall_intr (Sign.read_cterm HOL_Rule.sign ("?b",Aexp)) pair_type); 

bicompose (subst2, 1) (false, gth, 0);

???????????????????????????;


fun add_elem_var (Const("Elem",_) $ v $ _, vs) = v::vs
  | add_elem_var (_, vs) = vs;

val vs = itlist_right add_elem_var (prems_of F_type, []);
val cvs = map (Sign.cterm_of HOL_Rule.sign) vs;


goal HOL_Rule.thy "[| [ ?a = ?b : ?A ] |]";
by (subst2_tac "pair" 1);
by (REPEAT (ares_tac [pair_type] 1));







(*Thinning of a=a on the left.  
  If one of the a's is a Var, causes replacement throughout goal*)
val refl_elim = prove_goal class_thy
    "[| P |] ==> [| a=a |] ==> [| P |]"
 (fn asms=>
  [ (REPEAT (resolve_tac (asms @ [thin_elim]) 1)) ]);



(*Replace-right.  Simple version, no new variables *)
val Replace_intr_comb = prove_goal class_thy
    "[| S`a |] ==> [| f(a) : Replace(f,S) |]"
 (fn asms=>
  [ (rewrite_goals_tac [Replace_def]),
    (REPEAT (resolve_tac (asms @ [refl, exists_intr, conj_intr]) 1)) ]);


(*Replace-right.   "a" is new variable. *)
val Replace_intr = prove_goal class_thy
    "[| S`a |] ==> [| c=f(a) |] ==> \
\    [| c : Replace(f,S) |]"
 (fn asms=>
  [ (rewrite_goals_tac [Replace_def]),
    (REPEAT (resolve_tac (asms @ [exists_intr,conj_intr]) 1)) ]);


val Replace_elim = prove_goal class_thy
    "(!(x)[| S`x, c=f(x) |] ==> [| P |]) ==> \
\    [| c : Replace(f,S) |] ==> [| P |]"
 (fn asms=>
  [ (rewrite_goals_tac [Replace_def]),
    (REPEAT (resolve_tac (asms @ [exists_elim,conj_elim]) 1)) ]);




(*Powerset rules in terms of subsets (not elements). 
  Further reasoning takes place using the many different subset rules. *)

val Pow_intr = prove_goal class_thy
    "[| R<=S |] ==> [| R : Pow(S) |]"
 (fn asms=>
  [ (rewrite_goals_tac [Pow_def]),
    (REPEAT (resolve_tac asms 1))  ]);


val Pow_elim = prove_goal class_thy
    "[| R : Pow(S) |] ==> ([| R<=S |] ==> [| P |]) ==> [| P |]"
 (fn asms=>
  [ (rewrite_goals_tac [Pow_def]),
    (REPEAT (resolve_tac asms 1))  ]);


