(*  Title: 	tt-ex-typechk
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge
  
  Easy examples: type checking and type deduction
*)


writeln"Single-step proofs: verifying that a type is well-formed";

read_goal TypeThy "?A type";
expand (resolve_tac form_rls 1);
writeln"getting a second solution";
backtrack();
expand (resolve_tac form_rls 1);
expand (resolve_tac form_rls 1);



read_goal TypeThy "PROD x:?A. N + ?B'(x) type";
expand (resolve_tac form_rls 1);
expand (resolve_tac form_rls 1);
expand (resolve_tac form_rls 1);
expand (resolve_tac form_rls 1);
expand (resolve_tac form_rls 1);




writeln"Multi-step proofs: Type inference";

read_goal TypeThy "PROD x:N. N + N type";
expand form_tac;


read_goal TypeThy "<0, succ(0)> : ?A";
expand intr_tac;
expand (fold_tac ["*"]);


read_goal TypeThy "PROD x:N . PROD y:N . Eq(?A,x,y) type";
expand typechk_tac;


writeln"typechecking an application of fst";
read_goal TypeThy "(lam x. split(x, %(y,z)y)) ` <0, succ(0)> : ?A";
expand typechk_tac;


writeln"typechecking the predecessor function";
read_goal TypeThy "lam n. rec(n, 0, %(x,y)x) : ?A";
expand typechk_tac;


writeln"typechecking the addition function";
read_goal TypeThy "lam n. lam m. rec(n, m, %(x,y)succ(y)) : ?A";
expand typechk_tac;
expand (fold_tac ["==>"]);


(*Proofs involving arbitrary types.
  For concreteness, every type variable left over is forced to be N*)
val N_tac = determ_resolve_tac ([N_form], 1);

read_goal TypeThy "lam x. <x,x> : ?A";
expand typechk_tac;
expand (N_tac THEN fold_tac["==>","*"]);


read_goal TypeThy "lam x. lam y. x : ?A";
expand typechk_tac;
expand N_tac;


writeln"typechecking fst (as a function object) ";
read_goal TypeThy "lam x. split(x, %(y,z)y) : ?A";
expand typechk_tac;
expand (N_tac THEN fold_tac["==>","*"]);
