(*  Title: 	ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge

Root file for Isabelle : all modules in proper order for loading
Loads the part common to all logics into an empty database

To build system, enter Poly/ML and type
    install_ml;  ml;		(*Unless already in ML*)
    PolyML.use "ROOT";

Then load ROOT-TYPE or ROOT-SET to add a logic to the database.
*)

open PolyML;  print_depth 10;  open BasicIO;  (*for Matthews compiler*)

use "library";
use "term";
use "envir";
use "symtab";
use "parse";
use "print";
use "sequence";
use "unify";
use "match";
use "rules";
use "tactics";
use "goalstack";

(* PPLAMBDA (not working at present!)
   use "ppl-parse";
   use "ppl-print";
   use "ppl-rules";
*)

(*Needed in future:
Use modules in code, also better commentary.

Literal constants, for numbers, strings, etc., along with a mechanism for
deriving rules like 123+456 = 579.  A theory of numerals would not be
natural to use, simple, or efficient.

Theories: multiple parents

Automatic parser and prettyprinter generator, or at least mix-fix
syntax.  Example: <a,b> means pair(a,b) ;  higher-order example: PROD
x:A. B'(x) means Prod(A,B').  Compare with definition facilities in the
INRIA constructions prover.

Better methods for deriving rules.  How can the premises of the rule be
used in the derivation?  Will the technique work only for sequent
calculi?  See P. Schroeder-Heister, "A natural extension of natural
deduction", J. Symbolic Logic 49 (1984), pages 1284-1300.

Narrowing: deriving functions satisfying equations.  Would extend previous work on synthesis.

Prettyprinting: rules, goal trees
*)
