(* List of rules with one premise. *)

val Srlist1 = [Int_elim, Un_intr, subset_intr, setcons_intr, nullset_intr];

(* List of rules with two premises. *)

val Srlist2 = [Int_intr, Un_elim, subset_elim, setcons_elim];

(* Lists of rules whose use has to be delayed. *)

val Srlist3 = [ext_elim];

val Srlist4 = [ext_intr];


(* Tactic for reducing a goal, using the rules here above. *)

fun set_tac gno prf = 
    ((res_and_smash_tac [assume, refl, nullset_elim] gno)
     ORELSE
     ((res_and_smash_tac Srlist1 gno) THEN (set_tac gno))
     ORELSE
     ((res_and_smash_tac Srlist2 gno) THEN (set_tac (gno + 1))
                                      THEN (set_tac gno))
     ORELSE
     ((res_and_smash_tac Srlist3 gno) THEN (set_tac gno))
     ORELSE
     ((res_and_smash_tac Srlist4 gno) THEN (set_tac (gno + 1))
                                      THEN (set_tac gno))
     ORELSE
     all_tac) prf;
