(*  Title: 	tt-rules
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge
*)

(*Are thinning rules OK? (thin_elem)
  Equality forms of rules that follow by reflexivity are omitted.
*)


val TypeThySign =
  extend_sign (Signat{lextab=tt_lextab, defines=[],
	       parse_tm=parse_tt_term, parse_thm=parse_thm,
	       print_tm=print_tt_term, print_thm=print_goal},
	 [ ("*", InfixSy([Atype,Atype]--->Atype, 30, 29),
		   "%(A,B) Sum(A, %(z)B)"),	(*right associative*)
           ("==>", InfixSy([Atype,Atype]--->Atype, 10, 9),
		   "%(A,B)Prod(A, %(z)B)"),	(*right associative*)
 	   ("fst", ConstSy(Aexp-->Aexp), "%(a)split(a, %(x,y)x)"),
           ("snd", ConstSy(Aexp-->Aexp), "%(a)split(a, %(x,y)y)"),
	   ("#+", InfixSy([Aexp,Aexp]--->Aexp, 10, 9),
                   "%(a,b)rec(a, b, %(u,v)succ(v))"),
	   ("-", InfixSy([Aexp,Aexp]--->Aexp, 10, 9),
		   "%(a,b)rec(b, a, %(u,v)rec(v, 0, %(x,y)x))"),
	   ("|-|", InfixSy([Aexp,Aexp]--->Aexp, 10, 9),
		   "%(a,b) (a-b) #+ (b-a)"),
	   ("#*", InfixSy([Aexp,Aexp]--->Aexp, 30, 29),
		   "%(a,b)rec(a, 0, %(u,v) b #+ v)"),
	   ("MOD", InfixSy([Aexp,Aexp]--->Aexp, 30, 29),
		   "%(a,b)rec(a, 0, %(u,v)   \
\			rec(succ(v) |-| b, 0, %(x,y)succ(v)))"),
	   ("/", InfixSy([Aexp,Aexp]--->Aexp, 30, 29),
		   "%(a,b)rec(a, 0, %(u,v)   \
\			rec(succ(u) MOD b, succ(v), %(x,y)v))"),
	   ("Bool", ConstSy Atype, "T+T"),
	   ("true", ConstSy Aexp, "inl(tt)"),
	   ("false",ConstSy Aexp, "inr(tt)"),
	   ("cond", ConstSy([Aexp,Aexp,Aexp]--->Aexp),
		   "%(a,b,c)when(a, %(u)b, %(u)c)")
 ]);

val rdtt =  read_term TypeThySign
and prtt = print_term TypeThySign;


val TypeThy = new_theory TypeThySign
[ 
  ("assume_elem",   [],
      [ "?A type  [ ?H        ]" ] ,
    (*--------------------------*)
	"?a : ?A  [ ?H, ?a:?A ]"  ),

  (*perhaps needs premise ?B type ;  what if ?b is mentioned in ?H   ?
    looks OK as used in backwards proof*)
  ("thin_elem",   [],
      [ "?a : ?A  [ ?H        ]" ] ,
    (*--------------------------*)
	"?a : ?A  [ ?H, ?b:?B ]"  ),

  (*Special thinning rules for deleting assumptions after Sum_elim, Plus_elim
    ARE THEY OK?*)
  ("thin_elem1",   [],
      [ "?a : ?A  [ ?H,        ?b:?B ]" ] ,
    (*---------------------------------*)
	"?a : ?A  [ ?H, ?c:?C, ?b:?B ]"  ),

  ("thin_elem2",   [],
      [ "?a : ?A  [ ?H,        ?c:?C, ?b:?B ]" ] ,
    (*----------------------------------------*)
	"?a : ?A  [ ?H, ?d:?D, ?c:?C, ?b:?B ]"  ),

  ("thin_type",   [],
      [ "?A type  [ ?H        ]" ] ,
    (*--------------------------*)
	"?A type  [ ?H, ?b:?B ]"  ),

  ("thin_eqelem",   [],
      [ "?a = ?c : ?A  [ ?H        ]" ] ,
    (*----------------------------------*)
	"?a = ?c : ?A  [ ?H, ?b:?B ]"  ),


  (*Reduction: a weaker notion than equality;  a hack for simplification.
    reduce(a,b,A) means either that  a=b:A  or else that "a" and "b" 
    are textually identical.*)

  (*does not ask that a:A! Sound because only trans_red uses a reduce premise
    No new theorems can be proved about the standard judgements.*)
  ("refl_red",   [],
      [] , "reduce(?a,?a,?A) [ ?H ]"  ),

  ("red_if_equal",   [],
      [ "?a = ?b : ?A  [ ?H ]" ] ,
    (*----------------------------*)
	"reduce(?a,?b,?A) [ ?H ]"),


  ("trans_red",   [],
      [ "?a = ?b : ?A  [ ?H ]",  "reduce(?b,?c,?A) [ ?H ]" ] ,
    (*-----------------------------------------------*)
		 "?a = ?c : ?A  [ ?H ]"),


  (*Reflexivity*)

  ("refl_type",   [],
      [ "?A type  [ ?H ]" ] ,
    (*------------------------*)
	"?A = ?A  [ ?H ]"  ),

  ("refl_elem",   [],
      [ "?a : ?A  [ ?H ]" ] ,
    (*------------------------*)
	"?a = ?a : ?A  [ ?H ]"  ),


  (*Symmetry*)

  ("sym_type",   [],
      [ "?A = ?B  [ ?H ]" ] ,
    (*------------------------*)
	"?B = ?A  [ ?H ]"  ),

  ("sym_elem",   [],
      [ "?a = ?b : ?A  [ ?H ]" ] ,
    (*------------------------*)
	"?b = ?a : ?A  [ ?H ]"  ),


  (*Transitivity*)

  ("trans_type",   [],
      [ "?A = ?B  [ ?H ]",  "?B = ?C  [ ?H ]" ] ,
    (*-------------------------------------*)
		 "?A = ?C  [ ?H ]"),

  ("trans_elem",   [],
      [ "?a = ?b : ?A  [ ?H ]",  "?b = ?c : ?A  [ ?H ]" ] ,
    (*-----------------------------------------------*)
		 "?a = ?c : ?A  [ ?H ]"),

  ("equal_types",   [],
      [ "?a : ?A  [ ?H ]",  "?A = ?B  [ ?H ]" ] ,
    (*-----------------------------------------------*)
		 "?a : ?B  [ ?H ]"),

  ("equal_types_long",   [],
      [ "?a = ?b : ?A  [ ?H ]",  "?A = ?B  [ ?H ]" ] ,
    (*-----------------------------------------------*)
		 "?a = ?b : ?B  [ ?H ]"),


  (*Substitution*)

  ("subst_type",   ["z> ?H ?B'"],
      [ "?a : ?A  [ ?H ]",  "?B'(z) type  [ ?H, z:?A ]" ],
    (*-----------------------------------------------------*)
		  "?B'(?a) type  [ ?H ]"   ),

  ("subst_type_long",   ["z> ?H ?B' ?D'"],
      [ "?a = ?c : ?A  [ ?H ]",  "?B'(z) = ?D'(z)  [ ?H, z:?A ]" ],
    (*----------------------------------------------------------*)
		  "?B'(?a) = ?D'(?c)  [ ?H ]"   ),

  ("subst_elem",   ["z> ?H ?b' ?B'"],
      [ "?a : ?A  [ ?H ]",  "?b'(z) : ?B'(z)  [ ?H, z:?A ]" ],
    (*-----------------------------------------------------*)
		  "?b'(?a) : ?B'(?a)  [ ?H ]"   ),

  ("subst_elem_long",   ["z> ?H ?B' ?b' ?d'"],
      [ "?a = ?c : ?A  [ ?H ]",  "?b'(z) = ?d'(z) : ?B'(z)  [ ?H, z:?A ]" ],
    (*--------------------------------------------------------------------*)
		  "?b'(?a) = ?d'(?c) : ?B'(?a)  [ ?H ]"   ),


  (* Rules for type  N*)

  ("N_form",   [],
      [] ,    "N type  [ ?H ]"  ),

  ("N_intr0",   [],
      [] ,    "0 : N  [ ?H ]"  ),

  ("N_intr_succ",   [],
      [ "?a   :   N  [ ?H ]" ] ,
    (*------------------------------*)
	"succ(?a) : N  [ ?H ]"  ),


  ("N_intr_succ_long",   [],
      [ "?a = ?b   :   N  [ ?H ]" ] ,
    (*------------------------------*)
	"succ(?a) = succ(?b) : N  [ ?H ]"  ),

  ("N_elim",   ["u> ?H ?b'' ?C'", "v> ?H ?b''"],
      [ "?p : N  [ ?H ]" ,
	"?a : ?C'(0)  [ ?H ]",  
	"?b''(u,v) : ?C'(succ(u))  [ ?H, u: N, v: ?C'(u) ]" ],
    (*---------------------------------------------------------*)
	"rec(?p,?a,?b'') : ?C'(?p)  [ ?H ]"  ),

  ("N_elim_long",   ["u> ?H ?b'' ?d'' ?C'", "v> ?H ?b'' ?d''"],
      [ "?p = ?q : N  [ ?H ]",
	"?a = ?c : ?C'(0)  [ ?H ]",  
	"?b''(u,v) = ?d''(u,v) : ?C'(succ(u))  [ ?H, u: N, v: ?C'(u) ]" ],
    (*--------------------------------------------------------------------*)
	"rec(?p,?a,?b'') = rec(?q,?c,?d'') : ?C'(?p)  [ ?H ]"  ),

  ("N_comp0",   ["u> ?H ?b'' ?C'", "v> ?H ?b''"],
      [ "?a : ?C'(0)  [ ?H ]",  
	"?b''(u,v) : ?C'(succ(u))  [ ?H, u: N, v: ?C'(u) ]" ] ,
    (*---------------------------------------------------------*)
	"rec(0,?a,?b'') = ?a : ?C'(0)  [ ?H ]"  ),


  ("N_comp_succ",   ["u> ?H ?b'' ?C'", "v> ?H ?b''"],
      [ "?p : N  [ ?H ]",
	"?a : ?C'(0)  [ ?H ]",  
	"?b''(u,v) : ?C'(succ(u))  [ ?H, u: N, v: ?C'(u) ]" ],
    (*----------------------------------------------------------*)
	"rec(succ(?p),?a,?b'') = ?b''(?p, rec(?p,?a,?b'')) \
	       \	: ?C'(succ(?p))  [ ?H ]"  ),


  (*The fourth Peano axiom.  See page 91 of Martin-Lof's book*)
  ("zero_ne_succ", [],
      [ "?a : N  [ ?H ]",    "0 = succ(?a) : N  [ ?H ]" ],
    (*------------------------------------------------------*)
			    "0 : F  [ ?H ]"  ),




  (* Rules for the Product of a family of types*)

  ("Prod_form",   ["w> ?H ?B'"],
      [ "?A type  [ ?H ]",    "?B'(w) type  [ ?H, w: ?A ]" ] ,
    (*------------------------------------------------------*)
	"Prod(?A,?B') type  [ ?H ]"  ),


  ("Prod_form_long",   ["w> ?H ?B' ?D'"],
      [ "?A = ?C  [ ?H ]",    "?B'(w) = ?D'(w)  [ ?H, w: ?A ]" ] ,
    (*----------------------------------------------------------*)
	"Prod(?A,?B') = Prod(?C,?D')  [ ?H ]"  ),


  ("Prod_intr",   ["w> ?H ?B' ?b'"],
      [ "?A type  [ ?H ]",	"?b'(w) : ?B'(w)  [ ?H, w: ?A ]" ] ,
    (*-------------------------------------------------------------------*)
	"lambda(?b') : Prod(?A,?B')  [ ?H ]"  ),


  ("Prod_intr_long",   ["w> ?H ?B' ?b' ?c'"],
      [ "?A type  [ ?H ]",    "?b'(w) = ?c'(w) : ?B'(w)  [ ?H, w: ?A ]" ] ,
    (*-------------------------------------------------------------------*)
	"lambda(?b') = lambda(?c') : Prod(?A,?B')  [ ?H ]"  ),


  ("Prod_elim",   [],
      [ "?p : Prod(?A,?B')  [ ?H ]",  "?a : ?A  [ ?H ]" ] ,
    (*-------------------------------------------------*)
	"?p ` ?a : ?B'(?a)  [ ?H ]"  ),


  ("Prod_elim_long",   [],
      [ "?p = ?q : Prod(?A,?B')  [ ?H ]",  "?a = ?b : ?A  [ ?H ]"] ,
    (*------------------------------------------------------------*)
	"?p ` ?a = ?q ` ?b : ?B'(?a)  [ ?H ]"  ),


  ("Prod_comp",   ["w> ?H ?B' ?b'"],
      [ "?a : ?A  [ ?H ]", 	"?b'(w) : ?B'(w)  [ ?H, w: ?A ]" ] ,
    (*--------------------------------------------------------------------*)
	"lambda(?b') ` ?a = ?b'(?a) : ?B'(?a)  [ ?H ]"  ),
 




  (* Rules for the Sum of a family of types*)

  ("Sum_form",   ["w> ?H ?B'"],
      [ "?A type  [ ?H ]",    "?B'(w) type  [ ?H, w: ?A ]" ] ,
    (*------------------------------------------------------*)
	"Sum(?A,?B') type  [ ?H ]"  ),


  ("Sum_form_long",   ["w> ?H ?B' ?D'"],
      [ "?A = ?C  [ ?H ]",    "?B'(w) = ?D'(w)  [ ?H, w: ?A ]" ] ,
    (*----------------------------------------------------------*)
	"Sum(?A,?B') = Sum(?C,?D')  [ ?H ]"  ),


  ("Sum_intr",   [],
      [ "?a : ?A  [ ?H ]",   "?b : ?B'(?a)  [ ?H ]" ] ,
    (*------------------------------------------------*)
	"<?a,?b> : Sum(?A,?B')  [ ?H ]"  ),


  ("Sum_intr_long",   [],
      [ "?a = ?c : ?A  [ ?H ]",   "?b = ?d : ?B'(?a)  [ ?H ]" ] ,
    (*----------------------------------------------------------*)
	"<?a,?b> = <?c,?d> : Sum(?A,?B')  [ ?H ]"  ),


  ("Sum_elim",   ["x> ?H ?c'' ?C'", "y> ?H ?c'' ?C'"],
      [ "?p : Sum(?A,?B')  [ ?H ]",
	"?c''(x,y) : ?C'(<x,y>)  [ ?H, x: ?A, y: ?B'(x) ]" ],
    (*--------------------------------------------------------*)
	"split(?p,?c'') : ?C'(?p)  [ ?H ]"  ),


  ("Sum_elim_long",   ["x> ?H ?c'' ?d'' ?C'", "y> ?H ?c'' ?d'' ?C'"],
      [ "?p = ?q : Sum(?A,?B')  [ ?H ]",
	"?c''(x,y) = ?d''(x,y) : ?C'(<x,y>)  [ ?H, x:?A, y:?B'(x) ]" ],
    (*-----------------------------------------------------------------*)
	"split(?p,?c'') = split(?q,?d'') : ?C'(?p)  [ ?H ]"  ),


  ("Sum_comp",   ["x> ?H ?c'' ?C'", "y> ?H ?c'' ?C'"],
      [ "?a : ?A  [ ?H ]",
	"?b : ?B'(?a)  [ ?H ]",
	"?c''(x,y) : ?C'(<x,y>)  [ ?H, x: ?A, y: ?B'(x) ]" ],
    (*-------------------------------------------------------------------*)
	"split(<?a,?b>, ?c'') = ?c''(?a,?b) : ?C'(<?a,?b>)  [ ?H ]"  ),




  ("Plus_form",   [],
      [ "?A type  [ ?H ]",     "?B type  [ ?H ]" ] ,
    (*-----------------------------------------*)
	"?A + ?B type  [ ?H ]"  ),


  ("Plus_form_long",   [],
      [ "?A = ?C  [ ?H ]",     "?B = ?D  [ ?H ]" ] ,
    (*--------------------------------------------*)
	"?A + ?B = ?C + ?D  [ ?H ]"  ),


  ("Plus_intr_inl",   [],
      [ "?a : ?A  [ ?H ]",   "?B type  [ ?H ]" ] ,
    (*-------------------------------------------*)
	"inl(?a) : ?A + ?B  [ ?H ]"  ),


  ("Plus_intr_inl_long",   [],
      [ "?a = ?c : ?A  [ ?H ]",   "?B type  [ ?H ]" ] ,
    (*-------------------------------------------*)
	"inl(?a) = inl(?c) : ?A + ?B  [ ?H ]"  ),


  ("Plus_intr_inr",   [],
      [ "?A type  [ ?H ]",   "?b : ?B  [ ?H ]" ] ,
    (*-------------------------------------------*)
	"inr(?b) : ?A + ?B  [ ?H ]"  ),


  ("Plus_intr_inr_long",   [],
      [ "?A type  [ ?H ]",   "?b = ?d : ?B  [ ?H ]" ] ,
    (*-------------------------------------------*)
	"inr(?b) = inr(?d) : ?A + ?B  [ ?H ]"  ),


  ("Plus_elim",   ["x> ?H ?c' ?C'", "y> ?H ?d' ?C'"],
      [ "?p : ?A + ?B  [ ?H ]",
	"?c'(x) : ?C'(inl(x))  [ ?H, x: ?A ]",
	"?d'(y) : ?C'(inr(y))  [ ?H, y: ?B ]" ],
    (*-------------------------------------------------------------------*)
	"when(?p,?c',?d') : ?C'(?p)  [ ?H ]"  ),
 

  ("Plus_elim_long",   ["x> ?H ?c' ?e' ?C'", "y> ?H ?d' ?f' ?C'"],
      [ "?p = ?q : ?A + ?B  [ ?H ]",
	"?c'(x) = ?e'(x) : ?C'(inl(x))  [ ?H, x: ?A ]",
	"?d'(y) = ?f'(y) : ?C'(inr(y))  [ ?H, y: ?B ]" ],
    (*-------------------------------------------------------------------*)
	"when(?p,?c',?d') = when(?q,?e',?f') : ?C'(?p)  [ ?H ]"  ),
 

  ("Plus_comp_inl",   ["x> ?H ?c' ?C'", "y> ?H ?d' ?C'"],
      [ "?a : ?A  [ ?H ]",
	"?c'(x) : ?C'(inl(x))  [ ?H, x: ?A ]",
	"?d'(y) : ?C'(inr(y))  [ ?H, y: ?B ]" ],
    (*-------------------------------------------------------------------*)
	"when(inl(?a),?c',?d') = ?c'(?a) : ?C'(inl(?a))  [ ?H ]"  ),
 

  ("Plus_comp_inr",   ["x> ?H ?c' ?C'", "y> ?H ?d' ?C'"],
      [ "?b : ?B  [ ?H ]",
	"?c'(x) : ?C'(inl(x))  [ ?H, x: ?A ]",
	"?d'(y) : ?C'(inr(y))  [ ?H, y: ?B ]" ],
    (*-------------------------------------------------------------------*)
	"when(inr(?b),?c',?d') = ?d'(?b) : ?C'(inr(?b))  [ ?H ]"  ),
 


  (* Rules for type Eq*)


  ("Eq_form",   [],
      [ "?A type  [ ?H ]",   "?a : ?A  [ ?H ]",   "?b : ?A  [ ?H ]" ] ,
    (*----------------------------------------------------------------*)
	"Eq(?A,?a,?b) type  [ ?H ]"  ),


  ("Eq_form_long",   [],
      [ "?A = ?B  [?H]",   "?a = ?c: ?A  [?H]",   "?b = ?d : ?A  [?H]" ] ,
    (*------------------------------------------------------------------*)
	"Eq(?A,?a,?b) = Eq(?B,?c,?d)  [ ?H ]"  ),


  ("Eq_intr",   [],
      [ "?a = ?b : ?A  [ ?H ]" ] ,
    (*-----------------------------*)
	"eq : Eq(?A,?a,?b)  [ ?H ]"),


  ("Eq_elim",   [],
      [ "?p : Eq(?A,?a,?b)  [ ?H ]" ] ,
    (*-----------------------------*)
	"?a = ?b : ?A  [ ?H ]"     ),

  (*By equality of types, can prove C(p) from C(eq), an elimination rule*)
  ("Eq_comp",   [],
      [ "?p      : Eq(?A,?a,?b)  [ ?H ]" ] ,
    (*----------------------------------*)
	"?p = eq : Eq(?A,?a,?b)  [ ?H ]" ),


  (* Rules for type  F*)

  ("F_form",   [],
      [] ,    "F type  [ ?H ]"  ),

  ("F_elim",   [],
      [ "?p : F  [?H]",  "?C type  [?H]" ],
    (*---------------------------------------*)
	"contr(?p) : ?C  [?H]"  ),
 
  ("F_elim_long",   [],
      [ "?p = ?q : F  [?H]",  "?C type  [?H]" ],
    (*--------------------------------------------*)
	"contr(?p) = contr(?q) : ?C  [?H]"  ),


  (* Rules for type  T 
     Martin-Lof's book (page 68) discusses elimination and computation.
     Elimination can be derived by computation and equality of types,
     	but with an extra premise C(x) type [ x:T ].
     Also computation can be derived from elimination. *)

  ("T_form",   [],
      [] ,    "T type  [ ?H ]"  ),

  ("T_intr",   [],
      [] ,    "tt : T  [ ?H ]"  ),

  ("T_elim",   [],
      [ "?p : T  [ ?H ]",    "?c : ?C'(tt)  [ ?H ]" ],
    (*--------------------------------------------------*)
	           "?c : ?C'(?p)  [ ?H ]"  ),
 
  ("T_elim_long",   [],
      [ "?p = ?q : T  [ ?H ]",    "?c = ?d : ?C'(tt)  [ ?H ]" ],
    (*------------------------------------------------------------*)
	           "?c = ?d : ?C'(?p)  [ ?H ]"  ),
 
  ("T_comp",   [],
      [ "?p      : T  [ ?H ]" ] ,
    (*------------------------------*)
	"?p = tt : T  [ ?H ]" )

];


val rule_named = get_rule TypeThy;

