(*  Title: 	tt-ex-bool.ML
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge
*)

(*the type Bool, defined as T+T*)


(*formation rule*)
read_goal TypeThy "Bool type [H]";
expand (unfold_goal_tac ["Bool"]);
expand typechk_tac;
val bool_form = top_rule();


(*introduction rules for true, false*)

read_goal TypeThy "true : Bool [H]";
expand (unfold_goal_tac ["Bool","true"]);
expand typechk_tac;
val bool_intr_true = top_rule();

read_goal TypeThy "false : Bool [H]";
expand (unfold_goal_tac ["Bool","false"]);
expand typechk_tac;
val bool_intr_false = top_rule();


(*elimination rule: typing of cond*)
read_goal TypeThy "cond(p,a,b) : C'(p) [H]";
expand (unfold_goal_tac ["cond"]);
expand (determ_resolve_tac ([Plus_elim,T_elim0], 2));
expand (fold_tac ["Bool","true","false"]);
val bool_elim = top_rule();


read_goal TypeThy "cond(p,a,b) = cond(q,c,d) : C'(p) [H]";
expand (unfold_goal_tac ["cond"]);
expand (determ_resolve_tac ([Plus_elim_long,T_elim_long0], 2));
expand (fold_tac ["Bool","true","false"]);
val bool_elim_long = top_rule();


(*computation rules for true, false*)

read_goal TypeThy "cond(true,a,b) = a : C'(true) [H]";
expand (unfold_goal_tac ["cond","true","false"]);
expand (determ_resolve_tac (T_elim0::comp_rls, 2));
expand (fold_tac ["Bool","true","false"]);
val bool_comp_true = top_rule();


read_goal TypeThy "cond(false,a,b) = b : C'(false) [H]";
expand (unfold_goal_tac ["cond","true","false"]);
expand (determ_resolve_tac (T_elim0::comp_rls, 2));
expand (fold_tac ["Bool","true","false"]);
val bool_comp_false = top_rule();

