(*  Title: 	set-resolve
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge
*)

(*Set Theory resolution tactics
*)


(*  x1 : ?B [ ?H, x1 : ?A ]     
    -----------------------
       ?A <= ?B [ ?H ] 
    PROVISO   x1> ?A ?B ?H      *)
read_goal SetThy "A <= B  [ H ]";
expand (unfold_goal_tac ["<="]);
expand (REPEAT (resolve_tac intr_rls 1));
val subset_intr = ttop_rule();


(*  ?R [ ?H, ?G, y4 : ?A, ~ y4 : ?B ]     
    ---------------------------------
        ?R [ ?H, ~ ?A <= ?B, ?G ]
    PROVISO  y4> ?A ?B ?G ?H ?R	*)
read_goal SetThy "R [ H, ~ A <= B, G ]";
expand (unfold_goal_tac ["<="]);
expand (resolve_tac [all_right] 1);
expand (resolve_tac [imp_right] 1);
val subset_right = ttop_rule();



(*  ?Q [ ?H, ?G, ~ ?a: ?A ]     ?Q [ ?H, ?G, ?a: ?B ]     
    -------------------------------------------------
    	       ?Q [ ?H, ?A <= ?B, ?G ]
  Thinned version is incomplete (?)	    *)
read_goal SetThy "Q  [ H, A <= B, G ]";
expand (unfold_goal_tac ["<="]);
expand (rcut_tac "a : A ==> a : B" 1);
expand (resolve_tac [all_elimh] 1);
expand (resolve_tac [thin] 1);
expand (resolve_tac [cases_imp_elimh] 1);
val subset_elimh = ttop_rule();



(*  ?R [ ?H, ?G, ~ ?a : ?A ]     ?R [ ?H, ?G, ~ ?P'(?a) ]     
    -----------------------------------------------------
	  ?R [ ?H, ~ ?a : Collect(?A,?P'), ?G ] 	*)
read_goal SetThy "R [ H, ~ a:Collect(A,P'), G ]";
expand (resolve_tac [new_imp_hyp] 1);
expand (resolve_tac [ iff_elim2 RES Collect_iff RES assume ] 1);
expand (resolve_tac [thin] 1);
expand (resolve_tac [conj_right] 1);
val Collect_right = ttop_rule();


(*   ?Q [ ?H, ?G, ?a : ?A, ?P'(?a) ]     
    ----------------------------------
    ?Q [ ?H, ?a : Collect(?A,?P'), ?G ]   *)
read_goal SetThy "Q [ H, a:Collect(A,P'), G ]";
expand (resolve_tac [ cut RES iff_elim1 RES Collect_iff RES assume ] 1);
expand (resolve_tac [thin] 1);
expand (resolve_tac [conj_elimh] 1);
val Collect_elimh = ttop_rule();



(*    ?R [ ?H, ?G, ~ ?A <= ?B ]     
    -----------------------------
    ?R [ ?H, ~ ?A : Pow(?B), ?G ]
  Should powerset rules produce subgoals involving ":" instead of "<=" ?*)
read_goal SetThy "R [ H, ~ A : Pow(B), G ]";
expand (resolve_tac [new_imp_hyp] 1);
expand (resolve_tac [ iff_elim2 RES Pow_iff RES assume ] 1);
expand (resolve_tac [thin] 1);
val Pow_right = ttop_rule();


(*    ?Q [ ?H, ?G, ?A <= ?B ]     
    ---------------------------
    ?Q [ ?H, ?A : Pow(?B), ?G ]     *)
read_goal SetThy "Q  [ H, A : Pow(B), G ]";
expand (resolve_tac [ cut RES iff_elim1 RES Pow_iff RES assume ] 1);
expand (resolve_tac [thin] 1);
val Pow_elimh = ttop_rule();




(*  ?R [ ?H, ?G, ~ ?B : ?C ]     ?R [ ?H, ?G, ~ ?A : ?B ]     
    -----------------------------------------------------
	       ?R [ ?H, ~ ?A : Union(?C), ?G ]	
  Also version without thinning. 
  Clever manipulation to make ?B:?C the first goal,
	for sensible decomposition of the set Union(?C)	*)
read_goal SetThy "R [ H, ~ A: Union(C), G ]";
expand (rcut_tac "~ (B: C & A: B)" 1);
expand (resolve_tac [new_imp_hyp] 1);
expand (resolve_tac [ iff_elim2 RES Union_iff RES assume ] 1);
expand (SELECT_GOAL class_tac 1);
expand (resolve_tac [conj_right ] 1);
val Union_right_nothin = ttop_rule();
expand (resolve_tac [thin] 1);
expand (resolve_tac [thin] 2);
val Union_right = ttop_rule();




(*  ?Q [ ?H, ?G, ?A : y6, y6 : ?C ]     
    -------------------------------
     ?Q [ ?H, ?A : Union(?C), ?G ] 
    PROVISO  y6> ?A ?C ?G ?H ?Q 	*)
read_goal SetThy "Q [ H, A: Union(C), G ]";
expand (resolve_tac [ cut RES iff_elim1 RES Union_iff RES assume ] 1);
expand (resolve_tac [ exists_elimh RES conj_elimh ] 1);
expand (resolve_tac [thin] 1);
val Union_elimh = ttop_rule();



(*  ?a : ?a :: ?A [ ?H ]  USED?????????*)
read_goal SetThy "a : (a::A)  [ H ]";
expand (resolve_tac [ iff_elim2 RES setcons_iff RES disj_intr1 RES refl ] 1);
val setcons_intr1 = ttop_rule();



(*  ?R [ ?H, ?G, ~ ?a = ?b, ~ ?a : ?B ]     
    -----------------------------------
      ?R [ ?H, ~ ?a : ?b :: ?B, ?G ]	*)
read_goal SetThy "R [ H, ~ a : (b::B), G ]";
expand (resolve_tac [new_imp_hyp] 1);
expand (resolve_tac [ iff_elim2 RES setcons_iff RES assume ] 1);
expand (resolve_tac [thin] 1);
expand (resolve_tac [disj_right] 1);
val setcons_right = ttop_rule();


(*  ?Q [ ?H, ?G, ?a = ?b ]     ?Q [ ?H, ?G, ?a : ?B ]     
    -------------------------------------------------
                 ?Q [ ?H, ?a : (?b::?B), ?G ]     *)
read_goal SetThy "Q  [ H, a : (b::B), G ]";
expand (resolve_tac [ cut RES iff_elim1 RES setcons_iff RES assume ] 1);
expand (resolve_tac [disj_elimh] 1);
expand (resolve_tac [thin] 1);
expand (resolve_tac [thin] 2);
val setcons_elimh = ttop_rule();



(* Deletion of useless assumption
         ?R [ ?H, ?G ]     
    -------------------------
    ?R [ ?H, ?a: 0==>?Q, ?G ]	*)
read_goal SetThy "R [ H, a:0==>Q, G ]";
expand (resolve_tac [thin] 1);
val nullset_thin = ttop_rule();


(*  ?a : 0 [ ?H ]     
    -------------
      ?Q [ ?H ]		*)
read_goal SetThy "Q [ H ]";
expand (rcut_tac "a:0" 1);
expand (resolve_tac [ F_elim RES nullset RES assume ] 2);
val nullset_elim = ttop_rule();


(*?R [ ?H, ?a : 0, ?G ]   *)
read_goal SetThy "R [ H, a:0, G ]";
expand (resolve_tac [ cut RES F_elim RES nullset RES assume RES assume ] 1);
val nullset_elimh = ttop_rule();


(*  Deletion of useless assumption
        ?R [ ?H, ?G ]     
    ----------------------
    ?R [ ?H, 0 <= ?A, ?G ]	  *)
read_goal SetThy "R [ H, 0<=A, G ]";
expand (resolve_tac [thin] 1);
val nullsub_thin = ttop_rule();




val set_rls = quicksort ruleseq
    [nullset_elimh,
     subset_right, Collect_right, Collect_elimh, Pow_right, Pow_elimh, 
     Union_elimh, setcons_right, setcons_elimh, nullset_thin, nullsub_thin];


(*Rules that introduce a new variable must be used last of all!*)
val var_set_rls = [subset_elimh, Union_right];


fun new_set_step_tac (rls1,rls2) =
  new_cl_step_tac (rls1@set_rls, rls2@var_set_rls);

fun new_set_tac (rls1,rls2) =
  new_class_tac (rls1@set_rls, rls2@var_set_rls);

val set_step_tac = new_set_step_tac ([],[]);
val set_tac = new_set_tac ([],[]);

 





(*Simplification.....................*)


(*  ?A = ?B [ ?H ]     ?C = ?D [ ?H ]     ?B <= ?D [ ?H ]     
    -----------------------------------------------------
		    ?A <= ?C [ ?H ]		*)
read_goal SetThy "A <= C  [ H ]";
expand (rcut_tac "A = B" 1);
expand (rcut_tac "C = D" 2);
expand (rcut_tac "B <= D" 3);
expand (resolve_tac [F_elim] 4);
expand (REPEAT (set_step_tac 4));
expand (resolve_tac
  [ imp_elimh RES member_cong RES refl RES sym RES assume ] 4);
expand (resolve_tac [ imp_elimh RES member_cong RES refl ] 5);
expand (REPEAT (resolve_tac [assume] 4));
expand (resolve_tac [thin] 2);
expand (resolve_tac [thin] 3);
expand (resolve_tac [thin] 3);
val subset_cong = ttop_rule();


read_goal SetThy "A <= A  [ H ]";
expand set_tac;
val subset_refl = ttop_rule();


(* ?A <= ?B [ ?H ]     ?B <= ?C [ ?H ]     
   -----------------------------------
	    ?A <= ?C [ ?H ]    *)
read_goal SetThy "A <= C  [ H ]";
expand (rcut_tac "A <= B" 1);
expand (rcut_tac "B <= C" 2);
expand (SELECT_GOAL set_tac 3);
expand (resolve_tac [thin] 2);
val subset_trans = ttop_rule();



(*  ?Q [ ?H, ?G, ~ ?A <= ?B ]     ?Q [ ?H, ?G, ~ ?B <= ?A ]     
    -------------------------------------------------------
		?Q [ ?H, ~ ?A = ?B, ?G ]	
  In a sequent calculus, this would be the extensionality rule*)
read_goal SetThy "Q  [ H, ~ A=B, G ]";
expand (rcut_tac "~ (A<=B  & B<=A)" 1);
expand (resolve_tac [F_elim RES imp_elimh RES extensionality] 1);
expand (resolve_tac [ imp_right RES conj_elimh RES assume ] 2);
expand (resolve_tac [ imp_right RES conj_elimh RES assume ] 1);
expand (resolve_tac [thin] 1);
expand (resolve_tac [conj_right] 1);
val equal_right = ttop_rule();



(*  ?Q [ ?H, ?G, ?A <= ?B, ?B <= ?A ]     
    ---------------------------------
        ?Q [ ?H, ?A = ?B, ?G ]		*)
read_goal SetThy "Q  [ H, A = B, G ]";
expand (rcut_tac "A <= B" 1);
expand (rcut_tac "B <= A" 2);
expand (resolve_tac [subset_cong] 2);
expand (resolve_tac [subset_cong] 1);
expand (DEPTH_FIRST (has_prems 1)
	(filt_resolve_tac [assume,refl,subset_refl] 1));
expand (resolve_tac [thin] 1);
val equal_elimh = ttop_rule();



(*               ?A <= ?B [ ?H ]     
    -----------------------------------------
    Collect(?A,?P') <= Collect(?B,?P') [ ?H ]	*)
read_goal SetThy "Collect(A,P') <= Collect(B,P')  [ H ]";
expand (rcut_tac "A <= B" 1);
expand (SELECT_GOAL set_tac 2);
val Collect_mono = ttop_rule();


(*		 ?A = ?B [ ?H ]     
    ----------------------------------------
    Collect(?A,?P') = Collect(?B,?P') [ ?H ]   *)
read_goal SetThy "Collect(A,P') = Collect(B,P')  [ H ]";
expand (rcut_tac "A = B" 1);
expand (resolve_tac [ equal_elimh RES extensionality ] 2);
expand (resolve_tac [ Collect_mono RES assume ] 2);
expand (resolve_tac [ Collect_mono RES assume ] 2);
val Collect_cong = ttop_rule();


(* 	 ?A <= ?B [ ?H ]     
    -------------------------
    Pow(?A) <= Pow(?B) [ ?H ]		*)
read_goal SetThy "Pow(A) <= Pow(B)  [ H ]";
expand (rcut_tac "A <= B" 1);
expand (SELECT_GOAL set_tac 2);
val Pow_mono = ttop_rule();


(* 	 ?A = ?B [ ?H ]     
    -------------------------
    Pow(?A) = Pow(?B) [ ?H ]		*)
read_goal SetThy "Pow(A) = Pow(B)  [ H ]";
expand (rcut_tac "A = B" 1);
expand (resolve_tac [ equal_elimh RES extensionality ] 2);
expand (resolve_tac [ Pow_mono RES assume ] 2);
expand (resolve_tac [ Pow_mono RES assume ] 2);
val Pow_cong = ttop_rule();



(*        ?A <= ?B [ ?H ]     
    -----------------------------
    Union(?A) <= Union(?B) [ ?H ]    *)
read_goal SetThy "Union(A) <= Union(B)  [ H ]";
expand (rcut_tac "A <= B" 1);
expand (SELECT_GOAL set_tac 2);
val Union_mono = ttop_rule();


(*        ?A = ?B [ ?H ]     
    ----------------------------
    Union(?A) = Union(?B) [ ?H ]    *)
read_goal SetThy "Union(A) = Union(B)  [ H ]";
expand (rcut_tac "A = B" 1);
expand (resolve_tac [ equal_elimh RES extensionality ] 2);
expand (resolve_tac [ Union_mono RES assume ] 2);
expand (resolve_tac [ Union_mono RES assume ] 2);
val Union_cong = ttop_rule();


(*  ?a = ?b [ ?H ]     ?A <= ?B [ ?H ]     
    ----------------------------------
	 ?a :: ?A <= ?b :: ?B [ ?H ]	*)
read_goal SetThy "a::A <= b::B  [ H ]";
expand (rcut_tac "a=b" 1);
expand (rcut_tac "A <= B" 2);
expand (resolve_tac [subset_intr] 3);
expand (resolve_tac [setcons_elimh] 3);
expand (resolve_tac [member_cong] 3);
expand (resolve_tac [ trans RES assume RES assume ] 3);
expand (resolve_tac [refl] 3);
expand (resolve_tac [setcons_intr1] 3);
expand (SELECT_GOAL set_tac 3);
expand (resolve_tac [thin] 2);
val setcons_mono = ttop_rule();



(*  ?a = ?b [ ?H ]     ?A = ?B [ ?H ]     
    ---------------------------------
       ?a :: ?A = ?b :: ?B [ ?H ]	*)
read_goal SetThy "a::A = b::B  [ H ]";
expand (rcut_tac "a=b" 1);
expand (rcut_tac "A = B" 2);
expand (resolve_tac [ equal_elimh RES extensionality ] 3  THEN
	resolve_tac [ setcons_mono RES assume RES assume ] 3);
(*Thus eliminating ?a=?b fails, instead ?A=?B is eliminated*)
expand (resolve_tac [ setcons_mono] 3);
expand (resolve_tac [ sym RES assume ] 3);
expand (resolve_tac [assume ] 3);
expand (resolve_tac [thin] 2);
val setcons_cong = ttop_rule();



fun resolve_trans rl =  trans RES rl;


val cong_rls = [Collect_cong, Pow_cong, Union_cong, setcons_cong];


(*  ?A = ?B1 [ ?H ]     ?B = ?B1 [ ?H ]     
    -----------------------------------
	     ?B = ?A [ ?H ]	*)
val transym =  tidyrule(sym  RES  trans  RESN  (2, sym));


(*  reduce(?a,?b) [ ?H ]     
    --------------------
      ?a = ?b [ ?H ]	*)
read_goal SetThy "a = b [H]";
expand (fold_goal_tac ["reduce"]);
val equal_if_red = ttop_rule();



(*     ?a = ?b [ ?H ]     
    --------------------
    reduce(?a,?b) [ ?H ]	*)
read_goal SetThy "reduce(a,b) [H]";
expand (unfold_goal_tac ["reduce"]);
val red_if_equal = ttop_rule();



(*reduce(?a,?a) [ ?H ] *)
val refl_red = red_if_equal RES refl;



(*  ?A = ?B [ ?H ]     reduce(?B,?C) [ ?H ]     
    ---------------------------------------
		?A = ?C [ ?H ]		*)
val trans_red =  tidyrule (trans  RESN  (2, equal_if_red));


(*  ?a = ?B1 [ ?H ]     ?B1 = ?b [ ?H ]     
    -----------------------------------
	reduce(?a,?b) [ ?H ]	*)
val red_trans = tidyrule (red_if_equal RES trans);


(*resolve transym with each nontrivial equality goal*)
fun transym_choose (_ $ (Const("=",_) $ (_$_) $ (_$_)) $ _) = Some [transym]
  | transym_choose _ = None;


val transym_tac = depth_resolve_tac transym_choose;



(*rule for simplifying subterms, for example
    ?A1 = ?B1 [ ?H ]     reduce(Pow(?B1),?C) [ ?H ]     
    -----------------------------------------------
	        Pow(?A1) = ?C [ ?H ]    *)
fun subconv_rule rl = trans_red  RES  rl;


(*rule for resimplifying if possible, for example
  ?a: ?A [?H]   ?b: ?B'(?a) [?H]  ... ?c''(?a,?b) = ?d : ?C'(<?a,?b>) [?H]     
  --------------------------------------------------------------------------
	 reduce(split(<?a,?b>,?c''),?d,?C'(<?a,?b>)) [?H]        *)
fun resimp_rule rl = red_trans  RES  rl;


(*No standard reductions in set theory*)
val reduction_rls = [assume];

val subconv_rls = map subconv_rule cong_rls;


(*rules for simplification (top-level and subterms) *)
fun make_simp_rules (new_comp_rls, new_cong_rls) =
   map resolve_trans new_comp_rls  @    reduction_rls @
   map subconv_rule new_cong_rls   @    subconv_rls   @   [refl];


val resimp_rls =  [ resimp_rule assume ];


(*rules for resimplification*)
fun make_resimp_rules new_comp_rls =
    map resimp_rule new_comp_rls  @  resimp_rls  @  [refl_red];


fun all_simp_rules (new_comp_rls, new_cong_rls) =
    make_simp_rules(new_comp_rls, new_cong_rls) @
    make_resimp_rules new_comp_rls;


(*The form_cong_rls and refl_type allow simplification of types.*)
fun new_simp_tac (new_comp_rls, new_cong_rls, wlimit) =
    determ_resolve_tac (all_simp_rules(new_comp_rls, new_cong_rls),  wlimit) 
    THEN determ_resolve_tac([red_if_equal], 1)
    THEN merge_premises_tac;


(*4 allows for a comp_ rule, assume, a _cong rule, and refl*)
val simp_tac = new_simp_tac([],[],4);

