(*  Title: 	set-ex-pairing
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge

Set theory examples: unordered and ordered pairs

expand (set_step_tac 1);
*)



(*To find contradiction from   a=b, ~ b=a 
  SLOW UNIFICATION *)
val sym_imp_elimh = imp_elimh RES sym RES assume;


read_goal SetThy "a::a::B = a::B [ H ]";
expand (resolve_tac [extensionality] 1);
expand F_elim_tac;
expand set_tac;  (*2 secs*)
val setcons_absorption = ttop_rule();


read_goal SetThy "~ a=b ==> a::b::C = b::a::C [ H ]";
expand (resolve_tac [ imp_intr RES extensionality ] 1);
expand F_elim_tac;
expand set_tac;  (*3 secs*)
val setcons_commute = ttop_rule();


read_goal SetThy "Union(Pow(A)) = A [ H ]";
expand (resolve_tac [extensionality] 1);
expand F_elim_tac;
expand set_tac;  (*1 sec*)
val union_pow_inverse = ttop_rule();


read_goal SetThy "{ {a}, {a,a} } = { {a} } [ H ]";
expand transym_tac;
expand (new_simp_tac ([setcons_absorption], [], 4));




read_goal SetThy "{a,b} <= {c} ==> a=c & b=c [ H ]";
expand set_tac;
(*3 secs*)



read_goal SetThy "a::A <= {b} ==> (a = b & A <= {b}) [ H ]";
expand set_tac; (*2 secs*)
val sub_single_imp = ttop_rule();


(*  ?Q [ ?H, ?G, ?a = ?b, ?A <= {?b} ]     
    ----------------------------------
       ?Q [ ?H, ?a::?A <= {?b}, ?G ] 	*)
read_goal SetThy "Q [ H, a::A <= {b}, G ]";
expand (use_imp_tac sub_single_imp);
val sub_single_elimh = ttop_rule();


read_goal SetThy "a::A <= b::B ==> ((a=b | a:B) & A<=b::B) [ H ]";
expand set_tac;  (*3 secs*)
val sub_setcons_imp = ttop_rule();


(*  ?Q [ ?H, ?G, ?A <= ?b::?B, ?a=?b ]    ?Q [ ?H, ?G, ?A <= ?b::?B, ?a:?B ]  
    ------------------------------------------------------------------------
		?Q [ ?H, ?a::?A <= ?b::?B, ?G ]		*)
read_goal SetThy "Q [ H, a::A <= b::B, G ]";
expand (use_imp_tac sub_setcons_imp);
val sub_setcons_elimh = ttop_rule();



read_goal SetThy
  "a::A = b::B ==>  (b=a | ~ b=a & a:B & b:A) & A<=b::B & B<=a::A [ H ]";
expand (resolve_tac [imp_intr RES equal_elimh] 1);
expand (SELECT_GOAL 
	 (new_set_tac ([sub_setcons_elimh, sym_imp_elimh],[])) 1);  (*6 secs*)
val equal_setcons_imp = ttop_rule();


(*  ?Q [ ?H, ?G, ?b=?a, ?A <= ?b :: ?B, ?B <= ?a :: ?A ] 
    ?Q [ ?H, ?G, ~ ?b=?a, ?a : ?B, ?b : ?A, ?A <= ?b :: ?B, ?B <= ?a :: ?A ]        ------------------------------------------------------------------------
    ?Q [ ?H, ?a :: ?A = ?b :: ?B, ?G ] 		*)
read_goal SetThy "Q [ H, a::A = b::B, G ]";
expand (use_imp_tac equal_setcons_imp);
val equal_setcons_elimh = ttop_rule();



(*Basic lemma for proving that pairing works*)
read_goal SetThy "{a,b} = {c,d} ==> (a=c & b=d  |  a=d & b=c) [H]";
expand F_elim_tac;
expand (SELECT_GOAL (new_set_tac
   ([sym_imp_elimh, sub_setcons_elimh, equal_setcons_elimh], [])) 1);
(*36 secs???*)
val equal_upair_imp = ttop_rule();


(*  ?Q [ ?H, ?G, ?a = ?c, ?b = ?d ]     ?Q [ ?H, ?G, ?a = ?d, ?b = ?c ]     
    -------------------------------------------------------------------
		?Q [ ?H, {?a,?b} = {?c,?d}, ?G ]	*)
read_goal SetThy "Q [ H, {a,b} = {c,d}, G ]";
expand (use_imp_tac equal_upair_imp);
val equal_upair_elimh = ttop_rule();



read_goal SetThy "{a} = {b} ==> a=b  [H]";
expand (resolve_tac [imp_intr RES equal_elimh] 1);
expand set_tac;  (*3 secs*)


read_goal SetThy "{ {a}, {a,b} } <= { {c} } ==> a=c & b=c [ H ]";
expand F_elim_tac;
expand (REPEAT (new_set_step_tac([sub_single_elimh],[]) 1 
		ORELSE filt_resolve_tac [equal_elimh] 1));
(*3 secs!*)



(*PAIRING IS INJECTIVE (WELL DEFINED)  *)

val stac = new_set_step_tac
    ([sym_imp_elimh, sub_setcons_elimh, nullsub_thin,
      equal_upair_elimh, equal_setcons_elimh], []);

read_goal SetThy "<a,b> = <c,d>  ==>  a=c  &  b=d   [ H ]";
expand (unfold_goal_tac ["Pair"]);
expand F_elim_tac;
expand (REPEAT (stac 1));  (*3 secs*)
expand (REPEAT (stac 2));  (*2 secs*)
expand (REPEAT (stac 3));  (*2 secs*)
expand (resolve_tac [imp_elimh] 1);
expand (resolve_tac [trans RES assume] 1);
expand (resolve_tac [trans RES assume] 1);
expand (resolve_tac [assume] 1);
expand (resolve_tac [imp_elimh] 1);
expand (resolve_tac [trans RES assume] 1);
expand (resolve_tac [trans RES assume] 1);
expand (resolve_tac [sym RES assume] 1);
val pairing_imp = ttop_rule();


read_goal SetThy "Q [ H, <a,b> = <c,d>, G ]";
expand (use_imp_tac pairing_imp);
val pairing_injective = ttop_rule();


