(*  Title: 	pc-ex-int
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge

Predicate Calculus Examples: Intuitionistic

expand (pc_step_tac 1);
expand (pc_leap_tac 1);
backtrack();
expand (resolve_tac [cut_all_elimh] 1);
*)



(*absorptive laws of & and | *)

read_goal SetThy "P & P <=> P  [ H ]";
expand pc_tac;

read_goal SetThy "P | P <=> P  [ H ]";
expand pc_tac;

(*commutative laws of & and | *)

read_goal SetThy "P & Q  <=>  Q & P  [ H ]";
expand pc_tac;

read_goal SetThy "P | Q  <=>  Q | P  [ H ]";
expand pc_tac;


(*associative laws of & and | *)

read_goal SetThy "(P & Q) & R  <=>  P & (Q & R)  [ H ]";
expand pc_tac;

read_goal SetThy "(P | Q) | R  <=>  P | (Q | R)  [ H ]";
expand pc_tac;
(*8 secs: disjunction requires search!*)


(*distributive laws of & and | *)
read_goal SetThy "(P & Q) | R  <=> (P | R) & (Q | R)  [ H ]";
expand pc_tac;
(*10 secs*)

read_goal SetThy "(P | Q) & R  <=> (P & R) | (Q & R)  [ H ]";
expand pc_tac;
(*6 secs*)

(*Laws involving implication*)

read_goal SetThy "(P|Q ==> R) <=> (P==>R) & (Q==>R)  [ H ]";
expand pc_tac; 
(*4 secs*)

read_goal SetThy "(P & Q ==> R) <=> (P==> (Q==>R))  [ H ]";
expand pc_tac; 

read_goal SetThy "((P ==> Q)  &  P) ==> Q  [ H ]";
expand pc_tac;


(*The polymorphic type of the combinator K*)
read_goal SetThy "P ==> (Q ==> P)  [ H ]";
expand pc_tac;

(*The combinator S*)
read_goal SetThy "(P ==> Q ==> R)  ==> (P ==> Q) ==> (P ==> R) [ H ]";
expand pc_tac;


read_goal SetThy "(P ==> Q & R) <=> (P==>Q)  &  (P==>R)  [ H ]";
expand pc_tac;
(*6 secs*)


(*Converse is classical*)
read_goal SetThy "(P==>Q) | (P==>R)  ==>  (P ==> Q | R)  [ H ]";
expand pc_tac;
(*3 secs*)

read_goal SetThy "(P==>Q)  ==>  (~(Q) ==> ~(P))  [ H ]";
expand pc_tac;


read_goal SetThy "~ ~(P | ~ P)  [ H ]";
expand pc_tac;


(*Peirce's law*)
read_goal SetThy "~ ~ (((P==>Q) ==> P)  ==>  P ) [ H ]";
expand pc_tac;


read_goal SetThy "~ ~ ((P==>Q) | (Q==>P)) [ H ]";
expand pc_tac;


read_goal SetThy "~ ~ ((P ==> Q | R)  ==>  (P==>Q) | (P==>R))  [ H ]";
expand pc_tac;
(*12 secs*)


(*CANNOT BE DONE: too much branching*)
read_goal SetThy "~ ~ (((P <=> Q) <=> R)  ==>  (P <=> (Q <=> R)))  [H]";
expand (unfold_goal_tac ["<=>"]);
expand pc_tac;


(*Quantifiers*)

read_goal SetThy "(ALL x. P)  <=>  P  [ H ]";
expand pc_tac; 


read_goal SetThy "(ALL x. P'(x) & Q'(x))    \
\            <=>  (ALL x. P'(x))  &  (ALL x. Q'(x))  [ H ]";
expand pc_tac; 


(*Converse is false*)
read_goal SetThy "(ALL x. P'(x))  |  (ALL x. Q'(x))    \
\            ==>  (ALL x. P'(x) | Q'(x))  [ H ]";
expand pc_tac; 

read_goal SetThy "(ALL x. P ==> Q'(x)) \
\            <=>  (P ==> ALL x. Q'(x))  [ H ]";
expand pc_tac; 


read_goal SetThy "(ALL x.P'(x)==>Q)  <=>  ((EXISTS x.P'(x)) ==> Q)  [H]";
expand pc_tac; 


read_goal SetThy "(EXISTS x. P)  <=>  P  [ H ]";
expand pc_tac; 


read_goal SetThy "(EXISTS x. P'(x) | Q'(x)) \
\            <=>  (EXISTS x. P'(x))  |  (EXISTS x. Q'(x))  [ H ]";
expand pc_tac; 
(*6 secs*)


(*Converse is false*)
read_goal SetThy "(EXISTS x. P'(x) & Q'(x)) \
\            ==>  (EXISTS x. P'(x))  &  (EXISTS x. Q'(x))  [ H ]";
expand pc_tac; 


(*Converse is classical*)
read_goal SetThy "(EXISTS x. P ==> Q'(x)) \
\            ==>  (P ==> EXISTS x. Q'(x))  [ H ]";
expand pc_tac; 
(*4 secs*)


(*Converse is classical;  even its double negation fails constructively*)
read_goal SetThy "(EXISTS x.P'(x)==>Q)  ==>  (ALL x.P'(x)) ==> Q  [H]";
expand pc_tac; 
(*5 secs*)


read_goal SetThy "((ALL x.P'(x))==>Q)  ==>  ~ ALL x. P'(x) & ~ Q  [H]";
expand pc_tac; 
(*6 secs*)

read_goal SetThy "((ALL x. ~P'(x))==>Q)  ==>  ~ ALL x. ~ (P'(x)|Q)  [H]";
expand pc_tac; 
(*10 secs*)


(*Converse is classical*)
read_goal SetThy "(ALL x.P'(x)) | Q  ==>  (ALL x. P'(x) | Q)  [H]";
expand pc_tac; 


(*Useless flex-flex pairs, showing BUG in printing of hyps*)
read_goal SetThy "F [ Q,  P'(?a) & ~ Q ]";
expand (resolve_tac [conj_elimh] 1);
expand (resolve_tac [imp_elimh] 1);
expand smash_hobj_tac;


(*Basic test of quantifier reasoning*)
(*TRUE*)
read_goal SetThy "(EXISTS y. ALL x. Q''(x,y))  \
\            ==>  (ALL x. EXISTS y. Q''(x,y))  [ H ]";
expand pc_tac;  


(*FALSE*)
read_goal SetThy "(ALL x. EXISTS y. Q''(x,y))  \
\            ==>  (EXISTS y. ALL x. Q''(x,y))  [ H ]";
expand pc_tac;  


(*faulty proof attempt, stripping the quantifiers in wrong sequence
expand intr_tac;
expand (resolve_tac [exists_elimh] 1);
expand (resolve_tac [all_elimh] 1);
expand (resolve_tac [assume] 1);
    ...fails!  parameter dependencies forbid using the hypothesis *)


read_goal SetThy
    "(ALL x. P'(x)==>Q'(x)) & (EXISTS x.P'(x)) ==> EXISTS x.Q'(x) [ H ]";
expand pc_tac;  


(*An example of why exists_intr should be delayed as long as possible*)
read_goal SetThy "(P ==> EXISTS x.Q'(x)) & P ==> EXISTS x.Q'(x) [ H ]";
expand pc_tac;  


read_goal SetThy
    "(ALL x. P'(x)==>Q'(a'(x))) & (ALL x. Q'(x)==>R'(b'(x))) &  P'(d) \
\    ==> R'(?e)  [ H ]";
expand pc_tac;  


(*NOT PROVED DUE TO THINNING OF QUANTIFIED ASSUMPTIONS*)
read_goal SetThy
    "(ALL x. P'(x)==>P'(a'(x)))  &  P'(d) ==> P'(a'(a'(x)))  [ H ]";
expand pc_tac;  


(*The following are NOT constructively valid;
  the attempt to prove them terminates quickly!*)
read_goal SetThy "((P==>Q) ==> P)  ==>  P  [ H ]";
read_goal SetThy "(P&Q==>R)  ==>  (P==>R) | (Q==>R)  [ H ]";
read_goal SetThy "((ALL x.P'(x)) ==> Q)  ==>  (EXISTS x.P'(x)==>Q)  [H]";
read_goal SetThy "(P ==> EXISTS x.Q'(x))  ==>  EXISTS x. P==>Q'(x)  [H]";
read_goal SetThy "(ALL x. P'(x) | Q)  ==>  ((ALL x.P'(x)) | Q)  [H]";
read_goal SetThy "(ALL x. ~ ~ P'(x))  ==>  ~ ~ ALL x. P'(x)  [H]";


(*Classically valid and proved via a bug in previous versions*)
read_goal SetThy "EXISTS x. (Q'(x) ==> ALL x. Q'(x))  [G]";
expand pc_tac;


(*enumeration of theorems?  fails due to looping in unification*)
read_goal SetThy "?P [ H ]";
expand pc_tac;  



