(*  Title: 	class-resolve
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge
*)

(*Predicate Calculus resolution tactics -- classical

need LEFT and RIGHT rules for <=>   try Dijkstra's law
*)



(*Approach is similar to tableax:
  Sequent rules for simplifying or eliminating implications.
  The goal itself is always F. 
  Note that negative assumptions are like goals;
  the rule that replaces the assumption ~(P|Q) by ~P and ~Q
  is equivalent to the sequent rule for proving H -> P|Q from H -> P,Q

  It would be better to start with a sequent calculus, with negation primitive
*)

(*  ?R [ ?H, ?G, ~ ?P, ~ ?Q ]     
    --------------------------
    ?R [ ?H, ~ (?P | ?Q), ?G ]    *)
read_goal SetThy "R [ H, ~(P|Q), G ]";
expand (rcut_tac "~P" 1);
expand (rcut_tac "~Q" 2);
expand (resolve_tac [thin] 3);
expand (resolve_tac [imp_intr] 1);
expand (resolve_tac [ imp_elimh RES disj_intr1 RES assume ] 1);
expand (resolve_tac [imp_intr] 1);
expand (resolve_tac [ imp_elimh RES disj_intr2 RES assume ] 1);
val disj_right = tidyrule(top_rule());



(*    ?R [ ?H, ?G, ~ ?P'(?a) ]     
    ----------------------------
    ?R [ ?H, ~ Exists(?P'), ?G ] 
  Probably not complete: should not thin the assumption.*)
read_goal SetThy "R [ H, ~ Exists(P'), G ]";
expand (rcut_tac "~ P'(a)" 1);
expand (resolve_tac [thin] 2);
expand (resolve_tac [imp_intr] 1);
expand (resolve_tac [ imp_elimh RES exists_intr RES assume ] 1);
val exists_right = tidyrule(top_rule());



(*  ?R [ ?H, ?G, ~ ?P ]     ?R [ ?H, ?G, ~ ?Q ]     
    -------------------------------------------
	    ?R [ ?H, ~ (?P & ?Q), ?G ] 		 *)
read_goal SetThy "R [ H, ~(P&Q), G ]";
expand (rcut_tac "~P | ~Q" 1);
expand (resolve_tac [thin] 2);
expand (resolve_tac [F_elim] 1);
expand (resolve_tac [imp_elimh RES conj_intr] 1);
expand (resolve_tac [F_elim] 1);
expand (resolve_tac [ imp_elimh RES disj_intr1 RES assume ] 1);
expand (resolve_tac [F_elim] 1);
expand (resolve_tac [ imp_elimh RES disj_intr2 RES assume ] 1);
expand (resolve_tac [disj_elimh] 1);
val conj_right = tidyrule(top_rule());



(*    ?R [ ?H, ?G, ?P, ~ ?Q ]     
    ----------------------------
    ?R [ ?H, ~ (?P ==> ?Q), ?G ]      *)
read_goal SetThy "R [ H, ~(P==>Q), G ]";
expand (rcut_tac "P & ~ Q" 1);
expand (resolve_tac [thin] 2);
expand (resolve_tac [F_elim] 1);
expand (resolve_tac [imp_elimh RES imp_intr] 1);
expand (resolve_tac [F_elim] 1);
expand (resolve_tac [ imp_elimh RES conj_intr RES assume RES assume ] 1);
expand (resolve_tac [conj_elimh] 1);
val imp_right = tidyrule(top_rule());


(*  ?R [ ?H, ?G, ~ ?P'(y3) ]     
    -------------------------
    ?R [ ?H, ~ All(?P'), ?G ] 
  PROVISO  y3> ?G ?H ?P' ?R       *)
read_goal SetThy "R [ H, ~ All(P'), G ]";
expand (rcut_tac "EXISTS x. ~ P'(x)" 1);
expand (resolve_tac [exists_elimh] 2);
expand (resolve_tac [thin] 2);
expand (resolve_tac [F_elim] 1);
expand (resolve_tac [imp_elimh RES all_intr ] 1);
expand (resolve_tac [F_elim] 1);
expand (resolve_tac [ imp_elimh RES exists_intr RES imp_intr ] 1);
expand (resolve_tac [ imp_elimh RES assume ] 1);
val all_right = tidyrule(top_rule());


(*       ?R [ ?H, ?G ]     
    -----------------------
    ?R [ ?H, F ==> ?P, ?G ] 
  Deletion of assumption that could cause needless case split*)
read_goal SetThy "R [ H, F==>P, G ]";
expand (resolve_tac [thin] 1);
val F_imp_thin = tidyrule(top_rule());


(*  ?R [ ?H, ?G, ~ ?P ]     ?R [ ?H, ?G, ?Q ]     
    -----------------------------------------
           ?R [ ?H, ?P ==> ?Q, ?G ] 
  Left-implication sequent rule.  LOOPS if ?Q is F!  So ~ should be primitive*)
read_goal SetThy "R [ H, P==>Q, G ]";
expand (rcut_tac "~P | Q" 1);
expand (resolve_tac [F_elim ] 1);
expand (resolve_tac [disj_right] 1);
expand (resolve_tac [imp_right] 1);
expand (resolve_tac [ imp_elimh RES imp_elimh RES assume ] 1);
expand (resolve_tac [thin] 1);
expand (resolve_tac [disj_elimh] 1);
val cases_imp_elimh = tidyrule(top_rule());


(*Is the term an implication P=>Q, other than a negation?  
  Needed since ~P is always expanded to P=>F *)
fun is_real_imp (Const("==>",_)$_$Q) = Q<>F
  | is_real_imp _ = false;


val PimpQ_hyp = abs_hobj (rdset"?P ==> ?Q");

(*Tactic for using cases_imp_elimh without looping.*)
fun cases_imp_tac pno prf =
  case (nth_tail(pno-1, prems_of_rule prf)) of
      (_ $ _ $ Abs(_,_,body)) :: _ =>
	    (case (filter is_real_imp (form_hyps_of body)) of
		[] => null_sequence
	      | fm::_ => constrain_res_tac [ (PimpQ_hyp, abs_hobj fm) ]
			      cases_imp_elimh pno prf)
    | _ => null_sequence;



(*   ?R [ ?H, ~ ?a = ?a, ?G ]    *)
read_goal SetThy "R [ H, ~ a=a, G ]";
expand (resolve_tac [F_elim] 1);
expand (resolve_tac [imp_elimh RES refl] 1);
val refl_right = tidyrule(top_rule());


(*Contradiction if ~P and P are both assumed
  WARNING: RESOLUTION WITH THIS THEOREM TAKES SECONDS! 
  Finally resolved with assume to get flex-flex constraint *)
read_goal SetThy "R [ H, ~P, G ]";
expand (resolve_tac [ cut_imp_elim RES assume ] 1);
expand (resolve_tac [F_elimh] 2);
val contrassume = tidyrule(top_rule())  RES  assume;  (*NOTE*)


fun negated_of (Const("==>",_) $ P $ Const("F",_)) = [P]
  | negated_of _ = [];


val Pvar = Var(("P",0), Aform);


(*Use contrassume efficiently: find possibly unifiable negations, 
    instantiate rule.  *)
fun contrassume_tac pno prf =
  case (nth_tail(pno-1, prems_of_rule prf)) of
      (_ $ _ $ Abs(_,_,body)) :: _ =>
	let val hyps = tdistinct (form_hyps_of body);
	    val nhyps = flat (map negated_of hyps);
	    fun canres hyp = exists
		  (fn nhyp =>  could_resolve(hyp,nhyp))  nhyps;
	    val reshyps = filter canres hyps;
	    fun ctac Q = constrain_res_tac [(Pvar,Q)] contrassume pno
	in  itlist_right (op APPEND) (map ctac reshyps, no_tac) prf
	end
    | _ => null_sequence;




val classical_rls = quicksort ruleseq
    [F_elimh, all_right, conj_right, imp_right, 
     exists_elimh, conj_elimh, disj_elimh,
     disj_right, F_imp_thin];

(*Rules that introduce a new variable must be used last of all!*)
val var_quant_rls = [exists_right, cut_all_elimh];


(*Use F elimination on all goals that are not already F*)
fun F_choose (_$P$_) = if P=F then None else Some [F_elim]
  | F_choose   _     =  None;

val F_elim_tac = depth_resolve_tac F_choose;


(*Single step of classical proof.
  Must allow backtracking in contrassume_tac since 
	there may be more than one way of finding contradiction.
  Unfortunately these may be due to repeated assumptions*)
fun new_cl_step_tac (frls,lrls) =
  let val first_rules = quicksort ruleseq (frls @ classical_rls)
      and last_rules = quicksort ruleseq (lrls @ var_quant_rls)
  in  fn pno =>
    (contrassume_tac pno ORELSE
     DETERM (filhyp_resolve_tac first_rules pno  ORELSE  cases_imp_tac pno
     	     ORELSE filhyp_resolve_tac last_rules pno)
     ORELSE filhyp_resolve_tac [refl_right] pno)
    THEN  smash_hobj_tac
  end;

fun new_class_tac (frls,lrls) =
  let val stac = new_cl_step_tac (frls,lrls)
  in  F_elim_tac  THEN  BREADTH_FIRST is_theorem (stac 1)  end;

val cl_step_tac = new_cl_step_tac ([],[]);

val class_tac = new_class_tac ([],[]);

