(* LK-rules.

   Rules for classical Predicate Calculus + ZF set Theory,
   using a classical Sequent Calculus.

   Adapted from L. C. Paulson's file "pcset-rules";
   the present rules allow for sequences of conclusions.
*)

val LKSign =
  extend_sign (Signat{lextab=LK_lextab,  defines=[],
		      parse_tm=parse_LK_term,  parse_thm=parse_thm,
        	      print_tm=print_LK_term,  print_thm=print_goal},
         [ ("<=>", InfixSy([Aform,Aform]--->Aform, 10, 9), (*right assoc*)
                   "%(P,Q) (P==>Q)&(Q==>P)"),
           ("reduce", ConstSy([Aexp,Aexp]--->Aform), "%(A,B)A=B"),
           ("<=", InfixSy([Aexp,Aexp]--->Aform, 40, 40), 
		"%(A,B)ALL x. x:A ==> x:B"),
	   ("Inter", ConstSy(Aexp-->Aexp),
		"%(C)Collect(Union(C), %(x)ALL y. y:C ==> x:y)"),
	   ("Un",  InfixSy([Aexp,Aexp]--->Aexp, 50, 49),  "%(a,b)Union({a,b})"),
	   ("Int", InfixSy([Aexp,Aexp]--->Aexp, 60, 59),  "%(a,b)Inter({a,b})"),
	   ("Pair",  ConstSy([Aexp,Aexp]--->Aexp), "%(a,b) { {a}, {a,b} }"),
	   ("*",  InfixSy([Aexp,Aexp]--->Aexp, 60, 59),
		"%(A,B)Collect(Pow(Pow(A Un B)),   \
	           \	%(x) EXISTS a. EXISTS b. a:A & b:B & x= <a,b>)"),
	   ("Domain",  ConstSy(Aexp-->Aexp),
		"%(C)Collect(Union(Union(C)), %(a) EXISTS b. <a,b> : C)"),
	   ("Range",  ConstSy(Aexp-->Aexp),
		"%(C)Collect(Union(Union(C)), %(b) EXISTS a. <a,b> : C)"),
	   ("succ", ConstSy(Aexp-->Aexp),  "%(a) a Un {a}"),
           ("ord", ConstSy(Aexp-->Aform), 
            "%(A) Union(A) <= A & ALL x. x : A ==> Union(x) <= x" ) ]); 

val LKThy = new_theory LKSign [

  ("assume",   [],
      [],  " ?H, ?P, ?G |- ?E, ?P, ?F   "  ),

  ("thinh",    [],
      [ " ?H, ?G |- ?E " ], 
    (*-----------------------*)
      " ?H, ?P, ?G |- ?E "  ),

  ("thinc",    [],
      [ " ?H |- ?E, ?F " ], 
    (*-----------------------*)
      " ?H |- ?E, ?P, ?F "  ),

  ("cut",    [],
      [ " ?H |- ?E, ?P " , " ?H, ?P |- ?E " ], 
    (*------------------------------------*)
             " ?H |- ?E "  ),

  ("imp_intr",   [],
      [ " ?H, ?P |- ?E, ?F, ?Q " ],
    (*---------------------------------*)
       " ?H |- ?E, ?P==>?Q, ?F "  ),

  ("imp_elim",   [],
      [ " ?H, ?G |- ?E, ?P ", " ?H, ?G, ?Q |- ?E " ],
    (*-------------------------------------------------------*)
                  " ?H, ?P ==> ?Q, ?G |- ?E "  ),

  ("or_intr",   [],
      [ " ?H |- ?E, ?F, ?P, ?Q " ],
    (*-------------------------------*)
      " ?H |- ?E, ?P | ?Q, ?F "  ),

  ("or_elim",   [],
      [ " ?H, ?G, ?P |- ?E ", " ?H, ?G, ?Q |- ?E " ],
    (*-------------------------------------------------------*)
                  " ?H, ?P | ?Q, ?G |- ?E "  ),

  ("and_intr",   [],
      [ " ?H |- ?E, ?F, ?P ", " ?H |- ?E, ?F, ?Q " ],
    (*-------------------------------------------------------*)
                  " ?H |- ?E, ?P & ?Q, ?F "  ),

  ("and_elim",   [],
      [ " ?H, ?G, ?P, ?Q |- ?E " ],
    (*------------------------------*)
      " ?H, ?P & ?Q, ?G |- ?E "  ),

  ("not_intr",   [],
      [ " ?H, ?P |- ?E, ?F " ],
    (*------------------------------*)
      " ?H |- ?E, ~?P, ?F "  ),

  ("not_elim",   [],
      [ " ?H, ?G |- ?E, ?P " ],
    (*------------------------------*)
      " ?H, ~?P, ?G |- ?E "  ),

  ("all_intr",   ["x> ?H ?E ?P' ?F"],
      [ " ?H |- ?E, ?F, ?P'(x) " ],
    (*------------------------------*)
      " ?H |- ?E, All(?P'), ?F "  ),

  ("all_elim",   [],
      [ " ?H, ?G, All(?P'), ?P'(?a) |- ?E " ],
    (*-----------------------------------------*)
          " ?H, All(?P'), ?G |- ?E "  ),

  ("exists_intr",   [],
      [ " ?H |- ?E, ?F, Exists(?P'), ?P'(?a) " ],
    (*---------------------------------------------*)
         " ?H |- ?E, Exists(?P'), ?F "  ),

  ("exists_elim",   ["x> ?H ?P' ?G ?E"],
      [ " ?H, ?G, ?P'(x) |- ?E " ],
    (*---------------------------------*)
      " ?H, Exists(?P'), ?G |- ?E "  ),


  ("refl",   [],
      [] ,  "?H |- ?E, ?A = ?A, ?F"  ),


  ("sym",   [],
      [ "?H |- ?E, ?F, ?A = ?B" ] ,
    (*-----------------------------*)
	"?H |- ?E, ?B = ?A, ?F"  ),


  ("trans",   [],
      [ "?H |- ?E, ?F, ?A = ?B",  "?H |- ?E, ?F, ?B = ?C" ] ,
    (*-------------------------------------------------------*)
		 "?H |- ?E, ?A = ?C, ?F"),


  ("member_cong",   [],
      [ "?H |- ?E, ?F, ?a = ?b",
        "?H |- ?E, ?F, ?A = ?B",
        "?H |- ?E, ?F, ?b : ?B" ] ,
    (*--------------------------------*)
	"?H |- ?E, ?a : ?A, ?F"),

  ("extensionality",   [],
      [ "?H |- ?E, ?F, ?A <= ?B",  "?H |- ?E, ?F, ?B <= ?A" ] ,
    (*---------------------------------------------------------*)
		 "?H |- ?E, ?A = ?B, ?F"),

  ("nullset",   [],
      [ "?H |- ?E, ?a : 0" ] ,
    (*------------------------*)
	   "?H |- ?E"  ),

  ("Collect_iff",  [],
      [],  "?H |- ?E, ?a : Collect(?A,?P')  <=>  ?a:?A & ?P'(?a), ?F"  ),


  ("Pow_iff",  [],
      [],  "?H |- ?E, ?A : Pow(?B)   <=>   ?A <= ?B, ?F"  ),


  ("Union_iff",  [],
      [],  "?H |- ?E, ?A : Union(?C)   <=>   EXISTS B. ?A:B  &  B:?C, ?F"  ),


  ("N_intr0",   [],
      [] ,    "?H |- ?E, 0 : N, ?F"  ),

  ("N_intr_succ",   [],
      [ "?H |- ?E, ?F, ?a : N" ] ,
    (*------------------------------*)
	"?H |- ?E, succ(?a) : N, ?F"  ),

  ("N_elim",   ["z> ?H ?E ?P' ?F"],
      [ "?H |- ?E, ?F, ?a : N",
        "?H |- ?E, ?F, ?P'(0)",   
        "?H, ?P'(z) |- ?E, ?F, ?P'(succ(z))" ],
    (*-------------------------------------------*)
	"?H |- ?E, ?P'(?a), ?F"  ),


  ("induction",   ["u> ?H ?E ?P' ?F"],
      [ "?H, ALL v. v:u ==> ?P'(v) |- ?E, ?F, ?P'(u)" ],
    (*---------------------------------------------------*)
		"?H |- ?E, ?P'(?a), ?F"  ),


  ("setcons_iff",  [],
      [],  "?H |- ?E, ?a : (?b::?B)   <=>   ?a=?b  |  ?a:?B, ?F"  )

  ];

val rule_named = get_rule LKThy;
