(* List of rules with one premise. *)

val UIrlist1 = [Int_elim, Un_intr, subset_intr, ext_elim, setcons_intr, 
                nullset_intr];


(* List of rules with two premises. *)

val UIrlist2 = [Int_intr, Un_elim, subset_elim, ext_intr, setcons_elim];


(* Tactic for reducing a goal, using the rules here above. *)

fun set_tac gno prf = 
    ((res_and_smash_tac [assume, refl, nullset_elim] gno)
     ORELSE
     ((res_and_smash_tac UIrlist1 gno) THEN (set_tac gno))
     ORELSE
     ((res_and_smash_tac UIrlist2 gno) THEN (set_tac (gno + 1))
                                       THEN (set_tac gno))
     ORELSE
     all_tac) prf;

fun apply rl gno = expand(resolve_tac [rl] gno);
