(* LK-UnInt.

   Examples of automatic demonstrations of theorems, involving
   intersection, union, inclusion and equality.
*)


(* List of rules with one premise. *)

val UIrlist1 = [Int_elim, Un_intr, subset_intr, ext_elim];


(* List of rules with two premises. *)

val UIrlist2 = [Int_intr, Un_elim, subset_elim, ext_intr];


(* Tactic for reducing a goal, using the rules here above. *)

fun UnInt_tac gno prf = 
    ((res_and_smash_tac [assume] gno)
     ORELSE
     ((res_and_smash_tac UIrlist1 gno) THEN (UnInt_tac gno))
     ORELSE
     ((res_and_smash_tac UIrlist2 gno) THEN (UnInt_tac (gno + 1))
                                       THEN (UnInt_tac gno))
     ORELSE
     all_tac) prf;


(* The following examples prove that intersection and inclusion, 
   w.r.t. subset ordering, are the meet and join operations of a
   distributive lattice.                                          *)

read_goal LKThy "|- A Int B <= A";
expand(UnInt_tac 1);

read_goal LKThy "|- A Int B <= B";
expand(UnInt_tac 1);

read_goal LKThy "C <= A, C <= B |- C <= A Int B";
expand(UnInt_tac 1);

read_goal LKThy "|- A <= A Un B";
expand(UnInt_tac 1);

read_goal LKThy "|- B <= A Un B";
expand(UnInt_tac 1);

read_goal LKThy "A <= C, B <= C |- A Un B <= C";
expand(UnInt_tac 1);

read_goal LKThy "|- A Int (B Un C) = (A Int B) Un (A Int C)";
expand(UnInt_tac 1);

read_goal LKThy "|- A Un (B Int C) = (A Un B) Int (A Un C)";
expand(UnInt_tac 1);
