/*
 * Decompiled with CFR 0.152.
 */
package ise.plugin.nav;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class NavStack<E>
extends Stack<E>
implements ComboBoxModel {
    private int maxSize = 512;
    private Set<ListDataListener> listeners = null;
    private E selectedItem = null;

    public NavStack() {
    }

    public NavStack(int size) {
        this.maxSize = size;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
        while (this.size() > this.maxSize) {
            this.remove(0);
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public E push(E item) {
        if (item == null) {
            return null;
        }
        if (this.size() > 0 && item.equals(this.peek())) {
            return null;
        }
        super.push(item);
        if (this.size() > this.maxSize) {
            this.remove(0);
        }
        this.contentsChanged();
        return item;
    }

    @Override
    public E pop() {
        Object e = super.pop();
        this.contentsChanged();
        return e;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NavStack[\n");
        for (Object o : this) {
            sb.append(o.toString()).append(",\n");
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ListDataListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    @Override
    public E getElementAt(int index) {
        return this.get(index);
    }

    private void contentsChanged() {
        if (this.listeners == null) {
            return;
        }
        ListDataEvent event = new ListDataEvent(this, 0, 0, this.getSize());
        for (ListDataListener listener : this.listeners) {
            listener.contentsChanged(event);
        }
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public boolean add(E e) {
        boolean b = super.add(e);
        if (b) {
            this.contentsChanged();
        }
        return b;
    }

    @Override
    public void add(int index, E e) {
        super.add(index, e);
        this.contentsChanged();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean b = super.addAll(c);
        if (b) {
            this.contentsChanged();
        }
        return b;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean b = super.addAll(index, c);
        if (b) {
            this.contentsChanged();
        }
        return b;
    }

    @Override
    public void addElement(E e) {
        super.addElement(e);
        this.contentsChanged();
    }

    @Override
    public void clear() {
        super.clear();
        this.contentsChanged();
    }

    @Override
    public void insertElementAt(E e, int index) {
        super.insertElementAt(e, index);
        this.contentsChanged();
    }

    @Override
    public E remove(int index) {
        Object e = super.remove(index);
        this.contentsChanged();
        return e;
    }

    @Override
    public boolean remove(Object o) {
        boolean b = super.remove(o);
        if (b) {
            this.contentsChanged();
        }
        return b;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean b = super.removeAll(c);
        if (b) {
            this.contentsChanged();
        }
        return b;
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.contentsChanged();
    }

    @Override
    public boolean removeElement(Object obj) {
        boolean b = super.removeElement(obj);
        if (b) {
            this.contentsChanged();
        }
        return b;
    }

    @Override
    public void removeElementAt(int index) {
        super.removeElementAt(index);
        this.contentsChanged();
    }

    @Override
    protected void removeRange(int start, int end) {
        super.removeRange(start, end);
        this.contentsChanged();
    }

    @Override
    public E set(int index, E e) {
        E old = super.set(index, e);
        this.contentsChanged();
        return old;
    }

    @Override
    public void setElementAt(E e, int index) {
        super.setElementAt(e, index);
        this.contentsChanged();
    }

    @Override
    public void setSize(int newSize) {
        super.setSize(newSize);
        this.contentsChanged();
    }

    public E getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item != null) {
            this.selectedItem = item;
            this.contentsChanged();
        }
    }
}

