/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.PingPongList;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.util.StandardUtilities;

public class EditModesPane
extends AbstractOptionPane {
    private JComboBox<Mode> defaultMode;
    private PingPongList<Mode> pingPongList;
    private JTextField modeName;
    private JTextField modeFile;
    private JButton browse;
    private JTextField filenameGlob;
    private JTextField firstLineGlob;
    private JButton ok;
    private JButton deleteSelectedButton;

    public EditModesPane() {
        super("editmodes");
    }

    @Override
    protected void _init() {
        Mode[] modes = this.loadAllModes();
        Mode[] userSelectedModes = this.loadSelectedModes();
        this.defaultMode = new JComboBox<Mode>(userSelectedModes);
        this.defaultMode.setSelectedItem(jEdit.getMode(jEdit.getProperty("buffer.defaultMode")));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel(jEdit.getProperty("options.editing.defaultMode")), "West");
        topPanel.add(this.defaultMode);
        this.addComponent(topPanel);
        this.addSeparator();
        ArrayList<Mode> availableModes = new ArrayList<Mode>();
        ArrayList<Mode> selectedModes = new ArrayList<Mode>();
        for (Mode mode : modes) {
            boolean selected;
            String modeName = mode.getName();
            boolean bl = selected = !jEdit.getBooleanProperty("mode.opt-out." + modeName, false);
            if (selected) {
                selectedModes.add(mode);
                continue;
            }
            availableModes.add(mode);
        }
        this.pingPongList = new PingPongList(availableModes, selectedModes);
        this.pingPongList.setLeftTitle(jEdit.getProperty("options.editing.modes.available"));
        this.pingPongList.setRightTitle(jEdit.getProperty("options.editing.modes.selected"));
        this.pingPongList.setLeftTooltip(jEdit.getProperty("options.editing.modes.available.tooltip"));
        this.pingPongList.setRightTooltip(jEdit.getProperty("options.editing.modes.selected.tooltip"));
        this.pingPongList.setRightCellRenderer(new MyCellRenderer());
        this.pingPongList.addRightListSelectionListener(new MyListSelectionListener());
        this.deleteSelectedButton = new JButton(jEdit.getProperty("options.editing.modes.deleteSelected", "Delete Selected"));
        this.deleteSelectedButton.setEnabled(false);
        this.pingPongList.addButton(this.deleteSelectedButton);
        this.deleteSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                List modes = EditModesPane.this.pingPongList.getRightSelectedValues();
                StringBuilder sb = new StringBuilder();
                sb.append(jEdit.getProperty("options.editing.modes.Delete_these_modes?", "Delete these modes?")).append('\n');
                for (Mode m : modes) {
                    if (!m.isUserMode()) continue;
                    sb.append(m.getName()).append('\n');
                }
                int answer = JOptionPane.showConfirmDialog(jEdit.getActiveView(), sb.toString(), jEdit.getProperty("options.editing.deleteMode.dialog.title", "Confirm Mode Delete"), 2);
                if (answer == 0) {
                    for (Mode m : modes) {
                        if (!m.isUserMode()) continue;
                        try {
                            ModeProvider.instance.removeMode(m.getName());
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.deleteMode.dialog.message1") + ' ' + m.getProperty("file") + '\n' + jEdit.getProperty("options.editing.deleteMode.dialog.message2") + ' ' + m.getName());
                        }
                    }
                    EditModesPane.this.reloadLists(null);
                }
            }
        });
        this.addComponent(this.pingPongList, 1);
        this.addSeparator();
        this.addComponent(new JLabel(jEdit.getProperty("options.editing.addMode.dialog.title", "Add Mode")));
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.addComponent(content);
        AbstractOptionPane mainContent = new AbstractOptionPane("addmode");
        mainContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.modeName = new JTextField(36);
        mainContent.addComponent(jEdit.getProperty("options.editing.addMode.dialog.modeName"), (Component)this.modeName);
        this.modeFile = new JTextField();
        this.browse = new JButton("...");
        this.browse.addActionListener(new ActionHandler());
        JPanel browsePanel = new JPanel(new BorderLayout());
        browsePanel.add((Component)this.modeFile, "Center");
        browsePanel.add((Component)this.browse, "East");
        mainContent.addComponent(jEdit.getProperty("options.editing.addMode.dialog.modeFile"), (Component)browsePanel);
        this.filenameGlob = new JTextField(36);
        mainContent.addComponent(jEdit.getProperty("options.editing.addMode.dialog.filenameGlob"), (Component)this.filenameGlob);
        this.firstLineGlob = new JTextField(36);
        mainContent.addComponent(jEdit.getProperty("options.editing.addMode.dialog.firstLineGlob"), (Component)this.firstLineGlob);
        content.add(mainContent);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 6));
        this.ok = new JButton(jEdit.getProperty("options.editing.addMode", "Add Mode"));
        this.ok.addActionListener(new ActionHandler());
        buttons.add(Box.createGlue());
        buttons.add(this.ok);
        content.add("South", buttons);
        this.addComponent(content);
    }

    private Mode[] loadSelectedModes() {
        Mode[] modes = jEdit.getModes();
        Arrays.sort(modes, new StandardUtilities.StringCompare(true));
        return modes;
    }

    private Mode[] loadAllModes() {
        Mode[] modes = jEdit.getAllModes();
        Arrays.sort(modes, new StandardUtilities.StringCompare(true));
        return modes;
    }

    @Override
    protected void _save() {
        jEdit.setProperty("buffer.defaultMode", ((Mode)this.defaultMode.getSelectedItem()).getName());
        Iterator<Mode> available = this.pingPongList.getLeftDataIterator();
        while (available.hasNext()) {
            Mode mode = available.next();
            jEdit.setBooleanProperty("mode.opt-out." + mode.getName(), true);
        }
        Iterator<Mode> selected = this.pingPongList.getRightDataIterator();
        while (selected.hasNext()) {
            Mode mode = selected.next();
            jEdit.unsetProperty("mode.opt-out." + mode.getName());
        }
    }

    public String getModeName() {
        return this.modeName.getText();
    }

    public String getModeFile() {
        return this.modeFile.getText();
    }

    public String getFilenameGlob() {
        return this.filenameGlob.getText();
    }

    public String getFirstLineGlob() {
        return this.firstLineGlob.getText();
    }

    public void ok() {
        int answer;
        boolean exists;
        String modeName = this.getModeName();
        if (modeName == null || modeName.isEmpty()) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Mode_name_may_not_be_empty.", "Mode name may not be empty."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        String modeFile = this.getModeFile();
        if (modeFile == null || modeFile.isEmpty()) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Mode_file_may_not_be_empty.", "Mode file may not be empty."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        String filenameGlob = this.getFilenameGlob();
        String firstLineGlob = this.getFirstLineGlob();
        if ((filenameGlob == null || filenameGlob.isEmpty()) && (firstLineGlob == null || firstLineGlob.isEmpty())) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Either_file_name_glob_or_first_line_glob_or_both_must_be_filled_in.", "Either file name glob or first line glob or both must be filled in."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        boolean bl = exists = jEdit.getMode(modeName) != null;
        if (exists && 0 != (answer = JOptionPane.showConfirmDialog(this, jEdit.getProperty("options.editing.addMode.dialog.warning.message"), jEdit.getProperty("options.editing.addMode.dialog.warning.title") + " " + modeName, 0))) {
            return;
        }
        Mode newMode = new Mode(modeName);
        newMode.setProperty("file", modeFile);
        newMode.setProperty("filenameGlob", filenameGlob);
        newMode.setProperty("firstlineGlob", firstLineGlob);
        File file = new File(modeFile);
        Path target = FileSystems.getDefault().getPath(jEdit.getSettingsDirectory(), "modes", file.getName());
        try {
            ModeProvider.instance.addUserMode(newMode, target);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.warning.message1") + " " + modeFile + "\n--> " + target);
        }
        jEdit.reloadModes();
        this.reloadLists(newMode);
    }

    private void reloadLists(Mode newMode) {
        Mode[] modes;
        ArrayList<Mode> selectedModes = new ArrayList<Mode>();
        ArrayList<Mode> availableModes = new ArrayList<Mode>();
        for (Mode mode : modes = this.loadAllModes()) {
            boolean selected;
            boolean bl = selected = !jEdit.getBooleanProperty("mode.opt-out." + mode.getName(), false);
            if (selected) {
                selectedModes.add(mode);
                continue;
            }
            availableModes.add(mode);
        }
        this.pingPongList.setLeftData(availableModes);
        this.pingPongList.setRightData(selectedModes);
        if (newMode != null) {
            this.pingPongList.setRightSelected(newMode);
        }
        this.defaultMode.setModel(new DefaultComboBoxModel<Mode>(this.loadSelectedModes()));
        this.defaultMode.setSelectedItem(jEdit.getMode(jEdit.getProperty("buffer.defaultMode")));
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            List modes = EditModesPane.this.pingPongList.getRightSelectedValues();
            boolean enabled = false;
            for (Mode m : modes) {
                if (!m.isUserMode()) continue;
                enabled = true;
                break;
            }
            EditModesPane.this.deleteSelectedButton.setEnabled(enabled);
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer<Mode> {
        MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Mode> list, Mode value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            this.setForeground(value.isUserMode() ? Color.GREEN : (isSelected ? list.getSelectionForeground() : list.getForeground()));
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setOpaque(true);
            return this;
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == EditModesPane.this.browse) {
                boolean multiSelect;
                int type;
                String path;
                View view = jEdit.getActiveView();
                String[] filename = GUIUtilities.showVFSFileDialog(view, path = jEdit.getSettingsDirectory(), type = 0, multiSelect = false);
                if (filename != null && filename.length > 0) {
                    EditModesPane.this.modeFile.setText(filename[0]);
                } else {
                    EditModesPane.this.modeFile.setText("");
                }
            } else if (source == EditModesPane.this.ok) {
                EditModesPane.this.ok();
            }
        }
    }
}

