/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.GenericGUIUtilities;

public class MarkerViewer
extends JPanel
implements ActionListener {
    private JList<Marker> markerList;
    private JScrollPane markerListScroller;
    private View view;
    private RolloverButton previous;
    private RolloverButton next;
    private RolloverButton clear;

    public MarkerViewer(View view) {
        super(new BorderLayout());
        this.view = view;
        Box toolBar = new Box(0);
        toolBar.add(new JLabel(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("markers.label"))));
        toolBar.add(Box.createGlue());
        RolloverButton addMarker = new RolloverButton(GUIUtilities.loadIcon("Plus.png"));
        addMarker.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("add-marker.label")));
        addMarker.addActionListener(this);
        addMarker.setActionCommand("add-marker");
        toolBar.add(addMarker);
        this.previous = new RolloverButton(GUIUtilities.loadIcon("ArrowL.png"));
        this.previous.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("prev-marker.label")));
        this.previous.addActionListener(this);
        this.previous.setActionCommand("prev-marker");
        toolBar.add(this.previous);
        this.next = new RolloverButton(GUIUtilities.loadIcon("ArrowR.png"));
        this.next.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("next-marker.label")));
        this.next.addActionListener(this);
        this.next.setActionCommand("next-marker");
        toolBar.add(this.next);
        this.clear = new RolloverButton(GUIUtilities.loadIcon("Clear.png"));
        this.clear.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("remove-all-markers.label")));
        this.clear.addActionListener(this);
        this.clear.setActionCommand("clear");
        toolBar.add(this.clear);
        this.add("North", toolBar);
        this.markerList = new JList();
        this.markerList.setSelectionMode(0);
        this.markerList.setCellRenderer(new Renderer());
        this.markerList.addMouseListener(new MouseHandler());
        this.markerList.addKeyListener(new KeyHandler());
        this.markerListScroller = new JScrollPane(this.markerList);
        this.add("Center", this.markerListScroller);
        this.refreshList();
    }

    @Override
    public boolean requestDefaultFocus() {
        this.markerList.requestFocus();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals("clear")) {
            this.view.getBuffer().removeAllMarkers();
        } else if (cmd.equals("add-marker")) {
            this.view.getEditPane().addMarker();
        } else if (cmd.equals("next-marker")) {
            this.view.getEditPane().goToNextMarker(false);
            this.updateSelection();
        } else if (cmd.equals("prev-marker")) {
            this.view.getEditPane().goToPrevMarker(false);
            this.updateSelection();
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate epu) {
        if (epu.getEditPane().getView().equals(this.view) && epu.getWhat().equals(EditPaneUpdate.BUFFER_CHANGED)) {
            this.refreshList();
        }
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate vu) {
        if (vu.getView().equals(this.view) && vu.getWhat().equals(ViewUpdate.EDIT_PANE_CHANGED)) {
            this.refreshList();
        }
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bu) {
        if (this.view.getBuffer().equals(bu.getBuffer()) && (bu.getWhat().equals(BufferUpdate.MARKERS_CHANGED) || bu.getWhat().equals(BufferUpdate.LOADED))) {
            this.refreshList();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
    }

    private void refreshList() {
        Vector<Marker> markers = this.view.getBuffer().getMarkers();
        if (markers.size() > 0) {
            this.markerListScroller.setViewportView(this.markerList);
            this.markerList.setListData(markers);
            this.markerList.setEnabled(true);
            this.next.setEnabled(true);
            this.previous.setEnabled(true);
            this.clear.setEnabled(true);
        } else {
            this.markerListScroller.setViewportView(new JLabel(jEdit.getProperty("no-markers.label")));
            this.next.setEnabled(false);
            this.previous.setEnabled(false);
            this.clear.setEnabled(false);
        }
    }

    private void goToSelectedMarker() {
        Marker value = this.markerList.getSelectedValue();
        if (!(value instanceof Marker)) {
            return;
        }
        Marker mark = value;
        this.view.getTextArea().setCaretPosition(mark.getPosition());
        this.view.toFront();
        this.view.requestFocus();
        this.view.getTextArea().requestFocus();
    }

    private void updateSelection() {
        ListModel<Marker> model = this.markerList.getModel();
        int currentLine = this.view.getTextArea().getCaretLine();
        Buffer buffer = this.view.getBuffer();
        for (int i = 0; i < model.getSize(); ++i) {
            Marker mark;
            Marker o = model.getElementAt(i);
            if (!(o instanceof Marker) || buffer.getLineOfOffset((mark = model.getElementAt(i)).getPosition()) != currentLine) continue;
            this.markerList.setSelectedIndex(i);
            break;
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 32 || evt.getKeyCode() == 10) {
                evt.consume();
                MarkerViewer.this.goToSelectedMarker();
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            int index = MarkerViewer.this.markerList.locationToIndex(evt.getPoint());
            MarkerViewer.this.markerList.setSelectedIndex(index);
            MarkerViewer.this.goToSelectedMarker();
        }
    }

    class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Marker) {
                Marker mark = (Marker)value;
                JEditTextArea textArea = MarkerViewer.this.view.getTextArea();
                int pos = textArea.getLineOfOffset(mark.getPosition());
                String txt = MarkerViewer.this.view.getTextArea().getLineText(pos);
                if (txt.equals("")) {
                    txt = jEdit.getProperty("markers.blank-line");
                }
                char shortcut_char = mark.getShortcut();
                String shortcut = "";
                if (shortcut_char > '\u0000') {
                    shortcut = "[" + shortcut_char + "]";
                }
                this.setText(pos + 1 + " " + shortcut + ": " + txt);
            }
            return this;
        }
    }
}

