/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.util.Locale;
import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintRequestAttribute;

public class Margins
implements DocAttribute,
PrintRequestAttribute,
PrintJobAttribute {
    private float top;
    private float left;
    private float right;
    private float bottom;
    private static final long serialVersionUID = 5343792322705104289L;

    public Margins(float top, float left, float right, float bottom) {
        if ((double)top < 0.0 || (double)left < 0.0 || (double)right < 0.0 || (double)bottom < 0.0) {
            throw new IllegalArgumentException("Invalid margin.");
        }
        float u = new Integer(this.getUnits()).floatValue();
        this.top = top * u;
        this.left = left * u;
        this.right = right * u;
        this.bottom = bottom * u;
    }

    private int getUnits() {
        String country = Locale.getDefault().getCountry();
        if ("".equals(country) || Locale.US.getCountry().equals(country) || Locale.CANADA.getCountry().equals(country)) {
            return 25400;
        }
        return 1000;
    }

    public float[] getMargins(int units) {
        switch (units) {
            case 1000: 
            case 25400: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid units.");
            }
        }
        return new float[]{this.getTop(units), this.getLeft(units), this.getRight(units), this.getBottom(units)};
    }

    public float getTop(int units) {
        return this.convertFromMicrometers(this.top, units);
    }

    public float getLeft(int units) {
        return this.convertFromMicrometers(this.left, units);
    }

    public float getRight(int units) {
        return this.convertFromMicrometers(this.right, units);
    }

    public float getBottom(int units) {
        return this.convertFromMicrometers(this.bottom, units);
    }

    @Override
    public final Class<? extends Attribute> getCategory() {
        return Margins.class;
    }

    @Override
    public final String getName() {
        return "margins";
    }

    private float convertFromMicrometers(float margin, int units) {
        return margin / new Integer(units).floatValue();
    }

    public String toString() {
        return this.toString(25400);
    }

    public String toString(int units) {
        String uom = "";
        switch (units) {
            case 25400: {
                uom = "in";
                break;
            }
            case 1000: {
                uom = "mm";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid units.");
            }
        }
        float[] margins = this.getMargins(units);
        StringBuilder sb = new StringBuilder(128);
        sb.append("Margins(").append(uom).append(")[top:").append(margins[0]).append(", left:");
        sb.append(margins[1]).append(", right:").append(margins[2]).append(", bottom:").append(margins[3]).append(']');
        return sb.toString();
    }

    public boolean equals(Object object) {
        boolean toReturn = false;
        if (object instanceof Margins) {
            Margins margins = (Margins)object;
            if (this.top == margins.top && this.left == margins.left && this.bottom == margins.bottom && this.right == margins.right) {
                toReturn = true;
            }
        }
        return toReturn;
    }

    public int hashCode() {
        return new Float(this.top).intValue() + 37 * new Float(this.left).intValue() + 43 * new Float(this.right).intValue() + 47 * new Float(this.bottom).intValue();
    }
}

