/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.ListModelEditor;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;

public class HistoryText {
    private JTextComponent text;
    private HistoryModel historyModel;
    private int index;
    private String current;
    private JPopupMenu popup;
    private boolean instantPopups;

    public HistoryText(JTextComponent text, String name) {
        this.text = text;
        this.setModel(name);
        this.index = -1;
    }

    public void fireActionPerformed() {
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public HistoryModel getModel() {
        return this.historyModel;
    }

    public void setModel(String name) {
        this.historyModel = name == null ? null : HistoryModel.getModel(name);
        this.index = -1;
    }

    public void setInstantPopups(boolean instantPopups) {
        this.instantPopups = instantPopups;
    }

    public boolean getInstantPopups() {
        return this.instantPopups;
    }

    public void addCurrentToHistory() {
        if (this.historyModel != null) {
            this.historyModel.addItem(this.getText());
        }
        this.index = 0;
    }

    public void doBackwardSearch() {
        if (this.historyModel == null) {
            return;
        }
        if (this.text.getSelectionEnd() != this.getDocument().getLength()) {
            this.text.setCaretPosition(this.getDocument().getLength());
        }
        int start = this.getInputStart();
        String t = this.getText().substring(0, this.text.getSelectionStart() - start);
        if (t == null) {
            this.historyPrevious();
            return;
        }
        for (int i = this.index + 1; i < this.historyModel.getSize(); ++i) {
            String item = this.historyModel.getItem(i);
            if (!item.startsWith(t)) continue;
            this.text.replaceSelection(item.substring(t.length()));
            this.text.select(this.getInputStart() + t.length(), this.getDocument().getLength());
            this.index = i;
            return;
        }
        UIManager.getLookAndFeel().provideErrorFeedback(null);
    }

    public void doForwardSearch() {
        if (this.historyModel == null) {
            return;
        }
        if (this.text.getSelectionEnd() != this.getDocument().getLength()) {
            this.text.setCaretPosition(this.getDocument().getLength());
        }
        int start = this.getInputStart();
        String t = this.getText().substring(0, this.text.getSelectionStart() - start);
        if (t == null) {
            this.historyNext();
            return;
        }
        for (int i = this.index - 1; i >= 0; --i) {
            String item = this.historyModel.getItem(i);
            if (!item.startsWith(t)) continue;
            this.text.replaceSelection(item.substring(t.length()));
            this.text.select(this.getInputStart() + t.length(), this.getDocument().getLength());
            this.index = i;
            return;
        }
        UIManager.getLookAndFeel().provideErrorFeedback(null);
    }

    public void historyPrevious() {
        if (this.historyModel == null) {
            return;
        }
        if (this.index == this.historyModel.getSize() - 1) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        } else if (this.index == -1) {
            this.current = this.getText();
            this.setText(this.historyModel.getItem(0));
            this.index = 0;
        } else {
            int newIndex = this.index + 1;
            this.setText(this.historyModel.getItem(newIndex));
            this.index = newIndex;
        }
    }

    public void historyNext() {
        if (this.historyModel == null) {
            return;
        }
        if (this.index == -1) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        } else if (this.index == 0) {
            this.setText(this.current);
        } else {
            int newIndex = this.index - 1;
            this.setText(this.historyModel.getItem(newIndex));
            this.index = newIndex;
        }
    }

    public Document getDocument() {
        return this.text.getDocument();
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String text) {
        this.index = -1;
        this.text.setText(text);
    }

    public int getInputStart() {
        return 0;
    }

    public void showPopupMenu(String t, int x, int y) {
        if (this.historyModel == null) {
            return;
        }
        this.text.requestFocus();
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.setVisible(false);
            this.popup = null;
            return;
        }
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                if (!b) {
                    HistoryText.this.popup = null;
                }
                super.setVisible(b);
            }
        };
        JMenuItem caption = new JMenuItem(jEdit.getProperty("history.caption"));
        caption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ListModelEditor().open(HistoryText.this.historyModel);
            }
        });
        this.popup.add(caption);
        this.popup.addSeparator();
        for (int i = 0; i < this.historyModel.getSize(); ++i) {
            String item = this.historyModel.getItem(i);
            if (!item.startsWith(t)) continue;
            JMenuItem menuItem = new JMenuItem(item);
            menuItem.setActionCommand(String.valueOf(i));
            menuItem.addActionListener(new ActionHandler());
            this.popup.add(menuItem);
        }
        GenericGUIUtilities.showPopupMenu(this.popup, this.text, x, y, false);
    }

    public void showPopupMenu(boolean search) {
        if (search) {
            this.showPopupMenu(this.getText().substring(this.getInputStart(), this.text.getSelectionStart()), 0, this.text.getHeight());
        } else {
            this.showPopupMenu("", 0, this.text.getHeight());
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int ind = Integer.parseInt(evt.getActionCommand());
            if (ind == -1) {
                if (HistoryText.this.index != -1) {
                    HistoryText.this.setText(HistoryText.this.current);
                }
            } else {
                HistoryText.this.setText(HistoryText.this.historyModel.getItem(ind));
                HistoryText.this.index = ind;
            }
            if (HistoryText.this.instantPopups) {
                HistoryText.this.addCurrentToHistory();
                HistoryText.this.fireActionPerformed();
            }
        }
    }
}

