/*
 * Decompiled with CFR 0.152.
 */
package ise.plugin.nav;

import ise.java.awt.KappaLayout;
import ise.java.awt.LambdaLayout;
import ise.plugin.nav.NavHistoryList;
import ise.plugin.nav.NavToolBar;
import ise.plugin.nav.Navigator;
import ise.plugin.nav.NavigatorPlugin;
import ise.plugin.nav.SquareButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.ViewUpdate;

public class Dockable
extends JPanel
implements ChangeListener,
EBComponent {
    private Navigator client = null;
    private JCheckBox groupByFile = null;
    private JCheckBox groupByLine = null;
    private JCheckBox showLineText = null;
    private JCheckBox showLineTextSyntax = null;
    private JCheckBox showStripes = null;
    private JRadioButton viewScope = null;
    private JRadioButton editPaneScope = null;
    private JCheckBox showPath = null;
    private JCheckBox showLineNumber = null;
    private JCheckBox showCaretOffset = null;
    private JPanel controlPanel = null;
    private JPanel currentPanel = null;
    private JLabel currentLabel = null;
    private JPanel flipPanel = null;
    private NavToolBar toolbar = null;
    private JButton options = null;
    private JButton clear = null;
    private NavHistoryList backList = null;
    private NavHistoryList forwardList = null;
    protected static final int MAX_LINE_LENGTH = 120;

    public Dockable(View view) {
        EditBus.addToBus((EBComponent)this);
        this.client = NavigatorPlugin.getScope() == 1 ? NavigatorPlugin.createNavigator(view) : NavigatorPlugin.createNavigator(view.getEditPane());
        this.client.addChangeListener(this);
        this.installComponents();
        this.installListeners();
    }

    private void installComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 1));
        JLabel groupByLabel = new JLabel(jEdit.getProperty((String)"navigator.options.groupBy.label", (String)"Group by:"));
        this.groupByFile = new JCheckBox(jEdit.getProperty((String)"navigator.options.groupByFile.label", (String)"Group history items by file"));
        this.groupByFile.setName("groupByFile");
        this.groupByFile.setSelected(NavigatorPlugin.groupByFile());
        this.groupByLine = new JCheckBox(jEdit.getProperty((String)"navigator.options.groupByLine.label", (String)"Group history items by line"));
        this.groupByLine.setName("groupByLine");
        this.groupByLine.setSelected(NavigatorPlugin.groupByLine());
        JLabel scopeLabel = new JLabel(jEdit.getProperty((String)"navigator.options.scope.label", (String)"Scope:"));
        this.viewScope = new JRadioButton(jEdit.getProperty((String)"navigator.viewScope.label", (String)"View scope"));
        this.viewScope.setName("viewScope");
        this.editPaneScope = new JRadioButton(jEdit.getProperty((String)"navigator.editPaneScope.label", (String)"EditPane scope"));
        this.editPaneScope.setName("editPaneScope");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.viewScope);
        buttonGroup.add(this.editPaneScope);
        int scope = NavigatorPlugin.getScope();
        this.viewScope.setSelected(scope == 1);
        this.editPaneScope.setSelected(scope == 2);
        this.showLineText = new JCheckBox(jEdit.getProperty((String)"navigator.options.showLineText.label", (String)"Show line text in history list"));
        this.showLineText.setName("showLineText");
        this.showLineText.setSelected(jEdit.getBooleanProperty((String)"navigator.showLineText", (boolean)true));
        this.showLineTextSyntax = new JCheckBox(jEdit.getProperty((String)"navigator.options.showLineTextSyntax.label", (String)"Show syntax highlighting in history list"));
        this.showLineTextSyntax.setName("showLineTextSyntax");
        this.showLineTextSyntax.setSelected(jEdit.getBooleanProperty((String)"navigator.showLineText", (boolean)true) && jEdit.getBooleanProperty((String)"navigator.showLineTextSyntax", (boolean)true));
        JPanel syntaxPanel = new JPanel();
        syntaxPanel.add(Box.createHorizontalStrut(11));
        syntaxPanel.add(this.showLineTextSyntax);
        this.showStripes = new JCheckBox(jEdit.getProperty((String)"navigator.options.showStripes.label", (String)"Show stripes in history list"));
        this.showStripes.setName("showStripes");
        this.showStripes.setSelected(jEdit.getBooleanProperty((String)"navigator.showStripes", (boolean)true));
        this.showPath = new JCheckBox("Show path");
        this.showPath.setSelected(jEdit.getBooleanProperty((String)"navigator.showPath", (boolean)true));
        this.showLineNumber = new JCheckBox("Show line number");
        this.showLineNumber.setSelected(jEdit.getBooleanProperty((String)"navigator.showLineNumber", (boolean)true));
        this.showCaretOffset = new JCheckBox("Show caret offset");
        this.showCaretOffset.setSelected(jEdit.getBooleanProperty((String)"navigator.showCaretOffset", (boolean)true));
        this.toolbar = new NavToolBar(this.client);
        this.options = new SquareButton(GUIUtilities.loadIcon((String)"22x22/actions/document-properties.png"));
        this.options.setToolTipText(jEdit.getProperty((String)"navigator.options.label", (String)"Options"));
        this.clear = new SquareButton(GUIUtilities.loadIcon((String)"22x22/actions/edit-clear.png"));
        this.clear.setToolTipText(jEdit.getProperty((String)"navigator.clearHistory.label", (String)"Clear history"));
        this.backList = new NavHistoryList(this.client.getView(), this.client, this.client.getBackListModel(), null);
        this.backList.setToolTipText(jEdit.getProperty((String)"navigator.backlist.tooltip", (String)"Back history, click an item to jump to it."));
        this.forwardList = new NavHistoryList(this.client.getView(), this.client, this.client.getForwardListModel(), null);
        this.forwardList.setToolTipText(jEdit.getProperty((String)"navigator.forwardlist.tooltip", (String)"Forward history, click an item to jump to it."));
        this.controlPanel = new JPanel((LayoutManager)new LambdaLayout());
        this.controlPanel.setVisible(false);
        this.controlPanel.add("0, 0, 1, 1, W, w, 0", groupByLabel);
        this.controlPanel.add("0, 1, 1, 1, W, w, 0", this.groupByFile);
        this.controlPanel.add("0, 2, 1, 1, W, w, 0", this.groupByLine);
        this.controlPanel.add("1, 0, 1, 1, 0, w, 0", KappaLayout.createHorizontalStrut((int)11, (boolean)false));
        this.controlPanel.add("2, 0, 1, 1, W, w, 0", scopeLabel);
        this.controlPanel.add("2, 1, 1, 1, W, w, 0", this.viewScope);
        this.controlPanel.add("2, 2, 1, 1, W, w, 0", this.editPaneScope);
        this.controlPanel.add("3, 0, 1, 1, 0, w, 0", KappaLayout.createHorizontalStrut((int)11, (boolean)false));
        this.controlPanel.add("4, 0, 1, 1, W, w, 0", this.showLineText);
        this.controlPanel.add("4, 1, 1, 1, W, w, 0", this.showLineTextSyntax);
        this.controlPanel.add("4, 2, 1, 1, W, w, 0", this.showStripes);
        this.controlPanel.add("5, 0, 1, 1, 0, w, 0", KappaLayout.createHorizontalStrut((int)11, (boolean)false));
        this.controlPanel.add("6, 0, 1, 1, W, w, 0", this.showPath);
        this.controlPanel.add("6, 1, 1, 1, W, w, 0", this.showLineNumber);
        this.controlPanel.add("6, 2, 1, 1, W, w, 0", this.showCaretOffset);
        this.currentPanel = new JPanel();
        this.currentLabel = new JLabel();
        this.currentLabel.setText(this.client.getCurrentPosition() == null ? "" : this.client.getCurrentPosition().htmlText(120));
        this.currentLabel.setToolTipText(jEdit.getProperty((String)"navigator.current.tooltip", (String)"Current position"));
        this.currentPanel.add(this.currentLabel);
        this.flipPanel = new JPanel(new BorderLayout());
        this.flipPanel.add((Component)this.currentPanel, "North");
        this.flipPanel.add((Component)this.controlPanel, "South");
        JPanel buttonPanel = new JPanel((LayoutManager)new KappaLayout());
        buttonPanel.add("0, 0, 2, 3, 0,, 3", this.toolbar);
        buttonPanel.add("2, 0, 1, 3, 0,, 3", this.clear);
        buttonPanel.add("3, 0, 1, 3, 0,, 3", this.options);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)buttonPanel, "East");
        topPanel.add((Component)this.flipPanel, "West");
        JPanel middlePanel = new JPanel(new GridLayout(1, 2, 3, 3));
        middlePanel.add(this.backList);
        middlePanel.add(this.forwardList);
        this.add((Component)topPanel, "North");
        this.add((Component)middlePanel, "Center");
    }

    private void installListeners() {
        String name = "navigator";
        this.groupByFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jEdit.setBooleanProperty((String)"navigator.groupByFile", (boolean)Dockable.this.groupByFile.isSelected());
            }
        });
        this.groupByLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jEdit.setBooleanProperty((String)"navigator.groupByLine", (boolean)Dockable.this.groupByLine.isSelected());
            }
        });
        this.viewScope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int scope = Dockable.this.viewScope.isSelected() ? 1 : 2;
                jEdit.setIntegerProperty((String)"navigator.scope", (int)scope);
            }
        });
        this.editPaneScope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int scope = Dockable.this.editPaneScope.isSelected() ? 2 : 1;
                jEdit.setIntegerProperty((String)"navigator.scope", (int)scope);
            }
        });
        this.showLineText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jEdit.setBooleanProperty((String)"navigator.showLineText", (boolean)Dockable.this.showLineText.isSelected());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dockable.this.backList.updateUI();
                        Dockable.this.forwardList.updateUI();
                    }
                });
            }
        });
        this.showLineTextSyntax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jEdit.setBooleanProperty((String)"navigator.showLineTextSyntax", (boolean)Dockable.this.showLineTextSyntax.isSelected());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dockable.this.backList.updateUI();
                        Dockable.this.forwardList.updateUI();
                    }
                });
            }
        });
        this.showStripes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jEdit.setBooleanProperty((String)"navigator.showStripes", (boolean)Dockable.this.showStripes.isSelected());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dockable.this.backList.updateUI();
                        Dockable.this.forwardList.updateUI();
                    }
                });
            }
        });
        this.options.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dockable.this.controlPanel.setVisible(!Dockable.this.controlPanel.isVisible());
                        Dockable.this.currentPanel.setVisible(!Dockable.this.currentPanel.isVisible());
                        Dockable.this.flipPanel.invalidate();
                        Dockable.this.repaint();
                    }
                });
            }
        });
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                NavigatorPlugin.clearHistory(Dockable.this.client.getView());
            }
        });
        this.backList.addMouseListener(new MouseHandler(this.backList));
        this.forwardList.addMouseListener(new MouseHandler(this.forwardList));
        this.showPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jEdit.setBooleanProperty((String)"navigator.showPath", (boolean)Dockable.this.showPath.isSelected());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dockable.this.backList.updateUI();
                        Dockable.this.forwardList.updateUI();
                    }
                });
            }
        });
        this.showLineNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jEdit.setBooleanProperty((String)"navigator.showLineNumber", (boolean)Dockable.this.showLineNumber.isSelected());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dockable.this.backList.updateUI();
                        Dockable.this.forwardList.updateUI();
                    }
                });
            }
        });
        this.showCaretOffset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jEdit.setBooleanProperty((String)"navigator.showCaretOffset", (boolean)Dockable.this.showCaretOffset.isSelected());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dockable.this.backList.updateUI();
                        Dockable.this.forwardList.updateUI();
                    }
                });
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dockable.this.clear.setEnabled(Dockable.this.client.getBackModel().isEnabled() || Dockable.this.client.getForwardModel().isEnabled());
                Dockable.this.backList.setModel(Dockable.this.client.getBackListModel());
                Dockable.this.forwardList.setModel(Dockable.this.client.getForwardListModel());
                Dockable.this.currentLabel.setText(Dockable.this.client.getCurrentPosition() == null ? "" : Dockable.this.client.getCurrentPosition().htmlText(120));
            }
        });
    }

    public void handleMessage(EBMessage msg) {
        ViewUpdate vu;
        if (NavigatorPlugin.getScope() == 1) {
            return;
        }
        if (msg instanceof ViewUpdate && ViewUpdate.EDIT_PANE_CHANGED.equals((vu = (ViewUpdate)msg).getWhat())) {
            this.client = NavigatorPlugin.createNavigator(vu.getView().getEditPane());
            this.toolbar.updateComponents(this.client);
            this.client.addChangeListener(this);
            this.stateChanged(null);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        NavHistoryList list;

        public MouseHandler(NavHistoryList list) {
            this.list = list;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            this.list.jump();
        }
    }
}

