/*
 * Decompiled with CFR 0.152.
 */
package common.gui.util;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public class ConstraintFactory {
    public static final int NONE = 0;
    public static final int BOTH = 1;
    public static final int HORIZONTAL = 2;
    public static final int H = 2;
    public static final int VERTICAL = 3;
    public static final int V = 3;
    public static final int RELATIVE = -1;
    public static final int REMAINDER = 0;
    public static final int CENTER = 10;
    public static final int N = 11;
    public static final int E = 13;
    public static final int S = 15;
    public static final int W = 17;
    public static final int NW = 18;
    public static final int NE = 12;
    public static final int SW = 16;
    public static final int SE = 14;
    protected int DEFAULT_WEIGHTX = 100;
    protected int DEFAULT_WEIGHTY = 100;
    protected int DEFAULT_ANCHOR = 18;
    protected int DEFAULT_FILL = 1;
    protected Insets DEFAULT_INSETS = new Insets(0, 0, 0, 0);
    protected int DEFAULT_IPADX = 0;
    protected int DEFAULT_IPADY = 0;
    protected int LAST_X = 0;
    protected int LAST_Y = 0;
    protected int LAST_WIDTH = 0;
    protected int LAST_HEIGHT = 0;

    private GridBagConstraints buildConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = this.DEFAULT_WEIGHTX;
        constraints.weighty = this.DEFAULT_WEIGHTY;
        constraints.anchor = this.DEFAULT_ANCHOR;
        constraints.fill = this.DEFAULT_FILL;
        constraints.insets = this.DEFAULT_INSETS;
        constraints.ipadx = this.DEFAULT_IPADX;
        constraints.ipady = this.DEFAULT_IPADY;
        return constraints;
    }

    public GridBagConstraints buildConstraints(int x, int y, int width, int height) {
        GridBagConstraints constraints = this.buildConstraints();
        constraints.gridx = x < 0 ? this.LAST_X : (this.LAST_X = x);
        if (y < 0) {
            constraints.gridx = this.LAST_Y;
        } else {
            constraints.gridy = this.LAST_Y = y;
        }
        constraints.gridwidth = width < 0 ? this.LAST_WIDTH : (this.LAST_WIDTH = width);
        constraints.gridheight = height < 0 ? this.LAST_HEIGHT : (this.LAST_HEIGHT = height);
        return constraints;
    }

    public GridBagConstraints buildConstraints(int x, int y, int width, int height, int anchor, int fill) {
        GridBagConstraints constraints = this.buildConstraints(x, y, width, height);
        constraints.anchor = anchor;
        constraints.fill = fill;
        return constraints;
    }

    public GridBagConstraints buildConstraints(int x, int y, int width, int height, int anchor, int fill, int xweight, int yweight) {
        GridBagConstraints constraints = this.buildConstraints(x, y, width, height, anchor, fill);
        constraints.weightx = xweight;
        constraints.weighty = yweight;
        return constraints;
    }

    public GridBagConstraints buildConstraints(int x, int y, int width, int height, int anchor, int fill, int weightx, int weighty, Insets i) {
        GridBagConstraints constraints = this.buildConstraints(x, y, width, height, anchor, fill, weightx, weighty);
        constraints.insets = i;
        return constraints;
    }

    public void setDefaultAnchor(int i) {
        this.DEFAULT_ANCHOR = i;
    }

    public void setDefaultFill(int i) {
        this.DEFAULT_FILL = i;
    }

    public void setDefaultWeights(int x, int y) {
        this.setDefaultWeightX(x);
        this.setDefaultWeightY(y);
    }

    public void setDefaultWeightX(int i) {
        this.DEFAULT_WEIGHTX = i;
    }

    public void setDefaultWeightY(int i) {
        this.DEFAULT_WEIGHTY = i;
    }

    public void setDefaultInsets(Insets i) {
        this.DEFAULT_INSETS = i;
    }

    public void setDefaultInternalPaddingX(int i) {
        this.DEFAULT_IPADX = i;
    }

    public void setDefaultInternalPaddingY(int i) {
        this.DEFAULT_IPADY = i;
    }

    public void setDefaultInternalPadding(int i) {
        this.setDefaultInternalPaddingX(i);
        this.setDefaultInternalPaddingY(i);
    }
}

