/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.proto.jeditresource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.Nonnull;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class PluginResURLConnection
extends URLConnection {
    private InputStream in;
    private String plugin;
    private String resource;

    public PluginResURLConnection(URL url) throws IOException {
        super(url);
        String file = url.getFile();
        int index = file.indexOf(33, 0);
        if (index == -1) {
            this.plugin = null;
            this.resource = file;
        } else {
            int start = file.charAt(0) == '/' ? 1 : 0;
            this.plugin = file.substring(start, index);
            this.resource = file.substring(index + 1);
        }
        if (this.plugin != null && this.resource.startsWith("/")) {
            this.resource = this.resource.substring(1);
        }
    }

    @Override
    public void connect() throws IOException, FileNotFoundException {
        if (!this.connected) {
            File f;
            if (this.plugin == null) {
                this.in = jEdit.class.getResourceAsStream(this.resource);
            } else {
                PluginJAR[] plugins;
                boolean pluginFoundInPluginJARs = false;
                for (PluginJAR jar : plugins = jEdit.getPluginJARs()) {
                    String jarName = MiscUtilities.getFileName(jar.getPath()).toLowerCase();
                    if (!this.plugin.equalsIgnoreCase(jarName)) continue;
                    pluginFoundInPluginJARs = true;
                    this.in = jar.getClassLoader().getResourceAsStream(this.resource);
                    break;
                }
                if (!pluginFoundInPluginJARs) {
                    Log.log(1, PluginResURLConnection.class, "reading resource from not loaded plugin  => will always fail !");
                }
            }
            if (this.in == null && this.plugin == null && (f = new File(jEdit.getJEditHome(), this.resource)).exists()) {
                this.in = new FileInputStream(f);
            }
            this.connected = true;
        }
        if (this.in == null) {
            if (this.plugin != null) {
                throw new FileNotFoundException("Resource not found: " + this.plugin + "!" + this.resource);
            }
            throw new FileNotFoundException("Resource not found: " + this.getURL());
        }
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws IOException, FileNotFoundException {
        this.connect();
        return this.in;
    }

    @Override
    public String getHeaderField(String name) {
        if (name.equals("content-type")) {
            String lcResource = this.resource.toLowerCase();
            if (lcResource.endsWith(".html")) {
                return "text/html";
            }
            if (lcResource.endsWith(".txt")) {
                return "text/plain";
            }
            if (lcResource.endsWith(".rtf")) {
                return "text/rtf";
            }
            if (lcResource.endsWith(".gif")) {
                return "image/gif";
            }
            if (lcResource.endsWith(".jpg") || lcResource.endsWith(".jpeg")) {
                return "image/jpeg";
            }
            return null;
        }
        return null;
    }
}

