/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.KeyboardCommand;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.PluginManagerProgress;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.StringList;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class InstallPanel
extends JPanel
implements EBComponent {
    private final JTable table;
    private final JScrollPane scrollpane;
    private final PluginTableModel pluginModel;
    private final PluginManager window;
    private final PluginInfoBox infoBox;
    private final ChoosePluginSet chooseButton;
    private final boolean updates;
    private final CardLayout layout;
    private final JTextField searchField;
    private boolean hideInstalled;
    private boolean isLoading;
    private final Collection<String> pluginSet = new HashSet<String>();
    static final Icon ASC_ICON = GUIUtilities.loadIcon("arrow-asc.png");
    static final Icon DESC_ICON = GUIUtilities.loadIcon("arrow-desc.png");

    InstallPanel(PluginManager window, boolean updates) {
        super(null);
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        this.window = window;
        this.updates = updates;
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        final JSplitPane split = new JSplitPane(0);
        split.setResizeWeight(0.75);
        this.pluginModel = new PluginTableModel();
        this.table = new JTable(this.pluginModel);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeight(GenericGUIUtilities.defaultRowHeight() + 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.table.setDefaultRenderer(Object.class, new TextRenderer((DefaultTableCellRenderer)this.table.getDefaultRenderer(Object.class)));
        this.table.addFocusListener(new TableFocusHandler());
        InputMap tableInputMap = this.table.getInputMap(0);
        ActionMap tableActionMap = this.table.getActionMap();
        tableInputMap.put(KeyStroke.getKeyStroke(9, 0), "tabOutForward");
        tableActionMap.put("tabOutForward", new KeyboardAction(KeyboardCommand.TAB_OUT_FORWARD));
        tableInputMap.put(KeyStroke.getKeyStroke(9, 1), "tabOutBack");
        tableActionMap.put("tabOutBack", new KeyboardAction(KeyboardCommand.TAB_OUT_BACK));
        tableInputMap.put(KeyStroke.getKeyStroke(32, 0), "editPlugin");
        tableActionMap.put("editPlugin", new KeyboardAction(KeyboardCommand.EDIT_PLUGIN));
        tableInputMap.put(KeyStroke.getKeyStroke(10, 0), "closePluginManager");
        tableActionMap.put("closePluginManager", new KeyboardAction(KeyboardCommand.CLOSE_PLUGIN_MANAGER));
        TableColumn col1 = this.table.getColumnModel().getColumn(0);
        TableColumn col2 = this.table.getColumnModel().getColumn(1);
        TableColumn col3 = this.table.getColumnModel().getColumn(2);
        TableColumn col4 = this.table.getColumnModel().getColumn(3);
        TableColumn col5 = this.table.getColumnModel().getColumn(4);
        col1.setPreferredWidth(30);
        col1.setMinWidth(30);
        col1.setMaxWidth(30);
        col1.setResizable(false);
        col2.setPreferredWidth(180);
        col3.setPreferredWidth(130);
        col4.setPreferredWidth(70);
        col5.setPreferredWidth(70);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        header.addMouseListener(new HeaderMouseHandler());
        header.setDefaultRenderer(new HeaderRenderer((DefaultTableCellRenderer)header.getDefaultRenderer()));
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.getViewport().setBackground(this.table.getBackground());
        split.setTopComponent(this.scrollpane);
        this.infoBox = new PluginInfoBox();
        JScrollPane infoPane = new JScrollPane(this.infoBox);
        infoPane.setPreferredSize(new Dimension(500, 100));
        split.setBottomComponent(infoPane);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                split.setDividerLocation(0.75);
            }
        });
        this.searchField = new JTextField();
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    InstallPanel.this.table.dispatchEvent(e);
                    InstallPanel.this.table.requestFocus();
                }
            }
        });
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            void update() {
                InstallPanel.this.pluginModel.setFilterString(InstallPanel.this.searchField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int i = InstallPanel.this.table.getSelectedRow();
                int n = InstallPanel.this.table.getModel().getRowCount();
                if (e.getKeyChar() == '/' || e.getKeyCode() == 40 && i == n - 1 || e.getKeyCode() == 38 && i == 0) {
                    InstallPanel.this.searchField.requestFocus();
                    InstallPanel.this.searchField.selectAll();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c != '\uffff' && Character.isAlphabetic(c)) {
                    InstallPanel.this.searchField.dispatchEvent(e);
                    InstallPanel.this.searchField.requestFocus();
                }
            }
        });
        this.hideInstalled = !updates;
        final JCheckBox hideInstalledCB = new JCheckBox("Hide installed plugins", this.hideInstalled);
        hideInstalledCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallPanel.this.hideInstalled = hideInstalledCB.isSelected();
                InstallPanel.this.updateModel();
            }
        });
        hideInstalledCB.setAlignmentX(0.0f);
        Box filterBox = Box.createHorizontalBox();
        filterBox.add(new JLabel("Filter : "));
        filterBox.add(this.searchField);
        filterBox.setAlignmentX(0.0f);
        Box topBox = new Box(3);
        topBox.add(filterBox);
        if (!updates) {
            topBox.add(hideInstalledCB);
        }
        Box buttons = new Box(0);
        buttons.add(new InstallButton());
        buttons.add(Box.createHorizontalStrut(12));
        buttons.add(new SelectallButton());
        this.chooseButton = new ChoosePluginSet();
        buttons.add(this.chooseButton);
        buttons.add(new ClearPluginSet());
        buttons.add(Box.createGlue());
        buttons.add(new SizeLabel());
        JPanel _installPanel = new JPanel(new BorderLayout(12, 12));
        _installPanel.add("North", topBox);
        _installPanel.add("Center", split);
        _installPanel.add("South", buttons);
        this.add((Component)_installPanel, "INSTALL");
        JPanel loadingLabelPanel = new JPanel(new GridBagLayout());
        loadingLabelPanel.add(new JLabel("<html><b><strong>" + jEdit.getProperty("common.loading", "Loading...") + "</strong></b></html>"));
        this.add((Component)loadingLabelPanel, "LOADING");
        JPanel noAvailablePluginsPanel = new JPanel(new GridBagLayout());
        noAvailablePluginsPanel.add(new JLabel("<html><b><strong>" + jEdit.getProperty("options.plugin-manager.no-plugin-available", "No available plugins...") + "</strong></b></html>"));
        this.add((Component)noAvailablePluginsPanel, "NO_PLUGIN_AVAILABLE");
        JPanel pluginsAreUpToDatePanel = new JPanel(new GridBagLayout());
        pluginsAreUpToDatePanel.add(new JLabel("<html><b><strong>" + jEdit.getProperty("options.plugin-manager.no-plugin-uptodate", "Plugins are up to date...") + "</strong></b></html>"));
        this.add((Component)pluginsAreUpToDatePanel, "PLUGIN_ARE_UP_TO_DATE");
        this.layout.show(this, "INSTALL");
        String path = jEdit.getProperty("plugin-manager.pluginset.path", "");
        if (!path.isEmpty()) {
            this.loadPluginSet(path);
        }
    }

    boolean loadPluginSet(String path) {
        this.pluginSet.clear();
        this.pluginModel.clearSelection();
        VFS vfs = VFSManager.getVFSForPath(path);
        Object session = vfs.createVFSSession(path, this);
        try {
            InputStream is = vfs._createInputStream(session, path, false, this);
            XMLUtilities.parseXML(is, new StringMapHandler());
        }
        catch (Exception e) {
            Log.log(7, this, "Loading Pluginset failed:" + e.getMessage());
            return false;
        }
        this.pluginModel.update();
        return true;
    }

    public void updateModel() {
        this.infoBox.setText(null);
        this.pluginModel.update();
        if (this.pluginModel.getRowCount() == 0) {
            if (this.updates) {
                this.layout.show(this, "PLUGIN_ARE_UP_TO_DATE");
            } else {
                this.layout.show(this, "NO_PLUGIN_AVAILABLE");
            }
        } else {
            this.layout.show(this, "INSTALL");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InstallPanel.this.searchField.requestFocusInWindow();
                }
            });
        }
        this.isLoading = false;
    }

    @Override
    public void handleMessage(EBMessage message) {
        if (message.getSource() == PluginManager.getInstance()) {
            this.chooseButton.path = jEdit.getProperty("plugin-manager.pluginset.path", "");
            if (this.chooseButton.path.length() > 0) {
                this.loadPluginSet(this.chooseButton.path);
                this.pluginModel.clearSelection();
                this.chooseButton.updateUI();
            }
        }
    }

    void loading() {
        this.layout.show(this, "LOADING");
        this.isLoading = true;
    }

    private boolean isDownloadingList() {
        return this.isLoading;
    }

    private static String formatSize(int size) {
        NumberFormat df = NumberFormat.getInstance();
        df.setMaximumFractionDigits(1);
        df.setMinimumFractionDigits(0);
        String sizeText = size < 0x100000 ? (size >> 10) + "KB" : df.format((double)size / 1048576.0) + "MB";
        return sizeText;
    }

    private static class HeaderRenderer
    extends DefaultTableCellRenderer {
        private final DefaultTableCellRenderer tcr;

        HeaderRenderer(DefaultTableCellRenderer tcr) {
            this.tcr = tcr;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel l = (JLabel)this.tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            PluginTableModel model = (PluginTableModel)table.getModel();
            Icon icon = column == model.sortType ? (model.sortDirection == 1 ? ASC_ICON : DESC_ICON) : null;
            l.setIcon(icon);
            return l;
        }
    }

    private class TableFocusHandler
    extends FocusAdapter {
        private TableFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent fe) {
            if (-1 == InstallPanel.this.table.getSelectedRow() && InstallPanel.this.table.getRowCount() > 0) {
                InstallPanel.this.table.setRowSelectionInterval(0, 0);
                JScrollBar scrollbar = InstallPanel.this.scrollpane.getVerticalScrollBar();
                scrollbar.setValue(scrollbar.getMinimum());
            }
            if (-1 == InstallPanel.this.table.getSelectedColumn()) {
                InstallPanel.this.table.setColumnSelectionInterval(0, 0);
            }
        }
    }

    private class KeyboardAction
    extends AbstractAction {
        private KeyboardCommand command = KeyboardCommand.NONE;

        KeyboardAction(KeyboardCommand command) {
            this.command = command;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            switch (this.command) {
                case TAB_OUT_FORWARD: {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    break;
                }
                case TAB_OUT_BACK: {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    break;
                }
                case EDIT_PLUGIN: {
                    int i;
                    int[] rows = InstallPanel.this.table.getSelectedRows();
                    Object[] state = new Object[rows.length];
                    for (i = 0; i < rows.length; ++i) {
                        state[i] = InstallPanel.this.pluginModel.getValueAt(rows[i], 0);
                    }
                    for (i = 0; i < rows.length; ++i) {
                        InstallPanel.this.pluginModel.setValueAt(state[i].equals(Boolean.FALSE), rows[i], 0);
                    }
                    break;
                }
                case CLOSE_PLUGIN_MANAGER: {
                    InstallPanel.this.window.ok();
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
    }

    private static class TextRenderer
    extends DefaultTableCellRenderer {
        private final DefaultTableCellRenderer tcr;

        TextRenderer(DefaultTableCellRenderer tcr) {
            this.tcr = tcr;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 5) {
                this.tcr.setHorizontalAlignment(11);
            } else {
                this.tcr.setHorizontalAlignment(10);
            }
            return this.tcr.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int column = InstallPanel.this.table.getTableHeader().columnAtPoint(evt.getPoint());
            ((InstallPanel)InstallPanel.this).pluginModel.sortDirection *= -1;
            InstallPanel.this.pluginModel.sort(column);
        }
    }

    private static class EntryCompare
    implements Comparator<Entry> {
        private static final int COLUMN_INSTALL = 0;
        private static final int COLUMN_NAME = 1;
        private static final int COLUMN_CATEGORY = 2;
        private static final int COLUMN_VERSION = 3;
        private static final int COLUMN_SIZE = 4;
        private static final int COLUMN_RELEASE = 5;
        private final int type;
        private final int sortDirection;

        EntryCompare(int type, int sortDirection) {
            this.type = type;
            this.sortDirection = sortDirection;
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            int result;
            switch (this.type) {
                case 0: {
                    result = e1.install == e2.install ? 0 : (e1.install ? 1 : -1);
                    break;
                }
                case 1: {
                    result = e1.name.compareToIgnoreCase(e2.name);
                    break;
                }
                case 2: {
                    result = e1.set.compareToIgnoreCase(e2.set);
                    if (result != 0) break;
                    result = e1.name.compareToIgnoreCase(e2.name);
                    break;
                }
                case 3: {
                    result = StandardUtilities.compareStrings(e1.version, e2.version, true);
                    break;
                }
                case 4: {
                    result = e1.size < e2.size ? -1 : (e1.size == e2.size ? 0 : 1);
                    break;
                }
                case 5: {
                    result = e1.timestamp < e2.timestamp ? -1 : (e1.timestamp == e2.timestamp ? 0 : 1);
                    break;
                }
                default: {
                    result = 0;
                }
            }
            return result * this.sortDirection;
        }
    }

    private class InstallButton
    extends JButton
    implements ActionListener,
    TableModelListener {
        InstallButton() {
            super(jEdit.getProperty("install-plugins.install"));
            InstallPanel.this.pluginModel.addTableModelListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (InstallPanel.this.isDownloadingList()) {
                return;
            }
            boolean downloadSource = jEdit.getBooleanProperty("plugin-manager.downloadSource");
            boolean installUser = jEdit.getBooleanProperty("plugin-manager.installUser");
            Roster roster = new Roster();
            String installDirectory = installUser ? MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars") : MiscUtilities.constructPath(jEdit.getJEditHome(), "jars");
            int length = InstallPanel.this.pluginModel.entries.size();
            int instcount = 0;
            for (int i = 0; i < length; ++i) {
                Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(i);
                if (!entry.install) continue;
                entry.plugin.install(roster, installDirectory, downloadSource, !entry.checked);
                if (InstallPanel.this.updates) {
                    entry.plugin.getCompatibleBranch().satisfyDependencies(roster, installDirectory, downloadSource);
                }
                ++instcount;
            }
            if (roster.isEmpty()) {
                return;
            }
            boolean cancel = false;
            if (InstallPanel.this.updates && roster.getOperationCount() > instcount && GUIUtilities.confirm(InstallPanel.this.window, "install-plugins.depend", null, 2, 2) == 2) {
                cancel = true;
            }
            if (!cancel) {
                new PluginManagerProgress(InstallPanel.this.window, roster);
                roster.performOperationsInAWTThread(InstallPanel.this.window);
                InstallPanel.this.pluginModel.update();
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (InstallPanel.this.isDownloadingList()) {
                return;
            }
            if (e.getType() == 0) {
                int length = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < length; ++i) {
                    if (!((Boolean)InstallPanel.this.pluginModel.getValueAt(i, 0)).booleanValue()) continue;
                    this.setEnabled(true);
                    return;
                }
                this.setEnabled(false);
            }
        }
    }

    private class ClearPluginSet
    extends RolloverButton
    implements ActionListener {
        ClearPluginSet() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("install-plugins.clear-plugin-set.icon")));
            this.setToolTipText("clear plugin set");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstallPanel.this.pluginSet.clear();
            InstallPanel.this.pluginModel.clearSelection();
            jEdit.unsetProperty("plugin-manager.pluginset.path");
            InstallPanel.this.chooseButton.updateUI();
        }
    }

    private class ChoosePluginSet
    extends RolloverButton
    implements ActionListener {
        private String path;

        ChoosePluginSet() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("install-plugins.choose-plugin-set.icon")));
            this.addActionListener(this);
            this.updateUI();
        }

        @Override
        public void updateUI() {
            this.path = jEdit.getProperty("plugin-manager.pluginset.path", "");
            if (this.path.length() < 1) {
                this.setToolTipText("Click here to choose a predefined plugin set");
            } else {
                this.setToolTipText("Choose pluginset (" + this.path + ')');
            }
            super.updateUI();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.path = jEdit.getProperty("plugin-manager.pluginset.path", jEdit.getSettingsDirectory() + File.separator);
            String[] selectedFiles = GUIUtilities.showVFSFileDialog(InstallPanel.this.window, jEdit.getActiveView(), this.path, 0, false);
            if (selectedFiles == null || selectedFiles.length != 1) {
                return;
            }
            this.path = selectedFiles[0];
            boolean success = InstallPanel.this.loadPluginSet(this.path);
            if (success) {
                jEdit.setProperty("plugin-manager.pluginset.path", this.path);
            }
            this.updateUI();
        }
    }

    private class StringMapHandler
    extends DefaultHandler {
        StringMapHandler() {
            InstallPanel.this.pluginSet.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if ("plugin".equals(localName)) {
                InstallPanel.this.pluginSet.add(attrs.getValue("jar"));
            }
        }
    }

    private class SelectallButton
    extends JCheckBox
    implements ActionListener,
    TableModelListener {
        SelectallButton() {
            super(jEdit.getProperty("install-plugins.select-all"));
            this.addActionListener(this);
            InstallPanel.this.pluginModel.addTableModelListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            InstallPanel.this.pluginModel.setSelectAll(this.isSelected());
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (InstallPanel.this.isDownloadingList()) {
                return;
            }
            this.setEnabled(InstallPanel.this.pluginModel.getRowCount() != 0);
            if (e.getType() == 0) {
                int length = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < length; ++i) {
                    if (((Boolean)InstallPanel.this.pluginModel.getValueAt(i, 0)).booleanValue()) continue;
                    this.setSelected(false);
                    return;
                }
                if (length > 0) {
                    this.setSelected(true);
                }
            }
        }
    }

    private class SizeLabel
    extends JLabel
    implements TableModelListener {
        private int size;
        private int nbPlugins;

        SizeLabel() {
            this.update();
            InstallPanel.this.pluginModel.addTableModelListener(this);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                if (InstallPanel.this.isDownloadingList()) {
                    return;
                }
                this.size = 0;
                this.nbPlugins = 0;
                int length = InstallPanel.this.pluginModel.entries.size();
                for (int i = 0; i < length; ++i) {
                    Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(i);
                    if (!entry.install) continue;
                    ++this.nbPlugins;
                    this.size += entry.size;
                }
                this.update();
            }
        }

        private void update() {
            Object[] args = new Object[]{this.nbPlugins, InstallPanel.formatSize(this.size)};
            this.setText(jEdit.getProperty("install-plugins.totalSize", args));
        }
    }

    private class PluginInfoBox
    extends JEditorPane
    implements ListSelectionListener {
        PluginInfoBox() {
            this.setBackground(jEdit.getColorProperty("view.bgColor"));
            this.setForeground(jEdit.getColorProperty("view.fgColor"));
            this.putClientProperty("JEditorPane.honorDisplayProperties", true);
            this.setContentType("text/html");
            this.setEditable(false);
            InstallPanel.this.table.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            String text = this.getText();
            if (InstallPanel.this.table.getSelectedRowCount() == 1) {
                Entry entry = (Entry)InstallPanel.this.pluginModel.filteredEntries.get(InstallPanel.this.table.getSelectedRow());
                String pattern = "<b>{0}</b>: {1}<br><b>{2}</b>: {3}<br><br>{4}";
                ArrayList<String> params = new ArrayList<String>();
                params.add(jEdit.getProperty("install-plugins.info.author", "Author"));
                params.add(entry.author);
                params.add(jEdit.getProperty("install-plugins.info.released", "Released"));
                params.add(entry.date);
                params.add(entry.description);
                if (entry.dependencies != null && !entry.dependencies.isEmpty()) {
                    pattern = pattern + "<br><br><b>{5}</b>:<br>{6}";
                    params.add(jEdit.getProperty("install-plugins.info.depends", "Depends on"));
                    StringList sl = StringList.split(entry.dependencies, "\n");
                    params.add(sl.join(", "));
                }
                text = MessageFormat.format(pattern, params.toArray());
            }
            this.setText(text);
            this.setCaretPosition(0);
            this.putClientProperty("JEditorPane.honorDisplayProperties", true);
        }
    }

    private static class Entry {
        String name;
        String installedVersion;
        String version;
        String author;
        String date;
        String description;
        String set;
        String dependencies;
        long timestamp;
        int size;
        boolean checked;
        boolean install;
        PluginList.Plugin plugin;
        List<Entry> dependents = new LinkedList<Entry>();

        Entry(PluginList.Plugin plugin, String set) {
            PluginList.Branch branch = plugin.getCompatibleBranch();
            boolean downloadSource = jEdit.getBooleanProperty("plugin-manager.downloadSource");
            int size = downloadSource ? branch.downloadSourceSize : branch.downloadSize;
            this.name = plugin.name;
            this.author = plugin.author;
            this.installedVersion = plugin.getInstalledVersion();
            this.version = branch.version;
            this.size = size;
            this.date = branch.date;
            this.description = plugin.description;
            this.dependencies = branch.depsToString();
            this.set = set;
            this.install = false;
            this.checked = false;
            this.plugin = plugin;
            SimpleDateFormat format = new SimpleDateFormat("d MMMM yyyy", Locale.ENGLISH);
            try {
                this.timestamp = format.parse(this.date).getTime();
            }
            catch (ParseException e) {
                Log.log(9, this, e);
            }
        }

        private void getTransitiveDependents(List<Entry> list) {
            for (Entry entry : this.dependents) {
                if (!entry.install || list.contains(entry)) continue;
                list.add(entry);
                entry.getTransitiveDependents(list);
            }
        }

        Entry[] getTransitiveDependents() {
            ArrayList<Entry> list = new ArrayList<Entry>();
            this.getTransitiveDependents(list);
            Entry[] array = list.toArray(new Entry[list.size()]);
            Arrays.sort(array, new StandardUtilities.StringCompare(true));
            return array;
        }

        public String toString() {
            return this.name;
        }
    }

    private class PluginTableModel
    extends AbstractTableModel {
        private final List<Entry> entries = new ArrayList<Entry>();
        private final List<Entry> filteredEntries = new ArrayList<Entry>();
        private int sortType = 1;
        private String filterString;
        int sortDirection = 1;

        private PluginTableModel() {
        }

        public void setFilterString(String filterString) {
            this.filterString = filterString;
            this.updateFilteredEntries();
        }

        void updateFilteredEntries() {
            this.filteredEntries.clear();
            if (this.filterString == null) {
                if (!InstallPanel.this.hideInstalled) {
                    this.filteredEntries.addAll(this.entries);
                } else {
                    for (Entry e : this.entries) {
                        if (!e.install && e.installedVersion != null && !InstallPanel.this.updates) continue;
                        this.filteredEntries.add(e);
                    }
                }
            } else {
                String[] words = this.filterString.toLowerCase().split("\\s+");
                for (Entry e : this.entries) {
                    if (e.install) {
                        this.filteredEntries.add(e);
                        continue;
                    }
                    if (InstallPanel.this.hideInstalled && e.installedVersion != null) continue;
                    String s = (e.name + ' ' + e.set + ' ' + e.description).toLowerCase();
                    boolean hasAll = true;
                    boolean negative = false;
                    for (String word : words) {
                        if (word.startsWith("-")) {
                            word = word.substring(1);
                            negative = true;
                        }
                        if (word.length() == 0) continue;
                        if (negative == s.contains(word)) {
                            hasAll = false;
                            break;
                        }
                        negative = false;
                    }
                    if (!hasAll) continue;
                    this.filteredEntries.add(e);
                }
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return Object.class;
                }
            }
            throw new Error("Column out of range");
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return ' ' + jEdit.getProperty("install-plugins.info.name");
                }
                case 2: {
                    return ' ' + jEdit.getProperty("install-plugins.info.category");
                }
                case 3: {
                    return ' ' + jEdit.getProperty("install-plugins.info.version");
                }
                case 4: {
                    return ' ' + jEdit.getProperty("install-plugins.info.size");
                }
                case 5: {
                    return ' ' + jEdit.getProperty("install-plugins.info.releaseDate");
                }
            }
            throw new Error("Column out of range");
        }

        @Override
        public int getRowCount() {
            return this.filteredEntries.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Entry obj = this.filteredEntries.get(rowIndex);
            if (obj instanceof String) {
                if (columnIndex == 1) {
                    return obj;
                }
                return null;
            }
            Entry entry = obj;
            switch (columnIndex) {
                case 0: {
                    return entry.install;
                }
                case 1: {
                    return entry.name;
                }
                case 2: {
                    return entry.set;
                }
                case 3: {
                    if (entry.installedVersion != null) {
                        return entry.installedVersion + "->" + entry.version;
                    }
                    return entry.version;
                }
                case 4: {
                    return InstallPanel.formatSize(entry.size);
                }
                case 5: {
                    return entry.date;
                }
            }
            throw new Error("Column out of range");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public void setSelectAll(boolean b) {
            if (InstallPanel.this.isDownloadingList()) {
                return;
            }
            int length = this.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (b) {
                    this.setValueAt(Boolean.TRUE, i, 0);
                    continue;
                }
                Entry entry = this.filteredEntries.get(i);
                entry.dependents = new LinkedList<Entry>();
                entry.install = false;
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void setSortType(int type) {
            this.sortType = type;
            this.sort(type);
        }

        private boolean deselectDependents(Entry entry) {
            Object[] dependents = entry.getTransitiveDependents();
            if (dependents.length == 0) {
                return true;
            }
            String[] args = new String[]{entry.name};
            int result = GUIUtilities.listConfirm(InstallPanel.this.window, "plugin-manager.dependency", args, dependents);
            if (result != 0) {
                entry.install = true;
                return false;
            }
            for (Object dependent : dependents) {
                ((Entry)dependent).install = false;
                ((Entry)dependent).checked = false;
                this.updateDeps((Entry)dependent);
            }
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            boolean changed;
            if (column != 0) {
                return;
            }
            Entry entry = this.filteredEntries.get(row);
            boolean before = entry.install;
            entry.install = Boolean.TRUE.equals(aValue);
            if (before == entry.install) {
                return;
            }
            if (!entry.install && !this.deselectDependents(entry)) {
                return;
            }
            entry.checked = entry.install;
            this.updateDeps(entry);
            ArrayList<Entry> selected = new ArrayList<Entry>(this.entries.size());
            for (Entry temp : this.entries) {
                if (!temp.install) continue;
                selected.add(temp);
            }
            ArrayList<Entry> toRemove = new ArrayList<Entry>(selected.size());
            do {
                changed = false;
                for (Entry temp : selected) {
                    temp.dependents.removeAll(toRemove);
                    if (temp.checked || !temp.dependents.isEmpty()) continue;
                    toRemove.add(temp);
                    temp.install = false;
                    changed = true;
                }
                selected.removeAll(toRemove);
            } while (changed);
            this.updateFilteredEntries();
            for (int i = 0; i < this.filteredEntries.size(); ++i) {
                if (entry != this.filteredEntries.get(i)) continue;
                InstallPanel.this.table.setRowSelectionInterval(i, i);
                break;
            }
        }

        private void updateDeps(Entry entry) {
            List<PluginList.Dependency> deps = entry.plugin.getCompatibleBranch().deps;
            block0: for (PluginList.Dependency dep : deps) {
                if (!"plugin".equals(dep.what)) continue;
                for (Entry temp : this.entries) {
                    if (temp.plugin != dep.plugin) continue;
                    if (entry.install) {
                        temp.dependents.add(entry);
                        if (temp.install) continue block0;
                        if (temp.installedVersion == null) {
                            temp.install = true;
                        } else if (!temp.plugin.loaded) {
                            temp.install = true;
                        }
                        this.updateDeps(temp);
                        continue block0;
                    }
                    temp.dependents.remove(entry);
                    continue block0;
                }
            }
        }

        public void sort(int type) {
            HashSet<String> savedChecked = new HashSet<String>();
            HashSet<String> savedSelection = new HashSet<String>();
            this.saveSelection(savedChecked, savedSelection);
            if (this.sortType != type) {
                this.sortDirection = 1;
            }
            this.sortType = type;
            Collections.sort(this.entries, new EntryCompare(type, this.sortDirection));
            this.updateFilteredEntries();
            this.restoreSelection(savedChecked, savedSelection);
            InstallPanel.this.table.getTableHeader().repaint();
        }

        public void update() {
            HashSet<String> savedChecked = new HashSet<String>();
            HashSet<String> savedSelection = new HashSet<String>();
            this.saveSelection(savedChecked, savedSelection);
            PluginList pluginList = InstallPanel.this.window.getPluginList();
            if (pluginList == null) {
                return;
            }
            this.entries.clear();
            for (PluginList.PluginSet set : pluginList.pluginSets) {
                for (int j = 0; j < set.plugins.size(); ++j) {
                    PluginList.Plugin plugin = pluginList.pluginHash.get(set.plugins.get(j));
                    PluginList.Branch branch = plugin.getCompatibleBranch();
                    String installedVersion = plugin.getInstalledVersion();
                    if (InstallPanel.this.updates) {
                        if (branch == null || !branch.canSatisfyDependencies() || installedVersion == null || StandardUtilities.compareStrings(branch.version, installedVersion, false) <= 0) continue;
                        this.entries.add(new Entry(plugin, set.name));
                        continue;
                    }
                    if (!plugin.canBeInstalled()) continue;
                    this.entries.add(new Entry(plugin, set.name));
                }
            }
            this.sort(this.sortType);
            this.restoreSelection(savedChecked, savedSelection);
        }

        public void saveSelection(Set<String> savedChecked, Set<String> savedSelection) {
            int[] rows;
            if (this.entries.isEmpty()) {
                return;
            }
            int c = this.getRowCount();
            for (int i = 0; i < c; ++i) {
                if (!((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                savedChecked.add(this.filteredEntries.get(i).toString());
            }
            for (int row : rows = InstallPanel.this.table.getSelectedRows()) {
                savedSelection.add(this.filteredEntries.get(row).toString());
            }
        }

        public void clearSelection() {
            this.restoreSelection(Collections.emptySet(), Collections.emptySet());
        }

        public void restoreSelection(Set<String> savedChecked, Set<String> savedSelection) {
            String name;
            int i;
            int c = this.getRowCount();
            for (i = 0; i < c; ++i) {
                Entry obj = this.filteredEntries.get(i);
                name = ((Object)obj).toString();
                if (obj instanceof Entry) {
                    name = obj.plugin.jar;
                }
                if (InstallPanel.this.pluginSet.contains(name)) {
                    this.setValueAt(true, i, 0);
                    continue;
                }
                this.setValueAt(savedChecked.contains(name), i, 0);
            }
            if (InstallPanel.this.table == null) {
                return;
            }
            InstallPanel.this.table.setColumnSelectionInterval(0, 0);
            if (!savedSelection.isEmpty()) {
                int rowCount = this.getRowCount();
                for (i = 0; i < rowCount; ++i) {
                    String name2 = this.filteredEntries.get(i).toString();
                    if (!savedSelection.contains(name2)) continue;
                    InstallPanel.this.table.setRowSelectionInterval(i, i);
                    break;
                }
                ListSelectionModel lsm = InstallPanel.this.table.getSelectionModel();
                while (i < rowCount) {
                    name = this.filteredEntries.get(i).toString();
                    if (savedSelection.contains(name)) {
                        lsm.addSelectionInterval(i, i);
                    }
                    ++i;
                }
            } else {
                if (InstallPanel.this.table.getRowCount() != 0) {
                    InstallPanel.this.table.setRowSelectionInterval(0, 0);
                }
                JScrollBar scrollbar = InstallPanel.this.scrollpane.getVerticalScrollBar();
                scrollbar.setValue(scrollbar.getMinimum());
            }
        }
    }
}

