/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.Autosave;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.EditServer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.JEditKillRing;
import org.gjt.sp.jedit.JEditMode;
import org.gjt.sp.jedit.JEditRegisterSaver;
import org.gjt.sp.jedit.JEditRegistersListener;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.ModeCatalogHandler;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.PropertyManager;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.SettingsReloader;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.datatransfer.JEditTransferableService;
import org.gjt.sp.jedit.datatransfer.TransferHandler;
import org.gjt.sp.jedit.gui.ActionBar;
import org.gjt.sp.jedit.gui.CloseDialog;
import org.gjt.sp.jedit.gui.DefaultInputHandler;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.DockingLayoutManager;
import org.gjt.sp.jedit.gui.ErrorListDialog;
import org.gjt.sp.jedit.gui.FilesChangedDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.JEditHistoryModelSaver;
import org.gjt.sp.jedit.gui.TipOfTheDay;
import org.gjt.sp.jedit.gui.tray.JTrayIconManager;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.io.CharsetEncoding;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.msg.EditorExitRequested;
import org.gjt.sp.jedit.msg.EditorExiting;
import org.gjt.sp.jedit.msg.EditorStarted;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.syntax.XModeHandler;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.visitors.JEditVisitor;
import org.gjt.sp.jedit.visitors.SaveCaretInfoVisitor;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.StringList;
import org.gjt.sp.util.SyntaxUtilities;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.XMLUtilities;
import org.jedit.core.MigrationService;
import org.jedit.keymap.KeymapManager;
import org.jedit.keymap.KeymapManagerImpl;
import org.jedit.migration.OneTimeMigrationService;
import org.xml.sax.SAXParseException;

public class jEdit {
    private static String jEditHome;
    private static String settingsDirectory;
    private static String jarCacheDirectory;
    private static long propsModTime;
    private static PropertyManager propMgr;
    private static EditServer server;
    private static boolean background;
    private static ActionContext actionContext;
    private static ActionSet builtInActionSet;
    private static Vector<ErrorListDialog.ErrorEntry> pluginErrors;
    private static final Object pluginErrorLock;
    private static Vector<PluginJAR> jars;
    private static final JEditPropertyManager propertyManager;
    private static long startupTime;
    private static boolean saveCaret;
    private static InputHandler inputHandler;
    private static KeymapManager keymapManager;
    private static BufferSetManager bufferSetManager;
    private static boolean sortBuffers;
    private static boolean sortByName;
    private static int bufferCount;
    private static Buffer buffersFirst;
    private static Buffer buffersLast;
    private static Map<String, Buffer> bufferHash;
    private static final Object bufferListLock;
    private static final Object editBusOrderingLock;
    private static int viewCount;
    private static View viewsFirst;
    private static View viewsLast;
    private static View activeView;
    private static final List<Boolean> startupDone;
    private static Vector<String> additionalFiles;
    private static Thread mainThread;

    public static String getVersion() {
        return MiscUtilities.buildToVersion(jEdit.getBuild());
    }

    public static String getBuild() {
        return "05.04.99.00";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String path;
        String[] serviceNames;
        BufferedWriter stream;
        String appData;
        StringList slargs = new StringList(args);
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.compareTo("1.8") < 0) {
            System.err.println("You are running Java version " + javaVersion + '.');
            System.err.println("jEdit requires Java 1.8 or later.");
            System.exit(1);
        }
        startupDone.add(false);
        mainThread = Thread.currentThread();
        settingsDirectory = MiscUtilities.constructPath(System.getProperty("user.home"), ".jedit");
        if (OperatingSystem.isMacOS()) {
            settingsDirectory = MiscUtilities.constructPath(System.getProperty("user.home"), "Library/jEdit");
        } else if (OperatingSystem.isWindows() && (appData = System.getenv("APPDATA")) != null) {
            settingsDirectory = MiscUtilities.constructPath(appData, "jEdit");
        }
        background = OperatingSystem.isMacOS();
        if (OperatingSystem.isX11()) {
            try {
                Toolkit xToolkit = Toolkit.getDefaultToolkit();
                Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
                awtAppClassNameField.setAccessible(true);
                awtAppClassNameField.set(xToolkit, System.getProperty("x11.wmclass", "jedit"));
            }
            catch (Exception e) {
                Log.log(9, jEdit.class, e);
            }
        }
        boolean endOpts = false;
        int level = 7;
        String portFile = "server";
        boolean restore = true;
        boolean newView = true;
        boolean newPlainView = false;
        boolean gui = true;
        boolean loadPlugins = true;
        boolean runStartupScripts = true;
        boolean quit = false;
        boolean wait = false;
        boolean shouldRelocateSettings = true;
        String userDir = System.getProperty("user.dir");
        boolean splash = true;
        String scriptFile = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            if (arg.length() == 0) {
                args[i] = null;
                continue;
            }
            if (!arg.startsWith("-") || endOpts) continue;
            if (arg.equals("--")) {
                endOpts = true;
            } else if (arg.equals("-usage")) {
                jEdit.version();
                System.err.println();
                jEdit.usage();
                System.exit(1);
            } else if (arg.equals("-version")) {
                jEdit.version();
                System.exit(1);
            } else if (arg.startsWith("-log=")) {
                try {
                    level = Integer.parseInt(arg.substring("-log=".length()));
                }
                catch (NumberFormatException nf) {
                    System.err.println("Malformed option: " + arg);
                }
            } else if (arg.equals("-nosettings")) {
                settingsDirectory = null;
            } else if (arg.startsWith("-settings=")) {
                settingsDirectory = arg.substring(10);
                shouldRelocateSettings = false;
            } else if (arg.startsWith("-noserver")) {
                portFile = null;
            } else if (arg.equals("-server")) {
                portFile = "server";
            } else if (arg.startsWith("-server=")) {
                portFile = arg.substring(8);
            } else if (arg.startsWith("-background")) {
                background = true;
            } else if (arg.startsWith("-nobackground")) {
                background = false;
            } else if (arg.equals("-gui")) {
                gui = true;
            } else if (arg.equals("-nogui")) {
                gui = false;
            } else if (arg.equals("-newview")) {
                newView = true;
            } else if (arg.equals("-newplainview")) {
                newPlainView = true;
            } else if (arg.equals("-reuseview")) {
                newView = false;
                newPlainView = false;
            } else if (arg.equals("-restore")) {
                restore = true;
            } else if (arg.equals("-norestore")) {
                restore = false;
            } else if (arg.equals("-plugins")) {
                loadPlugins = true;
            } else if (arg.equals("-noplugins")) {
                loadPlugins = false;
            } else if (arg.equals("-startupscripts")) {
                runStartupScripts = true;
            } else if (arg.equals("-nostartupscripts")) {
                runStartupScripts = false;
            } else if (arg.startsWith("-run=")) {
                scriptFile = arg.substring(5);
            } else if (arg.equals("-wait")) {
                wait = true;
            } else if (arg.equals("-quit")) {
                quit = true;
            } else if (arg.equals("-nosplash")) {
                splash = false;
            } else {
                System.err.println("Unknown option: " + arg);
                jEdit.usage();
                System.exit(1);
            }
            args[i] = null;
        }
        JTrayIconManager.setTrayIconArgs(restore, userDir, args);
        if (settingsDirectory != null) {
            settingsDirectory = MiscUtilities.resolveSymlinks(settingsDirectory);
        }
        portFile = settingsDirectory != null && portFile != null ? MiscUtilities.constructPath(settingsDirectory, portFile) : null;
        Log.init(true, level);
        Log.log(3, jEdit.class, "starting with command line arguments: " + slargs.join(" "));
        if (portFile != null && new File(portFile).exists()) {
            BufferedReader in = null;
            FilterOutputStream out = null;
            try {
                in = new BufferedReader(new FileReader(portFile));
                String check = in.readLine();
                if (!"b".equals(check)) {
                    throw new IllegalArgumentException("Wrong port file format");
                }
                int port = Integer.parseInt(in.readLine());
                int key = Integer.parseInt(in.readLine());
                Socket socket = new Socket(InetAddress.getByName(null), port);
                out = new DataOutputStream(socket.getOutputStream());
                ((DataOutputStream)out).writeInt(key);
                String script = quit ? "socket.close();\njEdit.exit(null,true);\n" : jEdit.makeServerScript(wait, restore, newView, newPlainView, args, scriptFile);
                ((DataOutputStream)out).writeUTF(script);
                Log.log(1, jEdit.class, "Waiting for server");
                socket.getInputStream().read();
                System.exit(0);
            }
            catch (Exception e) {
                Log.log(5, jEdit.class, "An error occurred while connecting to the jEdit server instance.");
                Log.log(5, jEdit.class, "This probably means that jEdit crashed and/or exited abnormally");
                Log.log(5, jEdit.class, "the last time it was run.");
                Log.log(5, jEdit.class, "If you don't know what this means, don't worry.");
                Log.log(5, jEdit.class, e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (quit) {
            System.exit(0);
        }
        jEdit.logTime("before splash screen activation");
        if (splash && !new File(settingsDirectory, "nosplash").exists()) {
            GUIUtilities.showSplashScreen();
        }
        jEdit.logTime("after splash screen activation");
        if ((OperatingSystem.isMacOS() || OperatingSystem.isWindows()) && shouldRelocateSettings && settingsDirectory != null) {
            jEdit.relocateSettings();
        }
        if (settingsDirectory != null) {
            String[] _macrosDirectory;
            File _settingsDirectory = new File(settingsDirectory);
            if (!_settingsDirectory.exists()) {
                _settingsDirectory.mkdirs();
            }
            if (!(_macrosDirectory = new File(settingsDirectory, "macros")).exists()) {
                _macrosDirectory.mkdir();
            }
            String logPath = MiscUtilities.constructPath(settingsDirectory, "activity.log");
            jEdit.backupSettingsFile(new File(logPath));
            try {
                stream = new BufferedWriter(new FileWriter(logPath));
                String lineSep = System.getProperty("line.separator");
                stream.write("Log file created on " + new Date());
                stream.write(lineSep);
                stream.write("IMPORTANT:");
                stream.write(lineSep);
                stream.write("Because updating this file after every log message would kill");
                stream.write(lineSep);
                stream.write("performance, it will be *incomplete* unless you invoke the");
                stream.write(lineSep);
                stream.write("Utilities->Troubleshooting->Update Activity Log on Disk command!");
                stream.write(lineSep);
            }
            catch (Exception e) {
                e.printStackTrace();
                stream = null;
            }
        } else {
            stream = null;
        }
        Log.setLogWriter(stream);
        Log.log(5, jEdit.class, "jEdit version " + jEdit.getVersion());
        Log.log(3, jEdit.class, "Settings directory is " + settingsDirectory);
        GUIUtilities.advanceSplashProgress("init");
        jEdit.initMisc();
        GUIUtilities.advanceSplashProgress("init system properties");
        jEdit.initSystemProperties();
        GUIUtilities.advanceSplashProgress("init beanshell");
        BeanShell.init();
        GUIUtilities.advanceSplashProgress("loading site properties");
        if (jEditHome != null) {
            jEdit.initSiteProperties();
        }
        GUIUtilities.advanceSplashProgress("loading user properties");
        jEdit.initUserProperties();
        jEdit.initLocalizationProperties();
        GUIUtilities.advanceSplashProgress("init GUI");
        GUIUtilities.init();
        bufferSetManager = new BufferSetManager();
        if (portFile != null) {
            GUIUtilities.advanceSplashProgress("init server");
            server = new EditServer(portFile);
            if (!server.isOK()) {
                server = null;
            }
        } else {
            GUIUtilities.advanceSplashProgress();
            if (background) {
                background = false;
                Log.log(7, jEdit.class, "You cannot specify both the -background and -noserver switches");
            }
        }
        GUIUtilities.advanceSplashProgress("init look and feel");
        jEdit.initPLAF();
        GUIUtilities.advanceSplashProgress("init VFS Manager");
        VFSManager.init();
        GUIUtilities.advanceSplashProgress("init resources");
        jEdit.initResources();
        if (settingsDirectory != null) {
            GUIUtilities.advanceSplashProgress("Migrate keymaps");
            MigrationService keymapMigration = ServiceManager.getService(MigrationService.class, "keymap");
            keymapMigration.migrate();
        }
        SearchAndReplace.load();
        if (loadPlugins) {
            GUIUtilities.advanceSplashProgress("init plugins");
            jEdit.initPlugins();
        } else {
            GUIUtilities.advanceSplashProgress();
        }
        Registers.setSaver(new JEditRegisterSaver());
        Registers.setListener(new JEditRegistersListener());
        GUIUtilities.advanceSplashProgress("init history model");
        HistoryModel.setSaver(new JEditHistoryModelSaver());
        HistoryModel.loadHistory();
        GUIUtilities.advanceSplashProgress("init buffer history");
        BufferHistory.load();
        GUIUtilities.advanceSplashProgress("init killring");
        KillRing.setInstance(new JEditKillRing());
        KillRing.getInstance().load();
        GUIUtilities.advanceSplashProgress("init various properties");
        OneTimeMigrationService.execute();
        jEdit.propertiesChanged();
        GUIUtilities.advanceSplashProgress("init modes");
        sortBuffers = jEdit.getBooleanProperty("sortBuffers");
        sortByName = jEdit.getBooleanProperty("sortByName");
        jEdit.reloadModes();
        GUIUtilities.advanceSplashProgress("activate plugins");
        for (int i = 0; i < jars.size(); ++i) {
            jars.elementAt(i).activatePluginIfNecessary();
        }
        for (String serviceName : serviceNames = ServiceManager.getServiceNames(JEditTransferableService.class)) {
            JEditTransferableService service = ServiceManager.getService(JEditTransferableService.class, serviceName);
            TransferHandler.getInstance().registerTransferableService(service);
        }
        GUIUtilities.advanceSplashProgress("init macros");
        Macros.loadMacros();
        Macros.getMacroActionSet().initKeyBindings();
        if (runStartupScripts && jEditHome != null) {
            path = MiscUtilities.constructPath(jEditHome, "startup");
            File file = new File(path);
            if (file.exists()) {
                jEdit.runStartupScripts(file);
            } else {
                GUIUtilities.advanceSplashProgress();
            }
        } else {
            GUIUtilities.advanceSplashProgress("run startup scripts");
        }
        if (runStartupScripts && settingsDirectory != null) {
            path = MiscUtilities.constructPath(settingsDirectory, "startup");
            File file = new File(path);
            if (file.exists()) {
                GUIUtilities.advanceSplashProgress("run startup scripts");
                jEdit.runStartupScripts(file);
            } else {
                GUIUtilities.advanceSplashProgress();
                file.mkdirs();
            }
        } else {
            GUIUtilities.advanceSplashProgress();
        }
        if (scriptFile != null) {
            GUIUtilities.advanceSplashProgress("run script file");
            scriptFile = MiscUtilities.constructPath(userDir, scriptFile);
            try {
                BeanShell.getNameSpace().setVariable("args", args);
            }
            catch (UtilEvalError e) {
                Log.log(9, jEdit.class, e);
            }
            BeanShell.runScript(null, scriptFile, null, false);
        } else {
            GUIUtilities.advanceSplashProgress();
        }
        GUIUtilities.advanceSplashProgress();
        DockingLayoutManager.init();
        SyntaxUtilities.propertyManager = propertyManager;
        jEdit.finishStartup(gui, restore, newPlainView, userDir, args);
        jEdit.logTime("main done");
    }

    public static String getCurrentLanguage() {
        String language = jEdit.getBooleanProperty("lang.usedefaultlocale") ? Locale.getDefault().getLanguage() : jEdit.getProperty("lang.current", "en");
        return language;
    }

    public static Properties getProperties() {
        return propMgr.getProperties();
    }

    public static String getProperty(String name) {
        return propMgr.getProperty(name);
    }

    public static String getProperty(String name, String def) {
        String value = propMgr.getProperty(name);
        if (value == null) {
            return def;
        }
        return value;
    }

    public static String getProperty(String name, Object[] args) {
        if (name == null) {
            return null;
        }
        if (args == null) {
            return jEdit.getProperty(name);
        }
        String value = jEdit.getProperty(name);
        if (value == null) {
            return null;
        }
        return MessageFormat.format(value, args);
    }

    public static boolean getBooleanProperty(String name) {
        return jEdit.getBooleanProperty(name, false);
    }

    public static boolean getBooleanProperty(String name, boolean def) {
        String value = jEdit.getProperty(name);
        return StandardUtilities.getBoolean(value, def);
    }

    public static int getIntegerProperty(String name) {
        return jEdit.getIntegerProperty(name, 0);
    }

    public static int getIntegerProperty(String name, int def) {
        String value = jEdit.getProperty(name);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nf) {
            return def;
        }
    }

    public static double getDoubleProperty(String name, double def) {
        String value = jEdit.getProperty(name);
        if (value == null) {
            return def;
        }
        try {
            return Double.parseDouble(value.trim());
        }
        catch (NumberFormatException nf) {
            return def;
        }
    }

    public static Font getFontProperty(String name) {
        return jEdit.getFontProperty(name, null);
    }

    public static Font getFontProperty(String name, Font def) {
        int style;
        int size;
        String family = jEdit.getProperty(name);
        String sizeString = jEdit.getProperty(name + "size");
        String styleString = jEdit.getProperty(name + "style");
        if (family == null || sizeString == null || styleString == null) {
            return def;
        }
        try {
            size = Integer.parseInt(sizeString);
        }
        catch (NumberFormatException nf) {
            return def;
        }
        try {
            style = Integer.parseInt(styleString);
        }
        catch (NumberFormatException nf) {
            return def;
        }
        return new Font(family, style, size);
    }

    public static Color getColorProperty(String name) {
        return jEdit.getColorProperty(name, Color.black);
    }

    public static Color getColorProperty(String name, Color def) {
        String value = jEdit.getProperty(name);
        if (value == null) {
            return def;
        }
        return SyntaxUtilities.parseColor(value, def);
    }

    public static void setColorProperty(String name, Color value) {
        jEdit.setProperty(name, SyntaxUtilities.getColorHexString(value));
    }

    public static void setProperty(String name, String value) {
        propMgr.setProperty(name, value);
    }

    public static void setTemporaryProperty(String name, String value) {
        propMgr.setTemporaryProperty(name, value);
    }

    public static void setBooleanProperty(String name, boolean value) {
        jEdit.setProperty(name, value ? "true" : "false");
    }

    public static void setIntegerProperty(String name, int value) {
        jEdit.setProperty(name, String.valueOf(value));
    }

    public static void setDoubleProperty(String name, double value) {
        jEdit.setProperty(name, String.valueOf(value));
    }

    public static void setFontProperty(String name, Font value) {
        jEdit.setProperty(name, value.getFamily());
        jEdit.setIntegerProperty(name + "size", value.getSize());
        jEdit.setIntegerProperty(name + "style", value.getStyle());
    }

    public static void unsetProperty(String name) {
        propMgr.unsetProperty(name);
    }

    public static void resetProperty(String name) {
        propMgr.resetProperty(name);
    }

    public static void propertiesChanged() {
        jEdit.initPLAF();
        keymapManager.reload();
        jEdit.initKeyBindings();
        Autosave.setInterval(jEdit.getIntegerProperty("autosave", 30));
        saveCaret = jEdit.getBooleanProperty("saveCaret");
        UIDefaults defaults = UIManager.getDefaults();
        defaults.put("SplitPane.continuousLayout", (Object)true);
        Font font = jEdit.getFontProperty("view.font");
        defaults.put("TextArea.font", font);
        defaults.put("TextPane.font", font);
        ToolTipManager.sharedInstance().setEnabled(jEdit.getBooleanProperty("showTooltips"));
        jEdit.initProxy();
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            buffer.resetCachedProperties();
            buffer.propertiesChanged();
            buffer = buffer.next;
        }
        HistoryModel.setDefaultMax(jEdit.getIntegerProperty("history", 25));
        HistoryModel.setDefaultMaxSize(jEdit.getIntegerProperty("historyMaxSize", 5000000));
        KillRing.getInstance().propertiesChanged(jEdit.getIntegerProperty("history", 25));
        Chunk.propertiesChanged(propertyManager);
        Log.setBeepOnOutput(jEdit.getBooleanProperty("debug.beepOnOutput"));
        if (jEdit.getBooleanProperty("systrayicon")) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTrayIconManager.addTrayIcon();
                }
            });
        } else {
            JTrayIconManager.removeTrayIcon();
        }
        EditBus.send(new PropertiesChanged(null));
    }

    public static String[] getNotLoadedPluginJARs() {
        String userPluginDir;
        String systemPluginDir;
        String[] list;
        ArrayList<String> returnValue = new ArrayList<String>();
        if (jEditHome != null && (list = new File(systemPluginDir = MiscUtilities.constructPath(jEditHome, "jars")).list()) != null) {
            jEdit.getNotLoadedPluginJARs(returnValue, systemPluginDir, list);
        }
        if (settingsDirectory != null && (list = new File(userPluginDir = MiscUtilities.constructPath(settingsDirectory, "jars")).list()) != null) {
            jEdit.getNotLoadedPluginJARs(returnValue, userPluginDir, list);
        }
        String[] _returnValue = new String[returnValue.size()];
        returnValue.toArray(_returnValue);
        return _returnValue;
    }

    public static EditPlugin getPlugin(String name) {
        return jEdit.getPlugin(name, false);
    }

    public static EditPlugin getPlugin(String name, boolean loadIfNecessary) {
        if (name == null) {
            return null;
        }
        EditPlugin[] plugins = jEdit.getPlugins();
        EditPlugin plugin = null;
        for (EditPlugin ep : plugins) {
            if (!ep.getClassName().equals(name)) continue;
            plugin = ep;
            break;
        }
        if (!loadIfNecessary) {
            return plugin;
        }
        if (plugin instanceof EditPlugin.Deferred) {
            plugin.getPluginJAR().activatePlugin();
            plugin = plugin.getPluginJAR().getPlugin();
        }
        String jarPath = PluginJAR.findPlugin(name);
        PluginJAR pjar = PluginJAR.load(jarPath, true);
        return pjar.getPlugin();
    }

    public static EditPlugin[] getPlugins() {
        ArrayList<EditPlugin> pluginList = new ArrayList<EditPlugin>();
        for (int i = 0; i < jars.size(); ++i) {
            EditPlugin plugin = jars.elementAt(i).getPlugin();
            if (plugin == null) continue;
            pluginList.add(plugin);
        }
        EditPlugin[] array = new EditPlugin[pluginList.size()];
        pluginList.toArray(array);
        return array;
    }

    public static PluginJAR[] getPluginJARs() {
        Object[] array = new PluginJAR[jars.size()];
        jars.copyInto(array);
        return array;
    }

    public static PluginJAR getPluginJAR(String path) {
        for (int i = 0; i < jars.size(); ++i) {
            PluginJAR jar = jars.elementAt(i);
            if (!jar.getPath().equals(path)) continue;
            return jar;
        }
        return null;
    }

    public static void addPluginJAR(String path) {
        PluginJAR jar = new PluginJAR(new File(path));
        jars.addElement(jar);
        if (jar.init()) {
            String jarName = MiscUtilities.getFileName(path);
            jEdit.unsetProperty("plugin-blacklist." + jarName);
            jEdit.unsetProperty("plugin." + jarName + ".disabled");
            EditBus.send(new PluginUpdate(jar, PluginUpdate.LOADED, false));
            if (!jEdit.isMainThread()) {
                EditBus.send(new DynamicMenuChanged("plugins"));
                jEdit.initKeyBindings();
            }
        } else {
            jars.removeElement(jar);
            jar.uninit(false);
        }
    }

    private static void addPluginJARsFromDirectory(String directory) {
        Log.log(5, jEdit.class, "Loading plugins from " + directory);
        File file = new File(directory);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        String[] plugins = file.list();
        if (plugins == null) {
            return;
        }
        for (String plugin : plugins) {
            if (!plugin.toLowerCase().endsWith(".jar")) continue;
            String path = MiscUtilities.constructPath(directory, plugin);
            if (jEdit.getBooleanProperty("plugin-blacklist." + plugin)) continue;
            jEdit.addPluginJAR(path);
        }
    }

    public static void removePluginJAR(PluginJAR jar, boolean exit) {
        if (exit) {
            jar.uninit(true);
        } else {
            jar.uninit(false);
            jars.removeElement(jar);
            if (!jEdit.isMainThread()) {
                jEdit.initKeyBindings();
            }
        }
        EditBus.send(new PluginUpdate(jar, PluginUpdate.UNLOADED, exit));
        if (!jEdit.isMainThread() && !exit) {
            EditBus.send(new DynamicMenuChanged("plugins"));
        }
    }

    public static ActionContext getActionContext() {
        return actionContext;
    }

    public static void addActionSet(ActionSet actionSet) {
        actionContext.addActionSet(actionSet);
    }

    public static void removeActionSet(ActionSet actionSet) {
        actionContext.removeActionSet(actionSet);
    }

    public static ActionSet getBuiltInActionSet() {
        return builtInActionSet;
    }

    public static ActionSet[] getActionSets() {
        return (ActionSet[])actionContext.getActionSets();
    }

    public static EditAction getAction(String name) {
        return actionContext.getAction(name);
    }

    public static ActionSet getActionSetForAction(String action) {
        return actionContext.getActionSetForAction(action);
    }

    public static String[] getActionNames() {
        return actionContext.getActionNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadModes() {
        ModeProvider.instance.removeAll();
        if (jEditHome == null) {
            jEdit.loadModeCatalog("/modes/catalog", true, false);
        } else {
            jEdit.loadModeCatalog(MiscUtilities.constructPath(jEditHome, "modes", "catalog"), false, false);
        }
        if (settingsDirectory != null) {
            File userCatalog;
            File userModeDir = new File(MiscUtilities.constructPath(settingsDirectory, "modes"));
            if (!userModeDir.exists()) {
                userModeDir.mkdirs();
            }
            if (!(userCatalog = new File(MiscUtilities.constructPath(settingsDirectory, "modes", "catalog"))).exists()) {
                BufferedWriter out = null;
                try {
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(userCatalog), "UTF-8"));
                    out.write(jEdit.getProperty("defaultCatalog"));
                    IOUtilities.closeQuietly(out);
                }
                catch (IOException io) {
                    Log.log(9, jEdit.class, io);
                }
                finally {
                    IOUtilities.closeQuietly(out);
                }
            }
            jEdit.loadModeCatalog(userCatalog.getPath(), false, true);
        }
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            buffer.setMode();
            buffer = buffer.next;
        }
    }

    public static Mode getMode(String name) {
        return ModeProvider.instance.getMode(name);
    }

    public static Mode[] getModes() {
        Mode[] modes = ModeProvider.instance.getModes();
        HashSet<Mode> selected = new HashSet<Mode>();
        for (Mode mode : modes) {
            if (jEdit.getBooleanProperty("mode.opt-out." + mode.getName(), false)) continue;
            selected.add(mode);
        }
        modes = selected.toArray(new Mode[selected.size()]);
        Arrays.sort(modes, new StandardUtilities.StringCompare(true));
        return modes;
    }

    public static Mode[] getAllModes() {
        Mode[] modes = ModeProvider.instance.getModes();
        Arrays.sort(modes, new StandardUtilities.StringCompare(true));
        return modes;
    }

    public static Buffer openFiles(View view, String parent, String[] args) {
        Buffer retVal = null;
        Buffer lastBuffer = null;
        for (String arg : args) {
            if (arg == null) continue;
            if (arg.startsWith("+line:") || arg.startsWith("+marker:")) {
                if (lastBuffer == null) continue;
                jEdit.gotoMarker(view, lastBuffer, arg);
                continue;
            }
            lastBuffer = jEdit.openFile((View)null, parent, arg, false, null);
            if (retVal != null || lastBuffer == null) continue;
            retVal = lastBuffer;
        }
        if (view != null && retVal != null) {
            view.setBuffer(retVal);
        }
        return retVal;
    }

    public static Buffer openFileAfterStartup(String path) {
        if (jEdit.isStartupDone()) {
            return jEdit.openFile(jEdit.getActiveView(), path);
        }
        additionalFiles.add(path);
        return null;
    }

    public static Buffer openFile(View view, String path) {
        return jEdit.openFile(view, null, path, false, new Hashtable<String, Object>());
    }

    public static Buffer openFile(View view, String parent, String path, boolean newFile, Hashtable<String, Object> props) {
        return jEdit.openFile(view == null ? null : view.getEditPane(), parent, path, newFile, props);
    }

    public static Buffer openFile(EditPane editPane, String path) {
        return jEdit.openFile(editPane, null, path, false, new Hashtable<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer openFile(EditPane editPane, String parent, String path, boolean newFile, Hashtable<String, Object> props) {
        Buffer newBuffer;
        PerspectiveManager.setPerspectiveDirty(true);
        if (editPane != null && parent == null && editPane.getBuffer() != null) {
            parent = editPane.getBuffer().getDirectory();
        }
        try {
            URL u = new URL(path);
            if ("file".equals(u.getProtocol())) {
                path = URLDecoder.decode(u.getPath(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            path = MiscUtilities.constructPath(parent, path);
        }
        catch (MalformedURLException e) {
            path = MiscUtilities.constructPath(parent, path);
        }
        if (props == null) {
            props = new Hashtable();
        }
        jEdit.composeBufferPropsFromHistory(props, path);
        Object object = editBusOrderingLock;
        synchronized (object) {
            View view = editPane == null ? null : editPane.getView();
            Object object2 = bufferListLock;
            synchronized (object2) {
                Buffer buffer = jEdit.getBuffer(path);
                if (buffer != null) {
                    if (editPane != null) {
                        editPane.setBuffer(buffer, true);
                    }
                    return buffer;
                }
                newBuffer = new Buffer(path, newFile, false, props);
                if (!newBuffer.load(view, false)) {
                    return null;
                }
                jEdit.addBufferToList(newBuffer);
                if (editPane != null) {
                    bufferSetManager.addBuffer(editPane, newBuffer);
                } else {
                    bufferSetManager.addBuffer(jEdit.getActiveView(), newBuffer);
                }
            }
            EditBus.send(new BufferUpdate(newBuffer, view, BufferUpdate.CREATED));
        }
        if (editPane != null) {
            editPane.setBuffer(newBuffer, true);
        }
        return newBuffer;
    }

    public static Buffer openTemporary(View view, String parent, String path, boolean newFile) {
        return jEdit.openTemporary(view, parent, path, newFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer openTemporary(View view, String parent, String path, boolean newFile, Hashtable<String, Object> props) {
        if (view != null && parent == null) {
            parent = view.getBuffer().getDirectory();
        }
        if (MiscUtilities.isURL(path) && "file".equals(MiscUtilities.getProtocolOfURL(path))) {
            path = path.substring(5);
        }
        path = MiscUtilities.constructPath(parent, path);
        if (props == null) {
            props = new Hashtable();
        }
        jEdit.composeBufferPropsFromHistory(props, path);
        Object object = bufferListLock;
        synchronized (object) {
            Buffer buffer = jEdit.getBuffer(path);
            if (buffer != null) {
                return buffer;
            }
            buffer = new Buffer(path, newFile, true, props);
            buffer.setBooleanProperty("encodingAutodetect", true);
            if (!buffer.load(view, false)) {
                return null;
            }
            return buffer;
        }
    }

    public static void commitTemporary(Buffer buffer) {
        if (!buffer.isTemporary()) {
            return;
        }
        PerspectiveManager.setPerspectiveDirty(true);
        jEdit.addBufferToList(buffer);
        buffer.commitTemporary();
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.CREATED));
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.LOAD_STARTED));
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.LOADED));
    }

    public static Buffer newFile(View view) {
        return jEdit.newFile(view == null ? null : view.getEditPane());
    }

    public static Buffer newFile(View view, String dir2) {
        EditPane editPane = null;
        if (view != null) {
            editPane = view.getEditPane();
        } else {
            View v = jEdit.getActiveView();
            if (v != null) {
                editPane = v.getEditPane();
            }
        }
        return jEdit.newFile(editPane, dir2);
    }

    public static Buffer newFile(EditPane editPane) {
        String path;
        if (editPane != null && editPane.getBuffer() != null) {
            path = editPane.getBuffer().getDirectory();
            VFS vfs = VFSManager.getVFSForPath(path);
            if ((vfs.getCapabilities() & 2) == 0) {
                path = System.getProperty("user.home");
            }
        } else {
            path = null;
        }
        return jEdit.newFile(editPane, path);
    }

    public static Buffer newFile(EditPane editPane, String dir2) {
        if (editPane != null) {
            Buffer[] buffers;
            BufferSet bufferSet = editPane.getBufferSet();
            for (Buffer buf : buffers = bufferSet.getAllBuffers()) {
                if (!buf.isUntitled() || buf.isDirty()) continue;
                if (!MiscUtilities.getParentOfPath(buf.getPath()).equals(dir2)) {
                    int untitledCount = jEdit.getNextUntitledBufferId();
                    Buffer newBuffer = jEdit.openFile(editPane, dir2, "Untitled-" + untitledCount, true, null);
                    jEdit.closeBuffer(editPane, buf);
                    return newBuffer;
                }
                int l = buf.getLength();
                if (l > 0) {
                    buf.remove(0, l);
                }
                editPane.setBuffer(buf);
                return buf;
            }
        }
        int untitledCount = jEdit.getNextUntitledBufferId();
        return jEdit.openFile(editPane, dir2, "Untitled-" + untitledCount, true, null);
    }

    public static boolean closeBuffer(View view, Buffer buffer) {
        if (buffer.isPerformingIO()) {
            TaskManager.instance.waitForIoTasks();
            if (VFSManager.errorOccurred()) {
                return false;
            }
        }
        if (buffer.isDirty()) {
            Object[] args = new Object[]{buffer.getName()};
            int result = GUIUtilities.confirm(view, "notsaved", args, 1, 2);
            if (result == 0) {
                if (!buffer.save(view, null, true)) {
                    return false;
                }
                TaskManager.instance.waitForIoTasks();
                if (buffer.getBooleanProperty("BufferIORequest__error")) {
                    return false;
                }
            } else if (result != 1) {
                return false;
            }
        }
        jEdit._closeBuffer(view, buffer);
        return true;
    }

    public static void closeBuffer(EditPane editPane, Buffer buffer) {
        switch (bufferSetManager.getScope()) {
            case global: {
                jEdit.closeBuffer(editPane.getView(), buffer);
                break;
            }
            case view: {
                View view;
                BufferSet bufferSet;
                View[] views = jEdit.getViews();
                int viewOwner = 0;
                View[] viewArray = views;
                int n = viewArray.length;
                for (int i = 0; i < n && ((bufferSet = (view = viewArray[i]).getEditPane().getBufferSet()).indexOf(buffer) == -1 || ++viewOwner <= 1); ++i) {
                }
                if (viewOwner > 1) {
                    bufferSetManager.removeBuffer(editPane, buffer);
                    break;
                }
                jEdit.closeBuffer(editPane.getView(), buffer);
                break;
            }
            case editpane: {
                int bufferSetsCount = bufferSetManager.countBufferSets(buffer);
                if (bufferSetsCount < 2) {
                    jEdit.closeBuffer(editPane.getView(), buffer);
                    break;
                }
                bufferSetManager.removeBuffer(editPane, buffer);
            }
        }
    }

    public static void _closeBuffer(View view, Buffer buffer) {
        if (buffer.isClosed()) {
            return;
        }
        if (buffer.isTemporary()) {
            buffer.close();
            return;
        }
        PerspectiveManager.setPerspectiveDirty(true);
        if (!buffer.isNewFile()) {
            Integer _caret;
            if (view != null) {
                view.getEditPane().saveCaretInfo();
            }
            int caret = (_caret = (Integer)buffer.getProperty("Buffer__caret")) == null ? 0 : _caret;
            BufferHistory.setEntry(buffer.getPath(), caret, (Selection[])buffer.getProperty("Buffer__selection"), buffer.getStringProperty("encoding"), buffer.getMode().getName());
        }
        EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSING));
        String path = buffer.getSymlinkPath();
        if ((VFSManager.getVFSForPath(path).getCapabilities() & 0x80) != 0) {
            path = path.toLowerCase();
        }
        bufferHash.remove(path);
        jEdit.removeBufferFromList(buffer);
        buffer.close();
        DisplayManager.bufferClosed(buffer);
        bufferSetManager.removeBuffer(buffer);
        EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSED));
        if (jEdit.getBooleanProperty("persistentMarkers")) {
            buffer.updateMarkersFile(view);
        }
    }

    public static boolean closeAllBuffers(View view) {
        return jEdit.closeAllBuffers(view, false);
    }

    public static boolean closeAllBuffers(View view, boolean isExiting) {
        boolean ok;
        if (view != null) {
            view.getEditPane().saveCaretInfo();
        }
        boolean dirty = false;
        boolean saveRecent = !isExiting || !jEdit.getBooleanProperty("restore");
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.isDirty()) {
                dirty = true;
                break;
            }
            buffer = buffer.next;
        }
        if (dirty && !(ok = new CloseDialog(view).isOK())) {
            return false;
        }
        TaskManager.instance.waitForIoTasks();
        if (VFSManager.errorOccurred()) {
            return false;
        }
        buffer = buffersFirst;
        buffersLast = null;
        buffersFirst = null;
        bufferHash.clear();
        bufferCount = 0;
        while (buffer != null) {
            if (!buffer.isNewFile() && saveRecent) {
                Integer _caret = (Integer)buffer.getProperty("Buffer__caret");
                int caret = _caret == null ? 0 : _caret;
                BufferHistory.setEntry(buffer.getPath(), caret, (Selection[])buffer.getProperty("Buffer__selection"), buffer.getStringProperty("encoding"), buffer.getMode().getName());
            }
            if (!isExiting) {
                EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSING));
            }
            buffer.close();
            DisplayManager.bufferClosed(buffer);
            if (!isExiting) {
                bufferSetManager.removeBuffer(buffer);
                EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSED));
            }
            if (jEdit.getBooleanProperty("persistentMarkers")) {
                buffer.updateMarkersFile(view);
            }
            buffer = buffer.next;
        }
        PerspectiveManager.setPerspectiveDirty(true);
        return true;
    }

    public static void saveAllBuffers(View view) {
        jEdit.saveAllBuffers(view, jEdit.getBooleanProperty("confirmSaveAll"));
    }

    public static void saveAllBuffers(View view, boolean confirm) {
        ArrayList<Buffer> buffers = new ArrayList<Buffer>();
        List<String> selectedBuffers = new ArrayList<String>();
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.isDirty()) {
                buffers.add(buffer);
                selectedBuffers.add(buffer.getPath());
            }
            buffer = buffer.next;
        }
        if (confirm && !buffers.isEmpty()) {
            DefaultListModel<String> listModel = new DefaultListModel<String>();
            for (Buffer buffer2 : buffers) {
                listModel.addElement(buffer2.getPath());
            }
            JList bufferList = new JList(listModel);
            bufferList.setVisibleRowCount(Math.min(listModel.getSize(), 10));
            bufferList.setSelectionInterval(0, listModel.getSize() - 1);
            int result = JOptionPane.showConfirmDialog(view, new Object[]{new JLabel(jEdit.getProperty("saveall.message")), new JScrollPane(bufferList)}, jEdit.getProperty("saveall.title"), 0, 3);
            if (result != 0) {
                return;
            }
            selectedBuffers = bufferList.getSelectedValuesList();
        }
        Buffer current = view.getBuffer();
        for (Buffer buffer3 : buffers) {
            if (!selectedBuffers.contains(buffer3.getPath())) continue;
            if (buffer3.isNewFile()) {
                view.setBuffer(buffer3);
            }
            buffer3.save(view, null, true, true);
        }
        view.setBuffer(current);
    }

    public static void reloadAllBuffers(View view, boolean confirm) {
        int result;
        boolean hasDirty = false;
        Buffer[] buffers = jEdit.getBuffers();
        for (int i = 0; i < buffers.length && !hasDirty; ++i) {
            hasDirty = !buffers[i].isUntitled() && buffers[i].isDirty();
        }
        if (confirm && hasDirty && (result = GUIUtilities.confirm(view, "reload-all", null, 0, 3)) != 0) {
            return;
        }
        jEdit.visit(new SaveCaretInfoVisitor());
        for (Buffer buffer : buffers) {
            if (buffer.isUntitled()) continue;
            buffer.load(view, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer _getBuffer(String path) {
        if ((VFSManager.getVFSForPath(path).getCapabilities() & 0x80) != 0) {
            path = path.toLowerCase();
        }
        Object object = bufferListLock;
        synchronized (object) {
            return bufferHash.get(path);
        }
    }

    public static Buffer getBuffer(String path) {
        return jEdit._getBuffer(MiscUtilities.resolveSymlinks(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer[] getBuffers() {
        Object object = bufferListLock;
        synchronized (object) {
            Buffer[] buffers = new Buffer[bufferCount];
            Buffer buffer = buffersFirst;
            for (int i = 0; i < bufferCount; ++i) {
                buffers[i] = buffer;
                buffer = buffer.next;
            }
            return buffers;
        }
    }

    public static int getBufferCount() {
        return bufferCount;
    }

    public static Buffer getFirstBuffer() {
        return buffersFirst;
    }

    public static Buffer getLastBuffer() {
        return buffersLast;
    }

    public static void moveBuffer(EditPane editPane, int oldPosition, int newPosition) {
        bufferSetManager.moveBuffer(editPane, oldPosition, newPosition);
    }

    public static BufferSetManager getBufferSetManager() {
        return bufferSetManager;
    }

    public static JEditPropertyManager getPropertyManager() {
        return propertyManager;
    }

    public static void checkBufferStatus(View view) {
        jEdit.checkBufferStatus(view, false);
    }

    public static void checkBufferStatus(View view, boolean currentBuffer) {
        Log.log(1, jEdit.class, "checkBufferStatus for " + (currentBuffer ? "current buffer: " + view.getBuffer() : "all buffers"));
        boolean autoReload = jEdit.getBooleanProperty("autoReload");
        jEdit.visit(new SaveCaretInfoVisitor());
        Buffer buffer = buffersFirst;
        int[] states = new int[bufferCount];
        int i = 0;
        boolean notifyFileChanged = false;
        while (buffer != null) {
            if (currentBuffer && buffer != view.getBuffer()) {
                buffer = buffer.next;
                ++i;
                continue;
            }
            states[i] = buffer.checkFileStatus(view);
            switch (states[i]) {
                case 1: {
                    if (buffer.getAutoReload()) {
                        if (buffer.isDirty()) {
                            notifyFileChanged = true;
                        } else {
                            buffer.load(view, true);
                            final Buffer b = buffer;
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    jEdit.updateBufferHash(b);
                                }
                            };
                            AwtRunnableQueue.INSTANCE.runAfterIoTasks(runnable);
                        }
                    } else {
                        autoReload = false;
                    }
                    if (!buffer.getAutoReloadDialog()) break;
                    notifyFileChanged = true;
                    break;
                }
                case 2: {
                    notifyFileChanged = true;
                }
            }
            buffer = buffer.next;
            ++i;
        }
        if (notifyFileChanged) {
            new FilesChangedDialog(view, states, autoReload);
        }
    }

    public static InputHandler getInputHandler() {
        return inputHandler;
    }

    public static View newView(View view) {
        return jEdit.newView(view, null, false);
    }

    public static View newView(View view, Buffer buffer) {
        return jEdit.newView(view, buffer, false);
    }

    public static View newView(View view, Buffer buffer, boolean plainView) {
        View.ViewConfig config;
        if (view != null && plainView == view.isPlainView()) {
            config = view.getViewConfig();
            config.x -= 20;
            config.y += 20;
        } else {
            config = new View.ViewConfig(plainView);
        }
        return jEdit.newView(view, buffer, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static View newView(View view, Buffer buffer, View.ViewConfig config) {
        if (jEdit.isStartupDone()) {
            PerspectiveManager.setPerspectiveDirty(true);
        }
        try {
            if (view != null) {
                view.showWaitCursor();
                view.getEditPane().saveCaretInfo();
            }
            View newView = new View(buffer, config);
            jEdit.addViewToList(newView);
            EditBus.send(new ViewUpdate(newView, ViewUpdate.CREATED));
            newView.pack();
            newView.adjust(view, config);
            newView.setVisible(true);
            if (!config.plainView) {
                int index;
                List<Boolean> list = startupDone;
                synchronized (list) {
                    index = startupDone.size();
                    startupDone.add(false);
                }
                EventQueue.invokeLater(new DockingLayoutSetter(newView, config, index));
            }
            if (newView == viewsFirst) {
                newView.getTextArea().requestFocus();
                if (settingsDirectory != null && jEdit.getBooleanProperty("firstTime")) {
                    new HelpViewer("welcome.html");
                } else if (jEdit.getBooleanProperty("tip.show")) {
                    new TipOfTheDay(newView);
                }
                jEdit.setBooleanProperty("firstTime", false);
            } else {
                GenericGUIUtilities.requestFocus(newView, newView.getTextArea());
            }
            View view2 = newView;
            return view2;
        }
        finally {
            if (view != null) {
                view.hideWaitCursor();
            }
        }
    }

    public static void closeView(View view) {
        jEdit.closeView(view, true);
    }

    public static View[] getViews() {
        View[] views = new View[viewCount];
        View view = viewsFirst;
        for (int i = 0; i < viewCount; ++i) {
            views[i] = view;
            view = view.next;
        }
        return views;
    }

    public static int getViewCount() {
        return viewCount;
    }

    public static View getFirstView() {
        return viewsFirst;
    }

    public static View getLastView() {
        return viewsLast;
    }

    public static View getActiveView() {
        if (activeView == null) {
            return viewsFirst;
        }
        return activeView;
    }

    public static void relocateSettings() {
        String oldSettingsPath = MiscUtilities.constructPath(System.getProperty("user.home"), ".jedit");
        File oldSettingsDir = new File(oldSettingsPath);
        File newSettingsDir = new File(settingsDirectory);
        if (oldSettingsDir.exists() && !newSettingsDir.exists()) {
            Log.log(5, jEdit.class, "Old settings directory found (HOME/.jedit). Moving to new location (" + newSettingsDir + ')');
            try {
                oldSettingsDir.renameTo(newSettingsDir);
            }
            catch (SecurityException se) {
                Log.log(9, jEdit.class, se);
            }
        }
    }

    public static boolean isStartupDone() {
        return !startupDone.contains(false);
    }

    public static boolean isMainThread() {
        return Thread.currentThread() == mainThread;
    }

    public static boolean isBackgroundModeEnabled() {
        return background;
    }

    public static void showMemoryDialog(View view) {
        Runtime rt = Runtime.getRuntime();
        long usedBefore = rt.totalMemory() - rt.freeMemory();
        System.gc();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        long used = total - free;
        int totalKb = (int)(total / 1024L);
        int usedKb = (int)(used / 1024L);
        JProgressBar progress = new JProgressBar(0, totalKb);
        progress.setValue(usedKb);
        progress.setStringPainted(true);
        progress.setString(jEdit.getProperty("memory-status.use", new Object[]{usedKb, totalKb}));
        Object[] message = new Object[]{jEdit.getProperty("memory-status.gc", new Object[]{(usedBefore - used) / 1024L}), Box.createVerticalStrut(12), progress, Box.createVerticalStrut(6)};
        JOptionPane.showMessageDialog(view, message, jEdit.getProperty("memory-status.title"), 1);
    }

    public static String getJEditHome() {
        return jEditHome;
    }

    public static String getSettingsDirectory() {
        return settingsDirectory;
    }

    public static String getJARCacheDirectory() {
        return jarCacheDirectory;
    }

    public static void backupSettingsFile(File file) {
        if (settingsDirectory == null || !file.exists()) {
            return;
        }
        String backupDir = MiscUtilities.constructPath(settingsDirectory, "settings-backup");
        File dir2 = new File(backupDir);
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
        MiscUtilities.saveBackup(file, 5, null, "~", backupDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSettings() {
        block7: {
            File file2;
            File file1;
            block6: {
                if (settingsDirectory == null) {
                    return;
                }
                Abbrevs.save();
                keymapManager.getKeymap().save();
                FavoritesVFS.saveFavorites();
                HistoryModel.saveHistory();
                Registers.saveRegisters();
                SearchAndReplace.save();
                BufferHistory.save();
                KillRing.getInstance().save();
                file1 = new File(MiscUtilities.constructPath(settingsDirectory, "#properties#save#"));
                file2 = new File(MiscUtilities.constructPath(settingsDirectory, "properties"));
                if (!file2.exists() || file2.lastModified() == propsModTime) break block6;
                Log.log(7, jEdit.class, file2 + " changed on disk; will not save user properties");
                break block7;
            }
            jEdit.backupSettingsFile(file2);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file1);
                propMgr.saveUserProps(out);
            }
            catch (IOException io) {
                try {
                    Log.log(9, jEdit.class, io);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(out);
                    throw throwable;
                }
                IOUtilities.closeQuietly(out);
            }
            IOUtilities.closeQuietly(out);
            file2.delete();
            if (!file1.renameTo(file2)) {
                Log.log(9, jEdit.class, "Failed to rename \"" + file1 + "\" to the user properties file \"" + file2 + "\".");
            }
            propsModTime = file2.lastModified();
        }
    }

    public static void exit(View view, boolean reallyExit) {
        if (view == null) {
            view = activeView;
        }
        TaskManager.instance.waitForIoTasks();
        EditorExitRequested eer = new EditorExitRequested(view);
        EditBus.send(eer);
        if (eer.hasBeenExitCancelled()) {
            Log.log(3, jEdit.class, "Exit has been cancelled");
            return;
        }
        reallyExit |= !background;
        PerspectiveManager.savePerspective(false);
        try {
            PerspectiveManager.setPerspectiveEnabled(false);
            if (!jEdit.closeAllBuffers(view, reallyExit)) {
                return;
            }
        }
        finally {
            PerspectiveManager.setPerspectiveEnabled(true);
        }
        if (!reallyExit) {
            view = viewsFirst;
            while (view != null) {
                jEdit.closeView(view, false);
                view = view.next;
            }
            jEdit.saveSettings();
        } else {
            PluginJAR[] plugins;
            EditBus.send(new EditorExiting(null));
            view = viewsFirst;
            while (view != null) {
                jEdit.closeView(view, false);
                view = view.next;
            }
            Autosave.stop();
            if (server != null) {
                server.stopServer();
            }
            for (PluginJAR plugin : plugins = jEdit.getPluginJARs()) {
                jEdit.removePluginJAR(plugin, true);
            }
            jEdit.saveSettings();
            Log.closeStream();
            System.exit(0);
        }
    }

    public static EditServer getEditServer() {
        return server;
    }

    public static void visit(JEditVisitor visitor) {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            visitor.visit(view);
            view.visit(visitor);
        }
    }

    public static String getRegisterStatusPrompt(String action) {
        String registerNameString = Registers.getRegisterNameString();
        return jEdit.getProperty("view.status." + action, new String[]{registerNameString == null ? jEdit.getProperty("view.status.no-registers") : registerNameString});
    }

    public static KeymapManager getKeymapManager() {
        return keymapManager;
    }

    private static void logTime(String label) {
        long currentTime = System.currentTimeMillis();
        Log.log(1, jEdit.class, label + ':' + (currentTime - startupTime) + " ms");
    }

    static void updatePosition(String oldPath, Buffer buffer) {
        if ((VFSManager.getVFSForPath(oldPath).getCapabilities() & 0x80) != 0) {
            oldPath = oldPath.toLowerCase();
        }
        bufferHash.remove(oldPath);
        String path = buffer.getSymlinkPath();
        if ((VFSManager.getVFSForPath(path).getCapabilities() & 0x80) != 0) {
            path = path.toLowerCase();
        }
        bufferHash.put(path, buffer);
        if (sortBuffers) {
            jEdit.removeBufferFromList(buffer);
            jEdit.addBufferToList(buffer);
        }
    }

    static void loadMode(Mode mode) {
        final String fileName = (String)mode.getProperty("file");
        XModeHandler xmh = new XModeHandler(mode.getName()){

            @Override
            public void error(String what, Object subst) {
                String msg;
                Object line = "<unknown>";
                if (subst == null) {
                    msg = jEdit.getProperty("xmode-error." + what);
                } else {
                    msg = jEdit.getProperty("xmode-error." + what, new String[]{subst.toString()});
                    if (subst instanceof Throwable) {
                        Log.log(9, this, subst);
                    }
                    if (subst instanceof SAXParseException) {
                        line = ((SAXParseException)subst).getLineNumber();
                    }
                }
                Object[] args = new Object[]{fileName, line, null, msg};
                GUIUtilities.error(null, "xmode-error", args);
            }

            @Override
            public TokenMarker getTokenMarker(String modeName) {
                Mode mode = jEdit.getMode(modeName);
                if (mode == null) {
                    return null;
                }
                return mode.getTokenMarker();
            }
        };
        ModeProvider.instance.loadMode(mode, xmh);
    }

    static void addPluginProps(Properties map) {
        propMgr.addPluginProps(map);
    }

    static void removePluginProps(Properties map) {
        propMgr.removePluginProps(map);
    }

    static void addPluginLocalizationProps(Properties map) {
        propMgr.addPluginLocalizationProps(map);
    }

    static void removePluginLocalizationProps(Properties map) {
        propMgr.removePluginLocalizationProps(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pluginError(String path, String messageProp, Object[] args) {
        Object object = pluginErrorLock;
        synchronized (object) {
            if (pluginErrors == null) {
                pluginErrors = new Vector();
            }
            ErrorListDialog.ErrorEntry newEntry = new ErrorListDialog.ErrorEntry(path, messageProp, args);
            for (ErrorListDialog.ErrorEntry pluginError : pluginErrors) {
                if (!pluginError.equals(newEntry)) continue;
                return;
            }
            pluginErrors.addElement(newEntry);
            if (jEdit.isStartupDone()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jEdit.showPluginErrorDialog();
                    }
                });
            }
        }
    }

    static void setActiveView(View view) {
        activeView = view;
    }

    public static View getActiveViewInternal() {
        return activeView;
    }

    static void updateBufferHash(Buffer buffer) {
        Iterator<Buffer> iterator = bufferHash.values().iterator();
        while (iterator.hasNext()) {
            Buffer b = iterator.next();
            if (buffer != b) continue;
            iterator.remove();
        }
        String path = buffer.getSymlinkPath();
        if ((VFSManager.getVFSForPath(path).getCapabilities() & 0x80) != 0) {
            path = path.toLowerCase();
        }
        bufferHash.put(path, buffer);
    }

    private jEdit() {
    }

    private static void usage() {
        System.out.println("Usage: jedit [<options>] [<files>]");
        System.out.println("\t<file> +marker:<marker>: Positions caret at marker <marker>");
        System.out.println("\t<file> +line:<line>: Positions caret at line number <line>");
        System.out.println("\t<file> +line:<line>,<column>: Positions caret at line number <line> and column number <column>");
        System.out.println("\t--: End of options");
        System.out.println("\t-background: Run in background mode");
        System.out.println("\t-nobackground: Disable background mode (default)");
        System.out.println("\t-gui: Only if running in background mode; open initial view (default)");
        System.out.println("\t-nogui: Only if running in background mode; don't open initial view");
        System.out.println("\t-log=<level>: Log messages with level equal to or higher than this to");
        System.out.println("\t standard error. <level> must be between 1 and 9. Default is 7.");
        System.out.println("\t-newplainview: Client instance opens a new plain view");
        System.out.println("\t-newview: Client instance opens a new view (default)");
        System.out.println("\t-plugins: Load plugins (default)");
        System.out.println("\t-noplugins: Don't load any plugins");
        System.out.println("\t-restore: Restore previously open files (default)");
        System.out.println("\t-norestore: Don't restore previously open files");
        System.out.println("\t-reuseview: Client instance reuses existing view");
        System.out.println("\t-quit: Quit a running instance");
        System.out.println("\t-run=<script>: Run the specified BeanShell script");
        System.out.println("\t-server: Read/write server info from/to $HOME/.jedit/server (default)");
        System.out.println("\t-server=<name>: Read/write server info from/to $HOME/.jedit/<name>");
        System.out.println("\t-noserver: Don't start edit server");
        System.out.println("\t-settings=<path>: Load user-specific settings from <path>");
        System.out.println("\t-nosettings: Don't load user-specific settings");
        System.out.println("\t-nosplash: Don't show splash screen");
        System.out.println("\t-startupscripts: Run startup scripts (default)");
        System.out.println("\t-nostartupscripts: Don't run startup scripts");
        System.out.println("\t-usage: Print this message and exit");
        System.out.println("\t-version: Print jEdit version and exit");
        System.out.println("\t-wait: Wait until the user closes the specified buffer in the server");
        System.out.println("\t instance. Does nothing if passed to the initial jEdit instance.");
        System.out.println();
        System.out.println("Report bugs to http://sourceforge.net/tracker/?group_id=588&atid=100588");
    }

    private static void version() {
        System.out.println("jEdit " + jEdit.getVersion());
    }

    private static String makeServerScript(boolean wait, boolean restore, boolean newView, boolean newPlainView, String[] args, String scriptFile) {
        StringBuilder script = new StringBuilder();
        String userDir = System.getProperty("user.dir");
        script.append("parent = \"");
        script.append(StandardUtilities.charsToEscapes(userDir));
        script.append("\";\n");
        script.append("args = new String[");
        script.append(args.length);
        script.append("];\n");
        for (int i = 0; i < args.length; ++i) {
            script.append("args[");
            script.append(i);
            script.append("] = ");
            if (args[i] == null) {
                script.append("null");
            } else {
                script.append('\"');
                script.append(StandardUtilities.charsToEscapes(args[i]));
                script.append('\"');
            }
            script.append(";\n");
        }
        script.append("view = jEdit.getLastView();\n");
        script.append("buffer = EditServer.handleClient(");
        script.append(restore).append(',').append(newView).append(',').append(newPlainView);
        script.append(",parent,args);\n");
        script.append("if(buffer != null && ").append(wait).append(") {\n");
        script.append("\tbuffer.setWaitSocket(socket);\n");
        script.append("\tdoNotCloseSocket = true;\n");
        script.append("}\n");
        script.append("if(view != jEdit.getLastView() && ").append(wait).append(") {\n");
        script.append("\tjEdit.getLastView().setWaitSocket(socket);\n");
        script.append("\tdoNotCloseSocket = true;\n");
        script.append("}\n");
        script.append("if(doNotCloseSocket == void)\n");
        script.append("\tsocket.close();\n");
        if (scriptFile != null) {
            scriptFile = MiscUtilities.constructPath(userDir, scriptFile);
            script.append("BeanShell.runScript(view,\"").append(StandardUtilities.charsToEscapes(scriptFile)).append("\",null,this.namespace);\n");
        }
        return script.toString();
    }

    private static void initMisc() {
        ModeProvider.instance = new ModeProvider(){

            @Override
            protected void error(String fileName, Throwable e) {
                Log.log(9, this, e);
                if (e instanceof SAXParseException) {
                    String message = e.getMessage();
                    int line = ((SAXParseException)e).getLineNumber();
                    int col = ((SAXParseException)e).getColumnNumber();
                    Object[] args = new Object[]{fileName, line, col, message};
                    GUIUtilities.error(null, "xmode-error", args);
                }
            }
        };
        jars = new Vector();
        FoldHandler.foldHandlerProvider = new ServiceManager.ServiceFoldHandlerProvider();
        actionContext = new ActionContext(){

            @Override
            public void invokeAction(EventObject evt, EditAction action) {
                ActionBar actionBar;
                View view = GUIUtilities.getView((Component)evt.getSource());
                boolean actionBarVisible = view.getActionBar() == null || !view.getActionBar().isShowing() ? false : view.getActionBar().isVisible();
                view.getInputHandler().invokeAction(action);
                if (actionBarVisible && (actionBar = view.getActionBar()) != null) {
                    view.removeToolBar(actionBar);
                }
            }
        };
        bufferHash = new HashMap<String, Buffer>();
        File userKeymapFolder = null;
        if (settingsDirectory != null) {
            userKeymapFolder = new File(settingsDirectory, "keymaps");
        }
        inputHandler = new DefaultInputHandler(null);
        System.getProperties().put("java.protocol.handler.pkgs", "org.gjt.sp.jedit.proto|" + System.getProperty("java.protocol.handler.pkgs", ""));
        String userAgent = "jEdit/" + jEdit.getVersion() + " (Java " + System.getProperty("java.version") + ". " + System.getProperty("java.vendor") + "; " + System.getProperty("os.arch") + ')';
        System.getProperties().put("http.agent", userAgent);
        jEditHome = System.getProperty("jedit.home");
        if (jEditHome == null) {
            int index;
            String classpath = System.getProperty("java.class.path");
            int start = classpath.lastIndexOf(File.pathSeparator, index = classpath.toLowerCase().indexOf("jedit.jar")) + 1;
            if (start == index) {
                jEditHome = System.getProperty("user.dir");
            } else if (index > start) {
                jEditHome = classpath.substring(start, index - 1);
            } else {
                jEditHome = System.getProperty("user.dir");
                Log.log(7, jEdit.class, "jedit.jar not in class path!");
                Log.log(7, jEdit.class, "Assuming jEdit is installed in " + jEditHome + '.');
                Log.log(7, jEdit.class, "Override with jedit.home system property.");
            }
        }
        jEditHome = MiscUtilities.resolveSymlinks(jEditHome);
        Log.log(3, jEdit.class, "jEdit home directory is " + jEditHome);
        keymapManager = new KeymapManagerImpl(propertyManager, new File(jEditHome, "keymaps"), userKeymapFolder);
        if (settingsDirectory != null) {
            jarCacheDirectory = MiscUtilities.constructPath(settingsDirectory, "jars-cache");
            new File(jarCacheDirectory).mkdirs();
        }
        EditBus.addToBus(new SettingsReloader());
        Thread.currentThread().setContextClassLoader(new JARClassLoader());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(new JARClassLoader());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Reader getResourceAsUTF8Text(String name) throws IOException {
        InputStream bytes = jEdit.class.getResourceAsStream(name);
        if (bytes == null) {
            return null;
        }
        Reader text = null;
        try {
            CharsetEncoding utf8 = new CharsetEncoding("UTF-8");
            text = utf8.getTextReader(bytes);
        }
        finally {
            if (text == null) {
                bytes.close();
            }
        }
        return text;
    }

    private static void initSystemProperties() {
        propMgr = new PropertyManager();
        try {
            propMgr.loadSystemProps(jEdit.getResourceAsUTF8Text("/org/gjt/sp/jedit/jedit.props"));
            propMgr.loadSystemProps(jEdit.getResourceAsUTF8Text("/org/gjt/sp/jedit/jedit_gui.props"));
            propMgr.loadSystemProps(jEdit.getResourceAsUTF8Text("/org/jedit/localization/jedit_en.props"));
        }
        catch (Exception e) {
            Log.log(9, jEdit.class, "Error while loading system properties!");
            Log.log(9, jEdit.class, "One of the following property files could not be loaded:\n- jedit.props\n- jedit_gui.props\n- jedit_en.props\njedit.jar is probably corrupt.");
            Log.log(9, jEdit.class, e);
            System.exit(1);
        }
    }

    private static void initSiteProperties() {
        String siteSettingsDirectory = MiscUtilities.constructPath(jEditHome, "properties");
        File siteSettings = new File(siteSettingsDirectory);
        if (!siteSettings.exists() || !siteSettings.isDirectory()) {
            return;
        }
        String[] snippets = siteSettings.list();
        if (snippets == null) {
            return;
        }
        Arrays.sort(snippets, new StandardUtilities.StringCompare(true));
        for (String snippet : snippets) {
            if (!snippet.toLowerCase().endsWith(".props")) continue;
            try {
                String path = MiscUtilities.constructPath(siteSettingsDirectory, snippet);
                Log.log(1, jEdit.class, "Loading site snippet: " + path);
                propMgr.loadSiteProps(new FileInputStream(new File(path)));
            }
            catch (FileNotFoundException fnf) {
                Log.log(1, jEdit.class, fnf);
            }
            catch (IOException e) {
                Log.log(9, jEdit.class, "Cannot load site snippet " + snippet);
                Log.log(9, jEdit.class, e);
            }
        }
    }

    private static void initResources() {
        builtInActionSet = new ActionSet(null, null, null, jEdit.class.getResource("actions.xml"));
        builtInActionSet.setLabel(jEdit.getProperty("action-set.jEdit"));
        builtInActionSet.load();
        actionContext.addActionSet(builtInActionSet);
        DockableWindowFactory.getInstance().loadDockableWindows(null, jEdit.class.getResource("dockables.xml"), null);
        ServiceManager.loadServices(null, jEdit.class.getResource("services.xml"), null);
    }

    private static void initPlugins() {
        PluginJAR[] jars;
        if (jEditHome != null) {
            jEdit.addPluginJARsFromDirectory(MiscUtilities.constructPath(jEditHome, "jars"));
        }
        if (settingsDirectory != null) {
            File jarsDirectory = new File(settingsDirectory, "jars");
            if (!jarsDirectory.exists()) {
                jarsDirectory.mkdir();
            }
            jEdit.addPluginJARsFromDirectory(jarsDirectory.getPath());
        }
        for (PluginJAR jar : jars = jEdit.getPluginJARs()) {
            jar.checkDependencies();
        }
    }

    private static void initUserProperties() {
        if (settingsDirectory != null) {
            File file = new File(MiscUtilities.constructPath(settingsDirectory, "properties"));
            propsModTime = file.lastModified();
            try {
                propMgr.loadUserProps(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                Log.log(9, jEdit.class, e);
            }
        }
    }

    private static void initLocalizationProperties() {
        String language = jEdit.getCurrentLanguage();
        if ("en".equals(language)) {
            return;
        }
        Reader langResource = null;
        try {
            langResource = jEdit.getResourceAsUTF8Text("/org/jedit/localization/jedit_" + language + ".props");
            propMgr.loadLocalizationProps(langResource);
            IOUtilities.closeQuietly(langResource);
        }
        catch (IOException e) {
            if (jEdit.getBooleanProperty("lang.usedefaultlocale")) {
                Log.log(9, jEdit.class, "Unable to load language", e);
            }
        }
        finally {
            IOUtilities.closeQuietly(langResource);
        }
    }

    private static String fontStyleToString(int style) {
        if (style == 0) {
            return "PLAIN";
        }
        if (style == 1) {
            return "BOLD";
        }
        if (style == 2) {
            return "ITALIC";
        }
        if (style == 3) {
            return "BOLDITALIC";
        }
        throw new RuntimeException("Invalid style: " + style);
    }

    private static String fontToString(Font font) {
        return font.getFamily() + '-' + jEdit.fontStyleToString(font.getStyle()) + '-' + font.getSize();
    }

    private static void initPLAF() {
        Font secondaryFont;
        Font primaryFont;
        String lf = jEdit.getProperty("lookAndFeel");
        final String sLf = jEdit.getPLAFClassName(lf);
        String sLfOld = null;
        String sLfNew = null;
        LookAndFeel lfOld = UIManager.getLookAndFeel();
        if (lfOld != null) {
            sLfOld = lfOld.getClass().getName();
        }
        if ((primaryFont = jEdit.getFontProperty("metal.primary.font")) != null) {
            String primaryFontString = jEdit.fontToString(primaryFont);
            System.getProperties().put("swing.plaf.metal.controlFont", primaryFontString);
            System.getProperties().put("swing.plaf.metal.menuFont", primaryFontString);
        }
        if ((secondaryFont = jEdit.getFontProperty("metal.secondary.font")) != null) {
            String secondaryFontString = jEdit.fontToString(secondaryFont);
            System.getProperties().put("swing.plaf.metal.systemFont", secondaryFontString);
            System.getProperties().put("swing.plaf.metal.userFont", secondaryFontString);
        }
        KeyboardFocusManager.setCurrentKeyboardFocusManager(new MyFocusManager());
        if (EventQueue.isDispatchThread()) {
            try {
                UIManager.setLookAndFeel(sLf);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException secondaryFontString) {}
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UIManager.setLookAndFeel(sLf);
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException secondaryFontString) {
                // empty catch block
            }
        }
        LookAndFeel lfNew = UIManager.getLookAndFeel();
        if (lfNew != null) {
            sLfNew = lfNew.getClass().getName();
        }
        Log.log(1, jEdit.class, "initPLAF " + (EventQueue.isDispatchThread() ? "edt" : "non-edt") + " old=" + sLfOld + " requested=" + lf + " new=" + sLfNew);
        if (!sLf.equals(sLfNew)) {
            Log.log(7, jEdit.class, "initPLAF failed to set requested l&f " + lf);
        }
        UIDefaults defaults = UIManager.getDefaults();
        if (jEdit.getBooleanProperty("textColors")) {
            String[] prefixes;
            ColorUIResource background = new ColorUIResource(jEdit.getColorProperty("view.bgColor"));
            ColorUIResource foreground = new ColorUIResource(jEdit.getColorProperty("view.fgColor"));
            ColorUIResource caretColor = new ColorUIResource(jEdit.getColorProperty("view.caretColor"));
            ColorUIResource selectionColor = new ColorUIResource(jEdit.getColorProperty("view.selectionColor"));
            for (String prefix : prefixes = new String[]{"PasswordField", "TextField", "TextArea", "List", "Table"}) {
                defaults.put(prefix + ".foreground", foreground);
                defaults.put(prefix + ".background", background);
                defaults.put(prefix + ".disabledForeground", foreground);
                defaults.put(prefix + ".disabledBackground", background);
                defaults.put(prefix + ".caretForeground", caretColor);
                defaults.put(prefix + ".selectionForeground", foreground);
                defaults.put(prefix + ".selectionBackground", selectionColor);
            }
            defaults.put("ComboBox.foreground", foreground);
            defaults.put("ComboBox.background", background);
            defaults.put("ComboBox.disabledForeground", foreground);
            defaults.put("ComboBox.disabledBackground", background);
            defaults.put("ComboBox.selectedForeground", foreground);
            defaults.put("ComboBox.selectedBackground", selectionColor);
            defaults.put("Tree.background", background);
            defaults.put("Tree.foreground", foreground);
            defaults.put("Tree.textBackground", background);
            defaults.put("Tree.textForeground", foreground);
            defaults.put("Tree.selectionForeground", foreground);
            defaults.put("Tree.selectionBackground", selectionColor);
        }
        defaults.remove("SplitPane.border");
        defaults.remove("SplitPaneDivider.border");
        defaults.put("Tree.rowHeight", (Object)0);
        JFrame.setDefaultLookAndFeelDecorated(jEdit.getBooleanProperty("decorate.frames"));
        JDialog.setDefaultLookAndFeelDecorated(jEdit.getBooleanProperty("decorate.dialogs"));
        if (jEdit.isStartupDone()) {
            int iWindow = 0;
            for (Window window : Window.getWindows()) {
                try {
                    SwingUtilities.updateComponentTreeUI(window);
                }
                catch (Exception e) {
                    Log.log(9, jEdit.class, "Window " + iWindow + ": " + window, e);
                    break;
                }
                ++iWindow;
            }
        }
    }

    @Nonnull
    private static String getPLAFClassName(@Nullable String lf) {
        if (lf != null && lf.length() != 0) {
            return lf;
        }
        if (OperatingSystem.isMacOS()) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static int getNextUntitledBufferId() {
        int untitledCount = 0;
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.getName().startsWith("Untitled-")) {
                try {
                    untitledCount = Math.max(untitledCount, Integer.parseInt(buffer.getName().substring(9)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buffer = buffer.next;
        }
        return untitledCount + 1;
    }

    private static void runStartupScripts(File directory) {
        if (!directory.isDirectory()) {
            return;
        }
        File[] snippets = directory.listFiles();
        if (snippets == null) {
            return;
        }
        Arrays.sort(snippets, new StandardUtilities.StringCompare(true));
        String defaultEncoding = jEdit.getProperty("buffer.encoding");
        jEdit.setProperty("buffer.encoding", "UTF-8");
        for (File snippet : snippets) {
            Macros.Handler handler = Macros.getHandlerForPathName(snippet.getPath());
            if (handler == null) continue;
            try {
                Macros.Macro newMacro = handler.createMacro(snippet.getName(), snippet.getPath());
                handler.runMacro(null, newMacro, false);
            }
            catch (Exception e) {
                Log.log(9, jEdit.class, e);
            }
        }
        jEdit.setProperty("buffer.encoding", defaultEncoding);
    }

    private static void initProxy() {
        boolean socksEnabled = jEdit.getBooleanProperty("firewall.socks.enabled");
        if (!socksEnabled) {
            Log.log(1, jEdit.class, "SOCKS proxy disabled");
            System.getProperties().remove("socksProxyHost");
            System.getProperties().remove("socksProxyPort");
        } else {
            String socksPort;
            String socksHost = jEdit.getProperty("firewall.socks.host");
            if (socksHost != null) {
                System.setProperty("socksProxyHost", socksHost);
                Log.log(1, jEdit.class, "SOCKS proxy enabled: " + socksHost);
            }
            if ((socksPort = jEdit.getProperty("firewall.socks.port")) != null) {
                System.setProperty("socksProxyPort", socksPort);
            }
        }
        boolean httpEnabled = jEdit.getBooleanProperty("firewall.enabled");
        if (!httpEnabled) {
            Log.log(1, jEdit.class, "HTTP proxy disabled");
            System.getProperties().remove("proxySet");
            System.getProperties().remove("proxyHost");
            System.getProperties().remove("proxyPort");
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
            System.getProperties().remove("http.nonProxyHosts");
            Authenticator.setDefault(null);
        } else {
            String nonProxyHosts;
            String host = jEdit.getProperty("firewall.host");
            if (host == null) {
                return;
            }
            System.setProperty("http.proxyHost", host);
            Log.log(1, jEdit.class, "HTTP proxy enabled: " + host);
            String port = jEdit.getProperty("firewall.port");
            if (port != null) {
                System.setProperty("http.proxyPort", port);
            }
            if ((nonProxyHosts = jEdit.getProperty("firewall.nonProxyHosts")) != null) {
                System.setProperty("http.nonProxyHosts", nonProxyHosts);
            }
            String username = jEdit.getProperty("firewall.user");
            String password = jEdit.getProperty("firewall.password");
            if (password == null) {
                password = "";
            }
            if (username == null || username.length() == 0) {
                Log.log(1, jEdit.class, "HTTP proxy without user");
                Authenticator.setDefault(new FirewallAuthenticator(null));
            } else {
                Log.log(1, jEdit.class, "HTTP proxy user: " + username);
                PasswordAuthentication pw = new PasswordAuthentication(username, password.toCharArray());
                Authenticator.setDefault(new FirewallAuthenticator(pw));
            }
        }
    }

    private static void finishStartup(final boolean gui, final boolean restore, final boolean newPlainView, final String userDir, final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean restoreFiles;
                int count = jEdit.getBufferCount();
                boolean bl = restoreFiles = restore && jEdit.getBooleanProperty("restore") && (count == 0 || jEdit.getBooleanProperty("restore.cli"));
                if (gui || count != 0) {
                    Buffer buffer;
                    View view = newPlainView ? jEdit.newView(null, null, true) : PerspectiveManager.loadPerspective(restoreFiles);
                    if (view == null) {
                        view = jEdit.newView(null, null);
                    }
                    if (!additionalFiles.isEmpty()) {
                        Object[] newArgs = new String[additionalFiles.size() + args.length];
                        additionalFiles.copyInto(newArgs);
                        System.arraycopy(args, 0, newArgs, additionalFiles.size(), args.length);
                        buffer = jEdit.openFiles(null, userDir, (String[])newArgs);
                    } else {
                        buffer = jEdit.openFiles(null, userDir, args);
                    }
                    if (buffer != null) {
                        view.setBuffer(buffer);
                    }
                    view.toFront();
                } else {
                    jEdit.openFiles(null, userDir, args);
                }
                EditBus.send(new EditorStarted(null));
                VFSManager.start();
                if (server != null) {
                    server.start();
                }
                GUIUtilities.hideSplashScreen();
                Log.log(3, jEdit.class, "Startup complete: " + (System.currentTimeMillis() - startupTime) + " ms");
                if (pluginErrors != null) {
                    jEdit.showPluginErrorDialog();
                }
                startupDone.set(0, true);
                Toolkit.getDefaultToolkit();
            }
        });
    }

    private static void showPluginErrorDialog() {
        if (pluginErrors == null) {
            return;
        }
        String caption = jEdit.getProperty("plugin-error.caption" + (pluginErrors.size() == 1 ? "-1" : ""));
        JFrame frame = PluginManager.getInstance() == null ? viewsFirst : PluginManager.getInstance();
        new ErrorListDialog(frame, jEdit.getProperty("plugin-error.title"), caption, pluginErrors, true);
        pluginErrors = null;
    }

    private static void getNotLoadedPluginJARs(Collection<String> returnValue, String dir2, String[] list) {
        block0: for (String name : list) {
            if (!name.toLowerCase().endsWith(".jar")) continue;
            String path = MiscUtilities.constructPath(dir2, name);
            for (int j = 0; j < jars.size(); ++j) {
                PluginJAR jar = jars.elementAt(j);
                String jarPath = jar.getPath();
                if (path.equals(jarPath) || name.equals(MiscUtilities.getFileName(jarPath)) && !new File(jarPath).exists()) continue block0;
            }
            returnValue.add(path);
        }
    }

    private static void gotoMarker(final View view, final Buffer buffer, final String marker) {
        AwtRunnableQueue.INSTANCE.runAfterIoTasks(new Runnable(){

            @Override
            public void run() {
                int pos;
                if (marker.startsWith("+line:")) {
                    try {
                        int col;
                        int line;
                        String arg = marker.substring(6);
                        String[] lineCol = arg.split(",");
                        if (lineCol.length > 1) {
                            line = Integer.parseInt(lineCol[0]);
                            col = Integer.parseInt(lineCol[1]);
                        } else {
                            line = Integer.parseInt(marker.substring(6));
                            col = 1;
                        }
                        pos = buffer.getLineStartOffset(line - 1) + (col - 1);
                    }
                    catch (Exception e) {
                        return;
                    }
                } else if (marker.startsWith("+marker:")) {
                    if (marker.length() != 9) {
                        return;
                    }
                    Marker m = buffer.getMarker(marker.charAt(8));
                    if (m == null) {
                        return;
                    }
                    pos = m.getPosition();
                } else {
                    throw new InternalError();
                }
                if (view != null && view.getBuffer() == buffer) {
                    view.getTextArea().setCaretPosition(pos);
                    buffer.setIntegerProperty("Buffer__caret", pos);
                    buffer.setBooleanProperty("Buffer__caretPositioned", true);
                } else {
                    buffer.setIntegerProperty("Buffer__caret", pos);
                    buffer.setBooleanProperty("Buffer__caretPositioned", true);
                    buffer.unsetProperty("Buffer__scrollVert");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addBufferToList(Buffer buffer) {
        Object object = bufferListLock;
        synchronized (object) {
            String symlinkPath = buffer.getSymlinkPath();
            if ((VFSManager.getVFSForPath(symlinkPath).getCapabilities() & 0x80) != 0) {
                symlinkPath = symlinkPath.toLowerCase();
            }
            ++bufferCount;
            bufferHash.put(symlinkPath, buffer);
            if (buffersFirst == null) {
                buffersFirst = buffersLast = buffer;
                return;
            }
            if (sortBuffers) {
                String str12;
                String str11;
                if (sortByName) {
                    str11 = buffer.getName();
                    str12 = buffer.getDirectory();
                } else {
                    str11 = buffer.getDirectory();
                    str12 = buffer.getName();
                }
                Buffer _buffer = buffersFirst;
                while (_buffer != null) {
                    String str22;
                    String str21;
                    if (sortByName) {
                        str21 = _buffer.getName();
                        str22 = _buffer.getDirectory();
                    } else {
                        str21 = _buffer.getDirectory();
                        str22 = _buffer.getName();
                    }
                    int comp = StandardUtilities.compareStrings(str11, str21, true);
                    if (comp < 0 || comp == 0 && StandardUtilities.compareStrings(str12, str22, true) < 0) {
                        buffer.next = _buffer;
                        buffer.prev = _buffer.prev;
                        _buffer.prev = buffer;
                        if (_buffer != buffersFirst) {
                            buffer.prev.next = buffer;
                        } else {
                            buffersFirst = buffer;
                        }
                        return;
                    }
                    _buffer = _buffer.next;
                }
            }
            buffer.prev = buffersLast;
            buffer.next = null;
            jEdit.buffersLast.next = buffer;
            buffersLast = buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeBufferFromList(Buffer buffer) {
        Object object = bufferListLock;
        synchronized (object) {
            --bufferCount;
            String path = buffer.getPath();
            if (OperatingSystem.isCaseInsensitiveFS()) {
                path = path.toLowerCase();
            }
            bufferHash.remove(path);
            if (buffer == buffersFirst && buffer == buffersLast) {
                buffersLast = null;
                buffersFirst = null;
                return;
            }
            if (buffer == buffersFirst) {
                buffersFirst = buffer.next;
                buffer.next.prev = null;
            } else if (buffer.prev != null) {
                buffer.prev.next = buffer.next;
            }
            if (buffer == buffersLast) {
                buffersLast = jEdit.buffersLast.prev;
                buffer.prev.next = null;
            } else if (buffer.next != null) {
                buffer.next.prev = buffer.prev;
            }
            buffer.prev = null;
            buffer.next = null;
        }
    }

    private static void addViewToList(View view) {
        ++viewCount;
        if (viewsFirst == null) {
            viewsFirst = viewsLast = view;
        } else {
            view.prev = viewsLast;
            jEdit.viewsLast.next = view;
            viewsLast = view;
        }
    }

    private static void removeViewFromList(View view) {
        --viewCount;
        if (viewsFirst == viewsLast) {
            viewsLast = null;
            viewsFirst = null;
            return;
        }
        if (view == viewsFirst) {
            viewsFirst = view.next;
            view.next.prev = null;
        } else {
            view.prev.next = view.next;
        }
        if (view == viewsLast) {
            viewsLast = jEdit.viewsLast.prev;
            view.prev.next = null;
        } else {
            view.next.prev = view.prev;
        }
    }

    private static boolean closeView(View view, boolean callExit) {
        PerspectiveManager.setPerspectiveDirty(true);
        if (viewsFirst == viewsLast && callExit) {
            jEdit.exit(view, false);
            return false;
        }
        if (!view.confirmToCloseDirty()) {
            return false;
        }
        view.close();
        view.dispose();
        jEdit.removeViewFromList(view);
        if (view == activeView) {
            activeView = null;
        }
        return true;
    }

    private static void loadModeCatalog(String path, boolean resource, final boolean userMode) {
        Log.log(3, jEdit.class, "Loading mode catalog file " + path);
        ModeCatalogHandler handler = new ModeCatalogHandler(MiscUtilities.getParentOfPath(path), resource){

            @Override
            protected Mode instantiateMode(String modeName) {
                JEditMode mode = new JEditMode(modeName);
                mode.setUserMode(userMode);
                return mode;
            }
        };
        try {
            InputStream _in = resource ? jEdit.class.getResourceAsStream(path) : new FileInputStream(path);
            XMLUtilities.parseXML(_in, handler);
        }
        catch (IOException e) {
            Log.log(9, jEdit.class, e);
        }
    }

    private static void initKeyBindings() {
        ActionSet[] actionSets;
        inputHandler.removeAllKeyBindings();
        for (ActionSet actionSet : actionSets = jEdit.getActionSets()) {
            actionSet.initKeyBindings();
        }
    }

    private static void composeBufferPropsFromHistory(Map<String, Object> props, String path) {
        BufferHistory.Entry entry = BufferHistory.getEntry(path);
        if (entry != null && saveCaret && props.get("Buffer__caret") == null) {
            props.put("Buffer__caret", entry.caret);
            if (entry.selection != null) {
                props.put("Buffer__selection", entry.getSelection());
            }
        }
        if (entry != null && props.get("encoding") == null && entry.encoding != null) {
            props.put("encoding", entry.encoding);
        }
        if (entry != null && props.get("mode") == null && entry.mode != null) {
            props.put("mode", entry.mode);
        }
    }

    static {
        pluginErrorLock = new Object();
        propertyManager = new JEditPropertyManager();
        startupTime = System.currentTimeMillis();
        bufferListLock = new Object();
        editBusOrderingLock = new Object();
        startupDone = new Vector<Boolean>();
        additionalFiles = new Vector();
    }

    private static class DockingLayoutSetter
    implements Runnable {
        private final View view;
        private final View.ViewConfig config;
        private final int startupDoneIndex;

        DockingLayoutSetter(View view, View.ViewConfig config, int startupDoneIndex) {
            this.view = view;
            this.config = config;
            this.startupDoneIndex = startupDoneIndex;
        }

        @Override
        public void run() {
            DockableWindowManager wm = this.view.getDockableWindowManager();
            wm.setDockingLayout(this.config.docking);
            startupDone.set(this.startupDoneIndex, true);
        }
    }

    public static class JEditPropertyManager
    implements IPropertyManager {
        @Override
        public String getProperty(String name) {
            return jEdit.getProperty(name);
        }
    }

    private static class MyFocusManager
    extends DefaultKeyboardFocusManager {
        MyFocusManager() {
            this.setDefaultFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent evt) {
            if (!evt.isConsumed()) {
                Component comp = (Component)evt.getSource();
                if (!comp.isShowing()) {
                    return true;
                }
                while (true) {
                    if (comp instanceof View) {
                        ((View)comp).getInputHandler().processKeyEvent(evt, 0, false);
                        return true;
                    }
                    if (comp == null || comp instanceof Window || comp instanceof JEditTextArea) {
                        if (!(comp instanceof PluginManager)) break;
                        evt.setSource(comp);
                        ((PluginManager)comp).processKeyEvents(evt);
                        break;
                    }
                    comp = comp.getParent();
                }
            }
            return super.postProcessKeyEvent(evt);
        }
    }

    static class FirewallAuthenticator
    extends Authenticator {
        PasswordAuthentication pw;

        FirewallAuthenticator(PasswordAuthentication pw) {
            this.pw = pw;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.pw;
        }
    }
}

