/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;

public class CopyFileWorker
extends Task {
    private String source;
    private final Component comp;
    private List<String> sources;
    private final Behavior behavior;
    private final String target;
    private CountDownLatch latch;

    public CopyFileWorker(Component comp, String source, String target) {
        this(comp, source, target, null);
    }

    private CopyFileWorker(Component comp, String source, String target, @Nullable CountDownLatch latch) {
        if (source == null || target == null) {
            throw new NullPointerException("The source and target cannot be null");
        }
        if (source.equals(target)) {
            throw new IllegalArgumentException("The source and target must not be the same");
        }
        this.comp = comp;
        this.source = source;
        this.target = target;
        this.behavior = Behavior.OVERWRITE;
        this.latch = latch;
        this.setLabel("Copy " + source + " to " + target);
    }

    public CopyFileWorker(Component comp, List<String> sources, String target) {
        this(comp, sources, target, Behavior.SKIP);
    }

    public CopyFileWorker(Component comp, List<String> sources, String target, Behavior behavior) {
        if (sources == null || target == null) {
            throw new NullPointerException("The source and target cannot be null");
        }
        this.comp = comp;
        this.sources = sources;
        this.target = target;
        this.behavior = behavior;
    }

    @Override
    public void _run() {
        Log.log(1, this, this + ".run()");
        if (this.source != null) {
            try {
                VFS.copy(this, this.source, this.target, this.comp, false, false);
            }
            catch (IOException e) {
                Log.log(9, this, e, e);
            }
            finally {
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        } else {
            this.copyFileList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFileList() {
        VFS vfs = VFSManager.getVFSForPath(this.target);
        Object targetSession = null;
        try {
            targetSession = vfs.createVFSSession(this.target, this.comp);
            if (targetSession == null) {
                Log.log(9, this, "Target VFS path cannot be reached");
                return;
            }
            VFSFile targetFile = vfs._getFile(targetSession, this.target, this.comp);
            if (targetFile == null) {
                Log.log(9, this, "Target is unreachable or do not exist");
                return;
            }
            if (targetFile.getType() != 1) {
                Log.log(9, this, "Target is not a directory");
                return;
            }
            if (this.sources == null) return;
            this.setMaximum(this.sources.size());
            int i = 0;
            while (i < this.sources.size()) {
                this.setValue(i);
                String sourcePath = this.sources.get(i);
                String sourceName = MiscUtilities.getFileName(sourcePath);
                this.setLabel(sourceName);
                this.copy(targetSession, vfs, sourcePath, sourceName, this.target);
                ++i;
            }
            return;
        }
        catch (IOException e) {
            Log.log(9, this, e);
            return;
        }
        catch (InterruptedException e) {
            Log.log(7, this, "Copy was interrupted");
            return;
        }
        finally {
            VFSManager.sendVFSUpdate(vfs, this.target, true);
            try {
                if (targetSession != null) {
                    vfs._endVFSSession(targetSession, this.comp);
                }
            }
            catch (IOException e) {}
        }
    }

    private void copy(Object vfsSession, VFS vfs, String sourcePath, String sourceName, String targetPath) throws IOException, InterruptedException {
        String name = this.getTargetName(vfsSession, vfs, targetPath, sourceName);
        if (name == null) {
            return;
        }
        String targetName = MiscUtilities.constructPath(targetPath, name);
        CountDownLatch latch = new CountDownLatch(1);
        ThreadUtilities.runInBackground(new CopyFileWorker(this.comp, sourcePath, targetName, latch));
        latch.await();
    }

    @Nullable
    private String getTargetName(Object session, VFS vfs, String path, String baseName) throws IOException {
        if (this.behavior == Behavior.OVERWRITE) {
            return baseName;
        }
        String s = MiscUtilities.constructPath(this.target, baseName);
        VFSFile file = vfs._getFile(session, s, this.comp);
        if (file == null) {
            return baseName;
        }
        if (this.behavior == Behavior.SKIP) {
            return null;
        }
        String extension = MiscUtilities.getFileExtension(baseName);
        String nameNoExtension = MiscUtilities.getBaseName(baseName);
        for (int i = 1; i < 1000; ++i) {
            String name = nameNoExtension + "-copy-" + i;
            if (extension != null) {
                name = name + extension;
            }
            if ((file = vfs._getFile(session, s = MiscUtilities.constructPath(path, name), this.comp)) != null) continue;
            return name;
        }
        return null;
    }

    @Override
    public String toString() {
        return "CopyFileWorker[" + this.source + ',' + this.target + ']';
    }

    public static enum Behavior {
        SKIP,
        OVERWRITE,
        RENAME;

    }
}

