/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightManagerTableModel;
import gatchan.highlight.HighlightTablePanel;
import gatchan.highlight.InvalidHighlightException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;

public final class HighlightCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
DocumentListener {
    private Highlight highlight;
    private final HighlightTablePanel renderer = new HighlightTablePanel();

    public HighlightCellEditor() {
        this.renderer.setCellEditor(this);
    }

    @Override
    public Object getCellEditorValue() {
        return this.highlight;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.renderer.save(this.highlight);
            this.renderer.stopEdition();
            HighlightManagerTableModel.getManager().setHighlightEnable(true);
            this.fireEditingStopped();
            return true;
        }
        catch (InvalidHighlightException e) {
            GUIUtilities.error((Component)jEdit.getActiveView(), (String)"gatchan-highlight.errordialog.invalidHighlight", null);
            return false;
        }
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.highlight = (Highlight)value;
        this.renderer.setHighlight(this.highlight);
        return this.renderer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.saveHighlight();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.saveHighlight();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.saveHighlight();
    }

    private void saveHighlight() {
        try {
            this.renderer.save(this.highlight);
            HighlightManagerTableModel.getManager().setHighlightEnable(true);
        }
        catch (InvalidHighlightException invalidHighlightException) {
            // empty catch block
        }
    }
}

