/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Output;
import console.StreamTask;
import java.awt.Color;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class SimpleOutputStreamTask
extends StreamTask {
    private WaitingLoop waitingLoop;
    protected int BufferSize = 1024;
    protected int SleepDelayMSec = 20;
    protected InputStream in;
    protected Color defaultColor;
    protected Output output;
    protected StringBuilder lineBuffer;

    public SimpleOutputStreamTask(InputStream in, Output output, Color defaultColor) {
        super("Output thread");
        this.in = in;
        this.output = output;
        this.defaultColor = defaultColor;
    }

    protected void actionInsideWaitingLoop(InputStreamReader isr) throws Exception {
    }

    protected void afterWorking() throws Exception {
    }

    protected void beforeWorking() throws Exception {
    }

    protected void finalOutputting() {
        if (this.lineBuffer.length() > 0) {
            this.output.print(this.defaultColor, this.lineBuffer.toString());
        }
    }

    protected void exception_dumpToLog(Exception e) {
        Log.log((int)9, (Object)e, (Object)e);
    }

    protected void exception_dumpToOwner(Exception e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(this.in, jEdit.getProperty((String)"console.encoding"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        if (this.waitingLoop == null) {
            this.setWaitingLoop(WLTypes.nonsyncWL);
        }
        try {
            char[] input = new char[this.BufferSize];
            int read = 0;
            this.lineBuffer = new StringBuilder(this.BufferSize);
            this.beforeWorking();
            try {
                while (!this.abortFlag) {
                    try {
                        read = this.waitingLoop.readIfReady(isr, input, 0, input.length);
                    }
                    catch (InterruptedIOException iioe) {
                        break;
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                    this.lineBuffer.append(input, 0, read);
                    this.outputData();
                }
            }
            finally {
                this.finalOutputting();
            }
            this.afterWorking();
        }
        catch (Exception e) {
            this.exception_dumpToLog(e);
            this.exception_dumpToOwner(e);
        }
    }

    protected void outputData() throws Exception {
        this.output.print(this.defaultColor, this.lineBuffer.toString());
        this.lineBuffer.setLength(0);
    }

    public void setWaitingLoop(WLTypes wl) {
        switch (wl) {
            case syncWL: {
                this.waitingLoop = new SynchronizedWL();
                break;
            }
            case nonsyncWL: {
                this.waitingLoop = new NonsynchronizedWL();
                break;
            }
            case blockWL: {
                this.waitingLoop = new BlockingWL();
                break;
            }
            default: {
                this.waitingLoop = new NonsynchronizedWL();
            }
        }
    }

    private class BlockingWL
    extends WaitingLoop {
        private BlockingWL() {
        }

        @Override
        public int readIfReady(InputStreamReader isr, char[] input, int offset, int length) throws Exception {
            SimpleOutputStreamTask.this.actionInsideWaitingLoop(isr);
            int result = isr.read(input, offset, length);
            if (result == -1) {
                throw new InterruptedException("Break the main loop: input stream is empty");
            }
            return result;
        }
    }

    private class SynchronizedWL
    extends WaitingLoop {
        private SynchronizedWL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int readIfReady(InputStreamReader isr, char[] input, int offset, int length) throws Exception {
            int result = 0;
            InputStream inputStream = SimpleOutputStreamTask.this.in;
            synchronized (inputStream) {
                while (true) {
                    if (SimpleOutputStreamTask.this.abortFlag) {
                        throw new InterruptedException("Break the main loop: aborting");
                    }
                    if (isr.ready()) {
                        result = isr.read(input, offset, length);
                        if (result != -1) break;
                        throw new InterruptedException("Break the main loop: input stream is empty");
                    }
                    if (SimpleOutputStreamTask.this.finishFlag) {
                        throw new InterruptedException("End the main loop.");
                    }
                    SimpleOutputStreamTask.this.in.wait(SimpleOutputStreamTask.this.SleepDelayMSec);
                    SimpleOutputStreamTask.this.actionInsideWaitingLoop(isr);
                }
            }
            return result;
        }
    }

    private class NonsynchronizedWL
    extends WaitingLoop {
        private NonsynchronizedWL() {
        }

        @Override
        public int readIfReady(InputStreamReader isr, char[] input, int offset, int length) throws Exception {
            int result = 0;
            while (true) {
                if (SimpleOutputStreamTask.this.abortFlag) {
                    throw new InterruptedException("Break the main loop: aborting");
                }
                if (isr.ready()) {
                    result = isr.read(input, offset, length);
                    if (result != -1) break;
                    throw new InterruptedException("Break the main loop: input stream is empty");
                }
                if (SimpleOutputStreamTask.this.finishFlag) {
                    throw new InterruptedException("End the main loop.");
                }
                Thread.sleep(SimpleOutputStreamTask.this.SleepDelayMSec);
                SimpleOutputStreamTask.this.actionInsideWaitingLoop(isr);
            }
            return result;
        }
    }

    private class WaitingLoop {
        private WaitingLoop() {
        }

        public int readIfReady(InputStreamReader isr, char[] input, int offset, int length) throws Exception {
            throw new InterruptedException("End the main loop.");
        }
    }

    public static enum WLTypes {
        syncWL,
        nonsyncWL,
        blockWL;

    }
}

