/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.gui.FilteredTableModel;
import org.gjt.sp.jedit.gui.GrabKeyDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.jedit.keymap.Keymap;
import org.jedit.keymap.KeymapManager;

public class ShortcutsOptionPane
extends AbstractOptionPane {
    private Keymap selectedKeymap;
    private JButton duplicateKeymap;
    private JButton resetKeymap;
    private JButton deleteKeymap;
    private JComboBox<String> keymaps;
    private JTable keyTable;
    private Vector<ShortcutsModel> models;
    private FilteredTableModel<ShortcutsModel> filteredModel;
    private JComboBox<ShortcutsModel> selectModel;
    private List<GrabKeyDialog.KeyBinding> allBindings;
    private JTextField filterTF;

    public ShortcutsOptionPane() {
        super("shortcuts");
    }

    @Override
    protected void _init() {
        this.allBindings = new Vector<GrabKeyDialog.KeyBinding>();
        this.setLayout(new BorderLayout(12, 12));
        KeymapManager keymapManager = jEdit.getKeymapManager();
        String keymapName = jEdit.getProperty("keymap.current");
        this.selectedKeymap = keymapManager.getKeymap(keymapName);
        if (this.selectedKeymap == null) {
            this.selectedKeymap = keymapManager.getKeymap("jEdit");
        }
        this.initModels();
        this.duplicateKeymap = new JButton(jEdit.getProperty("options.shortcuts.duplicatekeymap.label"));
        this.resetKeymap = new JButton(jEdit.getProperty("options.shortcuts.resetkeymap.label"));
        this.deleteKeymap = new JButton(jEdit.getProperty("options.shortcuts.deletekeymap.label"));
        this.resetButtons();
        ActionHandler actionHandler = new ActionHandler();
        KeymapsModel model = new KeymapsModel();
        this.keymaps = new JComboBox<String>(model);
        this.keymaps.setRenderer(new KeymapCellRenderer());
        this.keymaps.setSelectedItem(keymapName);
        this.duplicateKeymap.addActionListener(actionHandler);
        this.resetKeymap.addActionListener(actionHandler);
        this.deleteKeymap.addActionListener(actionHandler);
        this.keymaps.addActionListener(actionHandler);
        this.keymaps.setSelectedItem(this.selectedKeymap);
        JPanel keymapBox = new JPanel(new FlowLayout(3));
        keymapBox.add(new JLabel(jEdit.getProperty("options.shortcuts.keymap.label")));
        keymapBox.add(this.keymaps);
        keymapBox.add(Box.createHorizontalStrut(6));
        keymapBox.add(this.duplicateKeymap);
        keymapBox.add(this.resetKeymap);
        keymapBox.add(this.deleteKeymap);
        this.selectModel = new JComboBox<ShortcutsModel>(this.models);
        this.selectModel.addActionListener(actionHandler);
        this.selectModel.setToolTipText(jEdit.getProperty("options.shortcuts.select.tooltip"));
        Box north = Box.createHorizontalBox();
        north.add(new JLabel(jEdit.getProperty("options.shortcuts.select.label")));
        north.add(Box.createHorizontalStrut(6));
        north.add(this.selectModel);
        this.filterTF = new JTextField(40);
        this.filterTF.setToolTipText(jEdit.getProperty("options.shortcuts.filter.tooltip"));
        this.filterTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ShortcutsOptionPane.this.setFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ShortcutsOptionPane.this.setFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ShortcutsOptionPane.this.setFilter();
            }
        });
        JButton clearButton = new JButton(jEdit.getProperty("options.shortcuts.clear.label"));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ShortcutsOptionPane.this.filterTF.setText("");
                ShortcutsOptionPane.this.filterTF.requestFocus();
            }
        });
        JPanel filterPanel = new JPanel(new FlowLayout(0));
        filterPanel.add(new JLabel(jEdit.getProperty("options.shortcuts.filter.label")));
        filterPanel.add(this.filterTF);
        filterPanel.add(clearButton);
        this.keyTable = new JTable(this.filteredModel);
        this.filteredModel.setTable(this.keyTable);
        this.keyTable.setRowHeight(GenericGUIUtilities.defaultRowHeight());
        this.keyTable.getTableHeader().setReorderingAllowed(false);
        this.keyTable.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.keyTable.addMouseListener(new TableMouseHandler());
        Dimension d = this.keyTable.getPreferredSize();
        d.height = Math.min(d.height, 200);
        JScrollPane scroller = new JScrollPane(this.keyTable);
        scroller.setPreferredSize(d);
        JPanel tableFilterPanel = new JPanel(new BorderLayout());
        tableFilterPanel.add("North", filterPanel);
        tableFilterPanel.add("Center", scroller);
        Box northBox = Box.createVerticalBox();
        northBox.add(keymapBox);
        northBox.add(Box.createVerticalGlue());
        northBox.add(north);
        this.add("North", northBox);
        this.add("Center", tableFilterPanel);
        try {
            this.selectModel.setSelectedIndex(jEdit.getIntegerProperty("options.shortcuts.select.index", 0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    protected void _save() {
        jEdit.setProperty("keymap.current", this.selectedKeymap.toString());
        if (this.keyTable.getCellEditor() != null) {
            this.keyTable.getCellEditor().stopCellEditing();
        }
        for (ShortcutsModel model : this.models) {
            model.save();
        }
        Macros.loadMacros();
        this.selectedKeymap.save();
    }

    private void setFilter() {
        this.filteredModel.setFilter(this.filterTF.getText());
    }

    private void initModels() {
        this.filteredModel = new FilteredTableModel<ShortcutsModel>(){

            @Override
            public String prepareFilter(String filter) {
                return filter.toLowerCase();
            }

            @Override
            public boolean passFilter(int row, String filter) {
                String name = ((ShortcutsModel)this.delegated).getBindingAt((int)row, (int)0).label.toLowerCase();
                return name.contains(filter);
            }
        };
        this.models = new Vector();
        this.reloadModels();
    }

    private void reloadModels() {
        ActionSet[] actionSets;
        this.models.clear();
        this.allBindings.clear();
        ArrayList<GrabKeyDialog.KeyBinding[]> allBindings = new ArrayList<GrabKeyDialog.KeyBinding[]>();
        HashSet<String> knownBindings = new HashSet<String>();
        for (ActionSet actionSet : actionSets = jEdit.getActionSets()) {
            if (actionSet.getActionCount() == 0) continue;
            String modelLabel = actionSet.getLabel();
            if (modelLabel == null) {
                Log.log(9, this, "Empty action set: " + actionSet.getPluginJAR());
            }
            ShortcutsModel model = this.createModel(actionSet.getLabel(), modelLabel, actionSet.getActionNames());
            this.models.add(model);
            List<GrabKeyDialog.KeyBinding[]> bindings = model.getBindings();
            for (GrabKeyDialog.KeyBinding[] binding : bindings) {
                String name = binding[0].name;
                if (knownBindings.contains(name)) continue;
                knownBindings.add(name);
                allBindings.add(binding);
            }
        }
        if (this.models.size() > 1) {
            this.models.add(new ShortcutsModel("All", allBindings));
        }
        ShortcutsModel delegated = this.filteredModel.getDelegated();
        Collections.sort(this.models, new StandardUtilities.StringCompare(true));
        if (delegated == null) {
            delegated = this.models.get(0);
        } else {
            for (ShortcutsModel model : this.models) {
                if (!model.toString().equals(delegated.toString())) continue;
                delegated = model;
                break;
            }
        }
        this.filteredModel.setDelegated(delegated);
        this.filteredModel.fireTableDataChanged();
    }

    private ShortcutsModel createModel(String actionSet, String modelLabel, String[] actions) {
        ArrayList<GrabKeyDialog.KeyBinding[]> bindings = new ArrayList<GrabKeyDialog.KeyBinding[]>(actions.length);
        for (String name : actions) {
            EditAction ea = jEdit.getAction(name);
            String label = ea.getLabel();
            if (label == null) continue;
            label = GenericGUIUtilities.prettifyMenuLabel(label);
            this.addBindings(actionSet, name, label, bindings);
        }
        return new ShortcutsModel(modelLabel, bindings);
    }

    private void addBindings(String actionSet, String name, String label, Collection<GrabKeyDialog.KeyBinding[]> bindings) {
        GrabKeyDialog.KeyBinding[] b = new GrabKeyDialog.KeyBinding[]{this.createBinding(actionSet, name, label, this.selectedKeymap.getShortcut(name + ".shortcut")), this.createBinding(actionSet, name, label, this.selectedKeymap.getShortcut(name + ".shortcut2"))};
        bindings.add(b);
    }

    private GrabKeyDialog.KeyBinding createBinding(String actionSet, String name, String label, String shortcut) {
        if (shortcut != null && shortcut.isEmpty()) {
            shortcut = null;
        }
        GrabKeyDialog.KeyBinding binding = new GrabKeyDialog.KeyBinding(name, label, shortcut, false);
        binding.actionSet = actionSet;
        this.allBindings.add(binding);
        return binding;
    }

    private void resetButtons() {
        KeymapManager keymapManager = jEdit.getKeymapManager();
        KeymapManager.State state = keymapManager.getKeymapState(this.selectedKeymap.toString());
        this.resetKeymap.setEnabled(state == KeymapManager.State.SystemModified);
        this.deleteKeymap.setEnabled(state == KeymapManager.State.User);
    }

    private static class KeymapCellRenderer
    extends DefaultListCellRenderer {
        private KeymapCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String label = jEdit.getProperty("keymaps." + value + ".label", String.valueOf(value).replace('_', ' '));
            this.setText(label);
            return this;
        }
    }

    private static class KeymapsModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private String[] keymaps;
        private Object selectedItem;

        private KeymapsModel() {
            this.reset();
        }

        void reset() {
            KeymapManager keymapManager = jEdit.getKeymapManager();
            Collection<String> keymapNames = keymapManager.getKeymapNames();
            this.keymaps = keymapNames.toArray(new String[keymapNames.size()]);
            if (!this.isValidName(this.selectedItem)) {
                this.selectedItem = this.keymaps[0];
            }
            this.fireContentsChanged(this, 0, this.keymaps.length - 1);
        }

        @Override
        public int getSize() {
            return this.keymaps.length;
        }

        @Override
        public String getElementAt(int index) {
            return this.keymaps[index];
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedItem = this.isValidName(anItem) ? anItem : this.keymaps[0];
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        private boolean isValidName(Object name) {
            for (String keymap : this.keymaps) {
                if (!keymap.equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    private class ShortcutsModel
    extends AbstractTableModel {
        public static final String ALL = "All";
        private final List<GrabKeyDialog.KeyBinding[]> bindings;
        private final String name;

        ShortcutsModel(String name, List<GrabKeyDialog.KeyBinding[]> bindings) {
            this.name = name;
            this.bindings = bindings;
            this.sort(0);
        }

        public List<GrabKeyDialog.KeyBinding[]> getBindings() {
            return this.bindings;
        }

        public void sort(int col) {
            Collections.sort(this.bindings, new KeyCompare(col));
        }

        @Override
        public int getColumnCount() {
            if (ALL.equals(this.name)) {
                return 4;
            }
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.bindings.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            GrabKeyDialog.KeyBinding bindingAt = this.getBindingAt(row, 0);
            ShortcutsOptionPane.this.setToolTipText(bindingAt.label);
            switch (col) {
                case 0: {
                    return bindingAt.label;
                }
                case 1: {
                    return GUIUtilities.getPlatformShortcutLabel(bindingAt.shortcut);
                }
                case 2: {
                    return GUIUtilities.getPlatformShortcutLabel(this.getBindingAt((int)row, (int)1).shortcut);
                }
                case 3: {
                    return bindingAt.actionSet;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                return;
            }
            this.getBindingAt((int)row, (int)(col - 1)).shortcut = (String)value;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return jEdit.getProperty("options.shortcuts.name");
                }
                case 1: {
                    return jEdit.getProperty("options.shortcuts.shortcut1");
                }
                case 2: {
                    return jEdit.getProperty("options.shortcuts.shortcut2");
                }
                case 3: {
                    return jEdit.getProperty("options.shortcuts.actionset");
                }
            }
            return null;
        }

        public void save() {
            for (GrabKeyDialog.KeyBinding[] binding : this.bindings) {
                ShortcutsOptionPane.this.selectedKeymap.setShortcut(binding[0].name + ".shortcut", binding[0].shortcut);
                ShortcutsOptionPane.this.selectedKeymap.setShortcut(binding[1].name + ".shortcut2", binding[1].shortcut);
            }
        }

        public GrabKeyDialog.KeyBinding getBindingAt(int row, int nr) {
            GrabKeyDialog.KeyBinding[] binding = this.bindings.get(row);
            return binding[nr];
        }

        public String toString() {
            return this.name;
        }

        private class KeyCompare
        implements Comparator<GrabKeyDialog.KeyBinding[]> {
            private final int col;

            KeyCompare(int col) {
                this.col = col;
            }

            @Override
            public int compare(GrabKeyDialog.KeyBinding[] k1, GrabKeyDialog.KeyBinding[] k2) {
                String shortcut2;
                String shortcut1;
                String label1 = k1[0].label.toLowerCase();
                String label2 = k2[0].label.toLowerCase();
                if (this.col == 0) {
                    return StandardUtilities.compareStrings(label1, label2, true);
                }
                if (this.col == 1) {
                    shortcut1 = k1[0].shortcut;
                    shortcut2 = k2[0].shortcut;
                } else {
                    shortcut1 = k1[1].shortcut;
                    shortcut2 = k2[1].shortcut;
                }
                if (shortcut1 == null && shortcut2 != null) {
                    return 1;
                }
                if (shortcut2 == null && shortcut1 != null) {
                    return -1;
                }
                if (shortcut1 == null) {
                    return StandardUtilities.compareStrings(label1, label2, true);
                }
                return StandardUtilities.compareStrings(shortcut1, shortcut2, true);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            KeymapManager manager;
            KeymapManager.State keymapState;
            int ret;
            if (evt.getSource() == ShortcutsOptionPane.this.selectModel) {
                ShortcutsModel newModel = (ShortcutsModel)ShortcutsOptionPane.this.selectModel.getSelectedItem();
                if (ShortcutsOptionPane.this.filteredModel.getDelegated() != newModel) {
                    jEdit.setIntegerProperty("options.shortcuts.select.index", ShortcutsOptionPane.this.selectModel.getSelectedIndex());
                    ShortcutsOptionPane.this.filteredModel.setDelegated(newModel);
                    ShortcutsOptionPane.this.setFilter();
                }
            } else if (evt.getSource() == ShortcutsOptionPane.this.keymaps) {
                String selectedKeymapName = (String)ShortcutsOptionPane.this.keymaps.getSelectedItem();
                KeymapManager keymapManager = jEdit.getKeymapManager();
                ShortcutsOptionPane.this.selectedKeymap = keymapManager.getKeymap(selectedKeymapName);
                ShortcutsOptionPane.this.resetButtons();
                ShortcutsOptionPane.this.reloadModels();
            } else if (evt.getSource() == ShortcutsOptionPane.this.duplicateKeymap) {
                String newName = JOptionPane.showInputDialog(ShortcutsOptionPane.this, jEdit.getProperty("options.shortcuts.duplicatekeymap.dialog.label"), jEdit.getProperty("options.shortcuts.duplicatekeymap.dialog.title"), 3);
                if (newName == null) {
                    return;
                }
                newName = newName.replace(' ', '_');
                KeymapManager manager2 = jEdit.getKeymapManager();
                Collection<String> keymapNames = manager2.getKeymapNames();
                while (keymapNames.contains(newName)) {
                    newName = JOptionPane.showInputDialog(ShortcutsOptionPane.this, jEdit.getProperty("options.shortcuts.duplicatekeymap.keymapalreadyexists.label"), jEdit.getProperty("options.shortcuts.duplicatekeymap.dialog.title"), 3);
                    if (newName == null) {
                        return;
                    }
                    newName = newName.replace(' ', '_');
                }
                if (manager2.copyKeymap(ShortcutsOptionPane.this.selectedKeymap.toString(), newName)) {
                    KeymapsModel model = (KeymapsModel)ShortcutsOptionPane.this.keymaps.getModel();
                    model.reset();
                    ShortcutsOptionPane.this.keymaps.setSelectedItem(newName);
                }
            } else if (evt.getSource() == ShortcutsOptionPane.this.resetKeymap) {
                int ret2 = JOptionPane.showConfirmDialog(ShortcutsOptionPane.this, jEdit.getProperty("options.shortcuts.resetkeymap.dialog.label"), jEdit.getProperty("options.shortcuts.resetkeymap.dialog.title"), 0, 3);
                if (ret2 == 0) {
                    String name = ShortcutsOptionPane.this.selectedKeymap.toString();
                    KeymapManager manager3 = jEdit.getKeymapManager();
                    manager3.resetKeymap(name);
                    ShortcutsOptionPane.this.selectedKeymap = manager3.getKeymap(name);
                    ShortcutsOptionPane.this.resetButtons();
                    ShortcutsOptionPane.this.reloadModels();
                }
            } else if (evt.getSource() == ShortcutsOptionPane.this.deleteKeymap && (ret = JOptionPane.showConfirmDialog(ShortcutsOptionPane.this, jEdit.getProperty("options.shortcuts.deletekeymap.dialog.label"), jEdit.getProperty("options.shortcuts.deletekeymap.dialog.title"), 0, 3)) == 0 && (keymapState = (manager = jEdit.getKeymapManager()).getKeymapState(ShortcutsOptionPane.this.selectedKeymap.toString())) == KeymapManager.State.User) {
                manager.deleteUserKeymap(ShortcutsOptionPane.this.selectedKeymap.toString());
                KeymapsModel model = (KeymapsModel)ShortcutsOptionPane.this.keymaps.getModel();
                model.reset();
            }
        }
    }

    private class TableMouseHandler
    extends MouseAdapter {
        private TableMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            GrabKeyDialog gkd;
            int row = ShortcutsOptionPane.this.keyTable.getSelectedRow();
            int col = ShortcutsOptionPane.this.keyTable.getSelectedColumn();
            if (col != 0 && row != -1 && (gkd = new GrabKeyDialog((Dialog)GenericGUIUtilities.getParentDialog(ShortcutsOptionPane.this), ((ShortcutsModel)ShortcutsOptionPane.this.filteredModel.getDelegated()).getBindingAt(ShortcutsOptionPane.this.filteredModel.getTrueRow(row), col - 1), (List<GrabKeyDialog.KeyBinding>)ShortcutsOptionPane.this.allBindings, null)).isOK()) {
                ShortcutsOptionPane.this.filteredModel.setValueAt(gkd.getShortcut(), row, col);
            }
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            ShortcutsModel shortcutsModel = (ShortcutsModel)ShortcutsOptionPane.this.filteredModel.getDelegated();
            switch (ShortcutsOptionPane.this.keyTable.getTableHeader().columnAtPoint(evt.getPoint())) {
                case 0: {
                    shortcutsModel.sort(0);
                    break;
                }
                case 1: {
                    shortcutsModel.sort(1);
                    break;
                }
                case 2: {
                    shortcutsModel.sort(2);
                }
            }
            ShortcutsOptionPane.this.setFilter();
        }
    }
}

