/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.SyntaxUtilities;

public class NumericTextField
extends JTextField
implements ComboBoxEditor {
    private final boolean positiveOnly;
    private final boolean integerOnly;
    private Number minValue;
    private Number maxValue;
    private SyntaxStyle invalidStyle;
    private Color defaultBackground;
    private Color defaultForeground;

    public NumericTextField(String text) {
        this(text, false);
    }

    public NumericTextField(String text, boolean positiveOnly) {
        super(text);
        this.positiveOnly = positiveOnly;
        this.integerOnly = true;
        this.minValue = positiveOnly ? new Integer(0) : Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        this.addFilter();
        this.loadInvalidStyle();
    }

    public NumericTextField(String text, boolean positiveOnly, boolean integerOnly) {
        super(text);
        this.positiveOnly = positiveOnly;
        this.integerOnly = integerOnly;
        if (integerOnly) {
            this.minValue = positiveOnly ? new Integer(0) : Integer.MIN_VALUE;
            this.maxValue = Integer.MAX_VALUE;
        } else {
            this.minValue = Float.valueOf(positiveOnly ? new Float(0.0).floatValue() : Float.MIN_VALUE);
            this.maxValue = Float.valueOf(Float.MAX_VALUE);
        }
        this.addFilter();
        this.loadInvalidStyle();
    }

    public NumericTextField(String text, int columns, boolean positiveOnly) {
        super(text, columns);
        this.positiveOnly = positiveOnly;
        this.integerOnly = true;
        this.minValue = positiveOnly ? new Integer(0) : Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        this.addFilter();
        this.loadInvalidStyle();
    }

    public NumericTextField(String text, int columns, boolean positiveOnly, boolean integerOnly) {
        super(text, columns);
        this.positiveOnly = positiveOnly;
        this.integerOnly = integerOnly;
        if (integerOnly) {
            this.minValue = positiveOnly ? new Integer(0) : Integer.MIN_VALUE;
            this.maxValue = Integer.MAX_VALUE;
        } else {
            this.minValue = Float.valueOf(positiveOnly ? new Float(0.0).floatValue() : Float.MIN_VALUE);
            this.maxValue = Float.valueOf(Float.MAX_VALUE);
        }
        this.addFilter();
        this.loadInvalidStyle();
    }

    private void loadInvalidStyle() {
        Font font = this.getFont();
        String family = font.getFamily();
        int size = font.getSize();
        this.invalidStyle = SyntaxUtilities.parseStyle(jEdit.getProperty("view.style.invalid"), family, size, true);
        this.defaultForeground = this.getForeground();
        this.defaultBackground = this.getBackground();
    }

    public void setMinValue(Number n) {
        int max;
        int i;
        float f;
        if (this.positiveOnly && (double)(f = n.floatValue()) < 0.0) {
            return;
        }
        if (this.integerOnly ? (i = n.intValue()) > (max = this.maxValue.intValue()) : (f = n.floatValue()) > (max = this.maxValue.floatValue())) {
            return;
        }
        this.minValue = n;
    }

    public void setMaxValue(Number n) {
        int min;
        int i;
        float f;
        if (this.positiveOnly && (f = n.floatValue()) < 0.0f) {
            return;
        }
        if (this.integerOnly ? (i = n.intValue()) < (min = this.minValue.intValue()) : (f = n.floatValue()) < (min = this.minValue.floatValue())) {
            return;
        }
        this.maxValue = n;
    }

    public Number getValue() {
        if (this.integerOnly) {
            return Integer.valueOf(this.getText());
        }
        return Float.valueOf(this.getText());
    }

    private void addFilter() {
        if (this.integerOnly) {
            ((AbstractDocument)this.getDocument()).setDocumentFilter(new IntegerDocumentFilter());
        } else {
            ((AbstractDocument)this.getDocument()).setDocumentFilter(new FloatDocumentFilter());
        }
        try {
            String text = this.getText();
            ((AbstractDocument)this.getDocument()).getDocumentFilter().replace(null, 0, text.length(), text, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public Object getItem() {
        return this.getText();
    }

    @Override
    public void setItem(Object item) {
        if (item == null) {
            this.setText("");
        } else {
            this.setText(item.toString());
        }
    }

    class FloatDocumentFilter
    extends DocumentFilter {
        FloatDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            String newString = new StringBuilder(NumericTextField.this.getText()).insert(offset, string).toString();
            if (!this.isFloat(newString)) {
                return;
            }
            NumericTextField.this.setBackground(this.inRange(newString) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(newString) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.insertString(fb, offset, string, attr);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            String newString = new StringBuilder(NumericTextField.this.getText()).delete(offset, offset + length).toString();
            NumericTextField.this.setBackground(this.inRange(newString) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(newString) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.remove(fb, offset, length);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text == null || text.length() == 0) {
                return;
            }
            String newString = new StringBuilder(NumericTextField.this.getText()).replace(offset, offset + length, text).toString();
            if (!this.isFloat(newString)) {
                return;
            }
            NumericTextField.this.setBackground(this.inRange(newString) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(newString) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.replace(fb, offset, length, text, attrs);
        }

        private boolean isFloat(String string) {
            if (string == null || string.isEmpty()) {
                return false;
            }
            try {
                if (".".equals(string)) {
                    return true;
                }
                if (!NumericTextField.this.positiveOnly && "-".equals(string)) {
                    return true;
                }
                Float.parseFloat(string);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        private boolean inRange(String string) {
            if (string == null || string.isEmpty()) {
                return false;
            }
            if (".".equals(string)) {
                return true;
            }
            float value = Float.parseFloat(string);
            boolean toReturn = value <= NumericTextField.this.maxValue.floatValue() && value >= NumericTextField.this.minValue.floatValue();
            return toReturn;
        }
    }

    class IntegerDocumentFilter
    extends DocumentFilter {
        IntegerDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            String newString = new StringBuilder(NumericTextField.this.getText()).insert(offset, string).toString();
            if (!this.isInteger(newString)) {
                return;
            }
            NumericTextField.this.setBackground(this.inRange(newString) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(newString) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.insertString(fb, offset, string, attr);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            String newString = new StringBuilder(NumericTextField.this.getText()).delete(offset, offset + length).toString();
            NumericTextField.this.setBackground(this.inRange(newString) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(newString) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.remove(fb, offset, length);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text == null || text.length() == 0) {
                return;
            }
            String newString = new StringBuilder(NumericTextField.this.getText()).replace(offset, offset + length, text).toString();
            if (!this.isInteger(newString)) {
                return;
            }
            NumericTextField.this.setBackground(this.inRange(newString) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(newString) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.replace(fb, offset, length, text, attrs);
        }

        private boolean isInteger(String string) {
            if (string == null || string.isEmpty()) {
                return false;
            }
            try {
                if (!NumericTextField.this.positiveOnly && "-".equals(string)) {
                    return true;
                }
                Integer.parseInt(string);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        private boolean inRange(String string) {
            if (string == null || string.isEmpty()) {
                return false;
            }
            int value = Integer.parseInt(string);
            return value <= NumericTextField.this.maxValue.intValue() && value >= NumericTextField.this.minValue.intValue();
        }
    }
}

