/*
 * Decompiled with CFR 0.152.
 */
package ise.plugin.nav;

import code2html.generic.GenericExporter;
import code2html.services.ExporterProvider;
import ise.plugin.nav.NavPosition;
import ise.plugin.nav.NavStack;
import ise.plugin.nav.Navigator;
import ise.plugin.nav.NavigatorPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.Selection;

class NavHistoryList
extends JPanel {
    JList list;
    private View view;
    private NavPosition initialPosition = null;
    private Navigator navigator = null;
    private Font textAreaFont = null;

    public NavHistoryList(View view, Navigator navigator, Collection<NavPosition> positions) {
        this(view, navigator, positions, null);
    }

    public NavHistoryList(View view, Navigator navigator, Collection<NavPosition> positions, NavPosition currentPosition) {
        this.navigator = navigator;
        this.view = view;
        this.initialPosition = currentPosition;
        positions = new ArrayList<NavPosition>(positions);
        Collections.reverse((List)positions);
        this.setLayout(new BorderLayout());
        if (NavigatorPlugin.groupByFile()) {
            positions = this.groupByFile(positions);
        }
        this.list = new JList<Object>(positions.toArray());
        this.list.setCellRenderer(new CellRenderer());
        this.list.setVisibleRowCount(jEdit.getIntegerProperty((String)"navigator.listSize", (int)10));
        JScrollPane scroller = new JScrollPane(this.list);
        this.add((Component)scroller, "Center");
        if (view.getEditPane().getTextArea().getPainter().getStyles() != null && view.getEditPane().getTextArea().getPainter().getStyles().length > 0) {
            this.textAreaFont = view.getEditPane().getTextArea().getPainter().getStyles()[0].getFont();
        }
        this.list.requestFocus();
        if (currentPosition != null) {
            this.list.setSelectedValue(currentPosition, true);
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.list.addKeyListener(listener);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.list.addMouseListener(listener);
    }

    public void setModel(NavStack model) {
        Collections.reverse(model);
        this.list.setModel(model);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.list != null) {
            this.list.updateUI();
        }
    }

    @Override
    public void setToolTipText(String tip) {
        this.list.setToolTipText(tip);
    }

    private Collection<NavPosition> groupByFile(Collection<NavPosition> positions) {
        ArrayList<NavPosition> items = new ArrayList<NavPosition>(positions.size());
        HashSet<String> paths = new HashSet<String>();
        for (NavPosition pos : positions) {
            if (!paths.add(pos.path)) continue;
            items.add(pos);
        }
        return items;
    }

    public void jump() {
        NavPosition item = (NavPosition)this.list.getSelectedValue();
        this.navigator.jump(item);
    }

    class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Border defaultBorder = BorderFactory.createEmptyBorder(1, 1, 6, 1);
        private Border initialPositionBorder = BorderFactory.createCompoundBorder(new LineBorder(this.getForeground()), this.defaultBorder);

        public CellRenderer() {
            this.setBorder(this.defaultBorder);
            this.setFont(NavHistoryList.this.view.getEditPane().getTextArea().getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            NavPosition pos = (NavPosition)value;
            if (pos == null) {
                return null;
            }
            String labelText = pos.plainText();
            if (jEdit.getBooleanProperty((String)"navigator.showLineText", (boolean)true)) {
                EditPane editPane = null;
                for (EditPane ep : NavHistoryList.this.view.getEditPanes()) {
                    if (ep.hashCode() != pos.editPane) continue;
                    editPane = ep;
                    break;
                }
                if (editPane == null || !jEdit.getBooleanProperty((String)"navigator.showLineTextSyntax", (boolean)true)) {
                    labelText = pos.htmlText(120);
                } else {
                    Buffer[] buffers = editPane.getBufferSet().getAllBuffers();
                    Buffer buffer = null;
                    for (Buffer b : buffers) {
                        if (!b.getPath().equals(pos.path)) continue;
                        buffer = b;
                        break;
                    }
                    if (buffer == null) {
                        labelText = pos.htmlText();
                    } else {
                        int line = pos.lineno >= buffer.getLineCount() ? buffer.getLineCount() - 1 : pos.lineno;
                        int start = buffer.getLineStartOffset(line);
                        int end = buffer.getLineEndOffset(line);
                        if (end - start > 120) {
                            end = start + 120;
                        }
                        Selection.Rect selection = new Selection.Rect(line, start, line, end);
                        Selection[] selections = new Selection[]{selection};
                        boolean usecss = jEdit.getBooleanProperty((String)"code2html.use-css", (boolean)false);
                        boolean showgutter = jEdit.getBooleanProperty((String)"code2html.show-gutter", (boolean)false);
                        int wrap = jEdit.getIntegerProperty((String)"code2html.wrap", (int)0);
                        jEdit.setBooleanProperty((String)"code2html.use-css", (boolean)false);
                        jEdit.setBooleanProperty((String)"code2html.show-gutter", (boolean)false);
                        jEdit.setIntegerProperty((String)"code2html.wrap", (int)0);
                        GenericExporter exporter = ((ExporterProvider)ServiceManager.getService((String)"code2html.services.ExporterProvider", (String)"html")).getExporter(buffer, editPane.getTextArea().getPainter().getStyles(), selections);
                        labelText = exporter.getContentString();
                        jEdit.setBooleanProperty((String)"code2html.use-css", (boolean)usecss);
                        jEdit.setBooleanProperty((String)"code2html.show-gutter", (boolean)showgutter);
                        jEdit.setIntegerProperty((String)"code2html.wrap", (int)wrap);
                        int preIndex = labelText.indexOf("<pre>");
                        if (preIndex >= 0 && (preIndex = (labelText = labelText.substring(preIndex + 5)).lastIndexOf("</pre>")) >= 0) {
                            labelText = labelText.substring(0, preIndex - 1);
                        }
                        labelText = "<font face=\"" + NavHistoryList.this.textAreaFont.getName() + "\">" + labelText + "</font>";
                        labelText = labelText.replaceAll("[ ]+", " ");
                        labelText = labelText.replaceAll("\n", "");
                        boolean showPath = jEdit.getBooleanProperty((String)"navigator.showPath", (boolean)true);
                        boolean showLineNumber = jEdit.getBooleanProperty((String)"navigator.showLineNumber", (boolean)true);
                        boolean showCaretOffset = jEdit.getBooleanProperty((String)"navigator.showCaretOffset", (boolean)true);
                        StringBuilder sb = new StringBuilder();
                        sb.append("<html><tt>");
                        sb.append(showPath ? pos.path : pos.name);
                        if (showLineNumber) {
                            sb.append(":").append(line + 1);
                        }
                        if (showCaretOffset) {
                            sb.append(":").append(pos.caret);
                        }
                        if (showPath) {
                            sb.append("<br>");
                        }
                        sb.append("</tt>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        sb.append(labelText.trim());
                        labelText = sb.toString();
                    }
                }
            }
            this.setText(labelText);
            this.setEnabled(list.isEnabled());
            this.setFont(NavHistoryList.this.view.getEditPane().getTextArea().getFont());
            this.setOpaque(true);
            this.setBackground(NavHistoryList.this.view.getBackground());
            if (jEdit.getBooleanProperty((String)"navigator.showStripes", (boolean)true) && index % 2 == 0) {
                this.setBackground(this.getBackground().darker());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            }
            this.setBorder(pos.equals(NavHistoryList.this.initialPosition) ? this.initialPositionBorder : this.defaultBorder);
            return this;
        }
    }
}

