/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.event.MouseEvent;
import javax.swing.UIManager;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;

public class MouseHandler
extends TextAreaMouseHandler {
    private JEditTextArea textArea;

    public MouseHandler(JEditTextArea textArea) {
        super(textArea);
        this.textArea = textArea;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.showCursor();
        int btn = evt.getButton();
        if (btn != 1 && btn != 2 && btn != 3) {
            return;
        }
        this.control = OperatingSystem.isMacOS() && evt.isMetaDown() || !OperatingSystem.isMacOS() && evt.isControlDown();
        this.ctrlForRectangularSelection = this.textArea.isCtrlForRectangularSelection();
        this.textArea.getInputHandler().resetLastActionCount();
        boolean bl = this.quickCopyDrag = this.textArea.isQuickCopyEnabled() && MouseHandler.isMiddleButton(evt.getModifiers());
        if (!this.quickCopyDrag) {
            this.textArea.requestFocus();
            TextArea.focusedComponent = this.textArea;
        }
        if (this.textArea.getBuffer().isLoading()) {
            return;
        }
        EditBus.send(new PositionChanging(this.textArea));
        int x = evt.getX();
        int y = evt.getY();
        this.dragStart = this.textArea.xyToOffset(x, y, !this.textArea.getPainter().isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled());
        this.dragStartLine = this.textArea.getLineOfOffset(this.dragStart);
        this.dragStartOffset = this.dragStart - this.textArea.getLineStartOffset(this.dragStartLine);
        if (MouseHandler.isPopupTrigger(evt) && this.textArea.getRightClickPopup() != null) {
            if (this.textArea.isRightClickPopupEnabled()) {
                this.textArea.handlePopupTrigger(evt);
            }
            return;
        }
        this.dragged = false;
        this.textArea.blink = true;
        this.textArea.invalidateLine(this.textArea.getCaretLine());
        this.clickCount = evt.getClickCount();
        if (this.textArea.isDragEnabled() && this.textArea.selectionManager.insideSelection(x, y) && this.clickCount == 1 && !evt.isShiftDown()) {
            this.maybeDragAndDrop = true;
            this.textArea.moveCaretPosition(this.dragStart, false);
            return;
        }
        this.maybeDragAndDrop = false;
        if (this.quickCopyDrag) {
            this.doSingleClick(evt);
        } else {
            switch (this.clickCount) {
                case 1: {
                    this.doSingleClick(evt);
                    break;
                }
                case 2: {
                    this.doDoubleClick();
                    break;
                }
                default: {
                    this.doTripleClick();
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        int btn = evt.getButton();
        if (btn != 1 && btn != 2 && btn != 3) {
            return;
        }
        Selection sel = this.textArea.getSelectionAtOffset(this.dragStart);
        if (this.dragged && sel != null) {
            Registers.setRegister('%', this.textArea.getSelectedText(sel));
            if (this.quickCopyDrag) {
                this.textArea.removeFromSelection(sel);
                Registers.paste(TextArea.focusedComponent, '%', sel instanceof Selection.Rect);
                TextArea.focusedComponent.requestFocus();
            }
        } else if (!this.dragged && this.textArea.isQuickCopyEnabled() && MouseHandler.isMiddleButton(evt.getModifiers())) {
            this.textArea.requestFocus();
            TextArea.focusedComponent = this.textArea;
            this.textArea.setCaretPosition(this.dragStart, false);
            if (!this.textArea.isEditable()) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            } else {
                Registers.paste((TextArea)this.textArea, '%', this.control);
            }
        } else if (this.maybeDragAndDrop && !this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.maybeDragAndDrop = false;
        this.dragged = false;
        if (!(this.textArea.isRectangularSelectionEnabled() || this.control && this.ctrlForRectangularSelection)) {
            this.textArea.scrollToCaret(false);
        }
    }
}

