/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.print.BufferPrintable1_7;
import org.gjt.sp.jedit.print.PrintPreviewModel;
import org.gjt.sp.jedit.print.PrinterDialog;
import org.gjt.sp.jedit.print.Range;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class BufferPrinter1_7 {
    private static PrintRequestAttributeSet format;
    private static DocPrintJob job;

    public static void pageSetup(View view) {
        BufferPrinter1_7.loadPrintSpec();
        PrinterDialog printerDialog = new PrinterDialog(view, format, true);
        if (!printerDialog.isCanceled()) {
            format = printerDialog.getAttributes();
            BufferPrinter1_7.savePrintSpec();
            EditBus.send(new PropertiesChanged(null));
        }
    }

    public static void print(final View view, Buffer buffer) {
        Attribute[] attributes;
        BufferPrinter1_7.loadPrintSpec();
        String jobName = MiscUtilities.abbreviateView(buffer.getPath());
        format.add(new JobName(jobName, null));
        PrinterDialog printerDialog = new PrinterDialog(view, format, false);
        if (printerDialog.isCanceled()) {
            return;
        }
        PrintService printService = printerDialog.getPrintService();
        if (printService != null) {
            try {
                job = printService.createPrintJob();
                job.addPrintJobListener(new JobListener(view));
                format = printerDialog.getAttributes();
                BufferPrinter1_7.savePrintSpec();
                EditBus.send(new PropertiesChanged(null));
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(view, jEdit.getProperty("print-error.message", new String[]{e.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                return;
            }
        } else {
            JOptionPane.showMessageDialog(view, jEdit.getProperty("print-error.message", new String[]{"Invalid print service."}), jEdit.getProperty("print-error.title"), 0);
            return;
        }
        BufferPrintable1_7 printable = new BufferPrintable1_7(format, view, buffer);
        printable.setReverse(printerDialog.getReverse());
        int printRangeType = printerDialog.getPrintRangeType();
        printable.setPrintRangeType(printRangeType);
        if (printRangeType == PrinterDialog.SELECTION) {
            int selectionCount = view.getTextArea().getSelectionCount();
            if (selectionCount == 0) {
                JOptionPane.showMessageDialog(view, jEdit.getProperty("print-error.message", new String[]{"No text is selected to print."}), jEdit.getProperty("print-error.title"), 0);
                return;
            }
            HashMap<Integer, Range> pageRanges = BufferPrinter1_7.getPageRanges(printable, format);
            if (pageRanges == null || pageRanges.isEmpty()) {
                JOptionPane.showMessageDialog(view, jEdit.getProperty("print-error.message", new String[]{"Unable to calculate page ranges."}), jEdit.getProperty("print-error.title"), 0);
                return;
            }
            int[] nArray = view.getTextArea().getSelectedLines();
            StringBuilder pageRange = new StringBuilder();
            block2: for (Integer i : pageRanges.keySet()) {
                Range range = pageRanges.get(i);
                for (int line : nArray) {
                    if (!range.contains(line)) continue;
                    pageRange.append(i).append(',');
                    continue block2;
                }
            }
            pageRange.deleteCharAt(pageRange.length() - 1);
            format.add(new PageRanges(pageRange.toString()));
            printable.setSelectedLines(nArray);
        }
        HashDocAttributeSet docAttributes = new HashDocAttributeSet();
        for (Attribute attribute : attributes = format.toArray()) {
            boolean isDocAttr = attribute instanceof DocAttribute;
            if (!isDocAttr) continue;
            docAttributes.add(attribute);
        }
        final SimpleDoc simpleDoc = new SimpleDoc(printable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, docAttributes);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    job.print(simpleDoc, format);
                }
                catch (PrintException e) {
                    JOptionPane.showMessageDialog(view, jEdit.getProperty("print-error.message", new String[]{e.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                }
            }
        };
        ThreadUtilities.runInBackground(runner);
    }

    protected static void printPage(PrintPreviewModel model) {
        String jobName = MiscUtilities.abbreviateView(model.getBuffer().getPath());
        model.getAttributes().add(new JobName(jobName, null));
        PrintService printService = model.getPrintService();
        if (printService == null) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        }
        if (printService != null) {
            try {
                job = printService.createPrintJob();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(model.getView(), jEdit.getProperty("print-error.message", new String[]{e.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                return;
            }
        } else {
            JOptionPane.showMessageDialog(model.getView(), jEdit.getProperty("print-error.message", new String[]{"Invalid print service."}), jEdit.getProperty("print-error.title"), 0);
            return;
        }
        BufferPrintable1_7 printable = new BufferPrintable1_7(model.getAttributes(), model.getView(), model.getBuffer());
        printable.setPages(model.getPageRanges());
        int pageNumber = model.getPageNumber();
        try {
            printable.print(model.getGraphics(), model, pageNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<Integer, Range> getPageRanges(View view, Buffer buffer, PrintRequestAttributeSet attributes) {
        if (attributes == null) {
            BufferPrinter1_7.loadPrintSpec();
            attributes = format;
        }
        BufferPrintable1_7 printable = new BufferPrintable1_7(attributes, view, buffer);
        return BufferPrinter1_7.getPageRanges(printable, attributes);
    }

    private static HashMap<Integer, Range> getPageRanges(BufferPrintable1_7 printable, PrintRequestAttributeSet attributes) {
        PageFormat pageFormat = BufferPrinter1_7.createPageFormat(attributes);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        BufferedImage image = new BufferedImage(new Double(pageFormat.getImageableWidth()).intValue(), new Double(pageFormat.getImageableHeight()).intValue(), 1);
        Graphics2D graphics = ge.createGraphics(image);
        Paper paper = pageFormat.getPaper();
        Rectangle2D.Double clipRegion = new Rectangle2D.Double(paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), paper.getImageableHeight());
        graphics.setClip(clipRegion);
        try {
            HashMap<Integer, Range> pageLineRanges = printable.calculatePages(graphics, pageFormat);
            PageRanges pr = (PageRanges)attributes.get(PageRanges.class);
            if (pr == null) {
                pr = new PageRanges(1, 1000);
            }
            HashMap<Integer, Range> newLineRanges = new HashMap<Integer, Range>();
            for (Integer i : pageLineRanges.keySet()) {
                if (!pr.contains(i)) continue;
                newLineRanges.put(i, pageLineRanges.get(i));
            }
            return pageLineRanges;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PageFormat getDefaultPageFormat(PrintRequestAttributeSet attributes) {
        return BufferPrinter1_7.createPageFormat(attributes);
    }

    private static PageFormat createPageFormat(PrintRequestAttributeSet attributes) {
        Paper paper = new Paper();
        MediaPrintableArea mpa = (MediaPrintableArea)attributes.get(MediaPrintableArea.class);
        int units = 25400;
        double dpi = 72.0;
        double x = (double)mpa.getX(units) * dpi;
        double y = (double)mpa.getY(units) * dpi;
        double w = (double)mpa.getWidth(units) * dpi;
        double h = (double)mpa.getHeight(units) * dpi;
        paper.setImageableArea(x, y, w, h);
        int orientation = 1;
        OrientationRequested or = (OrientationRequested)attributes.get(OrientationRequested.class);
        if (OrientationRequested.LANDSCAPE.equals(or) || OrientationRequested.REVERSE_LANDSCAPE.equals(or)) {
            orientation = 0;
        }
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(orientation);
        return pageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPrintSpec() {
        MediaPrintableArea mpa;
        String printSpecPath;
        File filePrintSpec;
        format = new HashPrintRequestAttributeSet();
        String settings = jEdit.getSettingsDirectory();
        if (settings != null && (filePrintSpec = new File(printSpecPath = MiscUtilities.constructPath(settings, "printspec"))).exists()) {
            ObjectInputStream obIn = null;
            try {
                FileInputStream fileIn = new FileInputStream(filePrintSpec);
                obIn = new ObjectInputStream(fileIn);
                format = (HashPrintRequestAttributeSet)obIn.readObject();
            }
            catch (Exception e) {
                Log.log(9, BufferPrinter1_7.class, e);
            }
            finally {
                try {
                    if (obIn != null) {
                        obIn.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((mpa = (MediaPrintableArea)format.get(MediaPrintableArea.class)) == null) {
            mpa = new MediaPrintableArea(0.5f, 0.5f, 10.0f, 7.5f, 25400);
            format.add(mpa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePrintSpec() {
        String settings = jEdit.getSettingsDirectory();
        if (settings == null) {
            return;
        }
        String printSpecPath = MiscUtilities.constructPath(settings, "printspec");
        File filePrintSpec = new File(printSpecPath);
        ObjectOutputStream objectOut = null;
        try {
            FileOutputStream fileOut = new FileOutputStream(filePrintSpec);
            objectOut = new ObjectOutputStream(fileOut);
            objectOut.writeObject(format);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (objectOut != null) {
                try {
                    objectOut.flush();
                }
                catch (IOException iOException) {}
                try {
                    objectOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class JobListener
    extends PrintJobAdapter {
        private View view;

        public JobListener(View view) {
            this.view = view;
        }

        @Override
        public void printJobCompleted(PrintJobEvent pje) {
            PrintService printService = pje.getPrintJob().getPrintService();
            if (printService instanceof StreamPrintService) {
                StreamPrintService streamService = (StreamPrintService)printService;
                OutputStream outputStream = streamService.getOutputStream();
                try {
                    outputStream.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.view.getStatus().setMessageAndClear("Printing complete.");
        }

        @Override
        public void printJobFailed(PrintJobEvent pje) {
            JOptionPane.showMessageDialog(this.view, jEdit.getProperty("print-error.message", new String[]{"Print job failed."}), jEdit.getProperty("print-error.title"), 0);
        }

        @Override
        public void printJobRequiresAttention(PrintJobEvent pje) {
            JOptionPane.showMessageDialog(this.view, jEdit.getProperty("print-error.message", new String[]{"Check the printer."}), jEdit.getProperty("print-error.title"), 0);
        }
    }
}

