/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.PageRanges;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.print.PrintPreviewModel;
import org.gjt.sp.jedit.print.PrinterDialog;
import org.gjt.sp.jedit.print.Range;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DisplayTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SyntaxUtilities;

class BufferPrintable1_7
implements Printable {
    private static Color headerColor = Color.lightGray;
    private static Color headerTextColor = Color.black;
    private static Color footerColor = Color.lightGray;
    private static Color footerTextColor = Color.black;
    private static Color lineNumberColor = Color.gray;
    private static Color textColor = Color.black;
    private PrintRequestAttributeSet attributes;
    private boolean firstCall;
    private View view;
    private Buffer buffer;
    private boolean selection;
    private int[] selectedLines;
    private boolean reverse;
    private int printRangeType = PrinterDialog.ALL;
    private Font font;
    private SyntaxStyle[] styles;
    private boolean header;
    private boolean footer;
    private boolean lineNumbers;
    private HashMap<Integer, Range> pages = null;
    private int currentPhysicalLine;
    private LineMetrics lm;
    private final List<Chunk> lineList;
    private FontRenderContext frc;
    private DisplayTokenHandler tokenHandler;

    BufferPrintable1_7(PrintRequestAttributeSet attributes, View view, Buffer buffer) {
        this.attributes = attributes;
        this.view = view;
        this.buffer = buffer;
        this.firstCall = true;
        this.header = jEdit.getBooleanProperty("print.header");
        this.footer = jEdit.getBooleanProperty("print.footer");
        this.lineNumbers = jEdit.getBooleanProperty("print.lineNumbers");
        this.font = jEdit.getFontProperty("print.font");
        boolean color = Chromaticity.COLOR.equals(attributes.get(Chromaticity.class));
        this.styles = SyntaxUtilities.loadStyles(jEdit.getProperty("print.font"), jEdit.getIntegerProperty("print.fontsize", 10), color);
        this.styles[0] = new SyntaxStyle(textColor, null, this.font);
        for (int i = 0; i < this.styles.length; ++i) {
            SyntaxStyle s = this.styles[i];
            if (!s.getForegroundColor().equals(Color.WHITE) || s.getBackgroundColor() != null) continue;
            this.styles[i] = new SyntaxStyle(Color.BLACK, s.getBackgroundColor(), s.getFont());
        }
        this.lineList = new ArrayList<Chunk>();
        this.tokenHandler = new DisplayTokenHandler();
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    public void setSelectedLines(int[] lines) {
        this.selectedLines = Arrays.copyOf(lines, lines.length);
        Arrays.sort(this.selectedLines);
    }

    public void setReverse(boolean b) {
        this.reverse = b;
    }

    public void setPrintRangeType(int printRangeType) {
        this.printRangeType = printRangeType;
        this.selection = PrinterDialog.SELECTION == printRangeType;
    }

    public void setPages(HashMap<Integer, Range> pages) {
        this.pages = pages;
    }

    @Override
    public int print(Graphics _gfx, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Range range;
        ++pageIndex;
        if (this.firstCall && this.pages == null) {
            this.pages = this.calculatePages(_gfx, pageFormat);
            if (this.pages == null || this.pages.isEmpty()) {
                throw new PrinterException("Unable to determine page ranges.");
            }
            this.firstCall = false;
        }
        if (this.printRangeType == PrinterDialog.CURRENT_PAGE) {
            int caretLine = this.view.getTextArea().getCaretLine();
            for (Integer i : this.pages.keySet()) {
                Range range2 = this.pages.get(i);
                if (!range2.contains(caretLine)) continue;
                pageIndex = i;
                break;
            }
        }
        if (this.reverse && this.printRangeType != PrinterDialog.CURRENT_PAGE) {
            pageIndex = this.pages.size() - 1 - pageIndex;
        }
        if (!((range = this.pages.get(pageIndex)) != null && this.inRange(pageIndex) || this.printRangeType == PrinterDialog.CURRENT_PAGE)) {
            return 1;
        }
        this.printPage(_gfx, pageFormat, pageIndex, true);
        return 0;
    }

    protected HashMap<Integer, Range> calculatePages(Graphics _gfx, PageFormat pageFormat) throws PrinterException {
        this.pages = new HashMap();
        String largeFileMode = this.buffer.getStringProperty("largefilemode");
        if (!"full".equals(largeFileMode)) {
            int largeBufferSize = jEdit.getIntegerProperty("largeBufferSize", 4000000);
            if (this.buffer.getLength() > largeBufferSize) {
                throw new PrinterException("Buffer is too large to print.");
            }
        }
        if (_gfx == null) {
            return this.pages;
        }
        Graphics2D gfx = (Graphics2D)_gfx;
        gfx.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.view.getTextArea().getPainter().getAntiAlias().renderHint());
        boolean useFractionalFontMetrics = jEdit.getBooleanProperty("view.fracFontMetrics");
        gfx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, useFractionalFontMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        gfx.setFont(this.font);
        gfx.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        this.frc = gfx.getFontRenderContext();
        double pageX = pageFormat.getImageableX();
        double pageY = pageFormat.getImageableY();
        double pageWidth = pageFormat.getImageableWidth();
        double pageHeight = pageFormat.getImageableHeight();
        if (this.header) {
            double headerHeight = this.paintHeader(gfx, pageX, pageY, pageWidth, false);
            pageY += headerHeight;
            pageHeight -= headerHeight;
        }
        if (this.footer) {
            double footerHeight = this.paintFooter(gfx, pageX, pageY, pageWidth, pageHeight, 0, false);
            pageHeight -= footerHeight;
        }
        double lineNumberWidth = 0.0;
        if (this.lineNumbers) {
            String lineNumberDigits = String.valueOf(this.buffer.getLineCount());
            StringBuilder digits = new StringBuilder();
            for (int i = 0; i < lineNumberDigits.length(); ++i) {
                digits.append('0');
            }
            lineNumberWidth = this.font.getStringBounds(digits.toString(), this.frc).getWidth();
        }
        int tabSize = jEdit.getIntegerProperty("print.tabSize", 4);
        StringBuilder tabs = new StringBuilder();
        char[] chars = new char[tabSize];
        for (int i = 0; i < tabSize; ++i) {
            tabs.append(' ');
        }
        double tabWidth = this.font.getStringBounds(tabs.toString(), this.frc).getWidth();
        PrintTabExpander tabExpander = new PrintTabExpander(tabWidth);
        this.lm = this.font.getLineMetrics("gGyYX", this.frc);
        float lineHeight = this.lm.getHeight();
        boolean printFolds = jEdit.getBooleanProperty("print.folds", true);
        this.currentPhysicalLine = 0;
        int pageCount = 1;
        int startLine = 0;
        double y = 0.0;
        int longLineLimit = jEdit.getIntegerProperty("longLineLimit", 4000);
        int bufferLineCount = this.buffer.getLineCount();
        while (this.currentPhysicalLine <= bufferLineCount) {
            if (this.currentPhysicalLine < bufferLineCount && this.buffer.getLineLength(this.currentPhysicalLine) > longLineLimit) {
                throw new PrinterException("Line " + (this.currentPhysicalLine + 1) + " is too long to print.");
            }
            if (this.currentPhysicalLine == bufferLineCount) {
                Range range = new Range(startLine, this.currentPhysicalLine);
                this.pages.put(new Integer(pageCount), range);
                Log.log(1, this, "calculatePages, page " + pageCount + " has " + range);
                break;
            }
            if (!printFolds && !this.view.getTextArea().getDisplayManager().isLineVisible(this.currentPhysicalLine)) {
                ++this.currentPhysicalLine;
                continue;
            }
            this.lineList.clear();
            this.tokenHandler.init(this.styles, this.frc, tabExpander, this.lineList, (float)(pageWidth - lineNumberWidth), 0);
            this.buffer.markTokens(this.currentPhysicalLine, this.tokenHandler);
            int n = this.lineList.isEmpty() ? 1 : this.lineList.size();
            if (y + (double)(lineHeight * (float)n) > pageHeight) {
                Range range = new Range(startLine, Math.max(0, this.currentPhysicalLine - 1));
                this.pages.put(new Integer(pageCount), range);
                Log.log(1, this, "calculatePages, page " + pageCount + " has " + range);
                ++pageCount;
                startLine = this.currentPhysicalLine;
                y = 0.0;
                continue;
            }
            for (int i = 0; i < (this.lineList.isEmpty() ? 1 : this.lineList.size()); ++i) {
                y += (double)lineHeight;
            }
            ++this.currentPhysicalLine;
        }
        return this.pages;
    }

    private boolean inRange(int pageNumber) {
        PageRanges ranges = (PageRanges)this.attributes.get(PageRanges.class);
        boolean answer = false;
        answer = ranges == null ? true : ranges.contains(pageNumber);
        return answer;
    }

    private void printPage(Graphics _gfx, PageFormat pageFormat, int pageIndex, boolean actuallyPaint) {
        int i;
        Graphics2D gfx = (Graphics2D)_gfx;
        float zoomLevel = 1.0f;
        if (pageFormat instanceof PrintPreviewModel) {
            PrintPreviewModel model = (PrintPreviewModel)pageFormat;
            zoomLevel = model.getZoomLevel();
            this.font = this.font.deriveFont((float)this.font.getSize() * zoomLevel);
            gfx.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.view.getTextArea().getPainter().getAntiAlias().renderHint());
            boolean useFractionalFontMetrics = jEdit.getBooleanProperty("view.fracFontMetrics");
            gfx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, useFractionalFontMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            gfx.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
            for (int i2 = 0; i2 < this.styles.length; ++i2) {
                SyntaxStyle s = this.styles[i2];
                this.styles[i2] = new SyntaxStyle(s.getForegroundColor(), s.getBackgroundColor(), this.font);
            }
        }
        gfx.setFont(this.font);
        if (this.frc == null) {
            this.frc = gfx.getFontRenderContext();
        }
        double pageX = pageFormat.getImageableX();
        double pageY = pageFormat.getImageableY();
        double pageWidth = pageFormat.getImageableWidth();
        double pageHeight = pageFormat.getImageableHeight();
        if (this.header) {
            double headerHeight = this.paintHeader(gfx, pageX, pageY, pageWidth, actuallyPaint);
            pageY += headerHeight;
            pageHeight -= headerHeight;
        }
        if (this.footer) {
            double footerHeight = this.paintFooter(gfx, pageX, pageY, pageWidth, pageHeight, pageIndex, actuallyPaint);
            pageHeight -= footerHeight;
        }
        double lineNumberWidth = 0.0;
        if (this.lineNumbers) {
            String lineNumberDigits = String.valueOf(this.buffer.getLineCount());
            StringBuilder digits = new StringBuilder();
            for (i = 0; i < lineNumberDigits.length(); ++i) {
                digits.append('0');
            }
            lineNumberWidth = this.font.getStringBounds(digits.toString(), this.frc).getWidth();
        }
        int tabSize = jEdit.getIntegerProperty("print.tabSize", 4);
        StringBuilder tabs = new StringBuilder();
        for (i = 0; i < tabSize; ++i) {
            tabs.append(' ');
        }
        double tabWidth = this.font.getStringBounds(tabs.toString(), this.frc).getWidth();
        PrintTabExpander tabExpander = new PrintTabExpander(tabWidth);
        this.lm = this.font.getLineMetrics("gGyYX", this.frc);
        float lineHeight = this.lm.getHeight();
        double y = 0.0;
        Range range = this.pages.get(pageIndex);
        this.currentPhysicalLine = range.getStart();
        while (this.currentPhysicalLine <= range.getEnd() && this.currentPhysicalLine != this.buffer.getLineCount()) {
            if (!(!jEdit.getBooleanProperty("print.folds", true) && !this.view.getTextArea().getDisplayManager().isLineVisible(this.currentPhysicalLine) || this.selection && Arrays.binarySearch(this.selectedLines, this.currentPhysicalLine) < 0)) {
                this.lineList.clear();
                this.tokenHandler.init(this.styles, this.frc, tabExpander, this.lineList, (float)(pageWidth - lineNumberWidth), -1);
                this.buffer.markTokens(this.currentPhysicalLine, this.tokenHandler);
                if (this.lineNumbers && actuallyPaint) {
                    gfx.setFont(this.font);
                    gfx.setColor(lineNumberColor);
                    gfx.drawString(String.valueOf(this.currentPhysicalLine + 1), (float)pageX, (float)(pageY + y + (double)lineHeight));
                }
                if (this.lineList.isEmpty()) {
                    y += (double)lineHeight;
                } else {
                    for (Chunk chunk : this.lineList) {
                        y += (double)lineHeight;
                        Chunk chunks = chunk;
                        if (chunks == null || !actuallyPaint) continue;
                        Chunk.paintChunkBackgrounds(chunks, gfx, (float)(pageX + lineNumberWidth), (float)(pageY + y), lineHeight);
                        Chunk.paintChunkList(chunks, gfx, (float)(pageX + lineNumberWidth), (float)(pageY + y), true);
                    }
                }
                if (this.currentPhysicalLine == range.getEnd()) break;
            }
            ++this.currentPhysicalLine;
        }
    }

    private double paintHeader(Graphics2D gfx, double pageX, double pageY, double pageWidth, boolean actuallyPaint) {
        String headerText = jEdit.getProperty("print.headerText", new String[]{this.buffer.getName()});
        FontRenderContext frc = gfx.getFontRenderContext();
        this.lm = this.font.getLineMetrics(headerText, frc);
        Rectangle2D bounds = this.font.getStringBounds(headerText, frc);
        Rectangle2D.Double headerBounds = new Rectangle2D.Double(pageX, pageY, pageWidth, bounds.getHeight());
        if (actuallyPaint) {
            gfx.setColor(headerColor);
            gfx.fill(headerBounds);
            gfx.setColor(headerTextColor);
            gfx.drawString(headerText, (float)(pageX + (pageWidth - bounds.getWidth()) / 2.0), (float)(pageY + (double)this.lm.getAscent()));
        }
        return ((RectangularShape)headerBounds).getHeight();
    }

    private double paintFooter(Graphics2D gfx, double pageX, double pageY, double pageWidth, double pageHeight, int pageIndex, boolean actuallyPaint) {
        String footerText = jEdit.getProperty("print.footerText", new Object[]{new Date(), pageIndex});
        FontRenderContext frc = gfx.getFontRenderContext();
        this.lm = this.font.getLineMetrics(footerText, frc);
        Rectangle2D bounds = this.font.getStringBounds(footerText, frc);
        Rectangle2D.Double footerBounds = new Rectangle2D.Double(pageX, pageY + pageHeight - bounds.getHeight(), pageWidth, bounds.getHeight());
        if (actuallyPaint) {
            gfx.setColor(footerColor);
            gfx.fill(footerBounds);
            gfx.setColor(footerTextColor);
            gfx.drawString(footerText, (float)(pageX + (pageWidth - bounds.getWidth()) / 2.0), (float)(pageY + pageHeight - bounds.getHeight() + (double)this.lm.getAscent()));
        }
        return ((RectangularShape)footerBounds).getHeight();
    }

    static class PrintTabExpander
    implements TabExpander {
        private double tabWidth;

        PrintTabExpander(double tabWidth) {
            this.tabWidth = tabWidth;
        }

        @Override
        public float nextTabStop(float x, int tabOffset) {
            int ntabs = (int)((double)(x + 1.0f) / this.tabWidth);
            return (float)((double)(ntabs + 1) * this.tabWidth);
        }
    }
}

