/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class ModeSettingsPane
extends AbstractOptionPane {
    private ModeProperties global;
    private ModeProperties[] modeProps;
    private ModeProperties current;
    private Box captionBox;
    private JComboBox<String> mode;
    private JCheckBox useDefaults;
    private JTextField filenameGlob;
    private JTextField firstlineGlob;
    private JTextField noWordSep;
    private JCheckBox camelCasedWords;
    private JComboBox<String> folding;
    private JTextField collapseFolds;
    private JComboBox<String> wrap;
    private JComboBox<String> maxLineLen;
    private JComboBox<String> tabSize;
    private JComboBox<String> indentSize;
    private JCheckBox noTabs;
    private JCheckBox elasticTabstops;
    private JComboBox<String> autoIndent;
    private JCheckBox deepIndent;
    private String[] modeNames;

    public ModeSettingsPane() {
        super("modesettings");
    }

    @Override
    protected void _init() {
        Mode[] modes = this.reloadModes();
        this.mode = new JComboBox<String>(this.modeNames);
        this.mode.addActionListener(new ActionHandler());
        this.captionBox = new Box(0);
        this.addComponent(this.captionBox);
        this.addComponent(jEdit.getProperty("options.editing.mode"), this.mode);
        this.useDefaults = new JCheckBox(jEdit.getProperty("options.editing.useDefaults"));
        this.useDefaults.addActionListener(new ActionHandler());
        this.addComponent(this.useDefaults);
        this.noWordSep = new JTextField();
        this.addComponent(jEdit.getProperty("options.editing.noWordSep"), (Component)this.noWordSep);
        this.camelCasedWords = new JCheckBox(jEdit.getProperty("options.editing.camelCasedWords"));
        this.addComponent(this.camelCasedWords);
        String[] foldModes = FoldHandler.getFoldModes();
        this.folding = new JComboBox<String>(foldModes);
        this.addComponent(jEdit.getProperty("options.editing.folding"), this.folding);
        this.collapseFolds = new JTextField();
        this.addComponent(jEdit.getProperty("options.editing.collapseFolds"), (Component)this.collapseFolds);
        String[] wrapModes = new String[]{"none", "soft", "hard"};
        this.wrap = new JComboBox<String>(wrapModes);
        this.addComponent(jEdit.getProperty("options.editing.wrap"), this.wrap);
        String[] lineLens = new String[]{"0", "72", "76", "80"};
        this.maxLineLen = new JComboBox<String>(lineLens);
        this.maxLineLen.setToolTipText(jEdit.getProperty("options.editing.maxLineLen.tooltip"));
        this.addComponent(jEdit.getProperty("options.editing.maxLineLen"), this.maxLineLen);
        this.maxLineLen.setEditable(true);
        String[] indentModes = new String[]{"none", "simple", "full"};
        this.autoIndent = new JComboBox<String>(indentModes);
        this.addComponent(jEdit.getProperty("options.editing.autoIndent"), this.autoIndent);
        String[] tabSizes = new String[]{"2", "4", "8"};
        this.tabSize = new JComboBox<String>(tabSizes);
        this.addComponent(jEdit.getProperty("options.editing.tabSize"), this.tabSize);
        this.tabSize.setEditable(true);
        this.indentSize = new JComboBox<String>(tabSizes);
        this.addComponent(jEdit.getProperty("options.editing.indentSize"), this.indentSize);
        this.indentSize.setEditable(true);
        this.noTabs = new JCheckBox(jEdit.getProperty("options.editing.noTabs"));
        this.addComponent(this.noTabs);
        this.elasticTabstops = new JCheckBox(jEdit.getProperty("options.editing.elasticTabstops"));
        this.addComponent(this.elasticTabstops);
        this.elasticTabstops.setToolTipText(jEdit.getProperty("options.editing.elasticTabstops.tooltip"));
        this.deepIndent = new JCheckBox(jEdit.getProperty("options.editing.deepIndent"));
        this.addComponent(this.deepIndent);
        this.filenameGlob = new JTextField();
        this.filenameGlob.setToolTipText(jEdit.getProperty("glob.tooltip"));
        this.addComponent(jEdit.getProperty("options.editing.filenameGlob"), (Component)this.filenameGlob);
        this.firstlineGlob = new JTextField();
        this.addComponent(jEdit.getProperty("options.editing.firstlineGlob"), (Component)this.firstlineGlob);
        this.selectMode();
    }

    private Mode[] reloadModes() {
        Mode[] modes = jEdit.getModes();
        Arrays.sort(modes, new StandardUtilities.StringCompare(true));
        this.global = new ModeProperties();
        this.modeProps = new ModeProperties[modes.length];
        this.modeNames = new String[modes.length + 1];
        this.modeNames[0] = jEdit.getProperty("options.editing.global");
        for (int i = 0; i < modes.length; ++i) {
            this.modeProps[i] = new ModeProperties(modes[i]);
            this.modeNames[i + 1] = modes[i].getName();
        }
        return modes;
    }

    @Override
    protected void _save() {
        this.saveMode();
        this.global.save();
        for (ModeProperties modeProp : this.modeProps) {
            modeProp.save();
        }
    }

    private void saveMode() {
        this.current.useDefaults = this.useDefaults.isSelected();
        this.current.filenameGlob = this.filenameGlob.getText();
        this.current.firstlineGlob = this.firstlineGlob.getText();
        this.current.noWordSep = this.noWordSep.getText();
        this.current.camelCasedWords = this.camelCasedWords.isSelected();
        this.current.folding = (String)this.folding.getSelectedItem();
        this.current.collapseFolds = this.collapseFolds.getText();
        this.current.wrap = (String)this.wrap.getSelectedItem();
        this.current.maxLineLen = (String)this.maxLineLen.getSelectedItem();
        this.current.tabSize = (String)this.tabSize.getSelectedItem();
        this.current.indentSize = (String)this.indentSize.getSelectedItem();
        this.current.noTabs = this.noTabs.isSelected();
        this.current.elasticTabstops = this.elasticTabstops.isSelected();
        this.current.autoIndent = (String)this.autoIndent.getSelectedItem();
        this.current.deepIndent = this.deepIndent.isSelected();
    }

    private void selectMode() {
        int index = this.mode.getSelectedIndex() < 0 ? 0 : this.mode.getSelectedIndex();
        this.current = index == 0 ? this.global : this.modeProps[index - 1];
        this.current.edited = true;
        this.current.load();
        this.captionBox.removeAll();
        this.captionBox.add(GUIUtilities.createMultilineLabel(jEdit.getProperty("options.editing.caption-" + (index == 0 ? "0" : "1"))));
        this.useDefaults.setSelected(this.current.useDefaults);
        this.filenameGlob.setText(this.current.filenameGlob);
        this.firstlineGlob.setText(this.current.firstlineGlob);
        this.noWordSep.setText(this.current.noWordSep);
        this.camelCasedWords.setSelected(this.current.camelCasedWords);
        this.folding.setSelectedItem(this.current.folding);
        this.collapseFolds.setText(this.current.collapseFolds);
        this.wrap.setSelectedItem(this.current.wrap);
        this.maxLineLen.setSelectedItem(this.current.maxLineLen);
        this.tabSize.setSelectedItem(this.current.tabSize);
        this.indentSize.setSelectedItem(this.current.indentSize);
        this.noTabs.setSelected(this.current.noTabs);
        this.elasticTabstops.setSelected(this.current.elasticTabstops);
        this.autoIndent.setSelectedItem(this.current.autoIndent);
        this.deepIndent.setSelected(this.current.deepIndent);
        this.updateEnabled();
        this.revalidate();
    }

    private void updateEnabled() {
        boolean enabled;
        if (this.current == this.global) {
            enabled = true;
            this.useDefaults.setEnabled(false);
            this.filenameGlob.setEnabled(false);
            this.firstlineGlob.setEnabled(false);
        } else {
            enabled = !this.modeProps[this.mode.getSelectedIndex() - 1].useDefaults;
            this.useDefaults.setEnabled(true);
            this.filenameGlob.setEnabled(enabled);
            this.firstlineGlob.setEnabled(enabled);
        }
        this.noWordSep.setEnabled(enabled);
        this.camelCasedWords.setEnabled(enabled);
        this.folding.setEnabled(enabled);
        this.collapseFolds.setEnabled(enabled);
        this.wrap.setEnabled(enabled);
        this.maxLineLen.setEnabled(enabled);
        this.tabSize.setEnabled(enabled);
        this.indentSize.setEnabled(enabled);
        this.noTabs.setEnabled(enabled);
        this.elasticTabstops.setEnabled(enabled);
        this.autoIndent.setEnabled(enabled);
        this.deepIndent.setEnabled(enabled);
    }

    private static class ModeProperties {
        Mode mode;
        boolean edited;
        boolean loaded;
        boolean useDefaults;
        String filenameGlob;
        String firstlineGlob;
        String noWordSep;
        boolean camelCasedWords;
        String folding;
        String collapseFolds;
        String wrap;
        String maxLineLen;
        String tabSize;
        String indentSize;
        boolean noTabs;
        boolean elasticTabstops;
        String autoIndent;
        boolean deepIndent;
        boolean isUserMode;

        ModeProperties() {
        }

        ModeProperties(Mode mode) {
            this.mode = mode;
        }

        void load() {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            if (this.mode != null) {
                this.mode.loadIfNecessary();
                this.useDefaults = !jEdit.getBooleanProperty("mode." + this.mode.getName() + ".customSettings");
                this.filenameGlob = (String)this.mode.getProperty("filenameGlob");
                this.firstlineGlob = (String)this.mode.getProperty("firstlineGlob");
                this.noWordSep = (String)this.mode.getProperty("noWordSep");
                this.camelCasedWords = this.mode.getBooleanProperty("camelCasedWords");
                this.folding = this.mode.getProperty("folding").toString();
                this.collapseFolds = this.mode.getProperty("collapseFolds").toString();
                this.wrap = this.mode.getProperty("wrap").toString();
                this.maxLineLen = this.mode.getProperty("maxLineLen").toString();
                this.tabSize = this.mode.getProperty("tabSize").toString();
                this.indentSize = this.mode.getProperty("indentSize").toString();
                this.noTabs = this.mode.getBooleanProperty("noTabs");
                this.elasticTabstops = this.mode.getBooleanProperty("elasticTabstops");
                this.autoIndent = this.mode.getProperty("autoIndent").toString();
                this.deepIndent = this.mode.getBooleanProperty("deepIndent");
                this.isUserMode = this.mode.isUserMode();
            } else {
                this.noWordSep = jEdit.getProperty("buffer.noWordSep");
                this.camelCasedWords = jEdit.getBooleanProperty("buffer.camelCasedWords");
                this.folding = jEdit.getProperty("buffer.folding");
                this.collapseFolds = jEdit.getProperty("buffer.collapseFolds");
                this.wrap = jEdit.getProperty("buffer.wrap");
                this.maxLineLen = jEdit.getProperty("buffer.maxLineLen");
                this.tabSize = jEdit.getProperty("buffer.tabSize");
                this.indentSize = jEdit.getProperty("buffer.indentSize");
                this.noTabs = jEdit.getBooleanProperty("buffer.noTabs");
                this.elasticTabstops = jEdit.getBooleanProperty("buffer.elasticTabstops");
                this.autoIndent = jEdit.getProperty("buffer.autoIndent");
                this.deepIndent = jEdit.getBooleanProperty("buffer.deepIndent");
            }
        }

        void save() {
            String prefix;
            if (!this.edited) {
                return;
            }
            if (this.mode != null) {
                prefix = "mode." + this.mode.getName() + '.';
                jEdit.setBooleanProperty(prefix + "customSettings", !this.useDefaults);
                String oldFilenameGlob = (String)this.mode.getProperty("filenameGlob");
                String oldFirstlineGlob = (String)this.mode.getProperty("firstlineGlob");
                if (this.useDefaults) {
                    jEdit.resetProperty(prefix + "filenameGlob");
                    jEdit.resetProperty(prefix + "firstlineGlob");
                    jEdit.resetProperty(prefix + "noWordSep");
                    jEdit.resetProperty(prefix + "camelCasedWords");
                    jEdit.resetProperty(prefix + "folding");
                    jEdit.resetProperty(prefix + "collapseFolds");
                    jEdit.resetProperty(prefix + "wrap");
                    jEdit.resetProperty(prefix + "maxLineLen");
                    jEdit.resetProperty(prefix + "tabSize");
                    jEdit.resetProperty(prefix + "indentSize");
                    jEdit.resetProperty(prefix + "noTabs");
                    jEdit.resetProperty(prefix + "elasticTabstops");
                    jEdit.resetProperty(prefix + "autoIndent");
                    jEdit.resetProperty(prefix + "deepIndent");
                    if (!Objects.equals(oldFilenameGlob, this.mode.getProperty("filenameGlob")) || !Objects.equals(oldFirstlineGlob, this.mode.getProperty("firstlineGlob"))) {
                        this.mode.init();
                    }
                    return;
                }
                jEdit.setProperty(prefix + "filenameGlob", this.filenameGlob);
                jEdit.setProperty(prefix + "firstlineGlob", this.firstlineGlob);
                if (!Objects.equals(oldFilenameGlob, this.filenameGlob) || !Objects.equals(oldFirstlineGlob, this.firstlineGlob)) {
                    this.mode.init();
                }
            } else {
                prefix = "buffer.";
            }
            jEdit.setProperty(prefix + "noWordSep", this.noWordSep);
            jEdit.setBooleanProperty(prefix + "camelCasedWords", this.camelCasedWords);
            jEdit.setProperty(prefix + "folding", this.folding);
            jEdit.setProperty(prefix + "collapseFolds", this.collapseFolds);
            jEdit.setProperty(prefix + "wrap", this.wrap);
            jEdit.setProperty(prefix + "maxLineLen", this.maxLineLen);
            jEdit.setProperty(prefix + "tabSize", this.tabSize);
            jEdit.setProperty(prefix + "indentSize", this.indentSize);
            jEdit.setProperty(prefix + "autoIndent", this.autoIndent);
            jEdit.setBooleanProperty(prefix + "noTabs", this.noTabs);
            jEdit.setBooleanProperty(prefix + "elasticTabstops", this.elasticTabstops);
            jEdit.setBooleanProperty(prefix + "deepIndent", this.deepIndent);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == ModeSettingsPane.this.mode) {
                ModeSettingsPane.this.saveMode();
                ModeSettingsPane.this.selectMode();
            } else if (source == ModeSettingsPane.this.useDefaults) {
                ((ModeSettingsPane)ModeSettingsPane.this).modeProps[((ModeSettingsPane)ModeSettingsPane.this).mode.getSelectedIndex() - 1].useDefaults = ModeSettingsPane.this.useDefaults.isSelected();
                ModeSettingsPane.this.updateEnabled();
            }
        }
    }
}

