/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.swing.Icon;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class VFSFile
implements Serializable {
    public static final int FILE = 0;
    public static final int DIRECTORY = 1;
    public static final int FILESYSTEM = 2;
    private String name;
    private String path;
    private String symlinkPath;
    private String deletePath;
    private int type;
    private long length;
    private boolean hidden;
    private boolean canRead;
    private boolean canWrite;
    protected boolean colorCalculated;
    protected Color color;
    private boolean fetchedAttrs;

    public static int findCompletion(VFSFile[] files, int start, int end, String str, boolean dirsOnly) {
        boolean strIsAbsolute = MiscUtilities.isAbsolutePath(str);
        int strLen = str.length();
        int iPotentialMatch = -1;
        boolean potentialMatchGTStr = false;
        for (int i = start; i < end; ++i) {
            String matchAgainst;
            VFSFile file = files[i];
            String string = matchAgainst = strIsAbsolute ? file.getPath() : file.getName();
            if (dirsOnly && file.getType() == 0) continue;
            if (matchAgainst.equals(str)) {
                return i;
            }
            if (!matchAgainst.regionMatches(true, 0, str, 0, strLen) || iPotentialMatch != -1 && (!potentialMatchGTStr || matchAgainst.length() != strLen)) continue;
            iPotentialMatch = i;
            potentialMatchGTStr = matchAgainst.length() > strLen;
        }
        return iPotentialMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findCompletion(String path, String complete, VFSBrowser browser, boolean dirsOnly) {
        VFS vfs;
        Log.log(1, VFSFile.class, "findCompletion(" + path + ',' + complete + ',' + dirsOnly + ')');
        if (complete.equals("~")) {
            return System.getProperty("user.home");
        }
        if (complete.equals("-")) {
            return browser.getView().getBuffer().getDirectory();
        }
        if (complete.equals("..")) {
            return MiscUtilities.getParentOfPath(path);
        }
        if (MiscUtilities.isAbsolutePath(complete)) {
            if (MiscUtilities.isURL(complete)) {
                return complete;
            }
            path = "roots:";
        }
        if (((vfs = VFSManager.getVFSForPath(path)).getCapabilities() & 0x40) == 0) {
            return null;
        }
        Object session = vfs.createVFSSession(path, browser);
        if (session == null) {
            return null;
        }
        try {
            VFSFile[] files = vfs._listFiles(session, path, browser);
            int index = VFSFile.findCompletion(files, 0, files.length, complete, dirsOnly);
            if (index != -1) {
                String string = files[index].path;
                return string;
            }
        }
        catch (IOException e) {
            VFSManager.error(e, path, browser);
        }
        finally {
            try {
                vfs._endVFSSession(session, browser);
            }
            catch (IOException e) {
                VFSManager.error(e, path, browser);
            }
        }
        return null;
    }

    public final Icon getIcon(boolean expanded) {
        return this.getIcon(expanded, jEdit._getBuffer(this.getSymlinkPath()) != null);
    }

    public Icon getIcon(boolean expanded, boolean openBuffer) {
        return this.getDefaultIcon(expanded, openBuffer);
    }

    public final Icon getDefaultIcon(boolean expanded, boolean openBuffer) {
        if (this.getType() == 1) {
            return expanded ? FileCellRenderer.openDirIcon : FileCellRenderer.dirIcon;
        }
        if (this.getType() == 2) {
            return FileCellRenderer.filesystemIcon;
        }
        if (openBuffer) {
            return FileCellRenderer.openFileIcon;
        }
        return FileCellRenderer.fileIcon;
    }

    public final Icon getDefaultIcon(boolean expanded) {
        return this.getDefaultIcon(expanded, jEdit._getBuffer(this.getSymlinkPath()) != null);
    }

    public VFSFile() {
    }

    public VFSFile(String name, String path, String deletePath, int type, long length, boolean hidden) {
        this.name = name;
        this.path = path;
        this.deletePath = deletePath;
        this.symlinkPath = path;
        this.type = type;
        this.length = length;
        this.hidden = hidden;
        if (path != null) {
            VFS vfs = VFSManager.getVFSForPath(path);
            this.canRead = (vfs.getCapabilities() & 1) != 0;
            this.canWrite = (vfs.getCapabilities() & 2) != 0;
        }
    }

    public VFS getVFS() {
        return VFSManager.getVFSForPath(this.path);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBinary(Object session) throws IOException {
        InputStream in = this.getVFS()._createInputStream(session, this.getPath(), false, jEdit.getActiveView());
        if (in == null) {
            throw new IOException("Unable to get a Stream for this file " + this);
        }
        try {
            boolean bl = MiscUtilities.isBinary(in);
            return bl;
        }
        finally {
            IOUtilities.closeQuietly(in);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSymlinkPath() {
        return this.symlinkPath;
    }

    public void setSymlinkPath(String symlinkPath) {
        this.symlinkPath = symlinkPath;
    }

    public String getDeletePath() {
        return this.deletePath;
    }

    public void setDeletePath(String deletePath) {
        this.deletePath = deletePath;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isReadable() {
        return this.canRead;
    }

    public void setReadable(boolean canRead) {
        this.canRead = canRead;
    }

    public boolean isWriteable() {
        return this.canWrite;
    }

    public void setWriteable(boolean canWrite) {
        this.canWrite = canWrite;
    }

    public String getExtendedAttribute(String name) {
        if (name.equals("type")) {
            switch (this.getType()) {
                case 0: {
                    return jEdit.getProperty("vfs.browser.type.file");
                }
                case 1: {
                    return jEdit.getProperty("vfs.browser.type.directory");
                }
                case 2: {
                    return jEdit.getProperty("vfs.browser.type.filesystem");
                }
            }
            throw new IllegalArgumentException();
        }
        if (name.equals("status")) {
            if (this.isReadable()) {
                if (this.isWriteable()) {
                    return jEdit.getProperty("vfs.browser.status.rw");
                }
                return jEdit.getProperty("vfs.browser.status.ro");
            }
            if (this.isWriteable()) {
                return jEdit.getProperty("vfs.browser.status.append");
            }
            return jEdit.getProperty("vfs.browser.status.no");
        }
        if (name.equals("size")) {
            if (this.getType() != 0) {
                return null;
            }
            return StandardUtilities.formatFileSize(this.getLength());
        }
        return null;
    }

    public Color getColor() {
        if (!this.colorCalculated) {
            this.colorCalculated = true;
            this.color = VFS.getDefaultColorFor(this.name);
        }
        return this.color;
    }

    public String toString() {
        return this.name;
    }

    protected boolean fetchedAttrs() {
        return this.fetchedAttrs;
    }

    protected void fetchAttrs() {
        this.fetchedAttrs = true;
    }

    public long getModified() {
        return 0L;
    }
}

