/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class TipOfTheDay
extends EnhancedDialog {
    private JCheckBox showNextTime;
    private JButton nextTip;
    private JButton close;
    private JEditorPane tipText;
    private int currentTip = -1;

    public TipOfTheDay(View view) {
        super(view, jEdit.getProperty("tip.title"), false);
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JLabel label = new JLabel(jEdit.getProperty("tip.caption"));
        label.setFont(label.getFont().deriveFont(label.getFont().getSize2D() * 2.0f));
        label.setForeground(UIManager.getColor("Button.foreground"));
        content.add("North", label);
        this.tipText = new JEditorPane();
        this.tipText.setEditable(false);
        this.tipText.setContentType("text/html");
        this.tipText.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.tipText.setFont(jEdit.getFontProperty("helpviewer.font"));
        this.nextTip();
        JScrollPane scroller = new JScrollPane(this.tipText);
        scroller.setPreferredSize(new Dimension(250, 250));
        content.add("Center", scroller);
        ActionHandler actionHandler = new ActionHandler();
        Box buttons = new Box(0);
        this.showNextTime = new JCheckBox(jEdit.getProperty("tip.show-next-time"), jEdit.getBooleanProperty("tip.show"));
        this.showNextTime.addActionListener(actionHandler);
        buttons.add(this.showNextTime);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(Box.createGlue());
        this.nextTip = new JButton(jEdit.getProperty("tip.next-tip"));
        this.nextTip.addActionListener(actionHandler);
        buttons.add(this.nextTip);
        buttons.add(Box.createHorizontalStrut(6));
        this.close = new JButton(jEdit.getProperty("common.close"));
        this.close.addActionListener(actionHandler);
        buttons.add(this.close);
        content.getRootPane().setDefaultButton(this.close);
        Dimension dim = this.nextTip.getPreferredSize();
        dim.width = Math.max(dim.width, this.close.getPreferredSize().width);
        this.nextTip.setPreferredSize(dim);
        this.close.setPreferredSize(dim);
        content.add("South", buttons);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    private void nextTip() {
        File[] tips = new File(MiscUtilities.constructPath(jEdit.getJEditHome(), "doc", "tips")).listFiles();
        if (tips == null || tips.length == 0) {
            this.tipText.setText(jEdit.getProperty("tip.not-found"));
            return;
        }
        int count = tips.length;
        int tipToShow = this.currentTip;
        while (tipToShow == this.currentTip || !tips[tipToShow].getName().endsWith(".html")) {
            tipToShow = new Random().nextInt(Integer.MAX_VALUE) % count;
        }
        try {
            this.tipText.setPage(tips[tipToShow].toURI().toURL());
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == TipOfTheDay.this.showNextTime) {
                jEdit.setBooleanProperty("tip.show", TipOfTheDay.this.showNextTime.isSelected());
            } else if (source == TipOfTheDay.this.nextTip) {
                TipOfTheDay.this.nextTip();
            } else if (source == TipOfTheDay.this.close) {
                TipOfTheDay.this.dispose();
            }
        }
    }
}

