/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class PingPongList<E>
extends JPanel {
    private MyListModel<E> leftModel;
    private MyListModel<E> rightModel;
    private JList<E> left;
    private JList<E> right;
    private JLabel leftLabel;
    private JLabel rightLabel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private Box buttonsBox;

    public PingPongList(List<E> leftData, List<E> rightData) {
        this(1, leftData, rightData);
    }

    public PingPongList(int newOrientation, List<E> leftData, List<E> rightData) {
        super(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(newOrientation);
        this.leftModel = new MyListModel(leftData);
        this.left = new JList<E>(this.leftModel);
        this.rightModel = new MyListModel(rightData);
        this.right = new JList<E>(this.rightModel);
        this.leftPanel = new JPanel(new BorderLayout());
        this.rightPanel = new JPanel(new BorderLayout());
        JScrollPane leftScroll = new JScrollPane(this.left);
        JScrollPane rightScroll = new JScrollPane(this.right);
        this.leftPanel.add(leftScroll);
        this.rightPanel.add(rightScroll);
        splitPane.setLeftComponent(this.leftPanel);
        splitPane.setRightComponent(this.rightPanel);
        this.left.setDragEnabled(true);
        this.right.setDragEnabled(true);
        MyTransferHandler myTransferHandler = new MyTransferHandler();
        this.left.setTransferHandler(myTransferHandler);
        this.right.setTransferHandler(myTransferHandler);
        splitPane.setDividerLocation(0.5);
        this.buttonsBox = Box.createHorizontalBox();
        this.buttonsBox.add(Box.createHorizontalStrut(12));
        ActionHandler actionHandler = new ActionHandler();
        this.selectAllButton = new JButton(jEdit.getProperty("common.selectAll"));
        this.selectAllButton.addActionListener(actionHandler);
        this.selectAllButton.setEnabled(this.getLeftSize() != 0);
        this.buttonsBox.add(this.selectAllButton);
        this.buttonsBox.add(Box.createHorizontalStrut(12));
        this.selectNoneButton = new JButton(jEdit.getProperty("common.selectNone"));
        this.selectNoneButton.addActionListener(actionHandler);
        this.selectNoneButton.setEnabled(this.getRightSize() != 0);
        this.buttonsBox.add(this.selectNoneButton);
        this.buttonsBox.add(Box.createHorizontalStrut(12));
        this.add((Component)splitPane, "Center");
        this.add((Component)this.buttonsBox, "South");
        MyListDataListener listDataListener = new MyListDataListener();
        this.leftModel.addListDataListener(listDataListener);
        this.rightModel.addListDataListener(listDataListener);
    }

    public void addButton(JButton button) {
        if (button != null) {
            this.buttonsBox.add(Box.createHorizontalStrut(12));
            this.buttonsBox.add(button);
        }
    }

    public void setLeftData(List<E> data) {
        this.leftModel = new MyListModel(data);
        this.left.setModel(this.leftModel);
    }

    public void setRightData(List<E> data) {
        this.rightModel = new MyListModel(data);
        this.right.setModel(this.rightModel);
    }

    public void setLeftSelected(E selected) {
        if (selected != null) {
            this.left.setSelectedValue(selected, true);
        }
    }

    public List<E> getLeftSelectedValues() {
        return this.left.getSelectedValuesList();
    }

    public void setRightSelected(E selected) {
        if (selected != null) {
            this.right.setSelectedValue(selected, true);
        }
    }

    public List<E> getRightSelectedValues() {
        return this.right.getSelectedValuesList();
    }

    public void setLeftTooltip(String leftTooltip) {
        this.left.setToolTipText(leftTooltip);
    }

    public void setRightTooltip(String rightTooltip) {
        this.right.setToolTipText(rightTooltip);
    }

    public void setLeftTitle(String leftTitle) {
        if (leftTitle == null) {
            this.removeLeftTitle();
            return;
        }
        if (this.leftLabel == null) {
            this.leftLabel = new JLabel();
        }
        this.leftLabel.setText(leftTitle);
        this.leftPanel.add((Component)this.leftLabel, "North");
    }

    public void setRightTitle(String rightTitle) {
        if (rightTitle == null) {
            this.removeRightTitle();
            return;
        }
        if (this.rightLabel == null) {
            this.rightLabel = new JLabel();
        }
        this.rightLabel.setText(rightTitle);
        this.rightPanel.add((Component)this.rightLabel, "North");
    }

    public void removeLeftTitle() {
        if (this.leftLabel != null) {
            this.leftPanel.remove(this.leftLabel);
            this.leftLabel = null;
        }
    }

    public void removeRightTitle() {
        if (this.rightLabel != null) {
            this.rightPanel.remove(this.rightLabel);
            this.rightLabel = null;
        }
    }

    public int getLeftSize() {
        return this.leftModel.getSize();
    }

    public int getRightSize() {
        return this.rightModel.getSize();
    }

    public Iterator<E> getLeftDataIterator() {
        return this.leftModel.iterator();
    }

    public Iterator<E> getRightDataIterator() {
        return this.rightModel.iterator();
    }

    public void moveAllToLeft() {
        this.leftModel.addAll(((MyListModel)this.rightModel).data);
        this.rightModel.clear();
    }

    public void moveAllToRight() {
        this.rightModel.addAll(((MyListModel)this.leftModel).data);
        this.leftModel.clear();
    }

    public void setLeftCellRenderer(ListCellRenderer<E> renderer) {
        if (renderer != null) {
            this.left.setCellRenderer(renderer);
        }
    }

    public void setRightCellRenderer(ListCellRenderer<E> renderer) {
        if (renderer != null) {
            this.right.setCellRenderer(renderer);
        }
    }

    public void addLeftListSelectionListener(ListSelectionListener listener) {
        if (listener != null) {
            this.left.addListSelectionListener(listener);
        }
    }

    public void addRightListSelectionListener(ListSelectionListener listener) {
        if (listener != null) {
            this.right.addListSelectionListener(listener);
        }
    }

    private class MyListDataListener
    implements ListDataListener {
        private MyListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.dataUpdated();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.dataUpdated();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.dataUpdated();
        }

        private void dataUpdated() {
            PingPongList.this.selectAllButton.setEnabled(PingPongList.this.getLeftSize() != 0);
            PingPongList.this.selectNoneButton.setEnabled(PingPongList.this.getRightSize() != 0);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source == PingPongList.this.selectAllButton) {
                PingPongList.this.moveAllToRight();
                PingPongList.this.selectAllButton.setEnabled(false);
                PingPongList.this.selectNoneButton.setEnabled(true);
            } else if (source == PingPongList.this.selectNoneButton) {
                PingPongList.this.moveAllToLeft();
                PingPongList.this.selectAllButton.setEnabled(true);
                PingPongList.this.selectNoneButton.setEnabled(false);
            }
        }
    }

    private static class MyTransferable<E>
    implements Transferable {
        public static final DataFlavor javaListFlavor = new DataFlavor(Collection.class, "java.util.Collection");
        private final E[] data;

        private MyTransferable(E[] data) {
            this.data = Arrays.copyOf(data, data.length);
        }

        private MyTransferable(List<E> data) {
            this.data = data.toArray();
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{javaListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(javaListFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.data;
        }
    }

    private class MyTransferHandler
    extends TransferHandler {
        private JList<E> sourceList;
        private int[] indices;

        private MyTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            try {
                Object[] transferData = (Object[])t.getTransferData(MyTransferable.javaListFlavor);
                JList targetList = (JList)comp;
                MyListModel targetModel = (MyListModel)targetList.getModel();
                MyListModel sourceModel = (MyListModel)this.sourceList.getModel();
                int dropLocation = targetList.getSelectedIndex();
                if (dropLocation == -1) {
                    dropLocation = 0;
                }
                targetModel.add(dropLocation, transferData);
                int dropStart = dropLocation;
                if (targetList == this.sourceList) {
                    int i;
                    for (i = this.indices.length - 1; i >= 0; --i) {
                        int index = this.indices[i];
                        if (this.indices[i] >= dropLocation) {
                            index += transferData.length;
                        } else {
                            --dropStart;
                        }
                        sourceModel.remove(index);
                    }
                    for (i = this.indices.length - 1; i >= 0; --i) {
                        this.indices[i] = dropStart + i;
                    }
                } else {
                    this.sourceList.clearSelection();
                    for (int i = this.indices.length - 1; i >= 0; --i) {
                        sourceModel.remove(this.indices[i]);
                        this.indices[i] = dropLocation + i;
                    }
                }
                targetList.setSelectedIndices(this.indices);
                return true;
            }
            catch (UnsupportedFlavorException e) {
                Log.log(9, this, e);
            }
            catch (IOException e) {
                Log.log(9, this, e);
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            this.sourceList = (JList)c;
            this.indices = this.sourceList.getSelectedIndices();
            return new MyTransferable(this.sourceList.getSelectedValuesList());
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return comp == PingPongList.this.left || comp == PingPongList.this.right;
        }
    }

    private static class MyListModel<E>
    extends AbstractListModel<E>
    implements Iterable<E> {
        private List<E> data;

        private MyListModel(List<E> data) {
            this.data = data;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public E getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public Iterator<E> iterator() {
            return this.data.iterator();
        }

        public void clear() {
            if (this.data.isEmpty()) {
                return;
            }
            int i = this.data.size();
            this.data.clear();
            this.fireIntervalRemoved(this, 0, i - 1);
        }

        public void addAll(Collection<E> newData) {
            int i = this.data.size();
            this.data.addAll(newData);
            this.fireIntervalAdded(this, i, i + newData.size() - 1);
        }

        public void remove(int index) {
            this.data.remove(index);
            this.fireContentsChanged(this, index, index);
        }

        public void add(int pos, E[] addedDatas) {
            for (int i = addedDatas.length - 1; i >= 0; --i) {
                this.data.add(pos, addedDatas[i]);
            }
            this.fireContentsChanged(this, pos, pos + addedDatas.length - 1);
        }
    }
}

