/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;

public class ColorChooserDialog
extends JDialog {
    private Color initialColor = null;
    private JColorChooser colorChooser = null;

    public ColorChooserDialog(Window owner, Color initialColor) {
        super(owner);
        this.setModal(true);
        this.initialColor = initialColor;
        this.init();
    }

    private void init() {
        this.setTitle(jEdit.getProperty("colorChooser.title"));
        JPanel contents = new JPanel();
        contents.setLayout(new BorderLayout());
        contents.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.colorChooser = new JColorChooser(this.initialColor);
        contents.add((Component)this.colorChooser, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 0));
        JButton ok = new JButton(jEdit.getProperty("common.ok"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColorChooserDialog.this.setVisible(false);
                ColorChooserDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(ok);
        JButton cancel = new JButton(jEdit.getProperty("common.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColorChooserDialog.this.setVisible(false);
                ColorChooserDialog.this.dispose();
            }
        });
        JButton reset = new JButton(jEdit.getProperty("common.reset"));
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColorChooserDialog.this.colorChooser.setColor(ColorChooserDialog.this.initialColor);
            }
        });
        GenericGUIUtilities.makeSameSize(ok, cancel, reset);
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(ok);
        buttonPanel.add(Box.createHorizontalStrut(6));
        buttonPanel.add(cancel);
        buttonPanel.add(Box.createHorizontalStrut(6));
        buttonPanel.add(reset);
        contents.add((Component)buttonPanel, "South");
        this.setContentPane(contents);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public Color getColor() {
        Color selectedColor = this.colorChooser.getColor();
        return selectedColor == null ? this.initialColor : selectedColor;
    }
}

