/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.helpers.DefaultHandler;

public class SettingsXML {
    private File file;
    private long knownLastModified;

    public SettingsXML(String settingsDirectory, String name) {
        String filename = name + ".xml";
        this.file = new File(MiscUtilities.constructPath(settingsDirectory, filename));
    }

    public SettingsXML(File f) {
        this.file = f;
    }

    public boolean fileExists() {
        return this.file.exists();
    }

    public void load(DefaultHandler handler) throws IOException {
        XMLUtilities.parseXML(new FileInputStream(this.file), handler);
        this.knownLastModified = this.file.lastModified();
    }

    public Saver openSaver() throws IOException {
        return new Saver();
    }

    public boolean hasChangedOnDisk() {
        return this.file.exists() && this.file.lastModified() != this.knownLastModified;
    }

    public String toString() {
        return this.file.toString();
    }

    public class Saver
    extends BufferedWriter {
        private File twoStageSaveFile;
        private static final String encoding = "UTF-8";

        public void writeXMLDeclaration() throws IOException {
            this.writeXMLDeclaration("1.0");
        }

        public void writeXMLDeclaration(String version) throws IOException {
            this.write("<?xml version=\"" + version + "\" encoding=\"" + encoding + "\" ?>");
            this.newLine();
        }

        public void finish() throws IOException {
            this.close();
            jEdit.backupSettingsFile(SettingsXML.this.file);
            SettingsXML.this.file.delete();
            this.twoStageSaveFile.renameTo(SettingsXML.this.file);
            SettingsXML.this.knownLastModified = SettingsXML.this.file.lastModified();
        }

        Saver() throws IOException {
            this(new File(this$0.file.getParentFile(), "#" + this$0.file.getName() + "#save#"));
        }

        private Saver(File twoStageSaveFile) throws IOException {
            super(new OutputStreamWriter((OutputStream)new FileOutputStream(twoStageSaveFile), encoding));
            this.twoStageSaveFile = twoStageSaveFile;
        }
    }
}

