/*
 * Decompiled with CFR 0.152.
 */
package code2html.impl.htmlcss;

import code2html.generic.GenericDocument;
import code2html.generic.GenericGutter;
import code2html.generic.Style;
import java.io.IOException;
import java.io.Writer;
import org.gjt.sp.jedit.syntax.SyntaxStyle;

public class HtmlCssDocument
extends GenericDocument {
    public HtmlCssDocument(String viewBgColor, String viewFgColor, SyntaxStyle[] syntaxStyles, Style style, GenericGutter gutter, String title, String lineSeparator) {
        super(viewBgColor, viewFgColor, syntaxStyles, style, gutter, title, lineSeparator);
    }

    public void openBeforeStyle(Writer out) throws IOException {
        out.write("<html>");
        out.write(this.lineSeparator);
        out.write("<head>");
        out.write(this.lineSeparator);
        out.write("<title>" + this.title + "</title>");
        out.write(this.lineSeparator);
        out.write("<style type=\"text/css\"><!--");
        out.write(this.lineSeparator);
    }

    public void openAfterStyle(Writer out) throws IOException {
        out.write("-->");
        out.write("</style>");
        out.write(this.lineSeparator);
        out.write("</head>");
        out.write(this.lineSeparator);
        out.write("<body bgcolor=\"");
        out.write(this.viewBgColor);
        out.write("\">");
        out.write(this.lineSeparator);
    }

    public void beforeContent(Writer out) throws IOException {
        out.write("<pre>");
        out.write("<span class=\"syntax0\">");
    }

    public void afterContent(Writer out) throws IOException {
        out.write("</span></pre>");
        out.write(this.lineSeparator);
    }

    public void close(Writer out) throws IOException {
        out.write("</body>");
        out.write(this.lineSeparator);
        out.write("</html>");
        out.write(this.lineSeparator);
    }
}

