/*
 * Decompiled with CFR 0.152.
 */
package code2html.generic;

import code2html.Code2HTMLPlugin;
import code2html.generic.GenericGutter;
import code2html.generic.Style;
import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.gjt.sp.jedit.syntax.SyntaxStyle;

public abstract class GenericDocument {
    protected String viewBgColor;
    protected String viewFgColor;
    protected Color bgColor;
    protected Color fgColor;
    protected SyntaxStyle[] syntaxStyles;
    protected Style style;
    protected GenericGutter gutter;
    protected String title;
    protected String lineSeparator;

    public GenericDocument() {
    }

    public GenericDocument(String viewBgColor, String viewFgColor, SyntaxStyle[] syntaxStyles, Style style, GenericGutter gutter, String title, String lineSeparator) {
        this.viewBgColor = viewBgColor;
        this.viewFgColor = viewFgColor;
        this.bgColor = Code2HTMLPlugin.decode(viewBgColor);
        this.fgColor = Code2HTMLPlugin.decode(viewFgColor);
        this.syntaxStyles = Arrays.copyOf(syntaxStyles, syntaxStyles.length);
        this.style = style;
        this.gutter = gutter;
        this.title = title;
        this.lineSeparator = lineSeparator;
    }

    public void open(Writer out) throws IOException {
        this.openBeforeStyle(out);
        this.openStyle(out);
        this.openAfterStyle(out);
    }

    public void openStyle(Writer out) throws IOException {
        out.write(this.lineSeparator);
        for (int i = 0; i < this.syntaxStyles.length; ++i) {
            out.write(this.style.style(i, this.syntaxStyles[i]));
        }
        out.write(this.lineSeparator);
        out.write(this.gutter != null ? this.gutter.style() : "");
        out.write(this.lineSeparator);
    }

    public abstract void openBeforeStyle(Writer var1) throws IOException;

    public abstract void openAfterStyle(Writer var1) throws IOException;

    public abstract void beforeContent(Writer var1) throws IOException;

    public abstract void afterContent(Writer var1) throws IOException;

    public abstract void close(Writer var1) throws IOException;
}

