/*
 * Decompiled with CFR 0.152.
 */
package ise.plugin.nav;

import ise.plugin.nav.NavPosition;
import java.awt.Component;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class NumberTextField
extends JTextField
implements ComboBoxEditor {
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;
    private Object item = null;

    public NumberTextField() {
        this.addFilter();
    }

    public NumberTextField(String text, int columns) {
        super(text, columns);
        this.addFilter();
    }

    public void setMaxValue(int value) {
        this.maxValue = value;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(int value) {
        this.minValue = value;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getValue() {
        String text = this.getText();
        if (text == null || text.length() == 0) {
            text = String.valueOf(this.getMinValue());
        }
        return Integer.parseInt(text);
    }

    public void setValue(int value) {
        this.setText(String.valueOf(value));
    }

    private void addFilter() {
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new NumericDocumentFilter());
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public Object getItem() {
        if (this.item == null || !(this.item instanceof NavPosition) || !this.item.toString().equals(this.getText())) {
            return this.getText();
        }
        return this.item;
    }

    @Override
    public void setItem(Object item) {
        this.item = item;
        this.setText(item == null ? "" : item.toString());
    }

    class NumericDocumentFilter
    extends DocumentFilter {
        NumericDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            if (this.isNumeric(string) && this.inRange(new StringBuilder(NumberTextField.this.getText()).insert(offset, string))) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            super.remove(fb, offset, length);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text == null || text.length() == 0) {
                return;
            }
            if (this.isNumeric(text) && this.inRange(new StringBuilder(NumberTextField.this.getText()).replace(offset, offset + length, text))) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        private boolean isNumeric(String string) {
            for (char c : string.toCharArray()) {
                if (Character.isDigit(c)) continue;
                return false;
            }
            return true;
        }

        private boolean inRange(CharSequence string) {
            int value = Integer.parseInt(string.toString());
            return value <= NumberTextField.this.maxValue && value >= NumberTextField.this.minValue;
        }
    }
}

