/*
 * Decompiled with CFR 0.152.
 */
package code2html;

import java.awt.Color;
import org.gjt.sp.jedit.EditPlugin;

public class Code2HTMLPlugin
extends EditPlugin {
    public void start() {
    }

    public void stop() {
    }

    public static Color decode(String colorString) {
        if (colorString == null || colorString.length() == 0 || colorString.charAt(0) != '#') {
            throw new IllegalArgumentException("Invalid color string: " + colorString);
        }
        colorString = colorString.substring(1);
        try {
            if (colorString.length() == 6) {
                colorString = "ff" + colorString;
            }
            int red = Integer.parseInt(colorString.substring(2, 4), 16);
            int green = Integer.parseInt(colorString.substring(4, 6), 16);
            int blue = Integer.parseInt(colorString.substring(6, 8), 16);
            Color color = new Color(red, green, blue);
            return color;
        }
        catch (NumberFormatException nf) {
            throw new IllegalArgumentException("Invalid color string: " + colorString);
        }
    }

    public static String encode(Color color) {
        String colString = Integer.toHexString(color.getRGB());
        return "#" + colString.substring(2);
    }
}

