/*
 * Decompiled with CFR 0.152.
 */
package ise.plugin.nav;

import ise.plugin.nav.NavHistoryPopup;
import ise.plugin.nav.Navigator;
import ise.plugin.nav.NavigatorPlugin;
import ise.plugin.nav.SquareButton;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;

public class NavToolBar
extends JToolBar {
    private JButton back;
    private JButton forward;

    public NavToolBar(Navigator client) {
        this.installComponents(client);
        this.installListeners(client);
    }

    public void installComponents(Navigator client) {
        this.back = new SquareButton(GUIUtilities.loadIcon((String)"ArrowL.png"));
        this.back.setToolTipText(jEdit.getProperty((String)"navigator.back.label", (String)"Back"));
        this.forward = new SquareButton(GUIUtilities.loadIcon((String)"ArrowR.png"));
        this.forward.setToolTipText(jEdit.getProperty((String)"navigator.forward.label", (String)"Forward"));
        this.updateComponents(client);
        this.add(this.back);
        this.add(this.forward);
    }

    public void installListeners(final Navigator client) {
        this.back.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getButton() == 3) {
                    NavHistoryPopup popup = NavigatorPlugin.backList(client.getView());
                    GUIUtilities.showPopupMenu((JPopupMenu)popup, (Component)NavToolBar.this.back, (int)me.getX(), (int)me.getY());
                }
            }
        });
        this.forward.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getButton() == 3) {
                    NavHistoryPopup popup = NavigatorPlugin.forwardList(client.getView());
                    GUIUtilities.showPopupMenu((JPopupMenu)popup, (Component)NavToolBar.this.forward, (int)me.getX(), (int)me.getY());
                }
            }
        });
    }

    public void updateComponents(Navigator client) {
        this.back.setModel(client.getBackModel());
        this.forward.setModel(client.getForwardModel());
    }
}

