/*
 * Decompiled with CFR 0.152.
 */
package console.options;

import console.ErrorListModel;
import console.ErrorMatcher;
import console.gui.PanelStack;
import console.options.ErrorMatcherPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class ErrorsOptionPane
extends AbstractOptionPane {
    private ErrorListModel errorListModel;
    private JList errorList;
    PanelStack panelStack;
    private JButton add;
    private JButton remove;
    private JButton reset;
    private JButton up;
    private JButton down;

    public ErrorsOptionPane() {
        super("console.errors");
    }

    protected void _init() {
        this.setLayout(new BorderLayout());
        this.addComponent(Box.createVerticalStrut(6));
        this.errorListModel = ErrorListModel.load();
        this.errorList = new JList();
        this.errorList.setModel(this.errorListModel);
        JScrollPane jsp = new JScrollPane(this.errorList);
        jsp.setMinimumSize(new Dimension(125, 300));
        this.errorList.setSelectionMode(0);
        this.errorList.addListSelectionListener(new ListHandler());
        this.errorList.addMouseListener(new MouseHandler());
        this.errorList.setVisibleRowCount(5);
        String title = jEdit.getProperty((String)"options.console.errors.caption");
        jsp.setBorder(new TitledBorder(title));
        Box westBox = new Box(1);
        westBox.add(jsp);
        this.panelStack = new PanelStack();
        this.add(this.panelStack, "Center");
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(6, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        this.add = new RolloverButton(GUIUtilities.loadIcon((String)"Plus.png"));
        this.add.setToolTipText(jEdit.getProperty((String)"common.add"));
        buttons.add(this.add);
        this.remove = new RolloverButton(GUIUtilities.loadIcon((String)"Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty((String)"common.remove"));
        buttons.add(this.remove);
        this.up = new RolloverButton(GUIUtilities.loadIcon((String)"ArrowU.png"));
        this.up.setToolTipText(jEdit.getProperty((String)"common.moveUp"));
        buttons.add(this.up);
        this.down = new RolloverButton(GUIUtilities.loadIcon((String)"ArrowD.png"));
        this.down.setToolTipText(jEdit.getProperty((String)"common.moveDown"));
        buttons.add(this.down);
        this.reset = new RolloverButton(GUIUtilities.loadIcon((String)"Reload.png"));
        this.reset.setToolTipText(jEdit.getProperty((String)"options.console.errors.reset.tooltip"));
        buttons.add(this.reset);
        ActionHandler handler = new ActionHandler();
        this.add.addActionListener(handler);
        this.remove.addActionListener(handler);
        this.up.addActionListener(handler);
        this.down.addActionListener(handler);
        this.reset.addActionListener(handler);
        westBox.add(buttons);
        this.add(westBox, "West");
        this.errorList.setSelectedIndex(0);
        this.updateButtons();
    }

    protected void _load() {
        this.errorListModel = ErrorListModel.load();
    }

    protected void _save() {
        this.errorListModel.save();
    }

    private void updateButtons() {
        String internalName;
        ErrorMatcher matcher = (ErrorMatcher)this.errorList.getSelectedValue();
        if (matcher != null && !this.panelStack.raise(internalName = matcher.internalName())) {
            ErrorMatcherPanel panel = new ErrorMatcherPanel(internalName, matcher);
            this.panelStack.add(internalName, (JPanel)((Object)panel));
            this.panelStack.raise(internalName);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                ErrorsOptionPane.this.updateButtons();
            }
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            ErrorsOptionPane.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int index;
            int answer;
            Object source = evt.getSource();
            if (source == ErrorsOptionPane.this.reset && (answer = GUIUtilities.confirm((Component)ErrorsOptionPane.this.errorList, (String)"options.console.errors.reset-confirm", null, (int)0, (int)3)) == 0) {
                ErrorsOptionPane.this.errorListModel.reset();
                ErrorsOptionPane.this.errorList.setModel(ErrorsOptionPane.this.errorListModel);
                ErrorsOptionPane.this.errorList.repaint();
            }
            if (source == ErrorsOptionPane.this.add) {
                String matcherNamePrompt = jEdit.getProperty((String)"options.console.errors.name");
                String matcherName = JOptionPane.showInputDialog(matcherNamePrompt);
                ErrorMatcher matcher = new ErrorMatcher(matcherName);
                matcher.name = matcherName;
                matcher.user = true;
                int index2 = ErrorsOptionPane.this.errorList.getSelectedIndex() + 1;
                ErrorsOptionPane.this.errorListModel.insertElementAt(matcher, index2);
                ErrorsOptionPane.this.errorList.setSelectedIndex(index2);
                ErrorsOptionPane.this.errorList.repaint();
            } else if (source == ErrorsOptionPane.this.remove) {
                index = ErrorsOptionPane.this.errorList.getSelectedIndex();
                ErrorsOptionPane.this.errorListModel.removeElementAt(index);
                if (ErrorsOptionPane.this.errorListModel.size() > index) {
                    ErrorsOptionPane.this.errorList.setSelectedIndex(index);
                } else if (!ErrorsOptionPane.this.errorListModel.isEmpty()) {
                    ErrorsOptionPane.this.errorList.setSelectedIndex(ErrorsOptionPane.this.errorListModel.size() - 1);
                }
                ErrorsOptionPane.this.errorList.repaint();
            } else if (source == ErrorsOptionPane.this.up) {
                index = ErrorsOptionPane.this.errorList.getSelectedIndex();
                ErrorMatcher selected = ErrorsOptionPane.this.errorListModel.get(index);
                ErrorsOptionPane.this.errorListModel.removeElementAt(index);
                ErrorsOptionPane.this.errorListModel.insertElementAt(selected, index - 1);
                ErrorsOptionPane.this.errorList.setSelectedIndex(index - 1);
                ErrorsOptionPane.this.errorList.repaint();
            } else if (source == ErrorsOptionPane.this.down) {
                index = ErrorsOptionPane.this.errorList.getSelectedIndex();
                ErrorMatcher matcher = ErrorsOptionPane.this.errorListModel.get(index);
                ErrorsOptionPane.this.errorListModel.removeElementAt(index);
                ErrorsOptionPane.this.errorListModel.insertElementAt(matcher, index + 1);
                ErrorsOptionPane.this.errorList.setSelectedIndex(index + 1);
                ErrorsOptionPane.this.errorList.repaint();
            }
        }
    }
}

