/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.TextAreaDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.search.BoyerMooreSearchMatcher;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.HyperSearchRequest;
import org.gjt.sp.jedit.search.HyperSearchResults;
import org.gjt.sp.jedit.search.PatternSearchMatcher;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ReverseCharSequence;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class SearchAndReplace {
    private static String search;
    private static String replace;
    private static BshMethod replaceMethod;
    private static NameSpace replaceNS;
    private static boolean regexp;
    private static boolean wholeWord;
    private static boolean ignoreCase;
    private static boolean reverse;
    private static boolean beanshell;
    private static boolean wrap;
    private static SearchMatcher matcher;
    private static SearchFileSet fileset;

    public static void setSearchString(String search) {
        if (search.equals(SearchAndReplace.search)) {
            return;
        }
        SearchAndReplace.search = search;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static String getSearchString() {
        return search;
    }

    public static void setReplaceString(String replace) {
        if (replace.equals(SearchAndReplace.replace)) {
            return;
        }
        SearchAndReplace.replace = replace;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static String getReplaceString() {
        return replace;
    }

    public static void setWholeWord(boolean wholeWord) {
        if (wholeWord == SearchAndReplace.wholeWord) {
            return;
        }
        SearchAndReplace.wholeWord = wholeWord;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static void setIgnoreCase(boolean ignoreCase) {
        if (ignoreCase == SearchAndReplace.ignoreCase) {
            return;
        }
        SearchAndReplace.ignoreCase = ignoreCase;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getWholeWord() {
        return wholeWord;
    }

    public static boolean getIgnoreCase() {
        return ignoreCase;
    }

    public static void setRegexp(boolean regexp) {
        if (regexp == SearchAndReplace.regexp) {
            return;
        }
        SearchAndReplace.regexp = regexp;
        if (regexp && reverse) {
            reverse = false;
        }
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getRegexp() {
        return regexp;
    }

    public static void setReverseSearch(boolean reverse) {
        if (reverse == SearchAndReplace.reverse) {
            return;
        }
        SearchAndReplace.reverse = reverse;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getReverseSearch() {
        return reverse;
    }

    public static void setBeanShellReplace(boolean beanshell) {
        if (beanshell == SearchAndReplace.beanshell) {
            return;
        }
        SearchAndReplace.beanshell = beanshell;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getBeanShellReplace() {
        return beanshell;
    }

    public static void setAutoWrapAround(boolean wrap) {
        if (wrap == SearchAndReplace.wrap) {
            return;
        }
        SearchAndReplace.wrap = wrap;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getAutoWrapAround() {
        return wrap;
    }

    public static void setSearchMatcher(SearchMatcher matcher) {
        SearchAndReplace.matcher = matcher;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static SearchMatcher getSearchMatcher() throws Exception {
        if (matcher != null) {
            return matcher;
        }
        if (search == null || "".equals(search)) {
            return null;
        }
        if (regexp) {
            Pattern re = Pattern.compile(search, PatternSearchMatcher.getFlag(ignoreCase));
            matcher = new PatternSearchMatcher(re, ignoreCase, wholeWord);
        } else {
            matcher = new BoyerMooreSearchMatcher(search, ignoreCase, wholeWord);
        }
        return matcher;
    }

    public static void setSearchFileSet(SearchFileSet fileset) {
        SearchAndReplace.fileset = fileset;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static SearchFileSet getSearchFileSet() {
        return fileset;
    }

    public static boolean getSmartCaseReplace() {
        return replace != null && TextUtilities.getStringCase(replace) == 1;
    }

    public static boolean hyperSearch(View view) {
        return SearchAndReplace.hyperSearch(view, false);
    }

    public static boolean hyperSearch(View view, boolean selection) {
        Window comp = SearchDialog.getSearchDialog(view);
        if (comp == null) {
            comp = view;
        }
        SearchAndReplace.record(view, "hyperSearch(view," + selection + ')', false, !selection);
        view.getDockableWindowManager().addDockableWindow("hypersearch-results");
        HyperSearchResults results = (HyperSearchResults)view.getDockableWindowManager().getDockable("hypersearch-results");
        results.searchStarted();
        try {
            Selection[] s;
            SearchMatcher matcher = SearchAndReplace.getSearchMatcher();
            if (matcher == null) {
                view.getToolkit().beep();
                results.searchFailed();
                return false;
            }
            if (selection) {
                s = view.getTextArea().getSelection();
                if (s == null) {
                    results.searchFailed();
                    return false;
                }
            } else {
                s = null;
            }
            ThreadUtilities.runInBackground(new HyperSearchRequest(view, matcher, results, s));
            return true;
        }
        catch (Exception e) {
            results.searchFailed();
            SearchAndReplace.handleError(comp, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean find(View view) {
        String path;
        Window comp = SearchDialog.getSearchDialog(view);
        if (comp == null || !((Component)comp).isShowing()) {
            comp = view;
        }
        if ((path = fileset.getNextFile(view, null)) == null) {
            GUIUtilities.error(comp, "empty-fileset", null);
            return false;
        }
        try {
            view.showWaitCursor();
            SearchMatcher matcher = SearchAndReplace.getSearchMatcher();
            if (matcher == null) {
                view.getToolkit().beep();
                boolean bl = false;
                return bl;
            }
            SearchAndReplace.record(view, "find(view)", false, true);
            boolean repeat = false;
            while (true) {
                boolean restart;
                if (path != null) {
                    JEditTextArea textArea22;
                    Selection s;
                    Buffer buffer = jEdit.openTemporary(view, null, path, false);
                    path = reverse ? fileset.getPrevFile(view, path) : fileset.getNextFile(view, path);
                    if (buffer == null) continue;
                    if (!buffer.isLoaded()) {
                        TaskManager.instance.waitForIoTasks();
                    }
                    int start = view.getBuffer() == buffer && !repeat ? ((s = (textArea22 = view.getTextArea()).getSelectionAtOffset(textArea22.getCaretPosition())) == null ? textArea22.getCaretPosition() : (reverse ? s.getStart() : s.getEnd())) : (reverse ? buffer.getLength() : 0);
                    if (!SearchAndReplace.find(view, buffer, start, repeat, reverse)) continue;
                    boolean textArea22 = true;
                    return textArea22;
                }
                if (repeat) {
                    if (!BeanShell.isScriptRunning()) {
                        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.search-not-found"));
                        view.getToolkit().beep();
                    }
                    boolean buffer = false;
                    return buffer;
                }
                if (wrap) {
                    if (!BeanShell.isScriptRunning()) {
                        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.auto-wrap"));
                        if (jEdit.getBooleanProperty("search.beepOnSearchAutoWrap")) {
                            view.getToolkit().beep();
                        }
                    }
                    restart = true;
                } else if (BeanShell.isScriptRunning()) {
                    restart = false;
                } else {
                    Object[] args = new Integer[]{reverse ? 1 : 0};
                    int result = GUIUtilities.confirm(comp, "keepsearching", args, 0, 3);
                    boolean bl = restart = result == 0;
                }
                if (restart) {
                    path = fileset.getFirstFile(view);
                    repeat = true;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            SearchAndReplace.handleError(comp, e);
        }
        finally {
            view.hideWaitCursor();
        }
        return false;
    }

    public static boolean find(View view, Buffer buffer, int start) throws Exception {
        return SearchAndReplace.find(view, buffer, start, false, false);
    }

    public static boolean find(View view, Buffer buffer, int start, boolean firstTime, boolean reverse) throws Exception {
        SearchMatcher.Match match;
        boolean endOfLine;
        boolean startOfLine;
        CharSequence text;
        EditBus.send(new PositionChanging(view.getEditPane()));
        SearchMatcher matcher = SearchAndReplace.getSearchMatcher();
        if (matcher == null) {
            view.getToolkit().beep();
            return false;
        }
        if (reverse) {
            text = new ReverseCharSequence(buffer.getSegment(0, start));
            startOfLine = true;
            endOfLine = buffer.getLineEndOffset(buffer.getLineOfOffset(start)) - 1 == start;
        } else {
            text = buffer.getSegment(start, buffer.getLength() - start);
            startOfLine = buffer.getLineStartOffset(buffer.getLineOfOffset(start)) == start;
            endOfLine = true;
        }
        if (matcher.wholeWord) {
            String noWordSep = buffer.getStringProperty("noWordSep");
            matcher.setNoWordSep(noWordSep);
        }
        if ((match = matcher.nextMatch(text, startOfLine, endOfLine, firstTime, reverse)) != null) {
            jEdit.commitTemporary(buffer);
            view.setBuffer(buffer);
            JEditTextArea textArea = view.getTextArea();
            if (reverse) {
                textArea.setSelection(new Selection.Range(start - match.end, start - match.start));
                textArea.scrollTo(start - match.start, false);
                textArea.moveCaretPosition(start - match.end);
            } else {
                textArea.setSelection(new Selection.Range(start + match.start, start + match.end));
                textArea.moveCaretPosition(start + match.end);
                textArea.scrollTo(start + match.start, false);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(View view) {
        Window comp = SearchDialog.getSearchDialog(view);
        if (comp == null) {
            comp = view;
        }
        JEditTextArea textArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        if (!buffer.isEditable()) {
            return false;
        }
        boolean smartCaseReplace = SearchAndReplace.getSmartCaseReplace();
        Selection[] selection = textArea.getSelection();
        if (selection.length == 0) {
            view.getToolkit().beep();
            return false;
        }
        SearchAndReplace.record(view, "replace(view)", true, false);
        int caret = textArea.getCaretPosition();
        Selection s = textArea.getSelectionAtOffset(caret);
        if (s != null) {
            caret = s.getStart();
        }
        try {
            buffer.beginCompoundEdit();
            SearchMatcher matcher = SearchAndReplace.getSearchMatcher();
            if (matcher == null) {
                boolean bl = false;
                return bl;
            }
            SearchAndReplace.initReplace();
            int retVal = 0;
            Selection[] selectionArray = selection;
            int n = selectionArray.length;
            for (int i = 0; i < n; ++i) {
                Selection aSelection;
                s = aSelection = selectionArray[i];
                retVal += SearchAndReplace.replaceInSelection(view, textArea, buffer, matcher, smartCaseReplace, s);
            }
            if (reverse) {
                textArea.moveCaretPosition(caret);
            } else {
                s = textArea.getSelectionAtOffset(textArea.getCaretPosition());
                if (s != null) {
                    textArea.moveCaretPosition(s.getEnd());
                }
            }
            if (!BeanShell.isScriptRunning()) {
                Object[] args = new Object[]{retVal, 1};
                view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.replace-all", args));
            }
            if (retVal == 0) {
                view.getToolkit().beep();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            SearchAndReplace.handleError(comp, e);
        }
        finally {
            buffer.endCompoundEdit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(View view, Buffer buffer, int start, int end) {
        if (!buffer.isEditable()) {
            return false;
        }
        Window comp = SearchDialog.getSearchDialog(view);
        if (comp == null) {
            comp = view;
        }
        boolean smartCaseReplace = SearchAndReplace.getSmartCaseReplace();
        try {
            buffer.beginCompoundEdit();
            SearchMatcher matcher = SearchAndReplace.getSearchMatcher();
            if (matcher == null) {
                boolean bl = false;
                return bl;
            }
            SearchAndReplace.initReplace();
            int retVal = 0;
            if ((retVal += SearchAndReplace._replace(view, buffer, matcher, start, end, smartCaseReplace)) != 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            SearchAndReplace.handleError(comp, e);
        }
        finally {
            buffer.endCompoundEdit();
        }
        return false;
    }

    public static boolean replaceAll(View view) {
        return SearchAndReplace.replaceAll(view, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceAll(View view, boolean dontOpenChangedFiles) {
        Window comp = SearchDialog.getSearchDialog(view);
        if (comp == null) {
            comp = view;
        }
        if (fileset.getFileCount(view) == 0) {
            GUIUtilities.error(comp, "empty-fileset", null);
            return false;
        }
        SearchAndReplace.record(view, "replaceAll(view)", true, true);
        view.showWaitCursor();
        boolean smartCaseReplace = SearchAndReplace.getSmartCaseReplace();
        int fileCount = 0;
        int occurCount = 0;
        try {
            SearchMatcher matcher = SearchAndReplace.getSearchMatcher();
            if (matcher == null) {
                boolean bl = false;
                return bl;
            }
            SearchAndReplace.initReplace();
            String path = fileset.getFirstFile(view);
            while (path != null) {
                Buffer buffer = jEdit.openTemporary(view, null, path, false);
                path = fileset.getNextFile(view, path);
                if (buffer == null) continue;
                if (buffer.isPerformingIO()) {
                    TaskManager.instance.waitForIoTasks();
                }
                if (!buffer.isEditable()) continue;
                int retVal = 0;
                try {
                    buffer.beginCompoundEdit();
                    retVal = SearchAndReplace._replace(view, buffer, matcher, 0, buffer.getLength(), smartCaseReplace);
                }
                finally {
                    buffer.endCompoundEdit();
                }
                if (retVal == 0) continue;
                ++fileCount;
                occurCount += retVal;
                if (dontOpenChangedFiles) {
                    buffer.save(null, null);
                    continue;
                }
                jEdit.commitTemporary(buffer);
                jEdit.getBufferSetManager().addBuffer(view, buffer);
            }
        }
        catch (Exception e) {
            SearchAndReplace.handleError(comp, e);
        }
        finally {
            view.hideWaitCursor();
        }
        if (!BeanShell.isScriptRunning()) {
            Object[] args = new Object[]{occurCount, fileCount};
            view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.replace-all", args));
            if (occurCount == 0) {
                view.getToolkit().beep();
            }
        }
        return fileCount != 0;
    }

    public static String escapeRegexp(String str, boolean multiline) {
        return StandardUtilities.charsToEscapes(str, "\r\t\\()[]{}$^*+?|." + (multiline ? "" : "\n"));
    }

    public static void load() {
        search = jEdit.getProperty("search.find.value");
        replace = jEdit.getProperty("search.replace.value");
        wholeWord = jEdit.getBooleanProperty("search.wholeWord.toggle");
        ignoreCase = jEdit.getBooleanProperty("search.ignoreCase.toggle");
        regexp = jEdit.getBooleanProperty("search.regexp.toggle");
        beanshell = jEdit.getBooleanProperty("search.beanshell.toggle");
        wrap = jEdit.getBooleanProperty("search.wrap.toggle");
        fileset = new CurrentBufferSet();
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static void save() {
        jEdit.setProperty("search.find.value", search);
        jEdit.setProperty("search.replace.value", replace);
        jEdit.setBooleanProperty("search.wholeWord.toggle", wholeWord);
        jEdit.setBooleanProperty("search.ignoreCase.toggle", ignoreCase);
        jEdit.setBooleanProperty("search.regexp.toggle", regexp);
        jEdit.setBooleanProperty("search.beanshell.toggle", beanshell);
        jEdit.setBooleanProperty("search.wrap.toggle", wrap);
    }

    static void handleError(Component comp, Exception e) {
        Log.log(9, SearchAndReplace.class, e);
        if (comp instanceof Dialog) {
            new TextAreaDialog((Dialog)comp, beanshell ? "searcherror-bsh" : "searcherror", (Throwable)e);
        } else {
            new TextAreaDialog((Frame)comp, beanshell ? "searcherror-bsh" : "searcherror", (Throwable)e);
        }
    }

    private static void initReplace() throws Exception {
        if (beanshell && replace.length() != 0) {
            String text = replace.trim().startsWith("{") ? replace : "return (" + replace + ");";
            replaceMethod = BeanShell.cacheBlock("replace", text, true);
        } else {
            replaceMethod = null;
        }
    }

    private static void record(View view, String action, boolean replaceAction, boolean recordFileSet) {
        Macros.Recorder recorder = view.getMacroRecorder();
        if (recorder != null) {
            recorder.record("SearchAndReplace.setSearchString(\"" + StandardUtilities.charsToEscapes(search) + "\");");
            if (replaceAction) {
                recorder.record("SearchAndReplace.setReplaceString(\"" + StandardUtilities.charsToEscapes(replace) + "\");");
                recorder.record("SearchAndReplace.setBeanShellReplace(" + beanshell + ");");
            } else {
                recorder.record("SearchAndReplace.setAutoWrapAround(" + wrap + ");");
                recorder.record("SearchAndReplace.setReverseSearch(" + reverse + ");");
            }
            recorder.record("SearchAndReplace.setWholeWord(" + wholeWord + ");");
            recorder.record("SearchAndReplace.setIgnoreCase(" + ignoreCase + ");");
            recorder.record("SearchAndReplace.setRegexp(" + regexp + ");");
            if (recordFileSet) {
                recorder.record("SearchAndReplace.setSearchFileSet(" + fileset.getCode() + ");");
            }
            recorder.record("SearchAndReplace." + action + ';');
        }
    }

    private static int replaceInSelection(View view, TextArea textArea, Buffer buffer, SearchMatcher matcher, boolean smartCaseReplace, Selection s) throws Exception {
        int returnValue;
        int start = s.getStart();
        if (s instanceof Selection.Range) {
            returnValue = SearchAndReplace._replace(view, buffer, matcher, s.getStart(), s.getEnd(), smartCaseReplace);
            textArea.removeFromSelection(s);
            textArea.addToSelection(new Selection.Range(start, s.getEnd()));
        } else if (s instanceof Selection.Rect) {
            Selection.Rect rect = (Selection.Rect)s;
            int startCol = rect.getStartColumn(buffer);
            int endCol = rect.getEndColumn(buffer);
            returnValue = 0;
            for (int j = s.getStartLine(); j <= s.getEndLine(); ++j) {
                returnValue += SearchAndReplace._replace(view, buffer, matcher, SearchAndReplace.getColumnOnOtherLine(buffer, j, startCol), SearchAndReplace.getColumnOnOtherLine(buffer, j, endCol), smartCaseReplace);
            }
            textArea.addToSelection(new Selection.Rect(start, s.getEnd()));
        } else {
            throw new RuntimeException("Unsupported: " + s);
        }
        return returnValue;
    }

    private static int _replace(View view, JEditBuffer buffer, SearchMatcher matcher, int start, int end, boolean smartCaseReplace) throws Exception {
        if (matcher.wholeWord) {
            String noWordSep = buffer.getStringProperty("noWordSep");
            matcher.setNoWordSep(noWordSep);
        }
        int occurCount = 0;
        boolean endOfLine = buffer.getLineEndOffset(buffer.getLineOfOffset(end)) - 1 == end;
        int offset = start;
        int counter = 0;
        while (true) {
            boolean startOfLine = buffer.getLineStartOffset(buffer.getLineOfOffset(offset)) == offset;
            CharSequence text = buffer.getSegment(offset, end - offset);
            SearchMatcher.Match occur = matcher.nextMatch(text, startOfLine, endOfLine, counter == 0, false);
            if (occur == null) break;
            CharSequence found = text.subSequence(occur.start, occur.end);
            int length = SearchAndReplace.replaceOne(view, buffer, occur, offset, found, smartCaseReplace);
            if (length == -1) {
                offset += occur.end;
            } else {
                offset += occur.start + length;
                end += length - found.length();
                ++occurCount;
            }
            ++counter;
        }
        return occurCount;
    }

    private static int replaceOne(View view, JEditBuffer buffer, SearchMatcher.Match occur, int offset, CharSequence found, boolean smartCaseReplace) throws Exception {
        String subst = SearchAndReplace.replaceOne(view, buffer, occur, found);
        if (smartCaseReplace && ignoreCase) {
            int strCase = TextUtilities.getStringCase(found);
            if (strCase == 1) {
                subst = subst.toLowerCase();
            } else if (strCase == 2) {
                subst = subst.toUpperCase();
            } else if (strCase == 3) {
                subst = TextUtilities.toTitleCase(subst);
            }
        }
        if (subst != null) {
            int end = offset + occur.end;
            int start = offset + occur.start;
            if (end - start > 0) {
                buffer.remove(start, end - start);
            }
            buffer.insert(start, subst);
            return subst.length();
        }
        return -1;
    }

    private static String replaceOne(View view, JEditBuffer buffer, SearchMatcher.Match occur, CharSequence found) throws Exception {
        if (regexp) {
            if (replaceMethod != null) {
                return SearchAndReplace.regexpBeanShellReplace(view, buffer, occur);
            }
            return SearchAndReplace.regexpReplace(occur, found);
        }
        if (replaceMethod != null) {
            return SearchAndReplace.literalBeanShellReplace(view, buffer, found);
        }
        return replace;
    }

    private static String regexpBeanShellReplace(View view, JEditBuffer buffer, SearchMatcher.Match occur) throws Exception {
        replaceNS.setVariable("buffer", buffer, false);
        for (int i = 0; i < occur.substitutions.length; ++i) {
            replaceNS.setVariable("_" + i, occur.substitutions[i]);
        }
        Object obj = BeanShell.runCachedBlock(replaceMethod, view, replaceNS);
        for (int i = 0; i < occur.substitutions.length; ++i) {
            replaceNS.setVariable("_" + i, null, false);
        }
        replaceNS.setVariable("buffer", null, false);
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    private static String regexpReplace(SearchMatcher.Match occur, CharSequence found) throws Exception {
        StringBuilder buf = new StringBuilder();
        block8: for (int i = 0; i < replace.length(); ++i) {
            char ch = replace.charAt(i);
            switch (ch) {
                case '$': {
                    String subs;
                    if (i == replace.length() - 1) {
                        buf.append(ch);
                        continue block8;
                    }
                    if ((ch = replace.charAt(++i)) == '$') {
                        buf.append('$');
                        continue block8;
                    }
                    if (ch == '0') {
                        buf.append(found);
                        continue block8;
                    }
                    if (!Character.isDigit(ch)) continue block8;
                    int n = ch - 48;
                    while (i < replace.length() - 1) {
                        if (Character.isDigit(ch = replace.charAt(++i))) {
                            n = n * 10 + (ch - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    if (n >= occur.substitutions.length || (subs = occur.substitutions[n]) == null) continue block8;
                    buf.append(subs);
                    continue block8;
                }
                case '\\': {
                    if (i == replace.length() - 1) {
                        buf.append('\\');
                        continue block8;
                    }
                    ch = replace.charAt(++i);
                    switch (ch) {
                        case 'n': {
                            buf.append('\n');
                            continue block8;
                        }
                        case 't': {
                            buf.append('\t');
                            continue block8;
                        }
                    }
                    buf.append(ch);
                    continue block8;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    private static String literalBeanShellReplace(View view, JEditBuffer buffer, CharSequence found) throws Exception {
        replaceNS.setVariable("buffer", buffer);
        replaceNS.setVariable("_0", found);
        Object obj = BeanShell.runCachedBlock(replaceMethod, view, replaceNS);
        replaceNS.setVariable("_0", null, false);
        replaceNS.setVariable("buffer", null, false);
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    private static int getColumnOnOtherLine(Buffer buffer, int line, int col) {
        int returnValue = buffer.getOffsetOfVirtualColumn(line, col, null);
        if (returnValue == -1) {
            return buffer.getLineEndOffset(line) - 1;
        }
        return buffer.getLineStartOffset(line) + returnValue;
    }

    static {
        replaceNS = new NameSpace(BeanShell.getNameSpace(), BeanShell.getNameSpace().getClassManager(), "search and replace");
    }
}

