/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.msg;

import java.io.File;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;

public class PluginUpdate
extends EBMessage {
    public static final Object LOADED = "LOADED";
    public static final Object ACTIVATED = "ACTIVATED";
    public static final Object DEACTIVATED = "DEACTIVATED";
    public static final Object UNLOADED = "UNLOADED";
    public static final Object REMOVED = "REMOVED";
    private PluginJAR jar = null;
    private File file = null;
    private Object what;
    private boolean exit;
    private String version;

    public PluginUpdate(PluginJAR jar, Object what, boolean exit) {
        super(jar);
        if (jar == null) {
            throw new IllegalArgumentException("PluginJAR may not be null.");
        }
        this.jar = jar;
        if (what == null) {
            throw new NullPointerException("What must be non-null");
        }
        EditPlugin plugin = jar.getPlugin();
        if (plugin != null) {
            String clazz = plugin.getClassName();
            this.version = jEdit.getProperty("plugin." + clazz + ".version");
        }
        this.what = what;
        this.exit = exit;
    }

    public PluginUpdate(File file, Object what, boolean exit) {
        super(file);
        this.file = file;
        if (what == null) {
            throw new NullPointerException("What must be non-null");
        }
        this.what = what;
        this.exit = exit;
    }

    public Object getWhat() {
        return this.what;
    }

    public boolean isExiting() {
        return this.exit;
    }

    @Nullable
    public PluginJAR getPluginJAR() {
        return this.jar;
    }

    public File getFile() {
        return this.file;
    }

    public String getPluginVersion() {
        return this.version;
    }

    @Override
    public String paramString() {
        return "what=" + this.what + ",exit=" + this.exit + ",version=" + this.version + "," + super.paramString();
    }
}

