/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.EnhancedMenuItem;
import org.gjt.sp.util.Log;
import org.jedit.keymap.Keymap;

public class EnhancedCheckBoxMenuItem
extends JCheckBoxMenuItem {
    private final ActionContext context;
    private String shortcut;
    private final String action;

    public EnhancedCheckBoxMenuItem(String label, String action, ActionContext context) {
        this.context = context;
        this.action = action;
        this.shortcut = GUIUtilities.getShortcutLabel(action, true);
        String toolTip = jEdit.getProperty(action + ".tooltip");
        if (toolTip != null) {
            this.setToolTipText(toolTip);
        }
        if (OperatingSystem.hasScreenMenuBar() && this.shortcut != null) {
            if (jEdit.getBooleanProperty("menu.multiShortcut", false)) {
                this.setText(label + " ( " + this.shortcut + " )");
            } else {
                this.setText(label);
                Keymap keymap = jEdit.getKeymapManager().getKeymap();
                String rawShortcut = keymap.getShortcut(action + ".shortcut");
                KeyStroke key = KeyEventTranslator.parseKeyStroke(rawShortcut);
                if (key != null) {
                    this.setAccelerator(key);
                }
            }
            this.shortcut = null;
        } else {
            this.setText(label);
        }
        if (action != null) {
            this.setEnabled(true);
            this.addActionListener(new EditAction.Wrapper(context, action));
            this.addMouseListener(new MouseHandler());
        } else {
            this.setEnabled(false);
        }
        this.setModel(new Model());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.shortcut != null) {
            FontMetrics fm = this.getFontMetrics(EnhancedMenuItem.acceleratorFont);
            d.width += fm.stringWidth(this.shortcut) + fm.stringWidth("AAAA");
        }
        return d;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.shortcut != null) {
            Graphics2D g2 = (Graphics2D)g;
            g.setFont(EnhancedMenuItem.acceleratorFont);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.getModel().isArmed() ? EnhancedMenuItem.acceleratorSelectionForeground : EnhancedMenuItem.acceleratorForeground);
            FontMetrics fm = g.getFontMetrics();
            Insets insets = this.getInsets();
            g.drawString(this.shortcut, this.getWidth() - (fm.stringWidth(this.shortcut) + insets.right + insets.left + 5), fm.getAscent() + insets.top);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        boolean msgSet = false;

        MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            String msg = jEdit.getProperty(EnhancedCheckBoxMenuItem.this.action + ".mouse-over");
            if (msg != null) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(msg);
                this.msgSet = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }
    }

    class Model
    extends DefaultButtonModel {
        Model() {
        }

        @Override
        public boolean isSelected() {
            if (!EnhancedCheckBoxMenuItem.this.isVisible()) {
                return false;
            }
            EditAction a = EnhancedCheckBoxMenuItem.this.context.getAction(EnhancedCheckBoxMenuItem.this.action);
            if (a == null) {
                Log.log(7, this, "Unknown action: " + EnhancedCheckBoxMenuItem.this.action);
                return false;
            }
            try {
                return a.isSelected(EnhancedCheckBoxMenuItem.this);
            }
            catch (Throwable t) {
                Log.log(9, this, t);
                return false;
            }
        }

        @Override
        public void setSelected(boolean b) {
        }
    }
}

